/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceRenderable;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLRenderToTextureSupport;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SurfaceObjectTileBuilder {
    protected static final int DEFAULT_TEXTURE_DIMENSION = 512;
    protected static final int DEFAULT_TEXTURE_INTERNAL_FORMAT = 32856;
    protected static final int DEFAULT_TEXTURE_PIXEL_FORMAT = 6408;
    protected static final double DEFAULT_SPLIT_SCALE = 2.9;
    protected static final LatLon DEFAULT_LEVEL_ZERO_TILE_DELTA = LatLon.fromDegrees(36.0, 36.0);
    protected static final int DEFAULT_NUM_LEVELS = 17;
    protected static long nextUniqueId = 1L;
    protected static Map<Dimension, LevelSet> levelSetMap = new HashMap<Dimension, LevelSet>();
    protected Dimension tileDimension = new Dimension(512, 512);
    protected int tileTextureFormat;
    protected boolean useLinearFilter = true;
    protected boolean useMipmaps = true;
    protected boolean forceTileUpdates;
    protected double splitScale = 2.9;
    protected List<SurfaceRenderable> currentSurfaceObjects = new ArrayList<SurfaceRenderable>();
    protected Map<Object, TileInfo> tileInfoMap = new HashMap<Object, TileInfo>();
    protected TileInfo currentInfo;
    protected OGLRenderToTextureSupport rttSupport = new OGLRenderToTextureSupport();

    public SurfaceObjectTileBuilder() {
    }

    public SurfaceObjectTileBuilder(Dimension dimension, int n, boolean bl, boolean bl2) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setTileDimension(dimension);
        this.setTileTextureFormat(n);
        this.setUseLinearFilter(bl);
        this.setUseMipmaps(bl2);
    }

    public Dimension getTileDimension() {
        return this.tileDimension;
    }

    public void setTileDimension(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tileDimension = dimension;
    }

    public int getTileTextureFormat() {
        return this.tileTextureFormat;
    }

    public void setTileTextureFormat(int n) {
        this.tileTextureFormat = n;
    }

    public boolean isUseLinearFilter() {
        return this.useLinearFilter;
    }

    public void setUseLinearFilter(boolean bl) {
        this.useLinearFilter = bl;
    }

    public boolean isUseMipmaps() {
        return this.useMipmaps;
    }

    public void setUseMipmaps(boolean bl) {
        this.useMipmaps = bl;
    }

    public boolean isForceTileUpdates() {
        return this.forceTileUpdates;
    }

    public void setForceTileUpdates(boolean bl) {
        this.forceTileUpdates = bl;
    }

    public void setSplitScale(double d) {
        this.splitScale = d;
    }

    public double getSplitScale() {
        return this.splitScale;
    }

    public int getTileCount(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        TileInfo tileInfo = this.tileInfoMap.get(tileInfoKey);
        return tileInfo != null ? tileInfo.tiles.size() : 0;
    }

    public Collection<? extends SurfaceTile> getTiles(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        TileInfo tileInfo = this.tileInfoMap.get(tileInfoKey);
        return tileInfo != null ? tileInfo.tiles : Collections.emptyList();
    }

    public void buildTiles(DrawContext drawContext, Iterable<?> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        this.currentInfo = this.tileInfoMap.get(tileInfoKey);
        if (this.currentInfo == null) {
            this.currentInfo = this.createTileInfo(drawContext);
            this.tileInfoMap.put(tileInfoKey, this.currentInfo);
        }
        this.currentSurfaceObjects.clear();
        this.currentInfo.tiles.clear();
        if (iterable == null) {
            return;
        }
        this.assembleSurfaceObjects(iterable);
        if (this.currentSurfaceObjects.isEmpty() || !this.canAssembleTiles(drawContext)) {
            return;
        }
        this.assembleTiles(drawContext);
        this.updateTiles(drawContext);
        this.currentSurfaceObjects.clear();
        for (SurfaceObjectTile surfaceObjectTile : this.currentInfo.tiles) {
            surfaceObjectTile.clearObjectList();
        }
    }

    public void clearTiles(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        TileInfo tileInfo = this.tileInfoMap.get(tileInfoKey);
        if (tileInfo != null) {
            tileInfo.tiles.clear();
        }
    }

    public Collection<PickedObject> getPickCandidates(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        TileInfo tileInfo = this.tileInfoMap.get(tileInfoKey);
        return tileInfo != null ? tileInfo.pickCandidates : Collections.emptyList();
    }

    public void clearPickCandidates(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileInfoKey tileInfoKey = this.createTileInfoKey(drawContext);
        TileInfo tileInfo = this.tileInfoMap.get(tileInfoKey);
        if (tileInfo != null) {
            tileInfo.pickCandidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTiles(DrawContext drawContext) {
        if (this.currentInfo.tiles.isEmpty()) {
            return;
        }
        this.rttSupport.setEnableFramebufferObject(this.tileTextureFormat == 0 || this.tileTextureFormat == 6407 || this.tileTextureFormat == 32849 || this.tileTextureFormat == 6408 || this.tileTextureFormat == 32856);
        this.rttSupport.beginRendering(drawContext, 0, 0, this.currentInfo.tileWidth, this.currentInfo.tileHeight);
        try {
            for (SurfaceObjectTile surfaceObjectTile : this.currentInfo.tiles) {
                this.updateTile(drawContext, surfaceObjectTile);
            }
        }
        finally {
            this.rttSupport.endRendering(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTile(DrawContext drawContext, SurfaceObjectTile surfaceObjectTile) {
        Texture texture = surfaceObjectTile.getTexture(drawContext.getTextureCache());
        if (!this.isForceTileUpdates()) {
            Iterator<SurfaceRenderable> iterator = surfaceObjectTile.getStateKey(drawContext);
            if (texture != null && iterator.equals(surfaceObjectTile.lastUpdateStateKey)) {
                return;
            }
            surfaceObjectTile.lastUpdateStateKey = iterator;
        }
        if (texture == null) {
            texture = this.createTileTexture(drawContext, surfaceObjectTile.getWidth(), surfaceObjectTile.getHeight());
            surfaceObjectTile.setTexture(drawContext.getTextureCache(), texture);
        }
        if (texture == null) {
            Logging.logger().warning(Logging.getMessage("nullValue.TextureIsNull"));
            return;
        }
        try {
            drawContext.setValue("gov.nasa.worldwind.avkey.SurfaceTileDrawContext", this.createSurfaceTileDrawContext(surfaceObjectTile));
            this.rttSupport.setColorTarget(drawContext, texture);
            this.rttSupport.clear(drawContext, new Color(0, 0, 0, 0));
            if (surfaceObjectTile.hasObjects()) {
                for (SurfaceRenderable surfaceRenderable : surfaceObjectTile.getObjectList()) {
                    surfaceRenderable.render(drawContext);
                }
            }
        }
        finally {
            this.rttSupport.setColorTarget(drawContext, null);
            drawContext.removeKey("gov.nasa.worldwind.avkey.SurfaceTileDrawContext");
        }
    }

    protected Texture createTileTexture(DrawContext drawContext, int n, int n2) {
        int n3;
        int n4 = this.tileTextureFormat;
        if (n4 == 0) {
            n4 = 32856;
        }
        if ((n3 = OGLUtil.computeTexturePixelFormat(n4)) == 0) {
            n3 = 6408;
        }
        GL gL = drawContext.getGL();
        TextureData textureData = new TextureData(gL.getGLProfile(), n4, n, n2, 0, n3, 5121, this.isUseMipmaps(), false, false, null, null){

            @Override
            public int getEstimatedMemorySize() {
                int n = OGLUtil.estimateTextureMemorySize(this.getInternalFormat(), this.getWidth(), this.getHeight(), this.getMipmap());
                if (n > 0) {
                    return n;
                }
                return super.getEstimatedMemorySize();
            }
        };
        Texture texture = TextureIO.newTexture(textureData);
        texture.bind(gL);
        gL.glTexParameteri(3553, 10241, this.isUseLinearFilter() ? (this.isUseMipmaps() ? 9987 : 9729) : 9728);
        gL.glTexParameteri(3553, 10240, this.isUseLinearFilter() ? 9729 : 9728);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        if (this.isUseMipmaps()) {
            double d = drawContext.getGLRuntimeCapabilities().getMaxTextureAnisotropy();
            if (drawContext.getGLRuntimeCapabilities().isUseAnisotropicTextureFilter() && d >= 2.0) {
                gL.glTexParameterf(3553, 34046, (float)d);
            }
        }
        return texture;
    }

    protected Object createSurfaceTileDrawContext(SurfaceObjectTile surfaceObjectTile) {
        return new SurfaceTileDrawContext(surfaceObjectTile, this.currentInfo.pickCandidates);
    }

    protected void assembleSurfaceObjects(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (!(obj instanceof SurfaceRenderable)) continue;
            this.currentSurfaceObjects.add((SurfaceRenderable)obj);
        }
    }

    protected LevelSet getLevelSet(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        LevelSet levelSet = levelSetMap.get(dimension);
        if (levelSet == null) {
            levelSet = SurfaceObjectTileBuilder.createLevelSet(n, n2);
            levelSetMap.put(dimension, levelSet);
        }
        return levelSet;
    }

    protected static LevelSet createLevelSet(int n, int n2) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", DEFAULT_LEVEL_ZERO_TILE_DELTA);
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 17);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", SurfaceObjectTileBuilder.class.getName());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", SurfaceObjectTileBuilder.class.getName());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", SurfaceObjectTileBuilder.class.getName());
        return new LevelSet(aVListImpl);
    }

    protected boolean canAssembleTiles(DrawContext drawContext) {
        Rectangle rectangle = drawContext.getView().getViewport();
        return rectangle.getWidth() > 0.0 && rectangle.getHeight() > 0.0;
    }

    protected void assembleTiles(DrawContext drawContext) {
        LevelSet levelSet = this.currentInfo.levelSet;
        String string = this.currentInfo.cacheName;
        Level level = levelSet.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = levelSet.getTileOrigin().getLatitude();
        Angle angle4 = levelSet.getTileOrigin().getLongitude();
        HashSet<SurfaceObjectTile> hashSet = new HashSet<SurfaceObjectTile>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (SurfaceRenderable object : this.currentSurfaceObjects) {
            List<Sector> list = object.getSectors(drawContext);
            if (list == null) continue;
            for (Sector sector : list) {
                int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
                int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
                int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
                int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
                Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
                for (int i = n; i <= n3; ++i) {
                    Angle angle6 = angle5.add(angle);
                    Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
                    for (int j = n2; j <= n4; ++j) {
                        Angle angle8 = angle7.add(angle2);
                        Object object2 = this.createTileKey(level, i, j, string);
                        if (hashSet2.contains(object2)) continue;
                        SurfaceObjectTile surfaceObjectTile = (SurfaceObjectTile)TextureTile.getMemoryCache().getObject(object2);
                        if (surfaceObjectTile == null) {
                            surfaceObjectTile = this.createTile(new Sector(angle5, angle6, angle7, angle8), level, i, j, string);
                            TextureTile.getMemoryCache().add(object2, surfaceObjectTile);
                        }
                        hashSet2.add(object2);
                        hashSet.add(surfaceObjectTile);
                        surfaceObjectTile.addSurfaceObject(object, sector);
                        angle7 = angle8;
                    }
                    angle5 = angle6;
                }
            }
            hashSet2.clear();
        }
        for (SurfaceObjectTile surfaceObjectTile : hashSet) {
            this.addTileOrDescendants(drawContext, levelSet, null, surfaceObjectTile);
        }
    }

    protected void addTileOrDescendants(DrawContext drawContext, LevelSet levelSet, SurfaceObjectTile surfaceObjectTile, SurfaceObjectTile surfaceObjectTile2) {
        if (!this.intersectsVisibleSector(drawContext, surfaceObjectTile2)) {
            surfaceObjectTile2.clearObjectList();
            return;
        }
        if (!this.intersectsFrustum(drawContext, surfaceObjectTile2)) {
            surfaceObjectTile2.clearObjectList();
            return;
        }
        if (surfaceObjectTile != null) {
            this.addIntersectingObjects(drawContext, surfaceObjectTile, surfaceObjectTile2);
        }
        if (!surfaceObjectTile2.hasObjects()) {
            return;
        }
        if (this.meetsRenderCriteria(drawContext, levelSet, surfaceObjectTile2)) {
            this.addTile(surfaceObjectTile2);
            return;
        }
        Level level = levelSet.getLevel(surfaceObjectTile2.getLevelNumber() + 1);
        for (TextureTile textureTile : surfaceObjectTile2.createSubTiles(level)) {
            this.addTileOrDescendants(drawContext, levelSet, surfaceObjectTile2, (SurfaceObjectTile)textureTile);
        }
        surfaceObjectTile2.clearObjectList();
    }

    protected void addIntersectingObjects(DrawContext drawContext, SurfaceObjectTile surfaceObjectTile, SurfaceObjectTile surfaceObjectTile2) {
        if (!surfaceObjectTile.hasObjects()) {
            return;
        }
        if (!surfaceObjectTile2.getSector().intersects(surfaceObjectTile.getObjectSector())) {
            return;
        }
        if (surfaceObjectTile2.getSector().contains(surfaceObjectTile.getObjectSector())) {
            surfaceObjectTile2.addAllSurfaceObjects(surfaceObjectTile.getObjectList(), surfaceObjectTile.getObjectSector());
        } else {
            block0: for (SurfaceRenderable surfaceRenderable : surfaceObjectTile.getObjectList()) {
                List<Sector> list = surfaceRenderable.getSectors(drawContext);
                if (list == null) continue;
                for (Sector sector : list) {
                    if (!surfaceObjectTile2.getSector().intersects(sector)) continue;
                    surfaceObjectTile2.addSurfaceObject(surfaceRenderable, sector);
                    continue block0;
                }
            }
        }
    }

    protected void addTile(SurfaceObjectTile surfaceObjectTile) {
        this.currentInfo.tiles.add(surfaceObjectTile);
        TextureTile.getMemoryCache().add(surfaceObjectTile.getTileKey(), surfaceObjectTile);
    }

    protected boolean intersectsFrustum(DrawContext drawContext, TextureTile textureTile) {
        Extent extent = textureTile.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    protected boolean intersectsVisibleSector(DrawContext drawContext, TextureTile textureTile) {
        return drawContext.getVisibleSector() != null && drawContext.getVisibleSector().intersects(textureTile.getSector());
    }

    protected boolean meetsRenderCriteria(DrawContext drawContext, LevelSet levelSet, Tile tile) {
        return levelSet.isFinalLevel(tile.getLevel().getLevelNumber()) || !this.needToSplit(drawContext, tile);
    }

    protected boolean needToSplit(DrawContext drawContext, Tile tile) {
        double d = tile.getLevel().getTexelSize();
        double d2 = drawContext.getGlobe().getRadius() * d;
        double d3 = this.getSplitScale();
        if (tile.getSector().getMinLatitude().degrees >= 75.0 || tile.getSector().getMaxLatitude().degrees <= -75.0) {
            d3 *= 0.85;
        }
        double d4 = Math.pow(10.0, -d3);
        double d5 = drawContext.getView().getFieldOfView().tanHalfAngle() / Angle.fromDegrees(45.0).tanHalfAngle();
        d5 = WWMath.clamp(d5, 0.0, 1.0);
        double d6 = tile.getSector().distanceTo(drawContext, drawContext.getView().getEyePoint());
        double d7 = d6 * d4 * d5;
        return d2 > d7;
    }

    protected TileInfoKey createTileInfoKey(DrawContext drawContext) {
        Dimension dimension = this.computeTextureTileDimension(drawContext);
        return new TileInfoKey(drawContext, dimension.width, dimension.height);
    }

    protected TileInfo createTileInfo(DrawContext drawContext) {
        Dimension dimension = this.computeTextureTileDimension(drawContext);
        LevelSet levelSet = this.getLevelSet(dimension.width, dimension.height);
        String string = this.uniqueCacheName();
        return new TileInfo(levelSet, string, dimension.width, dimension.height);
    }

    protected Dimension computeTextureTileDimension(DrawContext drawContext) {
        int n = Math.max(this.tileDimension.width, this.tileDimension.height);
        Rectangle rectangle = drawContext.getView().getViewport();
        if (n > rectangle.width) {
            n = rectangle.width;
        }
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        int n2 = WWMath.powerOfTwoFloor(n);
        return new Dimension(n2, n2);
    }

    protected String uniqueCacheName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("/");
        stringBuilder.append(nextUniqueId++);
        return stringBuilder.toString();
    }

    protected SurfaceObjectTile createTile(Sector sector, Level level, int n, int n2, String string) {
        return new SurfaceObjectTile(sector, level, n, n2, string);
    }

    protected Object createTileKey(Level level, int n, int n2, String string) {
        return new TileKey(level.getLevelNumber(), n, n2, string);
    }

    protected static class TileInfoKey {
        public final int globeOffset;
        public final int tileWidth;
        public final int tileHeight;

        public TileInfoKey(DrawContext drawContext, int n, int n2) {
            this.globeOffset = drawContext.getGlobe() instanceof Globe2D ? ((Globe2D)((Object)drawContext.getGlobe())).getOffset() : 0;
            this.tileWidth = n;
            this.tileHeight = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileInfoKey tileInfoKey = (TileInfoKey)object;
            return this.globeOffset == tileInfoKey.globeOffset && this.tileWidth == tileInfoKey.tileWidth && this.tileHeight == tileInfoKey.tileHeight;
        }

        public int hashCode() {
            int n = this.globeOffset;
            n = 31 * n + this.tileWidth;
            n = 31 * n + this.tileHeight;
            return n;
        }
    }

    protected static class TileInfo {
        public ArrayList<SurfaceObjectTile> tiles = new ArrayList();
        public ArrayList<PickedObject> pickCandidates = new ArrayList();
        public LevelSet levelSet;
        public String cacheName;
        public int tileWidth;
        public int tileHeight;

        public TileInfo(LevelSet levelSet, String string, int n, int n2) {
            this.levelSet = levelSet;
            this.cacheName = string;
            this.tileWidth = n;
            this.tileHeight = n2;
        }
    }

    protected static class SurfaceObjectTile
    extends TextureTile {
        protected Sector objectSector;
        protected List<SurfaceRenderable> intersectingObjects;
        protected Object lastUpdateStateKey;

        public SurfaceObjectTile(Sector sector, Level level, int n, int n2, String string) {
            super(sector, level, n, n2, string);
        }

        @Override
        public long getSizeInBytes() {
            long l = super.getSizeInBytes();
            if (this.lastUpdateStateKey instanceof Cacheable) {
                l += ((Cacheable)this.lastUpdateStateKey).getSizeInBytes();
            } else if (this.lastUpdateStateKey != null) {
                l += 4L;
            }
            return l;
        }

        public Object getStateKey(DrawContext drawContext) {
            return new SurfaceObjectTileStateKey(drawContext, this);
        }

        public Sector getObjectSector() {
            return this.objectSector;
        }

        public boolean hasObjects() {
            return this.intersectingObjects != null && !this.intersectingObjects.isEmpty();
        }

        public List<SurfaceRenderable> getObjectList() {
            return this.intersectingObjects;
        }

        public void clearObjectList() {
            this.intersectingObjects = null;
            this.objectSector = null;
        }

        public void addSurfaceObject(SurfaceRenderable surfaceRenderable, Sector sector) {
            if (this.intersectingObjects == null) {
                this.intersectingObjects = new ArrayList<SurfaceRenderable>();
            }
            this.intersectingObjects.add(surfaceRenderable);
            this.objectSector = this.objectSector != null ? this.objectSector.union(sector) : sector;
        }

        public void addAllSurfaceObjects(List<SurfaceRenderable> list, Sector sector) {
            if (this.intersectingObjects == null) {
                this.intersectingObjects = new ArrayList<SurfaceRenderable>();
            }
            this.intersectingObjects.addAll(list);
            this.objectSector = this.objectSector != null ? this.objectSector.union(sector) : sector;
        }

        @Override
        protected TextureTile createSubTile(Sector sector, Level level, int n, int n2) {
            return new SurfaceObjectTile(sector, level, n, n2, this.getCacheName());
        }

        @Override
        protected TileKey createSubTileKey(Level level, int n, int n2) {
            return new TileKey(level.getLevelNumber(), n, n2, this.getCacheName());
        }
    }

    protected static class SurfaceObjectTileStateKey
    implements Cacheable {
        protected final TileKey tileKey;
        protected final Object[] intersectingObjectKeys;

        public SurfaceObjectTileStateKey(DrawContext drawContext, SurfaceObjectTile surfaceObjectTile) {
            if (surfaceObjectTile != null && surfaceObjectTile.hasObjects()) {
                this.tileKey = surfaceObjectTile.getTileKey();
                this.intersectingObjectKeys = new Object[surfaceObjectTile.getObjectList().size()];
                int n = 0;
                for (SurfaceRenderable surfaceRenderable : surfaceObjectTile.getObjectList()) {
                    this.intersectingObjectKeys[n++] = surfaceRenderable.getStateKey(drawContext);
                }
            } else {
                this.tileKey = null;
                this.intersectingObjectKeys = null;
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SurfaceObjectTileStateKey surfaceObjectTileStateKey = (SurfaceObjectTileStateKey)object;
            return (this.tileKey != null ? this.tileKey.equals(surfaceObjectTileStateKey.tileKey) : surfaceObjectTileStateKey.tileKey == null) && Arrays.equals(this.intersectingObjectKeys, surfaceObjectTileStateKey.intersectingObjectKeys);
        }

        public int hashCode() {
            int n = this.tileKey != null ? this.tileKey.hashCode() : 0;
            n = 31 * n + Arrays.hashCode(this.intersectingObjectKeys);
            return n;
        }

        @Override
        public long getSizeInBytes() {
            if (this.intersectingObjectKeys == null) {
                return 0L;
            }
            long l = 4 * this.intersectingObjectKeys.length;
            for (Object object : this.intersectingObjectKeys) {
                if (object instanceof Cacheable) {
                    l += ((Cacheable)object).getSizeInBytes();
                    continue;
                }
                if (object == null) continue;
                l += 4L;
            }
            return l;
        }
    }
}

