/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfacePolygon
extends AbstractSurfaceShape
implements Exportable {
    protected List<Iterable<? extends LatLon>> boundaries = new ArrayList<Iterable<? extends LatLon>>();
    protected WWTexture explicitTexture;
    protected float[] explicitTextureCoords;
    protected Map<Object, ShapeData> shapeDataCache = new HashMap<Object, ShapeData>();
    protected static GLUtessellator tess;
    protected static GLUTessellatorSupport.CollectPrimitivesCallback tessCallback;

    public SurfacePolygon() {
    }

    public SurfacePolygon(SurfacePolygon surfacePolygon) {
        super(surfacePolygon);
        this.boundaries.addAll(surfacePolygon.boundaries);
    }

    public SurfacePolygon(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfacePolygon(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    public SurfacePolygon(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes);
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        return this.getOuterBoundary();
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.getOuterBoundary();
    }

    public List<Iterable<? extends LatLon>> getBoundaries() {
        return this.boundaries;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    public Iterable<? extends LatLon> getOuterBoundary() {
        return this.boundaries.size() > 0 ? this.boundaries.get(0) : null;
    }

    public void setOuterBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.boundaries.size() > 0) {
            this.boundaries.set(0, iterable);
        } else {
            this.boundaries.add(iterable);
        }
        this.onShapeChanged();
    }

    public void addInnerBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.add(iterable);
        this.onShapeChanged();
    }

    public Object getTextureImageSource() {
        return this.explicitTexture != null ? this.explicitTexture.getImageSource() : null;
    }

    public float[] getTextureCoords() {
        return this.explicitTextureCoords;
    }

    public void setTextureImageSource(Object object, float[] fArray, int n) {
        if (object == null) {
            this.explicitTexture = null;
            this.explicitTextureCoords = null;
            this.onShapeChanged();
            return;
        }
        if (fArray == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3 || fArray.length < 2 * n) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.explicitTexture = new BasicWWTexture(object, true);
        this.explicitTextureCoords = fArray;
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        if (this.getOuterBoundary() == null) {
            return null;
        }
        Iterator<? extends LatLon> iterator = this.getOuterBoundary().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return new Position(iterator.next(), 0.0);
    }

    @Override
    protected void clearCaches() {
        super.clearCaches();
        this.shapeDataCache.clear();
    }

    @Override
    protected void doDrawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        IntBuffer intBuffer;
        List<List<Vertex>> list;
        Object object;
        if (this.boundaries.isEmpty()) {
            return;
        }
        Object object2 = this.createGeometryKey(drawContext, surfaceTileDrawContext);
        ShapeData shapeData = this.shapeDataCache.get(object2);
        if (shapeData == null) {
            object = Angle.fromDegrees(1.0 / this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext));
            list = this.assembleContours((Angle)object);
            shapeData = this.tessellateContours(list);
            if (shapeData == null) {
                String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
                drawContext.addRenderingException(new WWRuntimeException(string));
                this.handleUnsuccessfulInteriorTessellation(drawContext);
                return;
            }
            this.shapeDataCache.put(object2, shapeData);
        }
        object = drawContext.getGL().getGL2();
        object.glVertexPointer(2, 5126, shapeData.vertexStride, shapeData.vertices.position(0));
        if (shapeData.hasTexCoords) {
            object.glEnableClientState(32888);
            object.glTexCoordPointer(2, 5126, shapeData.vertexStride, shapeData.vertices.position(2));
        }
        if ((list = this.getActiveAttributes()).isDrawInterior()) {
            this.applyInteriorState(drawContext, surfaceTileDrawContext, (ShapeAttributes)((Object)list), this.getInteriorTexture(), this.getReferencePosition());
            intBuffer = shapeData.interiorIndices;
            object.glDrawElements(4, intBuffer.remaining(), 5125, intBuffer);
        }
        if (list.isDrawOutline()) {
            this.applyOutlineState(drawContext, (ShapeAttributes)((Object)list));
            intBuffer = shapeData.outlineIndices;
            object.glDrawElements(1, intBuffer.remaining(), 5125, intBuffer);
        }
        if (shapeData.hasTexCoords) {
            object.glDisableClientState(32888);
        }
    }

    @Override
    protected void applyInteriorState(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext, ShapeAttributes shapeAttributes, WWTexture wWTexture, LatLon latLon) {
        if (this.explicitTexture != null && !drawContext.isPickingMode()) {
            GL2 gL2 = drawContext.getGL().getGL2();
            OGLUtil.applyBlending(gL2, true);
            OGLUtil.applyColor(gL2, shapeAttributes.getInteriorMaterial().getDiffuse(), shapeAttributes.getInteriorOpacity(), true);
            if (this.explicitTexture.bind(drawContext)) {
                this.explicitTexture.applyInternalTransform(drawContext);
                gL2.glEnable(3553);
                gL2.glDisable(3168);
                gL2.glDisable(3169);
            }
        } else {
            super.applyInteriorState(drawContext, surfaceTileDrawContext, shapeAttributes, this.getInteriorTexture(), this.getReferencePosition());
        }
    }

    protected List<List<Vertex>> assembleContours(Angle angle) {
        ArrayList<List<Vertex>> arrayList = new ArrayList<List<Vertex>>();
        for (int i = 0; i < this.boundaries.size(); ++i) {
            Iterable<? extends LatLon> iterable = this.boundaries.get(i);
            float[] fArray = i == 0 ? this.explicitTextureCoords : null;
            int n = 0;
            ArrayList<Vertex> arrayList2 = new ArrayList<Vertex>();
            for (LatLon latLon : iterable) {
                Vertex vertex = new Vertex(latLon);
                arrayList2.add(vertex);
                if (fArray == null || fArray.length <= n) continue;
                vertex.u = fArray[n++];
                vertex.v = fArray[n++];
            }
            this.closeContour(arrayList2);
            this.subdivideContour(arrayList2, angle);
            String string = LatLon.locationsContainPole(arrayList2);
            if (string != null) {
                arrayList.add(this.clipWithPole(arrayList2, string, angle));
                continue;
            }
            if (LatLon.locationsCrossDateLine(arrayList2)) {
                arrayList.addAll(this.clipWithDateline(arrayList2));
                continue;
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    protected void closeContour(List<Vertex> list) {
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            list.add(list.get(0));
        }
    }

    protected void subdivideContour(List<Vertex> list, Angle angle) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(list.size());
        arrayList.addAll(list);
        list.clear();
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Vertex vertex = (Vertex)arrayList.get(i);
            Vertex vertex2 = (Vertex)arrayList.get(i + 1);
            list.add(vertex);
            this.subdivideEdge(vertex, vertex2, angle, list);
        }
        Vertex vertex = (Vertex)arrayList.get(arrayList.size() - 1);
        list.add(vertex);
    }

    protected void subdivideEdge(Vertex vertex, Vertex vertex2, Angle angle, List<Vertex> list) {
        Vertex vertex3 = new Vertex(LatLon.interpolate(this.pathType, 0.5, vertex, vertex2));
        vertex3.u = 0.5 * (vertex.u + vertex2.u);
        vertex3.v = 0.5 * (vertex.v + vertex2.v);
        vertex3.edgeFlag = vertex.edgeFlag || vertex2.edgeFlag;
        Angle angle2 = LatLon.linearDistance(vertex, vertex2);
        if (angle2.compareTo(angle) > 0) {
            this.subdivideEdge(vertex, vertex3, angle, list);
            list.add(vertex3);
            this.subdivideEdge(vertex3, vertex2, angle, list);
        } else {
            list.add(vertex3);
        }
    }

    protected List<Vertex> clipWithPole(List<Vertex> list, String string, Angle angle) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        Angle angle2 = "gov.nasa.worldwind.avkey.North".equals(string) ? Angle.POS90 : Angle.NEG90;
        Vertex vertex = null;
        for (Vertex vertex2 : list) {
            if (vertex != null) {
                arrayList.add(vertex);
                if (LatLon.locationsCrossDateline(vertex, vertex2)) {
                    LatLon latLon = LatLon.intersectionWithMeridian(vertex, vertex2, Angle.POS180);
                    double d = Math.signum(vertex.getLongitude().degrees);
                    Angle angle3 = latLon.getLatitude();
                    Angle angle4 = Angle.POS180.multiply(d);
                    Angle angle5 = angle4.multiply(-1.0);
                    Vertex vertex3 = new Vertex(angle3, angle4, 0.0, 0.0);
                    Vertex vertex4 = new Vertex(angle2, angle4, 0.0, 0.0);
                    Vertex vertex5 = new Vertex(angle2, Angle.ZERO, 0.0, 0.0);
                    Vertex vertex6 = new Vertex(angle2, angle5, 0.0, 0.0);
                    Vertex vertex7 = new Vertex(angle3, angle5, 0.0, 0.0);
                    vertex7.edgeFlag = false;
                    vertex6.edgeFlag = false;
                    vertex5.edgeFlag = false;
                    vertex4.edgeFlag = false;
                    vertex3.edgeFlag = false;
                    double d2 = LatLon.linearDistance((LatLon)vertex, (LatLon)vertex3).degrees;
                    double d3 = LatLon.linearDistance((LatLon)vertex2, (LatLon)vertex7).degrees;
                    double d4 = d2 / (d2 + d3);
                    vertex3.u = vertex7.u = WWMath.mix(d4, vertex.u, vertex2.u);
                    vertex3.v = vertex7.v = WWMath.mix(d4, vertex.v, vertex2.v);
                    double[] dArray = this.uvWeightedAverage(list, vertex5);
                    vertex6.u = vertex5.u = dArray[0];
                    vertex4.u = vertex5.u;
                    vertex6.v = vertex5.v = dArray[1];
                    vertex4.v = vertex5.v;
                    arrayList.add(vertex3);
                    arrayList.add(vertex4);
                    this.subdivideEdge(vertex4, vertex5, angle, arrayList);
                    arrayList.add(vertex5);
                    this.subdivideEdge(vertex5, vertex6, angle, arrayList);
                    arrayList.add(vertex6);
                    arrayList.add(vertex7);
                }
            }
            vertex = vertex2;
        }
        arrayList.add(vertex);
        return arrayList;
    }

    protected double[] uvWeightedAverage(List<Vertex> list, Vertex vertex) {
        double[] dArray = new double[list.size()];
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d2 = LatLon.greatCircleDistance((LatLon)((LatLon)list.get((int)i)), (LatLon)vertex).degrees;
            dArray[i] = 1.0 / d2;
            d += dArray[i];
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d5 = dArray[i] / d;
            d3 += list.get((int)i).u * d5;
            d4 += list.get((int)i).v * d5;
        }
        return new double[]{d3, d4};
    }

    protected List<List<Vertex>> clipWithDateline(List<Vertex> list) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        Vertex object = null;
        Angle angle = null;
        boolean bl = false;
        for (Vertex object2 : list) {
            if (object != null && LatLon.locationsCrossDateline(object, object2)) {
                if (angle == null) {
                    angle = object.longitude.degrees < 0.0 ? Angle.NEG360 : Angle.POS360;
                }
                boolean bl2 = bl = !bl;
            }
            if (bl) {
                arrayList.add(new Vertex(object2.latitude, object2.longitude.add(angle), object2.u, object2.v));
            } else {
                arrayList.add(object2);
            }
            object = object2;
        }
        ArrayList arrayList2 = new ArrayList();
        for (Vertex vertex : arrayList) {
            arrayList2.add(new Vertex(vertex.latitude, vertex.longitude.subtract(angle), vertex.u, vertex.v));
        }
        return Arrays.asList(arrayList, arrayList2);
    }

    protected ShapeData tessellateContours(List<List<Vertex>> list) {
        Object object;
        Object object2;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        if (tess == null) {
            tess = GLU.gluNewTess();
            tessCallback = new GLUTessellatorSupport.CollectPrimitivesCallback();
            tessCallback.attach(tess);
            GLU.gluTessCallback(tess, 100111, new GLUtessellatorCallbackAdapter(){

                @Override
                public void combineData(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2, Object object) {
                    int n;
                    List list = (List)object;
                    Vertex vertex = new Vertex(LatLon.fromDegrees(dArray[1], dArray[0]));
                    vertex.edgeFlag = false;
                    for (n = 0; n < 4; ++n) {
                        if (!(fArray[n] > 0.0f)) continue;
                        int n2 = ((GLUTessellatorSupport.VertexData)objectArray[n]).index;
                        Vertex vertex2 = (Vertex)list.get(n2);
                        vertex.u += (double)fArray[n] * vertex2.u;
                        vertex.v += (double)fArray[n] * vertex2.v;
                        vertex.edgeFlag |= vertex2.edgeFlag;
                    }
                    n = ((Collection)object).size();
                    list.add(vertex);
                    objectArray2[0] = new GLUTessellatorSupport.VertexData(n, vertex.edgeFlag);
                }
            });
        }
        try {
            tessCallback.reset();
            GLU.gluTessNormal(tess, 0.0, 0.0, 1.0);
            GLU.gluTessBeginPolygon(tess, arrayList);
            for (List<Vertex> list2 : list) {
                GLU.gluTessBeginContour(tess);
                for (Vertex vertex : list2) {
                    dArray[0] = vertex.longitude.degrees;
                    dArray[1] = vertex.latitude.degrees;
                    int n = arrayList.size();
                    arrayList.add(vertex);
                    object2 = new GLUTessellatorSupport.VertexData(n, vertex.edgeFlag);
                    GLU.gluTessVertex(tess, dArray, 0, object2);
                }
                GLU.gluTessEndContour(tess);
            }
            GLU.gluTessEndPolygon(tess);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileTessellating", exception.getMessage());
            Logging.logger().log(Level.SEVERE, string, exception);
            return null;
        }
        if (tessCallback.getError() != 0) {
            object = Logging.getMessage("generic.ExceptionWhileTessellating", GLUTessellatorSupport.convertGLUTessErrorToString(tessCallback.getError()));
            Logging.logger().log(Level.SEVERE, (String)object);
            return null;
        }
        object = new ShapeData();
        ((ShapeData)object).hasTexCoords = this.explicitTextureCoords != null;
        ((ShapeData)object).vertexStride = ((ShapeData)object).hasTexCoords ? 16 : 0;
        ((ShapeData)object).vertices = Buffers.newDirectFloatBuffer(arrayList.size() * (((ShapeData)object).hasTexCoords ? 4 : 2));
        double d = this.getReferencePosition().longitude.degrees;
        double d2 = this.getReferencePosition().latitude.degrees;
        for (Vertex vertex : arrayList) {
            ((ShapeData)object).vertices.put((float)(vertex.longitude.degrees - d));
            ((ShapeData)object).vertices.put((float)(vertex.latitude.degrees - d2));
            if (!((ShapeData)object).hasTexCoords) continue;
            ((ShapeData)object).vertices.put((float)vertex.u);
            ((ShapeData)object).vertices.put((float)vertex.v);
        }
        ((ShapeData)object).vertices.rewind();
        object2 = tessCallback.getTriangleIndices();
        ((ShapeData)object).interiorIndices = Buffers.newDirectIntBuffer(((Buffer)object2).remaining());
        ((ShapeData)object).interiorIndices.put((IntBuffer)object2);
        ((ShapeData)object).interiorIndices.rewind();
        object2 = tessCallback.getLineIndices();
        ((ShapeData)object).outlineIndices = Buffers.newDirectIntBuffer(((Buffer)object2).remaining());
        ((ShapeData)object).outlineIndices.put((IntBuffer)object2);
        ((ShapeData)object).outlineIndices.rewind();
        return object;
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, double d) {
        if (this.boundaries.isEmpty()) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList = new ArrayList<List<LatLon>>();
        for (Iterable<? extends LatLon> iterable : this.boundaries) {
            ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
            this.generateIntermediateLocations(iterable, d, true, arrayList2);
            if (WWMath.computeWindingOrderOfLocations(arrayList2) != "gov.nasa.worldwind.avkey.CounterClockWise") {
                Collections.reverse(arrayList2);
            }
            arrayList.add(arrayList2);
        }
        if (arrayList.isEmpty() || ((List)arrayList.get(0)).size() < 3) {
            return null;
        }
        return arrayList;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (this.boundaries.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.boundaries.size(); ++i) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (LatLon latLon : this.boundaries.get(i)) {
                Angle angle = LatLon.greatCircleAzimuth(position, latLon);
                Angle angle2 = LatLon.greatCircleDistance(position, latLon);
                arrayList.add(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
            }
            this.boundaries.set(i, arrayList);
        }
        this.onShapeChanged();
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (this.boundaries.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.boundaries.size(); ++i) {
            List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, this.boundaries.get(i));
            this.boundaries.set(i, list);
        }
        this.onShapeChanged();
    }

    @Override
    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
        super.handleUnsuccessfulInteriorTessellation(drawContext);
        this.boundaries.clear();
        this.onShapeChanged();
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        if (!this.boundaries.isEmpty()) {
            RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "boundaries");
            for (Iterable<? extends LatLon> iterable : this.boundaries) {
                restorableSupport.addStateValueAsLatLonList(stateObject2, "boundary", iterable);
            }
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "boundaries");
        if (stateObject2 != null) {
            this.boundaries.clear();
            RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "boundary");
            if (stateObjectArray != null) {
                for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                    List<LatLon> list;
                    if (stateObject3 == null || (list = restorableSupport.getStateObjectAsLatLonList(stateObject3)) == null) continue;
                    this.boundaries.add(list);
                }
            }
            this.onShapeChanged();
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locationList");
        if (list == null) {
            list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        }
        if (list != null) {
            this.setOuterBoundary(list);
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        Iterator<Iterable<? extends LatLon>> iterator;
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        Iterable<? extends LatLon> iterable = this.getOuterBoundary();
        if (iterable != null) {
            xMLStreamWriter.writeStartElement("outerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable, null);
            xMLStreamWriter.writeEndElement();
        }
        if ((iterator = this.boundaries.iterator()).hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Iterable<? extends LatLon> iterable2 = iterator.next();
            xMLStreamWriter.writeStartElement("innerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable2, null);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    protected static class ShapeData {
        public int vertexStride;
        public boolean hasTexCoords;
        public FloatBuffer vertices;
        public IntBuffer interiorIndices;
        public IntBuffer outlineIndices;

        protected ShapeData() {
        }
    }

    protected static class Vertex
    extends LatLon {
        public double u;
        public double v;
        public boolean edgeFlag = true;

        public Vertex(LatLon latLon) {
            super(latLon);
        }

        public Vertex(Angle angle, Angle angle2, double d, double d2) {
            super(angle, angle2);
            this.u = d;
            this.v = d2;
        }
    }
}

