/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.OutlinedShape;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

public abstract class AbstractAirspace
extends WWObjectImpl
implements Airspace,
OrderedRenderable,
PreRenderable,
Movable,
Movable2,
Draggable {
    protected static final String ARC_SLICES = "ArcSlices";
    protected static final String DISABLE_TERRAIN_CONFORMANCE = "DisableTerrainConformance";
    protected static final String EXPIRY_TIME = "ExpiryTime";
    protected static final String GEOMETRY_CACHE_NAME = "Airspace Geometry";
    protected static final String GEOMETRY_CACHE_KEY = Geometry.class.getName();
    protected static final String GLOBE_KEY = "GlobeKey";
    protected static final String LENGTH_SLICES = "LengthSlices";
    protected static final String LOOPS = "Loops";
    protected static final String PILLARS = "Pillars";
    protected static final String SLICES = "Slices";
    protected static final String SPLIT_THRESHOLD = "SplitThreshold";
    protected static final String STACKS = "Stacks";
    protected static final String SUBDIVISIONS = "Subdivisions";
    protected static final String VERTICAL_EXAGGERATION = "VerticalExaggeration";
    private static final long DEFAULT_GEOMETRY_CACHE_SIZE = 0x1000000L;
    protected static final int DEFAULT_OUTLINE_PICK_WIDTH = 10;
    protected static final Material DEFAULT_INTERIOR_MATERIAL = Material.LIGHT_GRAY;
    protected static final Material DEFAULT_OUTLINE_MATERIAL = Material.DARK_GRAY;
    protected static final Material DEFAULT_HIGHLIGHT_MATERIAL = Material.WHITE;
    protected static AirspaceAttributes defaultAttributes = new BasicAirspaceAttributes();
    protected boolean visible = true;
    protected boolean highlighted;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected AirspaceAttributes attributes;
    protected AirspaceAttributes highlightAttributes;
    protected AirspaceAttributes activeAttributes = new BasicAirspaceAttributes();
    protected double lowerAltitude = 0.0;
    protected double upperAltitude = 1.0;
    protected boolean lowerTerrainConforming = false;
    protected boolean upperTerrainConforming = false;
    protected String lowerAltitudeDatum = "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
    protected String upperAltitudeDatum = "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
    protected LatLon groundReference;
    protected boolean enableLevelOfDetail = true;
    protected Collection<DetailLevel> detailLevels = new TreeSet<DetailLevel>();
    protected boolean enableBatchRendering = true;
    protected boolean enableBatchPicking = true;
    protected boolean enableDepthOffset;
    protected int outlinePickWidth = 10;
    protected Object delegateOwner;
    protected SurfaceShape surfaceShape;
    protected boolean mustRegenerateSurfaceShape;
    protected boolean drawSurfaceShape;
    protected long frameTimeStamp;
    protected boolean alwaysOnTop = false;
    protected AirspaceInfo currentInfo;
    protected Layer pickLayer;
    protected PickSupport pickSupport = new PickSupport();
    protected GeometryBuilder geometryBuilder = new GeometryBuilder();
    protected long expiryTime = -1L;
    protected long minExpiryTime = 2000L;
    protected long maxExpiryTime = 6000L;
    protected static Random rand;
    protected Map<LatLon, Double> elevationMap = new HashMap<LatLon, Double>();
    protected OutlinedShape outlineShapeRenderer = new OutlinedShape(){

        @Override
        public boolean isDrawOutline(DrawContext drawContext, Object object) {
            return ((AbstractAirspace)object).mustDrawOutline(drawContext);
        }

        @Override
        public boolean isDrawInterior(DrawContext drawContext, Object object) {
            return ((AbstractAirspace)object).mustDrawInterior(drawContext);
        }

        @Override
        public void drawOutline(DrawContext drawContext, Object object) {
            ((AbstractAirspace)object).drawOutline(drawContext);
        }

        @Override
        public void drawInterior(DrawContext drawContext, Object object) {
            ((AbstractAirspace)object).drawInterior(drawContext);
        }

        @Override
        public boolean isEnableDepthOffset(DrawContext drawContext, Object object) {
            return ((AbstractAirspace)object).isEnableDepthOffset();
        }

        @Override
        public Double getDepthOffsetFactor(DrawContext drawContext, Object object) {
            return null;
        }

        @Override
        public Double getDepthOffsetUnits(DrawContext drawContext, Object object) {
            return null;
        }
    };
    protected HashMap<GlobeStateKey, AirspaceInfo> airspaceInfo = new HashMap(2);

    public AbstractAirspace(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
        if (!WorldWind.getMemoryCacheSet().containsCache(GEOMETRY_CACHE_KEY)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.AirspaceGeometryCacheSize", 0x1000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(GEOMETRY_CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(GEOMETRY_CACHE_KEY, basicMemoryCache);
        }
    }

    protected abstract Extent computeExtent(Globe var1, double var2);

    protected abstract List<Vec4> computeMinimalGeometry(Globe var1, double var2);

    public AbstractAirspace(AbstractAirspace abstractAirspace) {
        this(abstractAirspace.getAttributes());
        this.visible = abstractAirspace.visible;
        this.attributes = abstractAirspace.attributes;
        this.highlightAttributes = abstractAirspace.highlightAttributes;
        this.lowerAltitude = abstractAirspace.lowerAltitude;
        this.upperAltitude = abstractAirspace.upperAltitude;
        this.lowerAltitudeDatum = abstractAirspace.lowerAltitudeDatum;
        this.upperAltitudeDatum = abstractAirspace.upperAltitudeDatum;
        this.lowerTerrainConforming = abstractAirspace.lowerTerrainConforming;
        this.upperTerrainConforming = abstractAirspace.upperTerrainConforming;
        this.groundReference = abstractAirspace.groundReference;
        this.enableLevelOfDetail = abstractAirspace.enableLevelOfDetail;
        this.enableBatchPicking = abstractAirspace.enableBatchPicking;
        this.enableBatchRendering = abstractAirspace.enableBatchRendering;
        this.enableDepthOffset = abstractAirspace.enableDepthOffset;
        this.outlinePickWidth = abstractAirspace.outlinePickWidth;
        this.delegateOwner = abstractAirspace.delegateOwner;
        this.drawSurfaceShape = abstractAirspace.drawSurfaceShape;
    }

    public AbstractAirspace() {
        this(new BasicAirspaceAttributes());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public AirspaceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
    }

    @Override
    public void setAttributes(ShapeAttributes shapeAttributes) {
        this.setAttributes(new BasicAirspaceAttributes(shapeAttributes));
    }

    @Override
    public void setHighlightAttributes(ShapeAttributes shapeAttributes) {
        this.setHighlightAttributes(shapeAttributes != null ? new BasicAirspaceAttributes(shapeAttributes) : null);
    }

    @Override
    public AirspaceAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    @Override
    public void setHighlightAttributes(AirspaceAttributes airspaceAttributes) {
        this.highlightAttributes = airspaceAttributes;
        if (this.surfaceShape != null) {
            this.surfaceShape.setHighlightAttributes(airspaceAttributes);
        }
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public double[] getAltitudes() {
        double[] dArray = new double[]{this.lowerAltitude, this.upperAltitude};
        return dArray;
    }

    protected double[] getAltitudes(double d) {
        double[] dArray = this.getAltitudes();
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        return dArray;
    }

    @Override
    public void setAltitudes(double d, double d2) {
        this.lowerAltitude = d;
        this.upperAltitude = d2;
        this.invalidateAirspaceData();
    }

    @Override
    public void setAltitude(double d) {
        this.setAltitudes(d, d);
    }

    @Override
    public boolean[] isTerrainConforming() {
        boolean[] blArray = new boolean[]{this.lowerTerrainConforming, this.upperTerrainConforming};
        return blArray;
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        this.lowerTerrainConforming = bl;
        this.upperTerrainConforming = bl2;
        this.lowerAltitudeDatum = this.lowerTerrainConforming ? "gov.nasa.worldwind.avkey.AboveGroundLevel" : "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
        this.upperAltitudeDatum = this.upperTerrainConforming ? "gov.nasa.worldwind.avkey.AboveGroundLevel" : "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
        this.invalidateAirspaceData();
    }

    @Override
    public String[] getAltitudeDatum() {
        return new String[]{this.lowerAltitudeDatum, this.upperAltitudeDatum};
    }

    @Override
    public void setAltitudeDatum(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.AltitudeDatumIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.lowerAltitudeDatum = string;
        this.upperAltitudeDatum = string2;
        if (string.equals("gov.nasa.worldwind.avkey.AboveGroundLevel") || string.equals("gov.nasa.worldwind.avkey.AboveGroundReference")) {
            this.lowerTerrainConforming = true;
        }
        if (string2.equals("gov.nasa.worldwind.avkey.AboveGroundLevel") || string2.equals("gov.nasa.worldwind.avkey.AboveGroundReference")) {
            this.upperTerrainConforming = true;
        }
        this.invalidateAirspaceData();
    }

    @Override
    public LatLon getGroundReference() {
        return this.groundReference;
    }

    @Override
    public void setGroundReference(LatLon latLon) {
        this.groundReference = latLon;
    }

    @Override
    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    @Override
    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    @Override
    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    @Override
    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    @Override
    public boolean isEnableDepthOffset() {
        return this.enableDepthOffset;
    }

    @Override
    public void setEnableDepthOffset(boolean bl) {
        this.enableDepthOffset = bl;
    }

    @Override
    public int getOutlinePickWidth() {
        return this.outlinePickWidth;
    }

    @Override
    public void setOutlinePickWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlinePickWidth = n;
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    @Override
    public boolean isDrawSurfaceShape() {
        return this.drawSurfaceShape;
    }

    @Override
    public void setDrawSurfaceShape(boolean bl) {
        this.drawSurfaceShape = bl;
    }

    protected void adjustForGroundReference(DrawContext drawContext, boolean[] blArray, double[] dArray, LatLon latLon) {
        if (latLon == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.getAltitudeDatum()[i].equals("gov.nasa.worldwind.avkey.AboveGroundReference")) continue;
            int n = i;
            dArray[n] = dArray[n] + this.computeElevationAt(drawContext, latLon.getLatitude(), latLon.getLongitude());
            blArray[i] = false;
        }
    }

    public boolean isAirspaceCollapsed() {
        return this.lowerAltitude == this.upperAltitude && this.lowerTerrainConforming == this.upperTerrainConforming;
    }

    @Override
    public void setTerrainConforming(boolean bl) {
        this.setTerrainConforming(bl, bl);
    }

    @Override
    public boolean isEnableLevelOfDetail() {
        return this.enableLevelOfDetail;
    }

    @Override
    public void setEnableLevelOfDetail(boolean bl) {
        this.enableLevelOfDetail = bl;
    }

    @Override
    public Iterable<DetailLevel> getDetailLevels() {
        return this.detailLevels;
    }

    @Override
    public void setDetailLevels(Collection<DetailLevel> collection) {
        this.detailLevels.clear();
        this.addDetailLevels(collection);
    }

    protected void addDetailLevels(Collection<DetailLevel> collection) {
        if (collection != null) {
            for (DetailLevel detailLevel : collection) {
                if (detailLevel == null) continue;
                this.detailLevels.add(detailLevel);
            }
        }
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = "nullValue.DrawingContextViewIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = this.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeExtent(globe, d);
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getAirspaceInfo((DrawContext)drawContext).extent;
    }

    protected AirspaceInfo getAirspaceInfo(DrawContext drawContext) {
        AirspaceInfo airspaceInfo = this.airspaceInfo.get(drawContext.getGlobe().getGlobeStateKey());
        if (airspaceInfo == null || !airspaceInfo.isValid(drawContext)) {
            airspaceInfo = new AirspaceInfo(drawContext, this.computeExtent(drawContext), this.computeMinimalGeometry(drawContext));
            this.airspaceInfo.put(drawContext.getGlobe().getGlobeStateKey(), airspaceInfo);
        }
        return airspaceInfo;
    }

    protected Extent computeExtent(DrawContext drawContext) {
        return this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
    }

    protected List<Vec4> computeMinimalGeometry(DrawContext drawContext) {
        return this.computeMinimalGeometry(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
    }

    protected void invalidateAirspaceData() {
        this.airspaceInfo.clear();
        this.mustRegenerateSurfaceShape = true;
    }

    @Override
    public double getDistanceFromEye() {
        return this.isAlwaysOnTop() ? 0.0 : this.currentInfo.getEyeDistance();
    }

    protected void determineActiveAttributes(DrawContext drawContext) {
        if (this.frameTimeStamp == drawContext.getFrameTimeStamp()) {
            return;
        }
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttributes.copy(this.getHighlightAttributes());
            } else {
                if (this.getAttributes() != null) {
                    this.activeAttributes.copy(this.getAttributes());
                } else {
                    this.activeAttributes.copy(defaultAttributes);
                }
                this.activeAttributes.setOutlineMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeAttributes.setInteriorMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttributes.copy(this.getAttributes());
        } else {
            this.activeAttributes.copy(defaultAttributes);
        }
    }

    public AirspaceAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.is2DGlobe() || this.isDrawSurfaceShape()) {
            if (this.surfaceShape == null) {
                this.surfaceShape = this.createSurfaceShape();
                this.mustRegenerateSurfaceShape = true;
                if (this.surfaceShape == null) {
                    return;
                }
            }
            if (this.mustRegenerateSurfaceShape) {
                this.regenerateSurfaceShape(drawContext, this.surfaceShape);
                this.mustRegenerateSurfaceShape = false;
            }
            this.updateSurfaceShape(drawContext, this.surfaceShape);
            this.surfaceShape.preRender(drawContext);
        }
    }

    protected SurfaceShape createSurfaceShape() {
        return null;
    }

    protected void updateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        this.determineActiveAttributes(drawContext);
        AirspaceAttributes airspaceAttributes = this.getActiveAttributes();
        if (surfaceShape.getAttributes() == null) {
            surfaceShape.setAttributes(new BasicShapeAttributes(airspaceAttributes));
        } else {
            surfaceShape.getAttributes().copy(airspaceAttributes);
        }
        Object object = this.getDelegateOwner();
        surfaceShape.setDelegateOwner(object != null ? object : this);
        boolean bl = this.isEnableBatchPicking();
        surfaceShape.setEnableBatchPicking(bl);
    }

    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if ((drawContext.is2DGlobe() || this.isDrawSurfaceShape()) && this.surfaceShape != null) {
            this.surfaceShape.render(drawContext);
            return;
        }
        this.currentInfo = this.getAirspaceInfo(drawContext);
        if (!this.isAirspaceVisible(drawContext)) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
        this.frameTimeStamp = drawContext.getFrameTimeStamp();
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        this.determineActiveAttributes(drawContext);
        double d = this.computeEyeDistance(drawContext);
        this.currentInfo.setEyeDistance(d);
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
        drawContext.addOrderedRenderable(this);
    }

    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginRendering(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchRendering()) {
                this.drawBatched(drawContext);
            }
        }
        finally {
            this.endRendering(drawContext);
        }
    }

    protected void drawBatched(DrawContext drawContext) {
        block3: {
            AbstractAirspace abstractAirspace;
            OrderedRenderable orderedRenderable;
            block2: {
                AbstractAirspace abstractAirspace2;
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block2;
                while (orderedRenderable instanceof AbstractAirspace && (abstractAirspace2 = (AbstractAirspace)orderedRenderable).isEnableBatchRendering()) {
                    drawContext.pollOrderedRenderables();
                    abstractAirspace2.doDrawOrderedRenderable(drawContext, this.pickSupport);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                }
                break block3;
            }
            if (!this.isEnableBatchPicking()) break block3;
            while (orderedRenderable instanceof AbstractAirspace && (abstractAirspace = (AbstractAirspace)orderedRenderable).isEnableBatchRendering() && abstractAirspace.isEnableBatchPicking() && abstractAirspace.pickLayer == this.pickLayer) {
                drawContext.pollOrderedRenderables();
                abstractAirspace.doDrawOrderedRenderable(drawContext, this.pickSupport);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        if (drawContext.isPickingMode()) {
            GL2 gL2 = drawContext.getGL().getGL2();
            Color color = drawContext.getUniquePickColor();
            pickSupport.addPickableObject(this.createPickedObject(color.getRGB()));
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        drawContext.drawOutlinedShape(this.outlineShapeRenderer, this);
    }

    protected PickedObject createPickedObject(int n) {
        return new PickedObject(n, this.getDelegateOwner() != null ? this.getDelegateOwner() : this);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Globe globe, Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        Position position3 = position;
        this.doMoveTo(globe, position2, position3);
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = true;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, this.isTerrainConforming()[0] ? 2 : 0);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    protected void doMoveTo(Globe globe, Position position, Position position2) {
        this.doMoveTo(position, position2);
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        Position position3 = position;
        this.doMoveTo(position2, position3);
    }

    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes();
        double d = position2.getElevation() - position.getElevation();
        this.setAltitudes(dArray[0] + d, dArray[1] + d);
    }

    protected Position computeReferencePosition(List<? extends LatLon> list, double[] dArray) {
        if (list == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = "nullValue.AltitudesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        LatLon latLon = n < 3 ? list.get(0) : list.get(n / 2);
        return new Position(latLon, dArray[0]);
    }

    protected double computeEyeDistance(DrawContext drawContext) {
        AirspaceInfo airspaceInfo = this.currentInfo;
        if (airspaceInfo == null || airspaceInfo.minimalGeometry == null || airspaceInfo.minimalGeometry.isEmpty()) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        Vec4 vec4 = drawContext.getView().getEyePoint();
        for (Vec4 vec42 : airspaceInfo.minimalGeometry) {
            double d2 = vec42.distanceToSquared3(vec4);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    protected abstract void doRenderGeometry(DrawContext var1, String var2);

    protected void beginRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnableClientState(32884);
        if (!drawContext.isPickingMode()) {
            int n = 20493;
            gL2.glPushAttrib(n);
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
            drawContext.beginStandardLighting();
        } else {
            int n = 5;
            gL2.glPushAttrib(n);
        }
    }

    protected void endRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisableClientState(32884);
        if (!drawContext.isPickingMode()) {
            drawContext.endStandardLighting();
            gL2.glDisableClientState(32885);
        }
        gL2.glPopAttrib();
    }

    protected boolean mustDrawInterior(DrawContext drawContext) {
        return this.getActiveAttributes().isDrawInterior();
    }

    protected void drawInterior(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        AirspaceAttributes airspaceAttributes = this.getActiveAttributes();
        if (!drawContext.isPickingMode()) {
            if (airspaceAttributes.isEnableLighting()) {
                gL2.glEnable(2896);
                gL2.glEnableClientState(32885);
                airspaceAttributes.getInteriorMaterial().apply(gL2, 1032, (float)airspaceAttributes.getInteriorOpacity());
            } else {
                gL2.glDisable(2896);
                gL2.glDisableClientState(32885);
                Color color = airspaceAttributes.getInteriorMaterial().getDiffuse();
                double d = airspaceAttributes.getInteriorOpacity();
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
            }
        }
        this.doRenderGeometry(drawContext, "Airspace.DrawStyleFill");
    }

    protected boolean mustDrawOutline(DrawContext drawContext) {
        return this.getActiveAttributes().isDrawOutline();
    }

    protected void drawOutline(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        AirspaceAttributes airspaceAttributes = this.getActiveAttributes();
        if (!drawContext.isPickingMode()) {
            gL2.glDisable(2896);
            gL2.glDisableClientState(32885);
            Color color = airspaceAttributes.getOutlineMaterial().getDiffuse();
            double d = airspaceAttributes.getOutlineOpacity();
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
            if (airspaceAttributes.isEnableAntialiasing()) {
                gL2.glEnable(2848);
            } else {
                gL2.glDisable(2848);
            }
        }
        if (drawContext.isPickingMode() && airspaceAttributes.getOutlineWidth() < (double)this.getOutlinePickWidth()) {
            gL2.glLineWidth(this.getOutlinePickWidth());
        } else {
            gL2.glLineWidth((float)airspaceAttributes.getOutlineWidth());
        }
        if (airspaceAttributes.getOutlineStippleFactor() > 0) {
            gL2.glEnable(2852);
            gL2.glLineStipple(airspaceAttributes.getOutlineStippleFactor(), airspaceAttributes.getOutlineStipplePattern());
        } else {
            gL2.glDisable(2852);
        }
        this.doRenderGeometry(drawContext, "Airspace.DrawStyleOutline");
    }

    protected void drawGeometry(DrawContext drawContext, Geometry geometry, Geometry geometry2) {
        GL2 gL2 = drawContext.getGL().getGL2();
        AirspaceAttributes airspaceAttributes = this.getActiveAttributes();
        int n = geometry2.getSize(2);
        int n2 = geometry2.getGLType(2);
        int n3 = geometry2.getStride(2);
        Buffer buffer = geometry2.getBuffer(2);
        gL2.glVertexPointer(n, n2, n3, buffer);
        if (!drawContext.isPickingMode() && airspaceAttributes.isEnableLighting()) {
            n2 = geometry2.getGLType(3);
            n3 = geometry2.getStride(3);
            buffer = geometry2.getBuffer(3);
            gL2.glNormalPointer(n2, n3, buffer);
        }
        int n4 = geometry.getMode(1);
        int n5 = geometry.getCount(1);
        n2 = geometry.getGLType(1);
        int n6 = 0;
        int n7 = geometry2.getCount(2) - 1;
        buffer = geometry.getBuffer(1);
        gL2.glDrawRangeElements(n4, n6, n7, n5, n2, buffer);
    }

    protected GeometryBuilder getGeometryBuilder() {
        return this.geometryBuilder;
    }

    protected void setGeometryBuilder(GeometryBuilder geometryBuilder) {
        if (geometryBuilder == null) {
            String string = "nullValue.GeometryBuilderIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geometryBuilder = geometryBuilder;
    }

    protected DetailLevel computeDetailLevel(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<DetailLevel> iterable = this.getDetailLevels();
        if (iterable == null) {
            return null;
        }
        Iterator<DetailLevel> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DetailLevel detailLevel = iterator.next();
        while (iterator.hasNext() && !detailLevel.meetsCriteria(drawContext, this)) {
            detailLevel = iterator.next();
        }
        return detailLevel;
    }

    protected MemoryCache getGeometryCache() {
        return WorldWind.getMemoryCache(GEOMETRY_CACHE_KEY);
    }

    protected boolean isExpired(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = geometry.getValue(EXPIRY_TIME);
        if (object != null && object instanceof Long && drawContext.getFrameTimeStamp() > (Long)object) {
            return true;
        }
        object = geometry.getValue(GLOBE_KEY);
        return object != null && !drawContext.getGlobe().getStateKey(drawContext).equals(object);
    }

    protected void updateExpiryCriteria(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = this.getExpiryTime();
        geometry.setValue(EXPIRY_TIME, l >= 0L ? Long.valueOf(l) : null);
        geometry.setValue(GLOBE_KEY, drawContext.getGlobe().getStateKey(drawContext));
    }

    protected long getExpiryTime() {
        return this.expiryTime;
    }

    protected void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    protected long[] getExpiryRange() {
        long[] lArray = new long[]{this.minExpiryTime, this.maxExpiryTime};
        return lArray;
    }

    protected void setExpiryRange(long l, long l2) {
        this.minExpiryTime = l;
        this.maxExpiryTime = l2;
    }

    protected long nextExpiryTime(DrawContext drawContext, boolean[] blArray) {
        long l;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blArray[0] || blArray[1]) {
            long l2 = AbstractAirspace.nextLong(this.minExpiryTime, this.maxExpiryTime);
            l = drawContext.getFrameTimeStamp() + l2;
        } else {
            l = -1L;
        }
        return l;
    }

    private static long nextLong(long l, long l2) {
        long l3 = l2 - l + 1L;
        long l4 = rand.nextLong() % l3;
        return l + (l4 < 0L ? -l4 : l4);
    }

    protected void clearElevationMap() {
        this.elevationMap.clear();
    }

    public Vec4 computePointFromPosition(DrawContext drawContext, Angle angle, Angle angle2, double d, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d;
        if (bl) {
            d2 += this.computeElevationAt(drawContext, angle, angle2);
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d2);
    }

    protected double computeElevationAt(DrawContext drawContext, Angle angle, Angle angle2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = new LatLon(angle, angle2);
        Double d = this.elevationMap.get(latLon);
        if (d == null) {
            Globe globe = drawContext.getGlobe();
            d = 0.0;
            Vec4 vec4 = drawContext.getPointOnTerrain(angle, angle2);
            if (vec4 != null) {
                Position position = globe.computePositionFromPoint(vec4);
                d = d + position.getElevation();
            } else {
                d = d + drawContext.getVerticalExaggeration() * globe.getElevation(angle, angle2);
            }
            this.elevationMap.put(latLon, d);
        }
        return d;
    }

    protected void makeExtremePoints(Globe globe, double d, Iterable<? extends LatLon> iterable, List<Vec4> list) {
        Object object;
        Object object2;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes();
        boolean[] blArray = this.isTerrainConforming();
        if (blArray[0] || blArray[1]) {
            object2 = new double[2];
            if (LatLon.locationsCrossDateLine(iterable)) {
                object = Sector.splitBoundingSectors(iterable);
                double[] dArray2 = globe.getMinAndMaxElevations(object[0]);
                double[] dArray3 = globe.getMinAndMaxElevations((Sector)object[1]);
                object2[0] = Math.min(dArray2[0], dArray3[0]);
                object2[1] = Math.max(dArray2[1], dArray3[1]);
            } else {
                object = Sector.boundingSector(iterable);
                object2 = globe.getMinAndMaxElevations((Sector)object);
            }
            if (blArray[0]) {
                dArray[0] = dArray[0] + object2[0];
            }
            if (blArray[1]) {
                dArray[1] = dArray[1] + object2[1];
            }
        }
        object2 = iterable.iterator();
        while (object2.hasNext()) {
            object = (LatLon)object2.next();
            list.add(globe.computePointFromPosition(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude(), d * dArray[0]));
            list.add(globe.computePointFromPosition(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude(), d * dArray[1]));
        }
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyGetRestorableState(restorableSupport, stateObject);
    }

    private void doMyGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsBoolean(stateObject, "highlighted", this.isHighlighted());
        restorableSupport.addStateValueAsDouble(stateObject, "lowerAltitude", this.getAltitudes()[0]);
        restorableSupport.addStateValueAsDouble(stateObject, "upperAltitude", this.getAltitudes()[1]);
        restorableSupport.addStateValueAsBoolean(stateObject, "lowerTerrainConforming", this.isTerrainConforming()[0]);
        restorableSupport.addStateValueAsBoolean(stateObject, "upperTerrainConforming", this.isTerrainConforming()[1]);
        restorableSupport.addStateValueAsString(stateObject, "lowerAltitudeDatum", this.getAltitudeDatum()[0]);
        restorableSupport.addStateValueAsString(stateObject, "upperAltitudeDatum", this.getAltitudeDatum()[1]);
        if (this.getGroundReference() != null) {
            restorableSupport.addStateValueAsLatLon(stateObject, "groundReference", this.getGroundReference());
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "enableBatchRendering", this.isEnableBatchRendering());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableBatchPicking", this.isEnableBatchPicking());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableDepthOffset", this.isEnableDepthOffset());
        restorableSupport.addStateValueAsInteger(stateObject, "outlinePickWidth", this.getOutlinePickWidth());
        restorableSupport.addStateValueAsBoolean(stateObject, "alwaysOnTop", this.isAlwaysOnTop());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawSurfaceShape", this.isDrawSurfaceShape());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableLevelOfDetail", this.isEnableLevelOfDetail());
        if (this.attributes != null) {
            this.attributes.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
        }
        if (this.highlightAttributes != null) {
            this.highlightAttributes.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "highlightAttributes"));
        }
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyRestoreState(restorableSupport, stateObject);
    }

    private void doMyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        Integer n;
        String string;
        Boolean bl;
        Double d;
        Double d2;
        Boolean bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "visible");
        if (bl2 != null) {
            this.setVisible(bl2);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "highlighted")) != null) {
            this.setHighlighted(bl2);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "lowerAltitude")) == null) {
            d2 = this.getAltitudes()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "upperAltitude")) == null) {
            d = this.getAltitudes()[1];
        }
        this.setAltitudes(d2, d);
        Boolean bl3 = restorableSupport.getStateValueAsBoolean(stateObject, "lowerTerrainConforming");
        if (bl3 == null) {
            bl3 = this.isTerrainConforming()[0];
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "upperTerrainConforming")) == null) {
            bl = this.isTerrainConforming()[1];
        }
        this.setTerrainConforming(bl3, bl);
        String string2 = restorableSupport.getStateValueAsString(stateObject, "lowerAltitudeDatum");
        if (string2 == null) {
            string2 = this.getAltitudeDatum()[0];
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "upperAltitudeDatum")) == null) {
            string = this.getAltitudeDatum()[1];
        }
        this.setAltitudeDatum(string2, string);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "groundReference");
        if (latLon != null) {
            this.setGroundReference(latLon);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableBatchRendering")) != null) {
            this.setEnableBatchRendering(bl2);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableBatchPicking")) != null) {
            this.setEnableBatchPicking(bl2);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableDepthOffset")) != null) {
            this.setEnableDepthOffset(bl2);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "outlinePickWidth")) != null) {
            this.setOutlinePickWidth(n);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "alwaysOnTop")) != null) {
            this.setAlwaysOnTop(bl2);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "drawSurfaceShape")) != null) {
            this.setDrawSurfaceShape(bl2);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableLevelOfDetail")) != null) {
            this.setEnableLevelOfDetail(bl2);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "attributes")) != null) {
            this.getAttributes().restoreState(restorableSupport, stateObject2);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "highlightAttributes")) != null) {
            this.getHighlightAttributes().restoreState(restorableSupport, stateObject2);
        }
    }

    static {
        defaultAttributes.setInteriorMaterial(DEFAULT_INTERIOR_MATERIAL);
        defaultAttributes.setOutlineMaterial(DEFAULT_OUTLINE_MATERIAL);
        rand = new Random();
    }

    protected static class AirspaceInfo {
        protected Extent extent;
        protected double eyeDistance;
        protected List<Vec4> minimalGeometry;
        protected double verticalExaggeration;
        protected Object globeStateKey;

        public AirspaceInfo(DrawContext drawContext, Extent extent, List<Vec4> list) {
            this.extent = extent;
            this.minimalGeometry = list;
            this.verticalExaggeration = drawContext.getVerticalExaggeration();
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }

        public double getEyeDistance() {
            return this.eyeDistance;
        }

        public void setEyeDistance(double d) {
            this.eyeDistance = d;
        }

        public boolean isValid(DrawContext drawContext) {
            return this.verticalExaggeration == drawContext.getVerticalExaggeration() && this.globeStateKey != null && this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
        }
    }
}

