/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;

public class BasicAirspaceAttributes
extends BasicShapeAttributes
implements AirspaceAttributes {
    public BasicAirspaceAttributes() {
        this.drawOutline = false;
        this.enableAntialiasing = false;
        this.enableLighting = true;
    }

    public BasicAirspaceAttributes(Material material, double d) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawOutline = false;
        this.enableAntialiasing = false;
        this.enableLighting = true;
        this.interiorMaterial = material;
        this.interiorOpacity = d;
    }

    public BasicAirspaceAttributes(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public BasicAirspaceAttributes(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    @Override
    public AirspaceAttributes copy() {
        return new BasicAirspaceAttributes(this);
    }

    public void copy(AirspaceAttributes airspaceAttributes) {
        super.copy(airspaceAttributes);
    }

    @Override
    public Material getMaterial() {
        return this.getInteriorMaterial();
    }

    @Override
    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setInteriorMaterial(material);
    }

    @Override
    public double getOpacity() {
        return this.getInteriorOpacity();
    }

    @Override
    public void setOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setInteriorOpacity(d);
    }

    @Override
    public void applyInterior(DrawContext drawContext, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.applyMaterial(drawContext, this.getInteriorMaterial(), this.getInteriorOpacity(), bl);
    }

    @Override
    public void applyOutline(DrawContext drawContext, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.applyMaterial(drawContext, this.getOutlineMaterial(), this.getOutlineOpacity(), bl);
        GL gL = drawContext.getGL();
        gL.glLineWidth((float)this.getOutlineWidth());
    }

    @Override
    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.restoreState(restorableSupport, stateObject);
        this.restoreDeprecatedState(restorableSupport, stateObject);
    }

    protected void restoreDeprecatedState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "material");
        if (stateObject2 != null) {
            this.setInteriorMaterial(this.getInteriorMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "opacity")) != null) {
            this.setInteriorOpacity(d);
        }
    }

    protected void applyMaterial(DrawContext drawContext, Material material, double d, boolean bl) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (material != null) {
            if (bl) {
                material.apply(gL2, 1032, (float)d);
            } else {
                float[] fArray = new float[4];
                material.getDiffuse().getRGBComponents(fArray);
                fArray[3] = (float)d;
                gL2.glColor4fv(fArray, 0);
            }
        }
    }
}

