/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.PartialCappedCylinder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Cake
extends AbstractAirspace {
    private List<Layer> layers = new ArrayList<Layer>();

    public Cake(Collection<Layer> collection) {
        this.addLayers(collection);
    }

    public Cake(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    public Cake() {
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public void setLayers(Collection<Layer> collection) {
        this.layers.clear();
        this.addLayers(collection);
    }

    protected void addLayers(Iterable<Layer> iterable) {
        if (iterable != null) {
            for (Layer layer : iterable) {
                if (layer == null) continue;
                this.layers.add(layer);
            }
        }
        this.invalidateAirspaceData();
    }

    public void setEnableCaps(boolean bl) {
        for (Layer layer : this.layers) {
            layer.setEnableCaps(bl);
        }
    }

    @Override
    public void setEnableDepthOffset(boolean bl) {
        for (Layer layer : this.layers) {
            layer.setEnableDepthOffset(bl);
        }
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        super.setTerrainConforming(bl, bl2);
        for (Layer layer : this.layers) {
            layer.setTerrainConforming(bl, bl2);
        }
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!super.isAirspaceVisible(drawContext)) {
            return false;
        }
        boolean bl = false;
        for (Layer layer : this.layers) {
            if (!layer.isAirspaceVisible(drawContext)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Position getReferencePosition() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.layers.size());
        for (Layer layer : this.layers) {
            arrayList.add(layer.getCenter());
        }
        return this.computeReferencePosition(arrayList, this.getAltitudes());
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Layer> list = this.getLayers();
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0).computeExtent(globe, d);
        }
        ArrayList<Box> arrayList = new ArrayList<Box>();
        for (Layer layer : list) {
            arrayList.add(layer.computeExtent(globe, d));
        }
        return Box.union(arrayList);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        return null;
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        for (Layer layer : this.layers) {
            layer.doMoveTo(globe, position, position2);
        }
        this.invalidateAirspaceData();
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        for (Layer layer : this.layers) {
            layer.doMoveTo(position, position2);
        }
        this.invalidateAirspaceData();
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes(drawContext);
        for (Layer layer : this.layers) {
            layer.setAttributes(this.getActiveAttributes());
            layer.setDelegateOwner(this.getDelegateOwner() != null ? this.getDelegateOwner() : this);
            layer.preRender(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.isAirspaceVisible(drawContext)) {
            return;
        }
        for (Layer layer : this.layers) {
            layer.render(drawContext);
        }
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "layers");
        for (Layer layer : this.layers) {
            RestorableSupport.StateObject stateObject3 = restorableSupport.addStateObject(stateObject2, "layer");
            layer.doGetRestorableState(restorableSupport, stateObject3);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "layers");
        if (stateObject2 == null) {
            return;
        }
        RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "layer");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return;
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>(stateObjectArray.length);
        for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
            if (stateObject3 == null) continue;
            Layer layer = new Layer();
            layer.doRestoreState(restorableSupport, stateObject3);
            arrayList.add(layer);
        }
        this.setLayers(arrayList);
    }

    public static class Layer
    extends PartialCappedCylinder {
        public Layer(LatLon latLon, double d, Angle angle, Angle angle2, double d2, double d3) {
            super(latLon, d, angle, angle2);
            this.setAltitudes(d2, d3);
        }

        public Layer(LatLon latLon, double d, Angle angle, Angle angle2) {
            super(latLon, d, angle, angle2);
        }

        public Layer(LatLon latLon, double d) {
            super(latLon, d);
        }

        public Layer(AirspaceAttributes airspaceAttributes) {
            super(airspaceAttributes);
        }

        public Layer() {
        }
    }
}

