/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public class Geometry
extends AVListImpl
implements Cacheable {
    public static final int TEXTURE = 0;
    public static final int ELEMENT = 1;
    public static final int VERTEX = 2;
    public static final int NORMAL = 3;
    private int[] mode = new int[4];
    private int[] count = new int[4];
    private int[] size = new int[4];
    private int[] glType = new int[4];
    private int[] stride = new int[4];
    private Buffer[] buffer = new Buffer[4];

    public int getMode(int n) {
        return this.mode[n];
    }

    public void setMode(int n, int n2) {
        this.mode[n] = n2;
    }

    public int getCount(int n) {
        return this.count[n];
    }

    public int getSize(int n) {
        return this.size[n];
    }

    public int getGLType(int n) {
        return this.glType[n];
    }

    public int getStride(int n) {
        return this.stride[n];
    }

    public Buffer getBuffer(int n) {
        return this.buffer[n];
    }

    public void setData(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        this.size[n] = n2;
        this.glType[n] = n3;
        this.stride[n] = n4;
        this.count[n] = n5;
        int n7 = n2 * n5;
        if (this.buffer[n] == null || this.buffer[n].capacity() < n7 || !(this.buffer[n] instanceof IntBuffer)) {
            this.buffer[n] = Buffers.newDirectIntBuffer(n7);
        }
        this.bufferCopy(nArray, n6, (IntBuffer)this.buffer[n], 0, n7);
    }

    public void setData(int n, int n2, int n3, int n4, float[] fArray, int n5) {
        this.size[n] = n2;
        this.glType[n] = 5126;
        this.stride[n] = n3;
        this.count[n] = n4;
        int n6 = n2 * n4;
        if (this.buffer[n] == null || this.buffer[n].capacity() < n6 || !(this.buffer[n] instanceof FloatBuffer)) {
            this.buffer[n] = Buffers.newDirectFloatBuffer(n6);
        }
        this.bufferCopy(fArray, n5, (FloatBuffer)this.buffer[n], 0, n6);
    }

    public void setData(int n, int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.size[n] = n2;
        this.glType[n] = 5126;
        this.stride[n] = n3;
        this.count[n] = n4;
        int n5 = n2 * n4;
        if (this.buffer[n] == null || this.buffer[n].capacity() < n5 || !(this.buffer[n] instanceof FloatBuffer)) {
            this.buffer[n] = floatBuffer;
        }
    }

    public void setElementData(int n, int n2, int[] nArray) {
        this.setMode(1, n);
        this.setData(1, 1, 5125, 0, n2, nArray, 0);
    }

    public void setElementData(int n, int n2, IntBuffer intBuffer) {
        this.setMode(1, n);
        this.buffer[1] = intBuffer;
        this.size[1] = 1;
        this.glType[1] = 5125;
        this.stride[1] = 0;
        this.count[1] = n2;
    }

    public void setVertexData(int n, float[] fArray) {
        this.setData(2, 3, 0, n, fArray, 0);
    }

    public void setVertexData(int n, FloatBuffer floatBuffer) {
        this.buffer[2] = floatBuffer;
        this.size[2] = 3;
        this.glType[2] = 5126;
        this.stride[2] = 0;
        this.count[2] = n;
    }

    public void setNormalData(int n, float[] fArray) {
        this.setData(3, 3, 0, n, fArray, 0);
    }

    public void setNormalData(int n, FloatBuffer floatBuffer) {
        this.buffer[3] = floatBuffer;
        this.size[3] = 3;
        this.glType[3] = 5126;
        this.stride[3] = 0;
        this.count[3] = n;
    }

    public void setTextureCoordData(int n, float[] fArray) {
        this.setData(0, 2, 0, n, fArray, 0);
    }

    public void setTextureCoordData(int n, FloatBuffer floatBuffer) {
        this.buffer[0] = floatBuffer;
        this.size[3] = 2;
        this.glType[3] = 5126;
        this.stride[3] = 0;
        this.count[3] = n;
    }

    public void clear(int n) {
        this.mode[n] = 0;
        this.count[n] = 0;
        this.size[n] = 0;
        this.glType[n] = 0;
        this.stride[n] = 0;
        this.buffer[n] = null;
    }

    @Override
    public long getSizeInBytes() {
        return this.bufferSize(1) + this.bufferSize(2) + this.bufferSize(3);
    }

    private long bufferSize(int n) {
        long l = 0L;
        if (this.buffer[n] != null) {
            l = this.sizeOf(this.glType[n]) * (long)this.buffer[n].capacity();
        }
        return l;
    }

    private long sizeOf(int n) {
        long l = 0L;
        switch (n) {
            case 5120: {
                l = 1L;
                break;
            }
            case 5122: 
            case 5123: {
                l = 2L;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                l = 4L;
                break;
            }
            case 5130: {
                l = 8L;
            }
        }
        return l;
    }

    private void bufferCopy(int[] nArray, int n, IntBuffer intBuffer, int n2, int n3) {
        intBuffer.position(n2);
        intBuffer.put(nArray, n, n3);
        intBuffer.position(n2);
    }

    private void bufferCopy(float[] fArray, int n, FloatBuffer floatBuffer, int n2, int n3) {
        floatBuffer.position(n2);
        floatBuffer.put(fArray, n, n3);
        floatBuffer.position(n2);
    }

    public static class CacheKey {
        private final GlobeStateKey globeStateKey;
        private final Class cls;
        private final String key;
        private final Object[] params;
        private int hash = 0;

        public CacheKey(Globe globe, Class clazz, String string, Object ... objectArray) {
            this.globeStateKey = globe != null ? globe.getGlobeStateKey() : null;
            this.cls = clazz;
            this.key = string;
            this.params = objectArray;
        }

        public CacheKey(Class clazz, String string, Object ... objectArray) {
            this(null, clazz, string, objectArray);
        }

        public CacheKey(String string, Object ... objectArray) {
            this(null, null, string, objectArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.globeStateKey != null ? !this.globeStateKey.equals(cacheKey.globeStateKey) : cacheKey.globeStateKey != null) {
                return false;
            }
            if (this.cls != null ? !this.cls.equals(cacheKey.cls) : cacheKey.cls != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null) {
                return false;
            }
            return Arrays.deepEquals(this.params, cacheKey.params);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = this.globeStateKey != null ? this.globeStateKey.hashCode() : 0;
                n = 31 * n + (this.cls != null ? this.cls.hashCode() : 0);
                n = 31 * n + (this.key != null ? this.key.hashCode() : 0);
                this.hash = n = 31 * n + (this.params != null ? Arrays.deepHashCode(this.params) : 0);
            }
            return this.hash;
        }
    }
}

