/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.List;

public class PolyArc
extends Polygon {
    protected static final int DEFAULT_SLICES = 32;
    protected static final int MINIMAL_GEOMETRY_SLICES = 8;
    private double radius = 1.0;
    private Angle leftAzimuth = Angle.ZERO;
    private Angle rightAzimuth = Angle.ZERO;
    private int slices = 32;
    private ArrayList<LatLon> polyArcLocations = new ArrayList();
    private ArrayList<Boolean> edgeFlags = new ArrayList();

    public PolyArc(List<? extends LatLon> list, double d, Angle angle, Angle angle2) {
        super(list);
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = "nullValue.LeftAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = "nullValue.RightAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.radius = d;
        this.leftAzimuth = angle;
        this.rightAzimuth = angle2;
        this.makeDefaultDetailLevels();
    }

    public PolyArc(List<? extends LatLon> list) {
        super(list);
        this.makeDefaultDetailLevels();
    }

    public PolyArc(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public PolyArc() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Slices", 32);
        screenSizeDetailLevel.setValue("Subdivisions", 3);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Slices", 26);
        screenSizeDetailLevel.setValue("Subdivisions", 3);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Slices", 20);
        screenSizeDetailLevel.setValue("Subdivisions", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Slices", 14);
        screenSizeDetailLevel.setValue("Subdivisions", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Slices", 8);
        screenSizeDetailLevel.setValue("Subdivisions", 0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.radius = d;
        this.invalidateAirspaceData();
    }

    public Angle[] getAzimuths() {
        Angle[] angleArray = new Angle[]{this.leftAzimuth, this.rightAzimuth};
        return angleArray;
    }

    public void setAzimuths(Angle angle, Angle angle2) {
        if (angle == null) {
            String string = "nullValue.LeftAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = "nullValue.RightAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leftAzimuth = angle;
        this.rightAzimuth = angle2;
        this.invalidateAirspaceData();
    }

    protected int getSlices() {
        return this.slices;
    }

    protected void setSlices(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.slices = n;
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        List<LatLon> list = this.getLocationList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        this.makePolyArcLocations(globe, list, 8, arrayList, arrayList2);
        ArrayList<LatLon> arrayList3 = new ArrayList<LatLon>();
        this.makeTessellatedLocations(globe, 2, arrayList, arrayList3);
        ArrayList<Vec4> arrayList4 = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, arrayList3, arrayList4);
        return arrayList4;
    }

    @Override
    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        this.makePolyArcLocations(drawContext.getGlobe(), this.getLocationList(), this.slices, arrayList, arrayList2);
        ((SurfacePolygon)surfaceShape).setOuterBoundary(arrayList);
    }

    protected double[] computeAngles() {
        Angle angle;
        Angle angle2 = this.normalizedAzimuth(this.leftAzimuth);
        Angle angle3 = angle2.compareTo(angle = this.normalizedAzimuth(this.rightAzimuth)) <= 0 ? angle.subtract(angle2) : Angle.POS360.subtract(angle2).add(angle);
        double[] dArray = new double[]{angle2.radians, angle.radians, angle3.radians};
        return dArray;
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        DetailLevel detailLevel;
        Object object;
        int n = this.slices;
        if (this.isEnableLevelOfDetail() && (object = (detailLevel = this.computeDetailLevel(drawContext)).getValue("Slices")) != null && object instanceof Integer) {
            n = (Integer)object;
        }
        this.polyArcLocations.clear();
        this.edgeFlags.clear();
        this.makePolyArcLocations(drawContext.getGlobe(), this.getLocationList(), n, this.polyArcLocations, this.edgeFlags);
        this.doRenderGeometry(drawContext, string, this.polyArcLocations, this.edgeFlags);
    }

    private void makePolyArcLocations(Globe globe, List<? extends LatLon> list, int n, List<LatLon> list2, List<Boolean> list3) {
        block7: {
            int n2 = list.size();
            if (n2 <= 0) break block7;
            double[] dArray = this.computeAngles();
            double d = this.radius;
            LatLon latLon = list.get(0);
            LatLon[] latLonArray = this.makeArc(globe, latLon, d, n, dArray[0], dArray[2]);
            for (LatLon latLon2 : latLonArray) {
                list2.add(latLon2);
                list3.add(false);
            }
            if (list3.size() > 1) {
                list3.set(0, true);
                list3.set(list3.size() - 1, true);
            }
            if (n2 > 1) {
                Matrix[] matrixArray;
                Vec4[] vec4Array;
                int n3;
                GeometryBuilder geometryBuilder = this.getGeometryBuilder();
                int n4 = geometryBuilder.computePolygonWindingOrder2(0, n3 = this.computeEllipsoidalPolygon(globe, list, null, vec4Array = new Vec4[n2 + 1], null, matrixArray = new Matrix[1]), vec4Array);
                if (n4 == 0) {
                    for (int i = 1; i < n2; ++i) {
                        list2.add(list.get(i));
                        list3.add(true);
                    }
                } else {
                    for (int i = n2 - 1; i >= 1; --i) {
                        list2.add(list.get(i));
                        list3.add(true);
                    }
                }
            }
        }
    }

    private LatLon[] makeArc(Globe globe, LatLon latLon, double d, int n, double d2, double d3) {
        double d4 = d3 / (double)n;
        double d5 = d / globe.getRadius();
        LatLon[] latLonArray = new LatLon[n + 1];
        for (int i = 0; i <= n; ++i) {
            double d6 = (double)i * d4 + d2;
            latLonArray[i] = LatLon.greatCircleEndPosition(latLon, d6, d5);
        }
        return latLonArray;
    }

    private Angle normalizedAzimuth(Angle angle) {
        double d = angle.degrees;
        double d2 = d < 0.0 ? d + 360.0 : (d >= 360.0 ? d - 360.0 : d);
        return Angle.fromDegrees(d2);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "leftAzimuthDegrees", this.leftAzimuth.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "rightAzimuthDegrees", this.rightAzimuth.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "radius", this.radius);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Double d2;
        super.doRestoreState(restorableSupport, stateObject);
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "radius");
        if (d3 != null) {
            this.setRadius(d3);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "leftAzimuthDegrees")) == null) {
            d2 = this.leftAzimuth.degrees;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "rightAzimuthDegrees")) == null) {
            d = this.rightAzimuth.degrees;
        }
        this.setAzimuths(Angle.fromDegrees(d2), Angle.fromDegrees(d));
    }
}

