/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.util.ArrayList;
import java.util.List;

public class SurfaceBox
extends AbstractSurfaceShape {
    protected List<LatLon> locations;
    protected int lengthSegments;
    protected int widthSegments;
    protected boolean enableStartCap = true;
    protected boolean enableEndCap = true;
    protected boolean enableCenterLine;
    protected List<List<LatLon>> activeCenterLineGeometry = new ArrayList<List<LatLon>>();

    public List<LatLon> getLocations() {
        return this.locations;
    }

    public void setLocations(List<LatLon> list) {
        this.locations = list;
        this.onShapeChanged();
    }

    public int getLengthSegments() {
        return this.lengthSegments;
    }

    public void setLengthSegments(int n) {
        this.lengthSegments = n;
        this.onShapeChanged();
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    public void setWidthSegments(int n) {
        this.widthSegments = n;
        this.onShapeChanged();
    }

    public boolean[] isEnableCaps() {
        return new boolean[]{this.enableStartCap, this.enableEndCap};
    }

    public void setEnableCaps(boolean bl, boolean bl2) {
        this.enableStartCap = bl;
        this.enableEndCap = bl2;
        this.onShapeChanged();
    }

    public boolean isEnableCenterLine() {
        return this.enableCenterLine;
    }

    public void setEnableCenterLine(boolean bl) {
        this.enableCenterLine = bl;
    }

    @Override
    public Position getReferencePosition() {
        return this.locations != null && this.locations.size() > 0 ? new Position(this.locations.get(0), 0.0) : null;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, double d) {
        Object object;
        if (this.locations == null) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList = new ArrayList<List<LatLon>>();
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        arrayList.add(arrayList2);
        for (int i = 0; i < this.locations.size() - 1; ++i) {
            object = this.locations.get(i);
            LatLon latLon = this.locations.get(i + 1);
            arrayList2.add((LatLon)object);
            this.addIntermediateLocations((LatLon)object, latLon, d, arrayList2);
        }
        int[] nArray = new int[]{2 * this.widthSegments, this.lengthSegments, 2 * this.widthSegments, this.lengthSegments};
        object = new boolean[]{this.enableStartCap, true, this.enableEndCap, true};
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (object[i] != false) {
                arrayList.add(this.makeLocations(n, nArray[i], d));
            }
            n += nArray[i] + 1;
        }
        LatLon latLon = this.locations.get(this.widthSegments);
        LatLon latLon2 = this.locations.get(3 * this.widthSegments + this.lengthSegments + 2);
        ArrayList<LatLon> arrayList3 = new ArrayList<LatLon>();
        arrayList3.add(latLon);
        this.addIntermediateLocations(latLon, latLon2, d, arrayList3);
        arrayList3.add(latLon2);
        arrayList.add(arrayList3);
        return arrayList;
    }

    protected ArrayList<LatLon> makeLocations(int n, int n2, double d) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (int i = n; i < n + n2; ++i) {
            LatLon latLon = this.locations.get(i);
            LatLon latLon2 = this.locations.get(i + 1);
            arrayList.add(latLon);
            this.addIntermediateLocations(latLon, latLon2, d, arrayList);
            if (i != n + n2 - 1) continue;
            arrayList.add(latLon2);
        }
        return arrayList;
    }

    @Override
    protected void determineActiveGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        List<LatLon> list;
        List<LatLon> list2;
        String string;
        this.activeGeometry.clear();
        this.activeOutlineGeometry.clear();
        this.activeCenterLineGeometry.clear();
        List<List<LatLon>> list3 = this.getCachedGeometry(drawContext, surfaceTileDrawContext);
        if (list3 == null) {
            return;
        }
        int n = 0;
        if ((string = this.containsPole(list2 = list3.get(n++))) != null) {
            this.activeGeometry.add(this.cutAlongDateLine(list2, string, drawContext.getGlobe()));
        } else if (LatLon.locationsCrossDateLine(list2)) {
            this.activeGeometry.addAll(this.repeatAroundDateline(list2));
        } else {
            this.activeGeometry.add(list2);
        }
        while (n < list3.size() - 1) {
            list = list3.get(n);
            if (LatLon.locationsCrossDateLine(list)) {
                this.activeOutlineGeometry.addAll(this.repeatAroundDateline(list));
            } else {
                this.activeOutlineGeometry.add(list);
            }
            ++n;
        }
        if (n < list3.size()) {
            list = list3.get(n);
            if (LatLon.locationsCrossDateLine(list)) {
                this.activeCenterLineGeometry.addAll(this.repeatAroundDateline(list));
            } else {
                this.activeCenterLineGeometry.add(list);
            }
        }
    }

    @Override
    protected void drawOutline(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        super.drawOutline(drawContext, surfaceTileDrawContext);
        if (this.enableCenterLine) {
            this.drawCenterLine(drawContext);
        }
    }

    protected void drawCenterLine(DrawContext drawContext) {
        if (this.activeCenterLineGeometry.isEmpty()) {
            return;
        }
        this.applyCenterLineState(drawContext, this.getActiveAttributes());
        for (List<LatLon> list : this.activeCenterLineGeometry) {
            this.drawLineStrip(drawContext, list);
        }
    }

    protected void applyCenterLineState(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode() && shapeAttributes.getOutlineStippleFactor() <= 0) {
            gL2.glEnable(2852);
            gL2.glLineStipple(2, (short)-4370);
        }
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.locations;
    }
}

