/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.FileStoreSource;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FileStoreRetriever
implements Retriever {
    FileStoreSource fsSource;
    RetrievalPostProcessor postProcessor;
    ByteBuffer buffer = null;

    public FileStoreRetriever(FileStoreSource fileStoreSource, RetrievalPostProcessor retrievalPostProcessor) {
        this.fsSource = fileStoreSource;
        this.postProcessor = retrievalPostProcessor;
    }

    @Override
    public Retriever call() throws Exception {
        this.postProcessor.run(this);
        return this;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = this.fsSource.getFileContentsAsByteBuffer();
        } else {
            this.buffer.rewind();
        }
        return this.buffer;
    }

    @Override
    public int getContentLength() {
        File file = this.fsSource.getFile();
        if (file != null) {
            return (int)file.length();
        }
        return 0;
    }

    @Override
    public int getContentLengthRead() {
        return 0;
    }

    @Override
    public String getName() {
        return this.fsSource.getFileName();
    }

    @Override
    public String getState() {
        if (this.getContentLength() > 0) {
            return "gov.nasa.worldwind.RetrieverStatusSuccessful";
        }
        return "gov.nasa.worldwind.RetrieverStatusError";
    }

    @Override
    public String getContentType() {
        String string = this.fsSource.getFileName();
        if (string.endsWith(".xml")) {
            return "application/xml";
        }
        if (string.endsWith(".json")) {
            return "application/json";
        }
        return "application/octet-stream";
    }

    @Override
    public long getExpirationTime() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getSubmitTime() {
        return 0L;
    }

    @Override
    public void setSubmitTime(long l) {
    }

    @Override
    public long getBeginTime() {
        return 0L;
    }

    @Override
    public void setBeginTime(long l) {
    }

    @Override
    public long getEndTime() {
        return 0L;
    }

    @Override
    public void setEndTime(long l) {
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int n) {
    }

    @Override
    public void setConnectTimeout(int n) {
    }

    @Override
    public int getStaleRequestLimit() {
        return 0;
    }

    @Override
    public void setStaleRequestLimit(int n) {
    }

    @Override
    public Object setValue(String string, Object object) {
        return null;
    }

    @Override
    public AVList setValues(AVList aVList) {
        return null;
    }

    @Override
    public Object getValue(String string) {
        return null;
    }

    @Override
    public Collection<Object> getValues() {
        return null;
    }

    @Override
    public String getStringValue(String string) {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return null;
    }

    @Override
    public boolean hasKey(String string) {
        return false;
    }

    @Override
    public Object removeKey(String string) {
        return null;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public AVList copy() {
        return null;
    }

    @Override
    public AVList clearList() {
        return null;
    }

    @Override
    public void onMessage(Message message) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

