/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.Logging;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class HTTPRetriever
extends URLRetriever {
    private int responseCode;
    private String responseMessage;

    public HTTPRetriever(URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        super(uRL, retrievalPostProcessor);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    protected ByteBuffer doRead(URLConnection uRLConnection) throws Exception {
        if (uRLConnection == null) {
            String string = Logging.getMessage("nullValue.ConnectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        this.responseCode = httpURLConnection.getResponseCode();
        this.responseMessage = httpURLConnection.getResponseMessage();
        String string = uRLConnection.getContentType();
        Logging.logger().log(Level.FINE, "HTTPRetriever.ResponseInfo", new Object[]{this.responseCode, uRLConnection.getContentLength(), string != null ? string : "content type not returned", uRLConnection.getURL()});
        if (this.responseCode == 200) {
            return super.doRead(uRLConnection);
        }
        return null;
    }
}

