/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.graphics.TacticalGraphicSymbol;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MilStd2525PointGraphic
extends AVListImpl
implements MilStd2525TacticalGraphic,
TacticalPoint,
Draggable {
    protected TacticalGraphicSymbol symbol;
    protected boolean highlighted;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected TacticalGraphicAttributes normalAttributes;
    protected TacticalGraphicAttributes highlightAttributes;
    protected long frameTimestamp = -1L;
    protected TacticalSymbolAttributes activeSymbolAttributes = new BasicTacticalSymbolAttributes();
    protected static TacticalSymbolAttributes defaultSymbolAttributes = new BasicTacticalSymbolAttributes();

    public MilStd2525PointGraphic(String string) {
        this.symbol = this.createSymbol(string);
    }

    protected TacticalGraphicSymbol createSymbol(String string) {
        TacticalGraphicSymbol tacticalGraphicSymbol = new TacticalGraphicSymbol(string);
        tacticalGraphicSymbol.setAttributes(this.activeSymbolAttributes);
        tacticalGraphicSymbol.setDelegateOwner(this);
        return tacticalGraphicSymbol;
    }

    @Override
    public boolean isVisible() {
        return this.symbol.isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this.symbol.setVisible(bl);
    }

    @Override
    public Object getModifier(String string) {
        return this.symbol.getModifier(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        this.symbol.setModifier(string, object);
    }

    @Override
    public boolean isShowTextModifiers() {
        return this.symbol.isShowTextModifiers();
    }

    @Override
    public void setShowTextModifiers(boolean bl) {
        this.symbol.setShowTextModifiers(bl);
    }

    @Override
    public boolean isShowGraphicModifiers() {
        return this.symbol.isShowGraphicModifiers();
    }

    @Override
    public void setShowGraphicModifiers(boolean bl) {
        this.symbol.setShowGraphicModifiers(bl);
    }

    @Override
    public boolean isShowLocation() {
        return this.symbol.isShowLocation();
    }

    @Override
    public void setShowLocation(boolean bl) {
        this.symbol.setShowLocation(bl);
    }

    @Override
    public boolean isShowHostileIndicator() {
        return this.symbol.isShowHostileIndicator();
    }

    @Override
    public void setShowHostileIndicator(boolean bl) {
        this.symbol.setShowHostileIndicator(bl);
    }

    @Override
    public String getIdentifier() {
        return this.symbol.getIdentifier();
    }

    @Override
    public void setText(String string) {
        this.symbol.setModifier("T", string);
    }

    @Override
    public String getText() {
        Object object = this.getModifier("T");
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Iterable) {
            Object object2;
            Iterator iterator = ((Iterable)object).iterator();
            Object object3 = object2 = iterator.hasNext() ? (Object)iterator.next() : null;
            if (object2 != null) {
                return object2.toString();
            }
        }
        return null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.getPosition());
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setPosition(iterator.next());
    }

    @Override
    public TacticalGraphicAttributes getAttributes() {
        return this.normalAttributes;
    }

    @Override
    public void setAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        this.normalAttributes = tacticalGraphicAttributes;
    }

    @Override
    public TacticalGraphicAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    @Override
    public void setHighlightAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        this.highlightAttributes = tacticalGraphicAttributes;
    }

    @Override
    public Offset getLabelOffset() {
        return null;
    }

    @Override
    public void setLabelOffset(Offset offset) {
    }

    public Offset getOffset() {
        return this.symbol.getOffset();
    }

    public void setOffset(Offset offset) {
        this.symbol.setOffset(offset);
    }

    @Override
    public Object getDelegateOwner() {
        Object object = this.symbol.getDelegateOwner();
        return object != this ? object : null;
    }

    @Override
    public void setDelegateOwner(Object object) {
        if (object != null) {
            this.symbol.setDelegateOwner(object);
        } else {
            this.symbol.setDelegateOwner(this);
        }
    }

    @Override
    public UnitsFormat getUnitsFormat() {
        return this.symbol.getUnitsFormat();
    }

    @Override
    public void setUnitsFormat(UnitsFormat unitsFormat) {
        this.symbol.setUnitsFormat(unitsFormat);
    }

    @Override
    public Position getPosition() {
        return this.symbol.getPosition();
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.symbol.setPosition(position);
    }

    public int getAltitudeMode() {
        return this.symbol.getAltitudeMode();
    }

    public void setAltitudeMode(int n) {
        this.symbol.setAltitudeMode(n);
    }

    @Override
    public String getStatus() {
        return this.symbol.getStatus();
    }

    @Override
    public void setStatus(String string) {
        this.symbol.setStatus(string);
    }

    @Override
    public Position getReferencePosition() {
        return this.getPosition();
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        this.symbol.setPosition(position);
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, this.getAltitudeMode());
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragScreenSizeConstant(dragContext);
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public void render(DrawContext drawContext) {
        long l = drawContext.getFrameTimeStamp();
        if (this.frameTimestamp != l) {
            this.determineActiveAttributes();
            this.frameTimestamp = l;
        }
        this.symbol.render(drawContext);
    }

    protected void determineActiveAttributes() {
        this.activeSymbolAttributes.copy(defaultSymbolAttributes);
        if (this.isHighlighted()) {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getHighlightAttributes();
            if (tacticalGraphicAttributes != null) {
                this.applyAttributesToSymbol(tacticalGraphicAttributes, this.activeSymbolAttributes);
            }
        } else {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getAttributes();
            if (tacticalGraphicAttributes != null) {
                this.applyAttributesToSymbol(tacticalGraphicAttributes, this.activeSymbolAttributes);
            }
        }
    }

    protected void applyAttributesToSymbol(TacticalGraphicAttributes tacticalGraphicAttributes, TacticalSymbolAttributes tacticalSymbolAttributes) {
        Double d = tacticalGraphicAttributes.getInteriorOpacity();
        if (d != null) {
            tacticalSymbolAttributes.setOpacity(d);
        }
        if ((d = tacticalGraphicAttributes.getScale()) != null) {
            tacticalSymbolAttributes.setScale(d);
        }
        Material material = tacticalGraphicAttributes.getInteriorMaterial();
        tacticalSymbolAttributes.setInteriorMaterial(material);
        Font font = tacticalGraphicAttributes.getTextModifierFont();
        if (font != null) {
            tacticalSymbolAttributes.setTextModifierFont(font);
        }
        if ((material = tacticalGraphicAttributes.getTextModifierMaterial()) != null) {
            tacticalSymbolAttributes.setTextModifierMaterial(material);
        }
    }

    public static List<String> getSupportedGraphics() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(MilStd2525PointGraphic.getTacGrpGraphics());
        arrayList.addAll(MilStd2525PointGraphic.getMetocGraphics());
        arrayList.addAll(MilStd2525PointGraphic.getEmsGraphics());
        return arrayList;
    }

    public static List<String> getTacGrpGraphics() {
        return Arrays.asList("G-T-D----------", "G-T-I----------", "G-T-N----------", "G-G-GPUUD------", "G-G-GPUUB------", "G-G-GPUUL------", "G-G-GPUUS------", "G-G-GPUY-------", "G-G-GPUYP------", "G-G-GPUYD------", "G-G-GPUYL------", "G-G-GPUYC------", "G-G-GPUYS------", "G-G-GPUYB------", "G-G-GPUYA------", "G-G-GPUYV------", "G-G-GPUYT------", "G-G-GPUYR------", "G-G-GPUYK------", "G-G-GPUYX------", "G-G-GPUS-------", "G-G-GPUSA------", "G-G-GPUSD------", "G-G-GPUSC------", "G-G-GPR--------", "G-G-GPRN-------", "G-G-GPRS-------", "G-G-GPRD-------", "G-G-GPRP-------", "G-G-GPRM-------", "G-G-GPRW-------", "G-G-GPRC-------", "G-G-GPRI-------", "G-G-GPWA-------", "G-G-GPWD-------", "G-G-GPWE-------", "G-G-GPWG-------", "G-G-GPWM-------", "G-G-GPWI-------", "G-G-GPWP-------", "G-G-GPF--------", "G-G-GPH--------", "G-G-GPHQ-------", "G-G-GPHA-------", "G-G-GPHY-------", "G-G-GPHX-------", "G-G-GPO--------", "G-G-GPOZ-------", "G-G-GPOD-------", "G-G-GPOW-------", "G-G-GPOP-------", "G-G-GPOR-------", "G-G-GPA--------", "G-G-GPAP-------", "G-G-GPAW-------", "G-G-GPAK-------", "G-G-GPAA-------", "G-G-GPAH-------", "G-G-GPAB-------", "G-G-GPAC-------", "G-G-GPAD-------", "G-G-GPAE-------", "G-G-GPAS-------", "G-G-GPAT-------", "G-G-GPAO-------", "G-G-GPAR-------", "G-G-GPAL-------", "G-G-GPAF-------", "G-G-GPAG-------", "G-G-GPAI-------", "G-G-GPAJ-------", "G-G-GPAM-------", "G-G-GPAN-------", "G-G-GPP--------", "G-G-GPPK-------", "G-G-GPPC-------", "G-G-GPPO-------", "G-G-GPPD-------", "G-G-GPPL-------", "G-G-GPPP-------", "G-G-GPPR-------", "G-G-GPPE-------", "G-G-GPPS-------", "G-G-GPPA-------", "G-G-GPPW-------", "G-G-GPC--------", "G-G-GPCU-------", "G-G-GPCUR------", "G-G-GPCUA------", "G-G-GPCUS------", "G-G-GPCUM------", "G-G-GPCA-------", "G-G-GPCS-------", "G-G-GPCM-------", "G-G-GPCP-------", "G-G-GPCR-------", "G-G-GPCC-------", "G-G-GPCE-------", "G-G-GPCN-------", "G-G-GPB--------", "G-G-GPBU-------", "G-G-GPBUA------", "G-G-GPBUS------", "G-G-GPBUM------", "G-G-GPBS-------", "G-G-GPBSA------", "G-G-DPT--------", "G-G-DPO--------", "G-G-DPOC-------", "G-G-DPOR-------", "G-G-DPOF-------", "G-G-DPOS-------", "G-G-DPON-------", "G-G-OPP--------", "G-G-APD--------", "G-M-OAOF-------", "G-M-OAOM-------", "G-M-OAOP-------", "G-M-OB---------", "G-M-OMU--------", "G-M-OMT--------", "G-M-OMD--------", "G-M-OME--------", "G-M-OMP--------", "G-M-OMW--------", "G-M-OHTL-------", "G-M-OHTH-------", "G-M-BCP--------", "G-M-SE---------", "G-M-SF---------", "G-M-SS---------", "G-M-SU---------", "G-M-NZ---------", "G-M-NF---------", "G-M-NEB--------", "G-M-NEC--------", "G-M-NDP--------", "G-M-NDA--------", "G-M-NDT--------", "G-M-NDE--------", "G-M-NDB--------", "G-M-NDO--------", "G-M-NDD--------", "G-F-PTS--------", "G-F-PTN--------", "G-F-PCF--------", "G-F-PCS--------", "G-F-PCB--------", "G-F-PCR--------", "G-F-PCH--------", "G-F-PCL--------", "G-S-PX---------", "G-S-PC---------", "G-S-PY---------", "G-S-PT---------", "G-S-PD---------", "G-S-PE---------", "G-S-PL---------", "G-S-PM---------", "G-S-PR---------", "G-S-PU---------", "G-S-PO---------", "G-S-PI---------", "G-S-PN---------", "G-S-PSZ--------", "G-S-PSA--------", "G-S-PSB--------", "G-S-PSC--------", "G-S-PSD--------", "G-S-PSE--------", "G-S-PSF--------", "G-S-PSG--------", "G-S-PSH--------", "G-S-PSI--------", "G-S-PSJ--------", "G-S-PAS--------", "G-S-PAT--------", "G-O-ED---------", "G-O-EP---------", "G-O-EV---------", "G-O-HM---------", "G-O-HI---------", "G-O-HO---------", "G-O-SB---------", "G-O-SBM--------", "G-O-SBN--------", "G-O-SBW--------", "G-O-SBX--------", "G-O-SM---------", "G-O-SS---------", "G-O-FA---------", "G-O-FE---------", "G-O-FO---------");
    }

    public static List<String> getMetocGraphics() {
        return Arrays.asList("WAS-PL----P----", "WAS-PC----P----", "WAS-PLT---P----", "WAS-PH----P----", "WAS-PA----P----", "WAS-PHT---P----", "WAS-TL----P----", "WAS-TM----P----", "WAS-TS----P----", "WAS-TE----P----", "WAS-T-MW--P----", "WAS-ICL---P----", "WAS-ICM---P----", "WAS-ICS---P----", "WAS-IRL---P----", "WAS-IRM---P----", "WAS-IRS---P----", "WAS-IML---P----", "WAS-IMM---P----", "WAS-IMS---P----", "WAS-WC----P----", "WAS-CCCSCSP----", "WAS-CCCSFCP----", "WAS-CCCSSCP----", "WAS-CCCSBCP----", "WAS-CCCSOCP----", "WAS-CCCSOBP----", "WAS-WSR-LIP----", "WAS-WSR-LCP----", "WAS-WSR-MIP----", "WAS-WSR-MCP----", "WAS-WSR-HIP----", "WAS-WSR-HCP----", "WAS-WSRFL-P----", "WAS-WSRFMHP----", "WAS-WSRSL-P----", "WAS-WSRSMHP----", "WAS-WSRST-P----", "WAS-WSD-LIP----", "WAS-WSD-LCP----", "WAS-WSD-MIP----", "WAS-WSD-MCP----", "WAS-WSD-HIP----", "WAS-WSD-HCP----", "WAS-WSDFL-P----", "WAS-WSDFMHP----", "WAS-WSM-L-P----", "WAS-WSM-MHP----", "WAS-WSMSL-P----", "WAS-WSMSMHP----", "WAS-WSS-LIP----", "WAS-WSS-LCP----", "WAS-WSS-MIP----", "WAS-WSS-MCP----", "WAS-WSS-HIP----", "WAS-WSS-HCP----", "WAS-WSSBLMP----", "WAS-WSSBH-P----", "WAS-WSSG--P----", "WAS-WSSSL-P----", "WAS-WSSSMHP----", "WAS-WSGRL-P----", "WAS-WSGRMHP----", "WAS-WSIC--P----", "WAS-WSPLL-P----", "WAS-WSPLM-P----", "WAS-WSPLH-P----", "WAS-WST-NPP----", "WAS-WSTMR-P----", "WAS-WSTHR-P----", "WAS-WSTMH-P----", "WAS-WSTHH-P----", "WAS-WST-FCP----", "WAS-WST-SQP----", "WAS-WST-LGP----", "WAS-WSFGPSP----", "WAS-WSFGCSP----", "WAS-WSFGP-P----", "WAS-WSFGSVP----", "WAS-WSFGSOP----", "WAS-WSFGFVP----", "WAS-WSFGFOP----", "WAS-WSBR--P----", "WAS-WSFU--P----", "WAS-WSHZ--P----", "WAS-WSDSLMP----", "WAS-WSDSS-P----", "WAS-WSDD--P----", "WAS-WSTSD-P----", "WAS-WSTSS-P----", "WAS-WSTSH-P----", "WAS-WSVE--P----", "WAS-WSVA--P----", "WAS-WST-LVP----", "WAS-WSF-LVP----", "WAS-WSUKP-P----", "WAS-GNG-TIP----", "WAS-GNDEWCP----", "WAS-GSI---P----", "WAS-GSSDC-P----", "WOS-IB----P----", "WOS-IBM---P----", "WOS-IBBS--P----", "WOS-IBG---P----", "WOS-IBMG--P----", "WOS-IBBB--P----", "WOS-IBBBM-P----", "WOS-IBGL--P----", "WOS-IBGLM-P----", "WOS-IBF---P----", "WOS-IBII--P----", "WOS-ICWB--P----", "WOS-ICWR--P----", "WOS-ICIF--P----", "WOS-IDC---P----", "WOS-IDD---P----", "WOS-IDS---P----", "WOS-II----P----", "WOS-IIP---P----", "WOS-ISC---P----", "WOS-ISS---P----", "WOS-ITRH--P----", "WOS-ITR---P----", "WOS-ITBB--P----", "WOS-HDS---P----", "WOS-HPB-O-P----", "WOS-HPB-A-P----", "WOS-HPBA--P----", "WOS-HPCP--P----", "WOS-HPFH--P----", "WOS-HPFS--P----", "WOS-HPML--P----", "WO-DHPMO--P----", "WOS-HPM-R-P----", "WOS-HPD---P----", "WOS-HABA--P----", "WOS-HABB--P----", "WOS-HABM--P----", "WOS-HABP--P----", "WOS-HAL---P----", "WOS-HALV--P----", "WOS-HALH--P----", "WOS-HHRS--P----", "WOS-HHRA--P----", "WOS-HHDF--P----", "WO-DHHDK--P----", "WOS-HHDMDBP----", "WOS-HHDMDFP----", "WOS-HHDS--P----", "WOS-HHDWA-P----", "WOS-HHDWB-P----", "WOS-HHDE--P----", "WOS-BFC-S-P----", "WOS-BFC-M-P----", "WOS-BFC-CLP----", "WOS-BFC-SIP----", "WOS-BFC-STP----", "WOS-BFC-G-P----", "WOS-BFC-P-P----", "WOS-BFC-CBP----", "WOS-BFC-R-P----", "WOS-BFC-COP----", "WOS-BFC-SHP----", "WOS-BFQ-F-P----", "WOS-BFQ-M-P----", "WOS-BFQ-C-P----", "WOS-TCCW--P----", "WOS-TCCTD-P----", "WOS-TCCTG-P----", "WOS-MF----P----", "WOS-ML----P----", "WOS-MOA---P----", "WOS-MPA---P----");
    }

    public static List<String> getEmsGraphics() {
        return Arrays.asList("E-N-AA---------", "E-N-AB---------", "E-N-AC---------", "E-N-AD---------", "E-N-AE---------", "E-N-AG---------", "E-N-BB---------", "E-N-BC---------", "E-N-BF---------", "E-N-BM---------", "E-N-CA---------", "E-N-CB---------", "E-N-CC---------", "E-N-CD---------", "E-N-CE---------");
    }
}

