/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;

public class MilStd2525UnitsFormat
extends UnitsFormat {
    public MilStd2525UnitsFormat() {
        this("UnitsFormat.Kilometers", "UnitsFormat.SquareKilometers", true);
    }

    public MilStd2525UnitsFormat(String string, String string2) {
        this(string, string2, true);
    }

    public MilStd2525UnitsFormat(String string, String string2, boolean bl) {
        super(string, string2, bl);
        this.setAltitudeUnits("UnitsFormat.Feet");
    }

    @Override
    public String latitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isShowDMS()) {
            double[] dArray = angle.toDMS();
            return String.format("%02.0f%02.0f%04.1f%s", Math.abs(dArray[0]), dArray[1], dArray[2], dArray[0] < 0.0 ? "S" : "N");
        }
        return super.latitude(angle);
    }

    @Override
    public String longitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isShowDMS()) {
            double[] dArray = angle.toDMS();
            return String.format("%03.0f%02.0f%04.1f%s", Math.abs(dArray[0]), dArray[1], dArray[2], dArray[0] < 0.0 ? "W" : "E");
        }
        return super.longitude(angle);
    }

    @Override
    public String latLon(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.latitude(latLon.getLatitude()) + this.longitude(latLon.getLongitude());
    }

    @Override
    public void setAltitudeUnits(String string) {
        super.setAltitudeUnits(string);
        this.altitudeUnitsSymbol = this.altitudeUnitsSymbol.toUpperCase();
    }

    @Override
    protected void setDefaultLabels() {
        this.setLabel("UnitsFormat.LatitudeLabel", "");
        this.setLabel("UnitsFormat.LongitudeLabel", "");
        this.setLabel("UnitsFormat.EyeAltitudeLabel", "");
    }
}

