/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics;

import gov.nasa.worldwind.render.Offset;
import java.util.HashMap;
import java.util.Map;

public class DefaultOffsets {
    protected static Offset DEFAULT_OFFSET = Offset.CENTER;
    public static final Offset OFFSET_BOTTOM_QUARTER = Offset.fromFraction(0.5, 0.25);
    public static final Offset OFFSET_C2GM_GNL_PNT_WPN_DRPPNT = Offset.fromFraction(0.5, 0.17);
    public static final Offset OFFSET_MOBSU_OBST_MNE_ATMAHD = Offset.fromFraction(0.5, 0.75);
    public static final Offset OFFSET_MOBSU_OBST_MNE_APMNE = Offset.fromFraction(0.5, 0.35);
    public static final Offset OFFSET_MOBSU_OBST_MNE_WAMNE = Offset.fromFraction(0.5, 0.71);
    public static final Offset OFFSET_OTH_HAZ_SML = Offset.fromFraction(0.5, 0.33);
    protected Map<String, Offset> offsets = new HashMap<String, Offset>();

    public DefaultOffsets() {
        this.populate();
    }

    public Offset get(String string) {
        Offset offset = this.offsets.get(string);
        return offset != null ? offset : DEFAULT_OFFSET;
    }

    protected void populate() {
        this.putAll(Offset.BOTTOM_CENTER, "G-G-GPUUB------", "G-G-GPUUL------", "G-G-GPUUS------", "G-G-GPUY-------", "G-G-GPUYB------", "G-G-GPRI-------", "G-G-GPWE-------", "G-G-GPWG-------", "G-G-GPWM-------", "G-G-GPP--------", "G-G-GPPK-------", "G-G-GPPC-------", "G-G-GPPL-------", "G-G-GPPP-------", "G-G-GPPR-------", "G-G-GPPE-------", "G-G-GPPS-------", "G-G-GPPA-------", "G-G-APD--------", "G-G-OPP--------", "G-M-OAOF-------", "G-M-OAOM-------", "G-M-OAOP-------", "G-M-OHTL-------", "G-M-OHTH-------", "G-M-BCP--------", "G-M-NZ---------", "G-M-NF---------", "G-M-NEB--------", "G-M-NEC--------", "G-M-NDP--------", "G-M-NDA--------", "G-M-NDT--------", "G-M-NDE--------", "G-M-NDB--------", "G-M-NDO--------", "G-M-NDD--------", "G-F-PCS--------", "G-F-PCB--------", "G-F-PCR--------", "G-F-PCH--------", "G-F-PCL--------", "G-S-PX---------", "G-S-PC---------", "G-S-PY---------", "G-S-PT---------", "G-S-PD---------", "G-S-PE---------", "G-S-PL---------", "G-S-PM---------", "G-S-PR---------", "G-S-PU---------", "G-S-PO---------", "G-S-PI---------", "G-S-PN---------", "G-S-PSZ--------", "G-S-PSA--------", "G-S-PSB--------", "G-S-PSC--------", "G-S-PSD--------", "G-S-PSE--------", "G-S-PSF--------", "G-S-PSG--------", "G-S-PSH--------", "G-S-PSI--------", "G-S-PSJ--------", "G-S-PAS--------", "G-S-PAT--------", "G-O-ED---------", "G-O-EP---------", "G-O-EV---------", "G-O-SB---------", "G-O-SBM--------", "G-O-SBN--------", "G-O-SS---------", "E-N-AB---------", "E-N-AD---------", "E-N-AE---------", "E-N-AG---------", "E-N-BB---------", "E-N-BC---------", "E-N-BF---------", "E-N-BM---------", "E-N-CA---------", "E-N-CB---------", "E-N-CC---------", "E-N-CD---------", "E-N-CE---------");
        this.putAll(OFFSET_BOTTOM_QUARTER, "G-G-GPUY-------", "G-G-GPUYP------", "G-G-GPUYD------", "G-G-GPUYL------", "G-G-GPUYC------", "G-G-GPUYS------", "G-G-GPUYB------", "G-G-GPUYA------", "G-G-GPUYV------", "G-G-GPUYT------", "G-G-GPUYR------", "G-G-GPUYK------", "G-G-GPUYX------", "G-M-OB---------", "G-M-OME--------");
        this.offsets.put("G-G-GPWD-------", OFFSET_C2GM_GNL_PNT_WPN_DRPPNT);
        this.offsets.put("G-M-OMD--------", OFFSET_MOBSU_OBST_MNE_ATMAHD);
        this.offsets.put("G-M-OMP--------", OFFSET_MOBSU_OBST_MNE_APMNE);
        this.offsets.put("G-M-OMW--------", OFFSET_MOBSU_OBST_MNE_WAMNE);
        this.offsets.put("G-O-HM---------", OFFSET_OTH_HAZ_SML);
        this.offsets.put("G-O-SM---------", Offset.LEFT_CENTER);
    }

    protected void putAll(Offset offset, String ... stringArray) {
        for (String string : stringArray) {
            this.offsets.put(string, offset);
        }
    }
}

