/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.symbology.milstd2525.graphics.EchelonSymbol;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.PhaseLine;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Boundary
extends PhaseLine {
    protected static final Offset TOP_LABEL_OFFSET = Offset.fromFraction(0.0, 0.5);
    protected static final Offset BOTTOM_LABEL_OFFSET = Offset.fromFraction(0.0, -1.5);
    protected List<EchelonSymbol> echelonSymbols = Collections.emptyList();
    protected TacticalSymbolAttributes symbolAttributes;
    protected boolean haveTopLabel;
    protected boolean haveBottomLabel;
    protected boolean haveHostileLabels;
    protected String additionalText;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GLB--------");
    }

    public Boundary(String string) {
        super(string);
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public void setAdditionalText(String string) {
        this.additionalText = string;
        this.onModifierChanged();
    }

    @Override
    public Object getModifier(String string) {
        if ("T".equals(string) && this.additionalText != null) {
            return Arrays.asList(this.getText(), this.getAdditionalText());
        }
        return super.getModifier(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("T".equals(string) && object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (iterator.hasNext()) {
                this.setText((String)iterator.next());
            }
            if (iterator.hasNext()) {
                this.setAdditionalText((String)iterator.next());
            }
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    protected void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        for (TacticalSymbol tacticalSymbol : this.echelonSymbols) {
            tacticalSymbol.render(drawContext);
        }
    }

    @Override
    protected void createLabels() {
        Iterable<? extends Position> iterable = this.getPositions();
        if (iterable == null) {
            return;
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        this.haveHostileLabels = this.mustCreateIdentityLabels();
        String string = this.getText();
        String string2 = this.getAdditionalText();
        this.haveTopLabel = !WWUtil.isEmpty(string);
        this.haveBottomLabel = !WWUtil.isEmpty(string2);
        Offset offset = this.getTopLabelOffset();
        Offset offset2 = this.getBottomLabelOffset();
        String string3 = this.symbolCode.getEchelon();
        boolean bl = !SymbolCode.isFieldEmpty(string3);
        this.echelonSymbols = bl ? new ArrayList() : Collections.emptyList();
        String string4 = this.symbolCode.toString();
        iterator.next();
        while (iterator.hasNext()) {
            TacticalGraphicLabel tacticalGraphicLabel;
            if (this.haveTopLabel) {
                tacticalGraphicLabel = this.addLabel(string);
                tacticalGraphicLabel.setOffset(offset);
            }
            if (this.haveBottomLabel) {
                tacticalGraphicLabel = this.addLabel(string2);
                tacticalGraphicLabel.setOffset(offset2);
            }
            if (this.haveHostileLabels) {
                this.addLabel("ENY");
                this.addLabel("ENY");
            }
            if (bl) {
                this.echelonSymbols.add(this.createEchelonSymbol(string4));
            }
            iterator.next();
        }
    }

    protected boolean mustCreateIdentityLabels() {
        return this.isShowHostileIndicator() && "H".equalsIgnoreCase(this.symbolCode.getStandardIdentity());
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Iterable<? extends Position> iterable = this.getPositions();
        if (iterable == null) {
            return;
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        Iterator<EchelonSymbol> iterator2 = this.echelonSymbols.iterator();
        Iterator<Object> iterator3 = this.labels != null ? this.labels.iterator() : Collections.emptyList().iterator();
        Position position = iterator.next();
        while (iterator.hasNext() && (iterator3.hasNext() || iterator2.hasNext())) {
            Object object;
            Position position2 = iterator.next();
            TacticalGraphicLabel tacticalGraphicLabel = this.haveTopLabel ? (TacticalGraphicLabel)iterator3.next() : null;
            TacticalGraphicLabel tacticalGraphicLabel2 = this.haveBottomLabel ? (TacticalGraphicLabel)iterator3.next() : null;
            LatLon latLon = LatLon.interpolate(0.5, position, position2);
            Position position3 = new Position(latLon, 0.0);
            if (tacticalGraphicLabel != null) {
                tacticalGraphicLabel.setPosition(position3);
                tacticalGraphicLabel.setOrientationPosition(position2);
            }
            if (tacticalGraphicLabel2 != null) {
                tacticalGraphicLabel2.setPosition(position3);
                tacticalGraphicLabel2.setOrientationPosition(position2);
            }
            if (iterator2.hasNext()) {
                object = iterator2.next();
                ((AbstractTacticalSymbol)object).setPosition(position3);
                ((EchelonSymbol)object).setOrientationPosition(position2);
            }
            if (this.haveHostileLabels) {
                object = (TacticalGraphicLabel)iterator3.next();
                latLon = LatLon.interpolate(0.25, position, position2);
                ((TacticalGraphicLabel)object).setPosition(new Position(latLon, 0.0));
                ((TacticalGraphicLabel)object).setOrientationPosition(position2);
                object = (TacticalGraphicLabel)iterator3.next();
                latLon = LatLon.interpolate(0.75, position, position2);
                ((TacticalGraphicLabel)object).setPosition(new Position(latLon, 0.0));
                ((TacticalGraphicLabel)object).setOrientationPosition(position2);
            }
            position = position2;
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        super.applyDelegateOwner(object);
        for (EchelonSymbol echelonSymbol : this.echelonSymbols) {
            echelonSymbol.setDelegateOwner(object);
        }
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        if (this.haveTopLabel) {
            return TOP_LABEL_OFFSET;
        }
        if (this.haveBottomLabel) {
            return BOTTOM_LABEL_OFFSET;
        }
        return TacticalGraphicLabel.DEFAULT_OFFSET;
    }

    protected Offset getTopLabelOffset() {
        return TOP_LABEL_OFFSET;
    }

    protected Offset getBottomLabelOffset() {
        return BOTTOM_LABEL_OFFSET;
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setTextModifierMaterial(this.getLabelMaterial());
        }
    }

    protected EchelonSymbol createEchelonSymbol(String string) {
        EchelonSymbol echelonSymbol = new EchelonSymbol(string);
        if (this.symbolAttributes == null) {
            this.symbolAttributes = new BasicTacticalSymbolAttributes();
        }
        echelonSymbol.setAttributes(this.symbolAttributes);
        return echelonSymbol;
    }
}

