/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import java.util.List;
import javax.xml.xpath.XPath;
import org.w3c.dom.Element;

public abstract class AbstractElevationModel
extends WWObjectImpl
implements ElevationModel {
    protected FileStore dataFileStore = WorldWind.getDataFileStore();
    protected double missingDataFlag = -1.7976931348623157E308;
    protected double missingDataValue = 0.0;
    protected boolean networkRetrievalEnabled = true;
    protected long expiryTime = 0L;
    protected boolean enabled = true;

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : this.toString();
    }

    @Override
    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    public String toString() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : super.toString();
    }

    @Override
    public boolean isNetworkRetrievalEnabled() {
        return this.networkRetrievalEnabled;
    }

    @Override
    public void setNetworkRetrievalEnabled(boolean bl) {
        this.networkRetrievalEnabled = bl;
    }

    @Override
    public long getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public double getMissingDataSignal() {
        return this.missingDataFlag;
    }

    @Override
    public void setMissingDataSignal(double d) {
        this.missingDataFlag = d;
    }

    @Override
    public double getMissingDataReplacement() {
        return this.missingDataValue;
    }

    @Override
    public void setMissingDataReplacement(double d) {
        this.missingDataValue = d;
    }

    @Override
    public double getDetailHint(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return 0.0;
    }

    public FileStore getDataFileStore() {
        return this.dataFileStore;
    }

    public void setDataFileStore(FileStore fileStore) {
        this.dataFileStore = fileStore;
    }

    @Override
    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getUnmappedElevation(angle, angle2);
        return d == this.missingDataFlag ? this.missingDataValue : d;
    }

    @Override
    public double[] getElevations(Sector sector, List<? extends LatLon> list, double[] dArray, double[] dArray2) {
        return new double[]{this.getElevations(sector, list, dArray[0], dArray2)};
    }

    @Override
    public double[] getUnmappedElevations(Sector sector, List<? extends LatLon> list, double[] dArray, double[] dArray2) {
        return new double[]{this.getElevations(sector, list, dArray[0], dArray2)};
    }

    @Override
    public double[] getBestResolutions(Sector sector) {
        return new double[]{this.getBestResolution(sector)};
    }

    @Override
    public String getRestorableState() {
        return null;
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreNotSupported");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public void composeElevations(Sector sector, List<? extends LatLon> list, int n, double[] dArray) throws Exception {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size() || n > list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            LatLon latLon = list.get(i);
            double d = this.getUnmappedElevation(latLon.getLatitude(), latLon.getLongitude());
            if (d == this.getMissingDataSignal() || this.isTransparentValue(d)) continue;
            dArray[i] = d;
        }
    }

    protected boolean isTransparentValue(Double d) {
        return (d == null || d.equals(this.getMissingDataSignal())) && this.getMissingDataReplacement() == this.getMissingDataSignal();
    }

    public static boolean isElevationModelConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element[] elementArray = WWXML.getElements(element, "//ElevationModel", xPath);
        return elementArray != null && elementArray.length > 0;
    }

    public static Element createElevationModelConfigElements(AVList aVList, Element element) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.DisplayName", element, "DisplayName");
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", element, "NetworkRetrievalEnabled");
        if (aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") != null || aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue") != null) {
            Double d;
            Element element2 = WWXML.getElement(element, "MissingData", null);
            if (element2 == null) {
                element2 = WWXML.appendElementPath(element, "MissingData");
            }
            if ((d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MissingDataFlag")) != null) {
                WWXML.setDoubleAttribute(element2, "signal", d);
            }
            if ((d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MissingDataValue")) != null) {
                WWXML.setDoubleAttribute(element2, "replacement", d);
            }
        }
        WWXML.checkAndAppendDoubleElement(aVList, "gov.nasa.worldwind.avkey.DetailHint", element, "DataDetailHint");
        return element;
    }

    public static AVList getElevationModelConfigParams(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DisplayName", "DisplayName", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", "NetworkRetrievalEnabled", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MissingDataFlag", "MissingData/@signal", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MissingDataValue", "MissingData/@replacement", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.DetailHint", "DataDetailHint", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.MaxAbsentTileAttempts", "MaxAbsentTileAttempts", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval", "MinAbsentTileCheckInterval", xPath);
        return aVList;
    }

    @Override
    public double getLocalDataAvailability(Sector sector, Double d) {
        return 1.0;
    }

    @Override
    public double getUnmappedLocalSourceElevation(Angle angle, Angle angle2) {
        return this.getUnmappedElevation(angle, angle2);
    }
}

