/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompoundElevationModel
extends AbstractElevationModel {
    protected CopyOnWriteArrayList<ElevationModel> elevationModels = new CopyOnWriteArrayList();

    @Override
    public void dispose() {
        for (ElevationModel elevationModel : this.elevationModels) {
            if (elevationModel == null) continue;
            elevationModel.dispose();
        }
    }

    public boolean containsElevationModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.elevationModels.contains(elevationModel)) {
            return true;
        }
        for (ElevationModel elevationModel2 : this.elevationModels) {
            if (!(elevationModel2 instanceof CompoundElevationModel) || !((CompoundElevationModel)elevationModel2).containsElevationModel(elevationModel)) continue;
            return true;
        }
        return false;
    }

    protected void sortElevationModels() {
        if (this.elevationModels.size() == 1) {
            return;
        }
        ArrayList<ElevationModel> arrayList = new ArrayList<ElevationModel>(this.elevationModels.size());
        for (ElevationModel elevationModel : this.elevationModels) {
            arrayList.add(elevationModel);
        }
        Collections.sort(arrayList, new Comparator<ElevationModel>(){

            @Override
            public int compare(ElevationModel elevationModel, ElevationModel elevationModel2) {
                double d;
                double d2 = elevationModel.getBestResolution(null);
                return d2 > (d = elevationModel2.getBestResolution(null)) ? -1 : (d2 == d ? 0 : 1);
            }
        });
        this.elevationModels.removeAll(arrayList);
        this.elevationModels.addAll(arrayList);
    }

    public void addElevationModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.add(elevationModel);
        this.sortElevationModels();
    }

    public void addElevationModel(int n, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.add(n, elevationModel);
    }

    public void removeElevationModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (ElevationModel elevationModel2 : this.elevationModels) {
            if (!(elevationModel2 instanceof CompoundElevationModel)) continue;
            ((CompoundElevationModel)elevationModel2).removeElevationModel(elevationModel);
        }
        this.elevationModels.remove(elevationModel);
    }

    public void removeElevationModel(int n) {
        if (n < 0 || n >= this.elevationModels.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.remove(n);
    }

    public void setElevationModel(int n, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.elevationModels.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.set(n, elevationModel);
    }

    public List<ElevationModel> getElevationModels() {
        return new ArrayList<ElevationModel>(this.elevationModels);
    }

    @Override
    public void setExpiryTime(long l) {
        super.setExpiryTime(l);
        for (ElevationModel elevationModel : this.elevationModels) {
            elevationModel.setExpiryTime(l);
        }
    }

    @Override
    public double getMaxElevation() {
        double d = -1.7976931348623157E308;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2;
            if (!elevationModel.isEnabled() || !((d2 = elevationModel.getMaxElevation()) > d)) continue;
            d = d2;
        }
        return d == -1.7976931348623157E308 ? 0.0 : d;
    }

    @Override
    public double getMinElevation() {
        double d = Double.MAX_VALUE;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2;
            if (!elevationModel.isEnabled() || !((d2 = elevationModel.getMinElevation()) < d)) continue;
            d = d2;
        }
        return d == Double.MAX_VALUE ? 0.0 : d;
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        double[] dArray;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = null;
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.isEnabled()) continue;
            double[] dArray3 = elevationModel.getExtremeElevations(angle, angle2);
            if (dArray2 == null) {
                dArray2 = new double[]{dArray3[0], dArray3[1]};
                continue;
            }
            if (dArray3[0] < dArray2[0]) {
                dArray2[0] = dArray3[0];
            }
            if (!(dArray3[1] > dArray2[1])) continue;
            dArray2[1] = dArray3[1];
        }
        if (dArray2 == null) {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        } else {
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        double[] dArray;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = null;
        for (ElevationModel elevationModel : this.elevationModels) {
            int n;
            if (!elevationModel.isEnabled() || (n = elevationModel.intersects(sector)) < 0) continue;
            double[] dArray3 = elevationModel.getExtremeElevations(sector);
            if (dArray2 == null) {
                dArray2 = new double[]{dArray3[0], dArray3[1]};
                continue;
            }
            if (dArray3[0] < dArray2[0]) {
                dArray2[0] = dArray3[0];
            }
            if (!(dArray3[1] > dArray2[1])) continue;
            dArray2[1] = dArray3[1];
        }
        if (dArray2 == null) {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        } else {
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public double getBestResolution(Sector sector) {
        double d = 0.0;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2;
            if (!elevationModel.isEnabled() || sector != null && elevationModel.intersects(sector) < 0 || !((d2 = elevationModel.getBestResolution(sector)) < d) && d != 0.0) continue;
            d = d2;
        }
        return d != 0.0 ? d : Double.MAX_VALUE;
    }

    @Override
    public double[] getBestResolutions(Sector sector) {
        double[] dArray = new double[this.elevationModels.size()];
        for (int i = 0; i < this.elevationModels.size(); ++i) {
            dArray[i] = this.elevationModels.get(i).getBestResolution(sector);
        }
        return dArray;
    }

    @Override
    public double getDetailHint(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = this.elevationModels.size() - 1; i >= 0; --i) {
            int n;
            ElevationModel elevationModel = this.elevationModels.get(i);
            if (!elevationModel.isEnabled() || (n = elevationModel.intersects(sector)) == -1) continue;
            return elevationModel.getDetailHint(sector);
        }
        return 0.0;
    }

    @Override
    public int intersects(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.isEnabled()) continue;
            int n = elevationModel.intersects(sector);
            if (n == 0) {
                return 0;
            }
            if (n != 1) continue;
            bl = true;
        }
        return bl ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.isEnabled() || !elevationModel.contains(angle, angle2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = this.missingDataFlag;
        for (int i = this.elevationModels.size() - 1; i >= 0; --i) {
            double d2;
            ElevationModel elevationModel = this.elevationModels.get(i);
            if (!elevationModel.isEnabled() || !elevationModel.contains(angle, angle2) || (d2 = elevationModel.getUnmappedElevation(angle, angle2)) == elevationModel.getMissingDataSignal()) continue;
            d = d2;
            break;
        }
        return d;
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        double[] dArray2 = new double[this.elevationModels.size()];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = d;
        }
        return this.doGetElevations(sector, list, dArray2, dArray, false)[0];
    }

    @Override
    public double getUnmappedElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        double[] dArray2 = new double[this.elevationModels.size()];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = d;
        }
        return this.doGetElevations(sector, list, dArray2, dArray, false)[0];
    }

    @Override
    public double[] getElevations(Sector sector, List<? extends LatLon> list, double[] dArray, double[] dArray2) {
        return this.doGetElevations(sector, list, dArray, dArray2, false);
    }

    @Override
    public double[] getUnmappedElevations(Sector sector, List<? extends LatLon> list, double[] dArray, double[] dArray2) {
        return this.doGetElevations(sector, list, dArray, dArray2, false);
    }

    protected double[] doGetElevations(Sector sector, List<? extends LatLon> list, double[] dArray, double[] dArray2, boolean bl) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.TargetElevationsArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray2 == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray2.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray3 = new double[this.elevationModels.size()];
        for (int i = 0; i < this.elevationModels.size(); ++i) {
            double d;
            int n;
            ElevationModel elevationModel = this.elevationModels.get(i);
            dArray3[i] = 0.0;
            if (!elevationModel.isEnabled() || (n = elevationModel.intersects(sector)) < 0 || !((d = bl || this.elevationModels.size() == 1 ? elevationModel.getElevations(sector, list, dArray[i], dArray2) : elevationModel.getUnmappedElevations(sector, list, dArray[i], dArray2)) < dArray3[i]) && dArray3[i] != 0.0) continue;
            dArray3[i] = d;
        }
        return dArray3;
    }

    @Override
    public void composeElevations(Sector sector, List<? extends LatLon> list, int n, double[] dArray) throws Exception {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (ElevationModel elevationModel : this.elevationModels) {
            int n2;
            if (!elevationModel.isEnabled() || (n2 = elevationModel.intersects(sector)) < 0) continue;
            elevationModel.composeElevations(sector, list, n, dArray);
        }
    }

    @Override
    public void setNetworkRetrievalEnabled(boolean bl) {
        super.setNetworkRetrievalEnabled(bl);
        for (ElevationModel elevationModel : this.elevationModels) {
            elevationModel.setNetworkRetrievalEnabled(bl);
        }
    }

    @Override
    public double getLocalDataAvailability(Sector sector, Double d) {
        int n = 0;
        double d2 = 0.0;
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.isEnabled() || elevationModel.intersects(sector) < 0) continue;
            d2 += elevationModel.getLocalDataAvailability(sector, d);
            ++n;
        }
        return n > 0 ? d2 / (double)n : 1.0;
    }

    @Override
    public void setExtremesCachingEnabled(boolean bl) {
        for (ElevationModel elevationModel : this.elevationModels) {
            elevationModel.setExtremesCachingEnabled(bl);
        }
    }

    @Override
    public boolean isExtremesCachingEnabled() {
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.isExtremesCachingEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getUnmappedLocalSourceElevation(Angle angle, Angle angle2) {
        double d = this.getMissingDataSignal();
        for (int i = this.elevationModels.size() - 1; i >= 0; --i) {
            double d2;
            ElevationModel elevationModel = this.elevationModels.get(i);
            if (!(elevationModel instanceof BasicElevationModel) || !elevationModel.isEnabled() || (d2 = ((BasicElevationModel)elevationModel).getUnmappedLocalSourceElevation(angle, angle2)) == elevationModel.getMissingDataSignal()) continue;
            d = d2;
            break;
        }
        return d;
    }
}

