/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import java.util.List;

public class ZeroElevationModel
extends AbstractElevationModel {
    @Override
    public double getMaxElevation() {
        return 1.0;
    }

    @Override
    public double getMinElevation() {
        return 0.0;
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        return new double[]{0.0, 1.0};
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        return new double[]{0.0, 1.0};
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = 0.0;
        }
        this.setValue("gov.nasa.worldwind.avkey.FrameTimestamp", System.currentTimeMillis());
        return 0.0;
    }

    @Override
    public double getUnmappedElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.getElevations(sector, list, d, dArray);
    }

    @Override
    public int intersects(Sector sector) {
        return 0;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        return true;
    }

    @Override
    public double getBestResolution(Sector sector) {
        return 1.6E-6;
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        return 0.0;
    }

    @Override
    public void setExtremesCachingEnabled(boolean bl) {
    }

    @Override
    public boolean isExtremesCachingEnabled() {
        return false;
    }
}

