/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.util.AbstractHotSpot;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class AbstractResizeHotSpot
extends AbstractHotSpot {
    protected static final int NORTH = 1;
    protected static final int SOUTH = 2;
    protected static final int EAST = 4;
    protected static final int WEST = 8;
    protected static final int NORTHWEST = 9;
    protected static final int NORTHEAST = 5;
    protected static final int SOUTHWEST = 10;
    protected static final int SOUTHEAST = 6;
    protected boolean dragging;
    protected Point dragRefPoint;
    protected Dimension refSize;
    protected Point refLocation;
    protected boolean allowVerticalResize = true;
    protected boolean allowHorizontalResize = true;
    protected boolean adjustLocationX;
    protected boolean adjustLocationY;
    protected int xSign = 1;
    protected int ySign = 1;
    protected int cursor;

    protected void setDirection(String string) {
        int n = 0;
        if ("gov.nasa.worldwind.avkey.North".equals(string)) {
            n = 1;
        } else if ("gov.nasa.worldwdind.avkey.South".equals(string)) {
            n = 2;
        } else if ("gov.nasa.worldwind.avkey.East".equals(string)) {
            n = 4;
        } else if ("gov.nasa.worldwind.avkey.West".equals(string)) {
            n = 8;
        } else if ("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast".equals(string)) {
            n = 5;
        } else if ("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest".equals(string)) {
            n = 9;
        } else if ("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast".equals(string)) {
            n = 6;
        } else if ("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest".equals(string)) {
            n = 10;
        }
        this.setDirection(n);
    }

    protected void setDirection(int n) {
        this.adjustLocationX = 1 == n || 8 == n || 10 == n || 9 == n;
        boolean bl = this.adjustLocationY = 1 == n || 8 == n || 9 == n || 5 == n;
        if (1 == n || 2 == n) {
            this.allowVerticalResize = true;
            this.allowHorizontalResize = false;
        } else if (4 == n || 8 == n) {
            this.allowVerticalResize = false;
            this.allowHorizontalResize = true;
        } else {
            this.allowVerticalResize = true;
            this.allowHorizontalResize = true;
        }
        this.xSign = 8 == n || 10 == n || 9 == n ? -1 : 1;
        this.ySign = 1 == n || 5 == n || 9 == n ? -1 : 1;
        if (1 == n) {
            this.cursor = 8;
        } else if (2 == n) {
            this.cursor = 9;
        } else if (4 == n) {
            this.cursor = 11;
        } else if (8 == n) {
            this.cursor = 10;
        } else if (5 == n) {
            this.cursor = 7;
        } else if (6 == n) {
            this.cursor = 5;
        } else if (10 == n) {
            this.cursor = 4;
        } else if (9 == n) {
            this.cursor = 6;
        }
    }

    protected void setDirectionFromPoint(Point point) {
        Point point2 = this.getScreenPoint();
        Dimension dimension = this.getSize();
        if (point2 == null || dimension == null) {
            return;
        }
        Point point3 = new Point(point2.x + dimension.width / 2, point2.y + dimension.height / 2);
        int n = point3.y - point.y;
        int n2 = point.x - point3.x;
        int n3 = n > 0 ? 1 : 2;
        int n4 = n2 > 0 ? 4 : 8;
        double d = (double)dimension.width / (double)dimension.height;
        double d2 = Math.abs((double)n2 / (double)n);
        double d3 = d * 0.1;
        int n5 = Math.abs(d2 - d) < d3 ? n4 + n3 : (d2 < d ? n3 : n4);
        this.setDirection(n5);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null || this.isConsumed(selectEvent)) {
            return;
        }
        Point point = selectEvent.getPickPoint();
        if (point != null && selectEvent.isDrag()) {
            if (!this.isDragging()) {
                this.dragging = true;
                this.beginDrag(point);
            }
            this.drag(point);
            selectEvent.consume();
        }
        if (selectEvent.isDragEnd()) {
            this.dragging = false;
            this.endDrag();
            selectEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        this.setDirectionFromPoint(mouseEvent.getPoint());
    }

    protected void beginDrag(Point point) {
        this.dragRefPoint = point;
        this.refSize = this.getSize();
        this.refLocation = this.getScreenPoint();
    }

    public void drag(Point point) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.refLocation == null || this.refSize == null) {
            return;
        }
        if (this.allowHorizontalResize) {
            n3 = (point.x - this.dragRefPoint.x) * this.xSign;
        }
        if (this.allowVerticalResize) {
            n4 = (point.y - this.dragRefPoint.y) * this.ySign;
        }
        if (this.isValidSize(n2 = this.refSize.width + n3, n = this.refSize.height + n4)) {
            this.setSize(new Dimension(n2, n));
            if (this.adjustLocationX || this.adjustLocationY) {
                double d = this.refLocation.x - (this.adjustLocationX ? n3 : 0);
                double d2 = this.refLocation.y - (this.adjustLocationY ? n4 : 0);
                this.setScreenPoint(new Point((int)d, (int)d2));
            }
        }
    }

    protected void endDrag() {
        this.dragRefPoint = null;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.cursor);
    }

    @Override
    public void setActive(boolean bl) {
        if (!bl) {
            this.cursor = 0;
        }
        super.setActive(bl);
    }

    protected boolean isValidSize(int n, int n2) {
        Dimension dimension = this.getMinimumSize();
        return n >= dimension.width && n2 >= dimension.height;
    }

    protected Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    protected abstract Dimension getSize();

    protected abstract void setSize(Dimension var1);

    protected abstract Point getScreenPoint();

    protected abstract void setScreenPoint(Point var1);
}

