/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContourBuilder {
    protected int width;
    protected int height;
    protected double[] values;
    protected Map<CellKey, CellInfo> contourCellMap = new HashMap<CellKey, CellInfo>();
    protected List<CellKey> contourCellList = new ArrayList<CellKey>();
    protected List<List<double[]>> contourList = new ArrayList<List<double[]>>();
    protected List<double[]> currentContour;
    protected static Map<Direction, Direction> dirRev = new HashMap<Direction, Direction>();
    protected static Map<Integer, LinkedHashMap<Direction, Direction>> dirNext = new HashMap<Integer, LinkedHashMap<Direction, Direction>>();

    public ContourBuilder(int n, int n2, double[] dArray) {
        if (n < 1) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length != n * n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = n;
        this.height = n2;
        this.values = dArray;
    }

    public List<List<double[]>> buildContourLines(double d) {
        this.assembleContourCells(d);
        this.traverseContourCells();
        ArrayList<List<double[]>> arrayList = new ArrayList<List<double[]>>(this.contourList);
        this.clearContourCells();
        return arrayList;
    }

    public List<List<Position>> buildContourLines(double d, Sector sector, double d2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.assembleContourCells(d);
        this.traverseContourCells();
        double d3 = sector.getMaxLatitude().degrees;
        double d4 = sector.getMinLongitude().degrees;
        double d5 = sector.getDeltaLatDegrees();
        double d6 = sector.getDeltaLonDegrees();
        ArrayList<List<Position>> arrayList = new ArrayList<List<Position>>();
        for (List<double[]> list : this.contourList) {
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            for (double[] dArray : list) {
                double d7 = dArray[0] / (double)(this.width - 1);
                double d8 = dArray[1] / (double)(this.height - 1);
                double d9 = d3 - d8 * d5;
                double d10 = d4 + d7 * d6;
                arrayList2.add(Position.fromDegrees(d9, d10, d2));
            }
            arrayList.add(arrayList2);
        }
        this.clearContourCells();
        return arrayList;
    }

    protected void assembleContourCells(double d) {
        this.contourCellMap.clear();
        this.contourCellList.clear();
        for (int i = 0; i < this.height - 1; ++i) {
            for (int j = 0; j < this.width - 1; ++j) {
                double d2 = this.valueFor(j, i);
                double d3 = this.valueFor(j + 1, i);
                double d4 = this.valueFor(j + 1, i + 1);
                double d5 = this.valueFor(j, i + 1);
                int n = 0;
                n |= d2 > d ? 1 : 0;
                n <<= 1;
                n |= d3 > d ? 1 : 0;
                n <<= 1;
                n |= d4 > d ? 1 : 0;
                n <<= 1;
                if ((n |= d5 > d ? 1 : 0) == 0 || n == 15) continue;
                if (n == 5 || n == 10) {
                    double d6 = (d2 + d3 + d4 + d5) / 4.0;
                    if (n == 5 && d6 <= d) {
                        n = 10;
                    } else if (n == 10 && d6 <= d) {
                        n = 5;
                    }
                }
                CellInfo cellInfo = new CellInfo(j, i, n);
                if (d3 > d ^ d2 > d) {
                    cellInfo.edgeWeights.put(Direction.NORTH, (d - d2) / (d3 - d2));
                }
                if (d4 > d ^ d5 > d) {
                    cellInfo.edgeWeights.put(Direction.SOUTH, (d - d5) / (d4 - d5));
                }
                if (d4 > d ^ d3 > d) {
                    cellInfo.edgeWeights.put(Direction.EAST, (d - d3) / (d4 - d3));
                }
                if (d5 > d ^ d2 > d) {
                    cellInfo.edgeWeights.put(Direction.WEST, (d - d2) / (d5 - d2));
                }
                this.putContourCell(cellInfo);
            }
        }
    }

    protected void traverseContourCells() {
        ArrayList<List<double[]>> arrayList = new ArrayList<List<double[]>>();
        this.contourList.clear();
        for (CellKey cellKey : this.contourCellList) {
            CellInfo cellInfo = this.contourCellMap.get(cellKey);
            for (Direction direction : dirNext.get(cellInfo.contourMask).keySet()) {
                if (cellInfo.visitedDirections.contains((Object)direction)) continue;
                this.currentContour = new ArrayList<double[]>();
                this.traverseContour(cellInfo, direction);
                arrayList.add(this.currentContour);
                this.currentContour = null;
                if (arrayList.size() != 2) continue;
                if (((List)arrayList.get(0)).size() == 0 && ((List)arrayList.get(1)).size() == 0) {
                    String string = Logging.getMessage("generic.UnexpectedCondition", "both contours are of zero length");
                    Logging.logger().severe(string);
                } else {
                    Collections.reverse((List)arrayList.get(0));
                    ((List)arrayList.get(0)).addAll((Collection)arrayList.get(1));
                    this.contourList.add((List)arrayList.get(0));
                }
                arrayList.clear();
            }
            if (arrayList.size() == 0) continue;
            String string = Logging.getMessage("generic.UnexpectedCondition", "non-empty contours list");
            Logging.logger().severe(string);
        }
    }

    protected void traverseContour(CellInfo cellInfo, Direction direction) {
        Direction direction2 = direction;
        Direction direction3 = direction;
        while (cellInfo != null && !cellInfo.visitedDirections.contains((Object)direction2)) {
            cellInfo.visitedDirections.add(direction2);
            cellInfo.visitedDirections.add(direction3);
            this.addIntersection(cellInfo, direction2);
            if ((cellInfo = this.nextCell(cellInfo, direction2)) == null) continue;
            direction3 = dirRev.get((Object)direction2);
            direction2 = dirNext.get(cellInfo.contourMask).get((Object)direction3);
        }
    }

    protected void addIntersection(CellInfo cellInfo, Direction direction) {
        double d = cellInfo.x;
        double d2 = cellInfo.y;
        switch (direction) {
            case NORTH: {
                d += cellInfo.edgeWeights.get((Object)direction).doubleValue();
                break;
            }
            case SOUTH: {
                d += cellInfo.edgeWeights.get((Object)direction).doubleValue();
                d2 += 1.0;
                break;
            }
            case EAST: {
                d += 1.0;
                d2 += cellInfo.edgeWeights.get((Object)direction).doubleValue();
                break;
            }
            case WEST: {
                d2 += cellInfo.edgeWeights.get((Object)direction).doubleValue();
                break;
            }
            default: {
                String string = Logging.getMessage("generic.UnexpectedDirection", dirNext);
                Logging.logger().severe(string);
            }
        }
        this.currentContour.add(new double[]{d, d2});
    }

    protected void clearContourCells() {
        this.contourCellMap.clear();
        this.contourCellList.clear();
        this.contourList.clear();
        this.currentContour = null;
    }

    protected CellInfo nextCell(CellInfo cellInfo, Direction direction) {
        int n = cellInfo.x;
        int n2 = cellInfo.y;
        switch (direction) {
            case NORTH: {
                return this.getContourCell(n, n2 - 1);
            }
            case SOUTH: {
                return this.getContourCell(n, n2 + 1);
            }
            case EAST: {
                return this.getContourCell(n + 1, n2);
            }
            case WEST: {
                return this.getContourCell(n - 1, n2);
            }
        }
        String string = Logging.getMessage("generic.UnexpectedDirection", dirNext);
        Logging.logger().severe(string);
        return null;
    }

    protected double valueFor(int n, int n2) {
        return this.values[n + n2 * this.width];
    }

    protected void putContourCell(CellInfo cellInfo) {
        CellKey cellKey = new CellKey(cellInfo.x, cellInfo.y);
        this.contourCellMap.put(cellKey, cellInfo);
        this.contourCellList.add(cellKey);
    }

    protected CellInfo getContourCell(int n, int n2) {
        return this.contourCellMap.get(new CellKey(n, n2));
    }

    static {
        dirRev.put(Direction.NORTH, Direction.SOUTH);
        dirRev.put(Direction.SOUTH, Direction.NORTH);
        dirRev.put(Direction.EAST, Direction.WEST);
        dirRev.put(Direction.WEST, Direction.EAST);
        LinkedHashMap<Direction, Direction> linkedHashMap = new LinkedHashMap<Direction, Direction>();
        linkedHashMap.put(Direction.SOUTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.SOUTH);
        dirNext.put(1, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.SOUTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.SOUTH);
        dirNext.put(2, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.EAST, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.EAST);
        dirNext.put(3, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.NORTH);
        dirNext.put(4, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.NORTH);
        linkedHashMap.put(Direction.SOUTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.SOUTH);
        dirNext.put(5, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.SOUTH);
        linkedHashMap.put(Direction.SOUTH, Direction.NORTH);
        dirNext.put(6, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.NORTH);
        dirNext.put(7, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.NORTH);
        dirNext.put(8, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.SOUTH);
        linkedHashMap.put(Direction.SOUTH, Direction.NORTH);
        dirNext.put(9, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.NORTH);
        linkedHashMap.put(Direction.SOUTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.SOUTH);
        dirNext.put(10, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.NORTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.NORTH);
        dirNext.put(11, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.EAST, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.EAST);
        dirNext.put(12, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.SOUTH, Direction.EAST);
        linkedHashMap.put(Direction.EAST, Direction.SOUTH);
        dirNext.put(13, linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(Direction.SOUTH, Direction.WEST);
        linkedHashMap.put(Direction.WEST, Direction.SOUTH);
        dirNext.put(14, linkedHashMap);
    }

    protected static class CellInfo {
        public final int x;
        public final int y;
        public final int contourMask;
        public final Map<Direction, Double> edgeWeights = new HashMap<Direction, Double>();
        public final Set<Direction> visitedDirections = new HashSet<Direction>(4);

        public CellInfo(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.contourMask = n3;
        }
    }

    protected static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }

    protected static class CellKey {
        public final int x;
        public final int y;

        public CellKey(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CellKey cellKey = (CellKey)object;
            return this.x == cellKey.x && this.y == cellKey.y;
        }

        public int hashCode() {
            return 31 * this.x + this.y;
        }
    }
}

