/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.combine.Combinable;
import gov.nasa.worldwind.util.combine.CombineContext;
import java.util.ArrayList;

public class ContourList
extends WWObjectImpl
implements Combinable {
    protected ArrayList<Iterable<? extends LatLon>> contours = new ArrayList();
    protected Sector sector;

    public ContourList() {
    }

    public ContourList(ContourList contourList) {
        if (contourList == null) {
            String string = Logging.getMessage("nullValue.ContourListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contours.addAll(contourList.contours);
        this.sector = contourList.sector;
    }

    public int getContourCount() {
        return this.contours.size();
    }

    public Iterable<? extends LatLon> getContour(int n) {
        if (n < 0 || n >= this.contours.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.contours.get(n);
    }

    public void setContour(int n, Iterable<? extends LatLon> iterable) {
        if (n < 0 || n >= this.contours.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contours.set(n, iterable);
        this.computeSector();
    }

    public void addContour(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contours.add(iterable);
        Sector sector = Sector.boundingSector(iterable);
        this.sector = this.sector != null ? this.sector.union(sector) : sector;
    }

    public void addAllContours(ContourList contourList) {
        if (contourList == null) {
            String string = Logging.getMessage("nullValue.ContourListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contours.addAll(contourList.contours);
        this.sector = this.sector != null ? this.sector.union(contourList.sector) : contourList.sector;
    }

    public void removeAllContours() {
        this.contours.clear();
        this.sector = null;
    }

    public Sector getSector() {
        return this.sector;
    }

    protected void computeSector() {
        this.sector = null;
        for (Iterable<? extends LatLon> iterable : this.contours) {
            Sector sector = Sector.boundingSector(iterable);
            this.sector = this.sector != null ? this.sector.union(sector) : sector;
        }
    }

    @Override
    public void combine(CombineContext combineContext) {
        if (combineContext == null) {
            String string = Logging.getMessage("nullValue.CombineContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (combineContext.isBoundingSectorMode()) {
            this.combineBounds(combineContext);
        } else {
            this.combineContours(combineContext);
        }
    }

    protected void combineBounds(CombineContext combineContext) {
        if (this.sector == null) {
            return;
        }
        combineContext.addBoundingSector(this.sector);
    }

    protected void combineContours(CombineContext combineContext) {
        if (this.sector == null) {
            return;
        }
        if (!combineContext.getSector().intersects(this.sector)) {
            return;
        }
        this.doCombineContours(combineContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCombineContours(CombineContext combineContext) {
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        for (Iterable<? extends LatLon> iterable : this.contours) {
            try {
                GLU.gluTessBeginContour(gLUtessellator);
                for (LatLon latLon : iterable) {
                    double[] dArray = new double[]{latLon.longitude.degrees, latLon.latitude.degrees, 0.0};
                    GLU.gluTessVertex(gLUtessellator, dArray, 0, dArray);
                }
            }
            finally {
                GLU.gluTessEndContour(gLUtessellator);
            }
        }
    }
}

