/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class EditorAnnotation
extends ScreenAnnotation {
    private Point tooltipOffset = new Point(5, 5);

    public EditorAnnotation(String string) {
        super(string, new Point(0, 0));
        this.initializeAttributes();
    }

    protected void initializeAttributes() {
        this.attributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        this.attributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.attributes.setTextColor(Color.BLACK);
        this.attributes.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        this.attributes.setCornerRadius(5);
        this.attributes.setBorderColor(new Color(0xABABAB));
        this.attributes.setFont(Font.decode("Arial-PLAIN-12"));
        this.attributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.attributes.setInsets(new Insets(5, 5, 5, 5));
    }

    protected int getOffsetX() {
        return this.tooltipOffset != null ? this.tooltipOffset.x : 0;
    }

    protected int getOffsetY() {
        return this.tooltipOffset != null ? this.tooltipOffset.y : 0;
    }

    @Override
    protected void doRenderNow(DrawContext drawContext) {
        this.getAttributes().setDrawOffset(new Point(this.getBounds((DrawContext)drawContext).width / 2 + this.getOffsetX(), this.getOffsetY()));
        this.setScreenPoint(this.getScreenPoint());
        super.doRenderNow(drawContext);
    }
}

