/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;

public class HTTPFileUpload
extends Observable {
    protected static final String CR_LF = "\r\n";
    protected static final String TWO_HYPHENS = "--";
    protected static final String BOUNDARY = "*********NASA_World_Wind_HTTP_File_Upload_Separator**********";
    protected int maxBufferSize = 0x100000;
    protected final URL url;
    protected ArrayList<FileInfo> filesToUpload = new ArrayList();
    protected String requestMethod = "POST";
    protected AVList requestProperties = new AVListImpl();
    protected long totalBytesToUpload = 0L;
    protected long totalBytesUploaded = 0L;
    protected int totalFilesUploaded = 0;
    protected int totalFilesFailed = 0;

    public HTTPFileUpload(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.url = uRL;
        this.setRequestMethod("POST");
        this.setRequestProperty("Connection", "Keep-Alive");
        this.setRequestProperty("Content-Type", "multipart/form-data; boundary=*********NASA_World_Wind_HTTP_File_Upload_Separator**********");
        this.setRequestProperty("Content-Transfer-Encoding", "binary");
    }

    public long getTotalFilesToUpload() {
        return this.filesToUpload.size();
    }

    public long getTotalBytesToUpload() {
        return this.totalBytesToUpload;
    }

    public long getTotalBytesUploaded() {
        return this.totalBytesUploaded;
    }

    public int getTotalFilesUploaded() {
        return this.totalFilesUploaded;
    }

    public int getTotalFilesFailed() {
        return this.totalFilesFailed;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int n) {
        this.maxBufferSize = n;
    }

    public void setRequestMethod(String string) {
        if ("POST".equalsIgnoreCase(string)) {
            this.requestMethod = "POST";
        } else if ("GET".equalsIgnoreCase(string)) {
            this.requestMethod = "GET";
        } else {
            String string2 = Logging.getMessage("generic.UnknownValueForKey", string, "method={POST|GET}");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestProperty(String string, String string2) {
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.requestProperties.setValue(string, string2);
    }

    public void add(ByteBuffer byteBuffer, String string, AVList aVList) {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (byteBuffer.limit() == 0) {
            String string4 = Logging.getMessage("generic.BufferIsEmpty");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.totalBytesToUpload += (long)byteBuffer.limit();
        this.filesToUpload.add(new FileInfo(string, byteBuffer, aVList));
    }

    public void add(File file, String string, AVList aVList) throws FileNotFoundException {
        if (null != file && file.exists()) {
            this.totalBytesToUpload += file.length();
        } else {
            throw new FileNotFoundException(file != null ? file.getName() : "");
        }
        this.filesToUpload.add(new FileInfo(string, file, aVList));
    }

    public void send() throws Exception {
        for (FileInfo fileInfo : this.filesToUpload) {
            try {
                if (fileInfo.uploadItem instanceof File) {
                    this.send((File)fileInfo.uploadItem, fileInfo.uploadName, fileInfo.properties);
                } else if (fileInfo.uploadItem instanceof ByteBuffer) {
                    this.send((ByteBuffer)fileInfo.uploadItem, fileInfo.uploadName, fileInfo.properties);
                } else if (fileInfo.uploadItem instanceof String) {
                    this.send((String)fileInfo.uploadItem, fileInfo.uploadName, fileInfo.properties);
                }
                ++this.totalFilesUploaded;
            }
            catch (Exception exception) {
                ++this.totalFilesFailed;
                String string = WWUtil.extractExceptionReason(exception);
                String string2 = Logging.getMessage("HTTP.FileUploadFailed", fileInfo.uploadName, string);
                Logging.logger().log(Level.FINEST, string2, exception);
                throw new WWRuntimeException(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(File file, String string, AVList aVList) throws IOException, NullPointerException {
        if (null == file || !file.exists()) {
            throw new FileNotFoundException();
        }
        if (null == this.url) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        HttpURLConnection httpURLConnection = null;
        FileInputStream fileInputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            this.writeRequestProperties(httpURLConnection);
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            this.writeProperties(dataOutputStream, aVList);
            this.writeContentDisposition(dataOutputStream, string);
            fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            int n2 = Math.min(n, this.maxBufferSize);
            byte[] byArray = ByteBuffer.allocate(n2).array();
            int n3 = fileInputStream.read(byArray, 0, n2);
            while (n3 > 0) {
                dataOutputStream.write(byArray, 0, n3);
                this.totalBytesUploaded += (long)n3;
                this.notifyProgress();
                n = fileInputStream.available();
                n2 = Math.min(n, this.maxBufferSize);
                n3 = fileInputStream.read(byArray, 0, n2);
            }
            this.writeContentSeparator(dataOutputStream);
            dataOutputStream.flush();
            this.handleResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            WWIO.closeStream(fileInputStream, null);
            WWIO.closeStream(dataOutputStream, null);
            this.disconnect(httpURLConnection, this.url.toString());
            throw throwable;
        }
        WWIO.closeStream(fileInputStream, null);
        WWIO.closeStream(dataOutputStream, null);
        this.disconnect(httpURLConnection, this.url.toString());
    }

    protected void handleResponse(HttpURLConnection httpURLConnection) throws IOException {
        if (null != httpURLConnection) {
            int n = httpURLConnection.getResponseCode();
            String string = httpURLConnection.getResponseMessage();
            if (n != 200) {
                String string2 = "(" + n + ") :" + string;
                throw new IOException(string2);
            }
        } else {
            throw new IOException(Logging.getMessage("nullValue.ConnectionIsNull"));
        }
    }

    protected void disconnect(HttpURLConnection httpURLConnection, String string) {
        if (null != httpURLConnection) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("WWIO.ErrorTryingToClose", string);
                Logging.logger().log(Level.WARNING, string2, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(ByteBuffer byteBuffer, String string, AVList aVList) throws IOException {
        if (null == byteBuffer) {
            String string2 = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (byteBuffer.limit() == 0) {
            String string3 = Logging.getMessage("generic.BufferIsEmpty");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (null == this.url) {
            String string4 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (WWUtil.isEmpty(string)) {
            String string5 = Logging.getMessage("nullValue.FilenameIsNullOrEmpty");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        HttpURLConnection httpURLConnection = null;
        DataOutputStream dataOutputStream = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            this.writeRequestProperties(httpURLConnection);
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            this.writeProperties(dataOutputStream, aVList);
            this.writeContentDisposition(dataOutputStream, string);
            int n = byteBuffer.rewind().remaining();
            int n2 = Math.min(n, this.maxBufferSize);
            byte[] byArray = ByteBuffer.allocate(n2).array();
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                int n3 = Math.min(byteBuffer.remaining(), this.maxBufferSize);
                byteBuffer.get(byArray, 0, n3);
                dataOutputStream.write(byArray, 0, n3);
                this.totalBytesUploaded += (long)n3;
                this.notifyProgress();
            }
            this.writeContentSeparator(dataOutputStream);
            dataOutputStream.flush();
            this.handleResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            WWIO.closeStream(dataOutputStream, null);
            this.disconnect(httpURLConnection, this.url.toString());
            throw throwable;
        }
        WWIO.closeStream(dataOutputStream, null);
        this.disconnect(httpURLConnection, this.url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(String string, String string2, AVList aVList) throws IOException {
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (null == this.url) {
            String string4 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (WWUtil.isEmpty(string2)) {
            String string5 = Logging.getMessage("nullValue.FilenameIsNullOrEmpty");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        HttpURLConnection httpURLConnection = null;
        DataOutputStream dataOutputStream = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            this.writeRequestProperties(httpURLConnection);
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            this.writeProperties(dataOutputStream, aVList);
            this.writeContentDisposition(dataOutputStream, string2);
            byte[] byArray = string.getBytes("UTF-8");
            dataOutputStream.write(byArray, 0, byArray.length);
            this.totalBytesUploaded += (long)string.length();
            this.notifyProgress();
            this.writeContentSeparator(dataOutputStream);
            dataOutputStream.flush();
            this.handleResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            WWIO.closeStream(dataOutputStream, null);
            this.disconnect(httpURLConnection, this.url.toString());
            throw throwable;
        }
        WWIO.closeStream(dataOutputStream, null);
        this.disconnect(httpURLConnection, this.url.toString());
    }

    protected void writeProperties(DataOutputStream dataOutputStream, AVList aVList) throws IOException {
        if (null != dataOutputStream && null != aVList) {
            for (Map.Entry<String, Object> entry : aVList.getEntries()) {
                String string = entry.getKey();
                String string2 = AVListImpl.getStringValue(aVList, string, "");
                this.writeContentDisposition(dataOutputStream, string, string2);
            }
        }
    }

    protected void writeRequestProperties(HttpURLConnection httpURLConnection) throws IOException {
        if (null != httpURLConnection) {
            httpURLConnection.setRequestMethod(this.getRequestMethod());
            for (Map.Entry<String, Object> entry : this.requestProperties.getEntries()) {
                httpURLConnection.setRequestProperty(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected void writeContentDisposition(DataOutputStream dataOutputStream, String string) throws IOException {
        if (null != dataOutputStream) {
            dataOutputStream.writeBytes("--*********NASA_World_Wind_HTTP_File_Upload_Separator**********\r\n");
            dataOutputStream.writeBytes("Content-Disposition: attachment; filename=\"" + string + "\"\r\n");
            dataOutputStream.writeBytes("Content-type: application/octet-stream\r\n");
            dataOutputStream.writeBytes(CR_LF);
        }
    }

    protected void writeContentDisposition(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        if (null != dataOutputStream && null != string) {
            dataOutputStream.writeBytes("--*********NASA_World_Wind_HTTP_File_Upload_Separator**********\r\n");
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"\r\n");
            dataOutputStream.writeBytes(CR_LF + string2 + CR_LF);
        }
    }

    protected void writeContentSeparator(DataOutputStream dataOutputStream) throws IOException {
        if (null != dataOutputStream) {
            dataOutputStream.writeBytes("\r\n--*********NASA_World_Wind_HTTP_File_Upload_Separator**********--\r\n");
        }
    }

    protected void notifyProgress() {
        double d = 100.0 * (double)this.totalBytesUploaded / (double)this.totalBytesToUpload;
        this.setChanged();
        this.notifyObservers(new Float(d));
    }

    protected class FileInfo {
        protected final String uploadName;
        protected final Object uploadItem;
        protected final AVList properties;

        public FileInfo(String string, Object object, AVList aVList) {
            this.uploadName = string;
            this.uploadItem = object;
            this.properties = aVList;
        }
    }
}

