/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.FileStoreSource;
import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.logging.Level;

public class SessionCacheRetrievalPostProcessor
implements RetrievalPostProcessor {
    protected String name;
    protected final SessionCache cache;
    protected final Object cacheKey;
    protected final AbsentResourceList absentResourceList;
    protected final long resourceID;
    protected FileStoreSource fsSource;
    protected final PropertyChangeListener propertyListener;
    protected final String propertyName;

    public SessionCacheRetrievalPostProcessor(SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, FileStoreSource fileStoreSource, PropertyChangeListener propertyChangeListener, String string) {
        if (sessionCache == null) {
            String string2 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.cache = sessionCache;
        this.cacheKey = object;
        this.absentResourceList = absentResourceList;
        this.resourceID = l;
        this.fsSource = fileStoreSource;
        this.propertyListener = propertyChangeListener;
        this.propertyName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final SessionCache getCache() {
        return this.cache;
    }

    public final Object getCacheKey() {
        return this.cacheKey;
    }

    public final AbsentResourceList getAbsentResourceList() {
        return this.absentResourceList;
    }

    public final long getResourceID() {
        return this.resourceID;
    }

    public final PropertyChangeListener getPropertyListener() {
        return this.propertyListener;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public ByteBuffer run(Retriever retriever) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validate(retriever);
        if (string == null) {
            this.onRetrievalSuceeded(retriever);
        } else {
            this.onRetrievalFailed(retriever);
            Logging.logger().severe(string);
        }
        this.signalRetrievalComplete();
        return retriever.getBuffer();
    }

    protected void onRetrievalSuceeded(Retriever retriever) {
        try {
            this.handleContent(retriever);
            if (this.absentResourceList != null) {
                this.absentResourceList.unmarkResourceAbsent(this.resourceID);
            }
        }
        catch (Exception exception) {
            this.handleContentException(retriever, exception);
        }
    }

    protected void onRetrievalFailed(Retriever retriever) {
        if (this.absentResourceList != null) {
            this.absentResourceList.markResourceAbsent(this.resourceID);
        }
    }

    protected String validate(Retriever retriever) {
        if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
            return Logging.getMessage("generic.RetrievalFailed", this.toString());
        }
        if (retriever.getBuffer() == null || retriever.getBuffer().limit() == 0) {
            return Logging.getMessage("generic.RetrievalReturnedNoContent", this.toString());
        }
        return null;
    }

    protected void signalRetrievalComplete() {
        if (this.propertyListener != null && this.propertyName != null) {
            this.propertyListener.propertyChange(new PropertyChangeEvent(this, this.propertyName, null, this.propertyListener));
        }
    }

    protected void handleContent(Retriever retriever) throws Exception {
        String string = retriever.getName().toUpperCase();
        if (string.contains("SERVICE=WMS") && string.contains("REQUEST=GETCAPABILITIES")) {
            this.handleWMSCapabilitiesContent(retriever);
        } else {
            this.handleUnknownContent(retriever);
        }
    }

    protected void handleWMSCapabilitiesContent(Retriever retriever) throws Exception {
        ByteBuffer byteBuffer = retriever.getBuffer();
        WMSCapabilities wMSCapabilities = new WMSCapabilities(byteBuffer);
        this.cache.put(this.cacheKey, wMSCapabilities.parse(new Object[0]));
        if (this.fsSource != null) {
            this.fsSource.storeFileContents(byteBuffer);
        }
    }

    protected void handleUnknownContent(Retriever retriever) throws Exception {
        this.cache.put(this.cacheKey, retriever.getBuffer());
    }

    protected void handleContentException(Retriever retriever, Exception exception) {
        if (exception instanceof ClosedByInterruptException) {
            Logging.logger().log(Level.FINE, Logging.getMessage("generic.OperationCancelled", "retrieval post-processing for " + retriever.getName()), exception);
        } else {
            this.onRetrievalFailed(retriever);
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhileSavingRetreivedData", retriever.getName()), exception);
        }
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }
}

