/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Attributable;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.CappedEllipticalCylinder;
import gov.nasa.worldwind.render.airspaces.Curtain;
import gov.nasa.worldwind.render.airspaces.Orbit;
import gov.nasa.worldwind.render.airspaces.PartialCappedCylinder;
import gov.nasa.worldwind.render.airspaces.Route;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.TrackAirspace;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.EditorAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ShapeEditor
implements SelectListener,
PropertyChangeListener {
    protected static String ANNOTATION = "gov.nasa.worldwind.shapeEditor.Annotation";
    protected static String LOCATION = "gov.nasa.worldwind.shapeEditor.Location";
    protected static String ROTATION = "gov.nasa.worldwind.shapeEditor.Rotation";
    protected static String WIDTH = "gov.nasa.worldwind.shapeEditor.Width";
    protected static String HEIGHT = "gov.nasa.worldwind.shapeEditor.Height";
    protected static String LEFT_WIDTH = "gov.nasa.worldwind.shapeEditor.LeftWidth";
    protected static String RIGHT_WIDTH = "gov.nasa.worldwind.shapeEditor.RightWidth";
    protected static String INNER_RADIUS = "gov.nasa.worldwind.shapeEditor.InnerRadius";
    protected static String OUTER_RADIUS = "gov.nasa.worldwind.shapeEditor.OuterRadius";
    protected static String INNER_MINOR_RADIUS = "gov.nasa.worldwind.shapeEditor.InnerMinorRadius";
    protected static String OUTER_MINOR_RADIUS = "gov.nasa.worldwind.shapeEditor.OuterMinorRadius";
    protected static String INNER_MAJOR_RADIUS = "gov.nasa.worldwind.shapeEditor.InnerMajorRadius";
    protected static String OUTER_MAJOR_RADIUS = "gov.nasa.worldwind.shapeEditor.OuterMajorRadius";
    protected static String LEFT_AZIMUTH = "gov.nasa.worldwind.shapeEditor.LeftAzimuth";
    protected static String RIGHT_AZIMUTH = "gov.nasa.worldwind.shapeEditor.RightAzimuth";
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int SIZING = 2;
    protected final WorldWindow wwd;
    protected Renderable shape;
    protected MarkerLayer controlPointLayer;
    protected RenderableLayer accessoryLayer;
    protected RenderableLayer annotationLayer;
    protected RenderableLayer shadowLayer;
    protected EditorAnnotation annotation;
    protected UnitsFormat unitsFormat;
    protected boolean armed;
    protected boolean active;
    protected int activeOperation = 0;
    protected Position previousPosition = null;
    protected ControlPointMarker currentSizingMarker;
    protected ShapeAttributes originalAttributes;
    protected ShapeAttributes originalHighlightAttributes;
    protected SelectEvent currentEvent;
    protected Angle currentHeading = Angle.ZERO;
    protected List<Box> trackAdjacencyList;
    protected MarkerAttributes locationControlPointAttributes;
    protected MarkerAttributes sizeControlPointAttributes;
    protected MarkerAttributes angleControlPointAttributes;
    protected boolean extensionEnabled = true;

    public ShapeEditor(WorldWindow worldWindow, Renderable renderable) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        if (!(renderable instanceof Movable2)) {
            String string = Logging.getMessage("generic.Movable2NotSupported");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        if (!(renderable instanceof Attributable)) {
            String string = Logging.getMessage("generic.AttributableNotSupported");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.shape = renderable;
        this.originalAttributes = ((Attributable)((Object)this.getShape())).getAttributes();
        this.controlPointLayer = new MarkerLayer();
        this.controlPointLayer.setKeepSeparated(false);
        this.controlPointLayer.setValue("gov.nasa.worldwind.avkey.Ignore", true);
        if (this.shape instanceof SurfaceShape || this.shape instanceof Airspace && ((Airspace)this.shape).isDrawSurfaceShape()) {
            this.controlPointLayer.setOverrideMarkerElevation(true);
            this.controlPointLayer.setElevation(0.0);
        }
        this.accessoryLayer = new RenderableLayer();
        this.accessoryLayer.setPickEnabled(false);
        this.accessoryLayer.setValue("gov.nasa.worldwind.avkey.Ignore", true);
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setOutlineMaterial(Material.GREEN);
        basicShapeAttributes.setOutlineWidth(2.0);
        ArrayList<Position> arrayList = new ArrayList<Position>(2);
        arrayList.add(Position.ZERO);
        arrayList.add(Position.ZERO);
        Path path = new Path(arrayList);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(2);
        path.setAttributes(basicShapeAttributes);
        this.accessoryLayer.addRenderable(path);
        this.annotationLayer = new RenderableLayer();
        this.annotationLayer.setPickEnabled(false);
        this.annotationLayer.setValue("gov.nasa.worldwind.avkey.Ignore", true);
        this.annotation = new EditorAnnotation("");
        this.annotationLayer.addRenderable(this.annotation);
        this.shadowLayer = new RenderableLayer();
        this.shadowLayer.setPickEnabled(false);
        this.shadowLayer.setValue("gov.nasa.worldwind.avkey.Ignore", true);
        this.unitsFormat = new UnitsFormat();
        this.unitsFormat.setFormat("UnitsFormat.FormatLength", " %,12.3f %s");
        this.makeControlPointAttributes();
    }

    protected void makeControlPointAttributes() {
        this.locationControlPointAttributes = new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.Sphere", 0.7, 10.0, 0.0);
        this.sizeControlPointAttributes = new BasicMarkerAttributes(Material.CYAN, "gov.nasa.worldwind.render.markers.Sphere", 0.7, 10.0, 0.0);
        this.angleControlPointAttributes = new BasicMarkerAttributes(Material.GREEN, "gov.nasa.worldwind.render.markers.Sphere", 0.7, 10.0, 0.0);
    }

    public UnitsFormat getUnitsFormat() {
        return this.unitsFormat;
    }

    public void setUnitsFormat(UnitsFormat unitsFormat) {
        this.unitsFormat = unitsFormat != null ? unitsFormat : new UnitsFormat();
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public Renderable getShape() {
        return this.shape;
    }

    public MarkerLayer getControlPointLayer() {
        return this.controlPointLayer;
    }

    public RenderableLayer getAccessoryLayer() {
        return this.accessoryLayer;
    }

    public RenderableLayer getAnnotationLayer() {
        return this.annotationLayer;
    }

    public RenderableLayer getShadowLayer() {
        return this.shadowLayer;
    }

    public EditorAnnotation getAnnotation() {
        return this.annotation;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getActiveOperation() {
        return this.activeOperation;
    }

    public Position getPreviousPosition() {
        return this.previousPosition;
    }

    public ControlPointMarker getCurrentSizingMarker() {
        return this.currentSizingMarker;
    }

    public ShapeAttributes getOriginalAttributes() {
        return this.originalAttributes;
    }

    public ShapeAttributes getOriginalHighlightAttributes() {
        return this.originalHighlightAttributes;
    }

    public Angle getCurrentHeading() {
        return this.currentHeading;
    }

    public MarkerAttributes getLocationControlPointAttributes() {
        return this.locationControlPointAttributes;
    }

    public MarkerAttributes getSizeControlPointAttributes() {
        return this.sizeControlPointAttributes;
    }

    public MarkerAttributes getAngleControlPointAttributes() {
        return this.angleControlPointAttributes;
    }

    public boolean isExtensionEnabled() {
        return this.extensionEnabled;
    }

    public void setExtensionEnabled(boolean bl) {
        this.extensionEnabled = bl;
    }

    public SelectEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        if (!this.isArmed() && bl) {
            this.enable();
        } else if (this.isArmed() && !bl) {
            this.disable();
        }
        this.armed = bl;
    }

    protected void enable() {
        LayerList layerList = this.getWwd().getModel().getLayers();
        if (!layerList.contains(this.getControlPointLayer())) {
            layerList.add(this.getControlPointLayer());
        }
        if (!this.getControlPointLayer().isEnabled()) {
            this.getControlPointLayer().setEnabled(true);
        }
        if (!layerList.contains(this.getAccessoryLayer())) {
            layerList.add(this.getAccessoryLayer());
        }
        if (!this.getAccessoryLayer().isEnabled()) {
            this.getAccessoryLayer().setEnabled(true);
        }
        if (!layerList.contains(this.getAnnotationLayer())) {
            layerList.add(this.getAnnotationLayer());
        }
        if (!layerList.contains(this.getShadowLayer())) {
            layerList.add(0, this.getShadowLayer());
        }
        this.getShadowLayer().setEnabled(true);
        if (this.getShape() instanceof TrackAirspace) {
            this.determineTrackAdjacency();
        }
        this.updateControlPoints();
        this.getWwd().addSelectListener(this);
        this.getWwd().getSceneController().addPropertyChangeListener(this);
    }

    protected void disable() {
        LayerList layerList = this.getWwd().getModel().getLayers();
        layerList.remove(this.getControlPointLayer());
        layerList.remove(this.getAccessoryLayer());
        layerList.remove(this.getAnnotationLayer());
        layerList.remove(this.getShadowLayer());
        this.getWwd().removeSelectListener(this);
        this.getWwd().getSceneController().removePropertyChangeListener(this);
        ((Component)((Object)this.getWwd())).setCursor(null);
    }

    protected void determineTrackAdjacency() {
        if (this.trackAdjacencyList == null) {
            this.trackAdjacencyList = new ArrayList<Box>();
        } else {
            this.trackAdjacencyList.clear();
        }
        TrackAirspace trackAirspace = (TrackAirspace)this.getShape();
        List<Box> list = trackAirspace.getLegs();
        for (int i = 1; i < list.size(); ++i) {
            boolean bl = list.get(i - 1).getLocations()[1].equals(list.get(i).getLocations()[0]);
            if (!bl) continue;
            this.trackAdjacencyList.add(list.get(i));
        }
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.currentEvent = selectEvent;
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.active = false;
            this.activeOperation = 0;
            this.previousPosition = null;
            ((Component)((Object)this.getWwd())).setCursor(null);
            this.removeShadowShape();
            this.updateAnnotation(null);
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            if (!(this.getWwd() instanceof Component)) {
                return;
            }
            Cursor cursor = null;
            if (this.activeOperation == 1) {
                cursor = Cursor.getPredefinedCursor(12);
            } else if (this.getActiveOperation() == 2) {
                cursor = Cursor.getPredefinedCursor(1);
            } else if (selectEvent.getTopObject() != null && selectEvent.getTopObject() == this.getShape()) {
                cursor = Cursor.getPredefinedCursor(12);
            } else if (selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof Marker) {
                cursor = Cursor.getPredefinedCursor(1);
            }
            ((Component)((Object)this.getWwd())).setCursor(cursor);
            if (this.getActiveOperation() == 1 && selectEvent.getTopObject() == this.getShape()) {
                this.updateShapeAnnotation();
            } else if (this.getActiveOperation() == 2) {
                this.updateAnnotation(this.getCurrentSizingMarker());
            } else if (selectEvent.getTopObject() != null && selectEvent.getTopObject() == this.getShape()) {
                this.updateShapeAnnotation();
            } else if (selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof ControlPointMarker) {
                this.updateAnnotation((ControlPointMarker)selectEvent.getTopObject());
            } else {
                this.updateAnnotation(null);
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress")) {
            PickedObject pickedObject;
            this.active = true;
            PickedObjectList pickedObjectList = this.getWwd().getObjectsAtCurrentPosition();
            if (pickedObjectList != null && (pickedObject = pickedObjectList.getTerrainObject()) != null) {
                this.previousPosition = pickedObject.getPosition();
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
            Object object = selectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (selectEvent.getTopPickedObject().getParentLayer() == this.getControlPointLayer()) {
                this.reshapeShape((ControlPointMarker)object);
                this.updateControlPoints();
                this.updateAnnotation(this.getCurrentSizingMarker());
                selectEvent.consume();
            } else if (selectEvent.getTopObject() == this.getShape() && (this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0) {
                this.reshapeShape(null);
                this.updateControlPoints();
                selectEvent.consume();
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            if (!this.isActive()) {
                return;
            }
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (this.getActiveOperation() == 0) {
                this.makeShadowShape();
            }
            if (object == this.getShape() || this.getActiveOperation() == 1) {
                this.activeOperation = 1;
                this.dragWholeShape(dragSelectEvent);
                this.updateControlPoints();
                this.updateShapeAnnotation();
                selectEvent.consume();
            } else if (dragSelectEvent.getTopPickedObject().getParentLayer() == this.getControlPointLayer() || this.getActiveOperation() == 2) {
                this.activeOperation = 2;
                this.reshapeShape((ControlPointMarker)object);
                this.updateControlPoints();
                this.updateAnnotation(this.getCurrentSizingMarker());
                selectEvent.consume();
            }
            this.getWwd().redraw();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.VerticalExaggeration")) {
            this.updateControlPoints();
        }
    }

    protected void makeShadowShape() {
        Renderable renderable = this.doMakeShadowShape();
        if (renderable == null) {
            return;
        }
        if (this.getShape() instanceof Airspace) {
            ((Airspace)this.getShape()).setAlwaysOnTop(true);
        }
        this.originalAttributes = ((Attributable)((Object)this.getShape())).getAttributes();
        this.originalHighlightAttributes = ((Attributable)((Object)this.getShape())).getHighlightAttributes();
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes(this.originalAttributes);
        if (basicShapeAttributes.getInteriorOpacity() == 1.0) {
            basicShapeAttributes.setInteriorOpacity(0.7);
        }
        ((Attributable)((Object)this.getShape())).setAttributes(basicShapeAttributes);
        ((Attributable)((Object)this.getShape())).setHighlightAttributes(basicShapeAttributes);
        this.getShadowLayer().addRenderable(renderable);
        if (this.getShape() instanceof Airspace) {
            double[] dArray = ((Airspace)renderable).getAltitudes();
            ((Airspace)renderable).setAltitudes(dArray[0], 0.95 * dArray[1]);
        }
    }

    protected void removeShadowShape() {
        this.getShadowLayer().removeAllRenderables();
        if (this.getShape() instanceof AbstractAirspace) {
            ((AbstractAirspace)this.getShape()).setAlwaysOnTop(false);
        }
        if (this.getOriginalAttributes() != null) {
            ((Attributable)((Object)this.getShape())).setAttributes(this.getOriginalAttributes());
            ((Attributable)((Object)this.getShape())).setHighlightAttributes(this.getOriginalHighlightAttributes());
        }
        this.getWwd().redraw();
    }

    protected Renderable doMakeShadowShape() {
        if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon) {
            return new gov.nasa.worldwind.render.airspaces.Polygon((gov.nasa.worldwind.render.airspaces.Polygon)this.getShape());
        }
        if (this.getShape() instanceof PartialCappedCylinder) {
            return new PartialCappedCylinder((PartialCappedCylinder)this.getShape());
        }
        if (this.getShape() instanceof CappedCylinder) {
            return new CappedCylinder((CappedCylinder)this.getShape());
        }
        if (this.getShape() instanceof CappedEllipticalCylinder) {
            return new CappedEllipticalCylinder((CappedEllipticalCylinder)this.getShape());
        }
        if (this.getShape() instanceof Orbit) {
            return new Orbit((Orbit)this.getShape());
        }
        if (this.getShape() instanceof Route) {
            return new Route((Route)this.getShape());
        }
        if (this.getShape() instanceof Curtain) {
            return new Curtain((Curtain)this.getShape());
        }
        if (this.getShape() instanceof SphereAirspace) {
            return new SphereAirspace((SphereAirspace)this.getShape());
        }
        if (this.getShape() instanceof TrackAirspace) {
            return new TrackAirspace((TrackAirspace)this.getShape());
        }
        if (this.getShape() instanceof SurfaceSquare) {
            return new SurfaceSquare((SurfaceSquare)this.getShape());
        }
        if (this.getShape() instanceof SurfaceQuad) {
            return new SurfaceQuad((SurfaceQuad)this.getShape());
        }
        if (this.getShape() instanceof SurfaceCircle) {
            return new SurfaceCircle((SurfaceCircle)this.getShape());
        }
        if (this.getShape() instanceof SurfaceEllipse) {
            return new SurfaceEllipse((SurfaceEllipse)this.getShape());
        }
        if (this.getShape() instanceof SurfacePolyline) {
            return new SurfacePolyline((SurfacePolyline)this.getShape());
        }
        if (this.getShape() instanceof SurfacePolygon) {
            return new SurfacePolygon((SurfacePolygon)this.getShape());
        }
        return null;
    }

    protected void adjustShape() {
        if (this.getShape() instanceof TrackAirspace) {
            this.adjustTrackShape();
        }
    }

    protected void adjustTrackShape() {
        TrackAirspace trackAirspace = (TrackAirspace)this.getShape();
        List<Box> list = trackAirspace.getLegs();
        if (list == null) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            Box box = list.get(i);
            if (!this.trackAdjacencyList.contains(list.get(i))) continue;
            box.setLocations(list.get(i - 1).getLocations()[1], box.getLocations()[1]);
        }
    }

    protected void dragWholeShape(DragSelectEvent dragSelectEvent) {
        Movable2 movable2 = (Movable2)((Object)this.getShape());
        View view = this.getWwd().getView();
        Globe globe = this.getWwd().getModel().getGlobe();
        Position position = movable2.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = view.project(vec4);
        int n = dragSelectEvent.getPickPoint().x - dragSelectEvent.getPreviousPickPoint().x;
        double d = vec42.x + (double)n;
        int n2 = dragSelectEvent.getPickPoint().y - dragSelectEvent.getPreviousPickPoint().y;
        double d2 = (double)dragSelectEvent.getMouseEvent().getComponent().getSize().height - vec42.y + (double)n2 - 1.0;
        Line line = view.computeRayFromScreenPoint(d, d2);
        Intersection[] intersectionArray = globe.intersect(line, position.getElevation());
        if (intersectionArray != null) {
            Position position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            movable2.moveTo(this.getWwd().getModel().getGlobe(), new Position(position2, ((Movable2)((Object)this.getShape())).getReferencePosition().getAltitude()));
        }
        this.adjustShape();
    }

    protected void reshapeShape(ControlPointMarker controlPointMarker) {
        this.currentSizingMarker = controlPointMarker;
        PickedObjectList pickedObjectList = this.getWwd().getObjectsAtCurrentPosition();
        if (pickedObjectList == null) {
            return;
        }
        PickedObject pickedObject = this.getWwd().getObjectsAtCurrentPosition().getTerrainObject();
        if (pickedObject == null) {
            return;
        }
        if (this.getPreviousPosition() == null) {
            this.previousPosition = pickedObject.getPosition();
            return;
        }
        this.doReshapeShape(controlPointMarker, pickedObject.getPosition());
        this.previousPosition = pickedObject.getPosition();
        this.adjustShape();
    }

    protected void doReshapeShape(ControlPointMarker controlPointMarker, Position position) {
        if (this.getShape() instanceof Airspace) {
            if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon || this.getShape() instanceof Curtain) {
                this.reshapePolygonAirspace(position, controlPointMarker);
            } else if (this.getShape() instanceof CappedCylinder) {
                this.reshapeCappedCylinder(position, controlPointMarker);
            } else if (this.getShape() instanceof CappedEllipticalCylinder) {
                this.reshapeCappedEllipticalCylinder(position, controlPointMarker);
            } else if (this.getShape() instanceof Orbit) {
                this.reshapeOrbit(position, controlPointMarker);
            } else if (this.getShape() instanceof Route) {
                this.reshapeRoute(position, controlPointMarker);
            } else if (this.getShape() instanceof SphereAirspace) {
                this.reshapeSphere(position, controlPointMarker);
            } else if (this.getShape() instanceof TrackAirspace) {
                this.reshapeTrack(position, controlPointMarker);
            }
        } else if (this.getShape() instanceof SurfaceShape) {
            if (this.getShape() instanceof SurfacePolygon) {
                this.reshapeSurfacePolygon(position, controlPointMarker);
            } else if (this.getShape() instanceof SurfacePolyline) {
                this.reshapeSurfacePolygon(position, controlPointMarker);
            } else if (this.getShape() instanceof SurfaceCircle) {
                this.reshapeSurfaceCircle(position, controlPointMarker);
            } else if (this.getShape() instanceof SurfaceSquare) {
                this.reshapeSurfaceSquare(position, controlPointMarker);
            } else if (this.getShape() instanceof SurfaceQuad) {
                this.reshapeSurfaceQuad(position, controlPointMarker);
            } else if (this.getShape() instanceof SurfaceEllipse) {
                this.reshapeSurfaceEllipse(position, controlPointMarker);
            }
        }
    }

    protected void updateControlPoints() {
        if (this.getShape() instanceof Airspace) {
            if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon || this.getShape() instanceof Curtain) {
                this.updatePolygonAirspaceControlPoints();
            } else if (this.getShape() instanceof PartialCappedCylinder) {
                this.updatePartialCappedCylinderControlPoints();
            } else if (this.getShape() instanceof CappedCylinder) {
                this.updateCappedCylinderControlPoints();
            } else if (this.getShape() instanceof CappedEllipticalCylinder) {
                this.updateCappedEllipticalCylinderControlPoints();
            } else if (this.getShape() instanceof Orbit) {
                this.updateOrbitControlPoints();
            } else if (this.getShape() instanceof Route) {
                this.updateRouteControlPoints();
            } else if (this.getShape() instanceof SphereAirspace) {
                this.updateSphereControlPoints();
            } else if (this.getShape() instanceof TrackAirspace) {
                this.updateTrackControlPoints();
            }
        } else if (this.getShape() instanceof SurfaceShape) {
            if (this.getShape() instanceof SurfacePolygon || this.getShape() instanceof SurfacePolyline) {
                this.updateSurfacePolygonControlPoints();
            } else if (this.getShape() instanceof SurfaceCircle) {
                this.updateSurfaceCircleControlPoints();
            } else if (this.getShape() instanceof SurfaceSquare) {
                this.updateSurfaceSquareControlPoints();
            } else if (this.getShape() instanceof SurfaceQuad) {
                this.updateSurfaceQuadControlPoints();
            } else if (this.getShape() instanceof SurfaceEllipse) {
                this.updateSurfaceEllipseControlPoints();
            }
        }
    }

    protected void updateShapeAnnotation() {
        LatLon latLon = this.getShapeCenter();
        if (latLon != null) {
            ControlPointMarker controlPointMarker = this.makeControlPoint(new Position(latLon, 0.0), new BasicMarkerAttributes(), 0, ANNOTATION);
            this.updateAnnotation(controlPointMarker);
        } else {
            this.updateAnnotation(null);
        }
    }

    protected LatLon getShapeCenter() {
        LatLon latLon = null;
        if (this.getShape() instanceof CappedCylinder) {
            latLon = ((CappedCylinder)this.getShape()).getCenter();
        } else if (this.getShape() instanceof CappedEllipticalCylinder) {
            latLon = ((CappedEllipticalCylinder)this.getShape()).getCenter();
        } else if (this.getShape() instanceof SphereAirspace) {
            latLon = ((SphereAirspace)this.getShape()).getLocation();
        } else if (this.getShape() instanceof SurfaceEllipse) {
            latLon = ((SurfaceEllipse)this.getShape()).getCenter();
        } else if (this.getShape() instanceof SurfaceQuad) {
            latLon = ((SurfaceQuad)this.getShape()).getCenter();
        }
        return latLon;
    }

    protected void updateAnnotation(ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            this.getAnnotationLayer().setEnabled(false);
            return;
        }
        this.getAnnotationLayer().setEnabled(true);
        this.getAnnotation().setPosition(controlPointMarker.getPosition());
        String string = controlPointMarker.size != null ? this.unitsFormat.length(null, controlPointMarker.size) : (controlPointMarker.rotation != null ? this.unitsFormat.angle(null, controlPointMarker.rotation) : this.unitsFormat.latLon2(controlPointMarker.getPosition()));
        this.getAnnotation().setText(string);
    }

    protected void updateOrientationLine(Position position, Position position2) {
        Path path = (Path)this.getAccessoryLayer().getRenderables().iterator().next();
        double d = position.getAltitude();
        double d2 = position2.getAltitude();
        if (this.getShapeAltitudeMode() == 2) {
            path.setAltitudeMode(2);
            path.setFollowTerrain(true);
            d = position.getAltitude() - this.getWwd().getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
            d2 = position2.getAltitude() - this.getWwd().getModel().getGlobe().getElevation(position2.getLatitude(), position2.getLongitude());
            d *= this.getWwd().getSceneController().getVerticalExaggeration();
            d2 *= this.getWwd().getSceneController().getVerticalExaggeration();
            d += 100.0;
            d2 += 100.0;
        } else if (this.getShapeAltitudeMode() == 1) {
            path.setAltitudeMode(1);
            path.setFollowTerrain(true);
        } else {
            path.setAltitudeMode(0);
            path.setFollowTerrain(false);
        }
        ArrayList<Position> arrayList = new ArrayList<Position>(2);
        arrayList.add(new Position(position, d));
        arrayList.add(new Position(position2, d2));
        path.setPositions(arrayList);
    }

    protected double getControlPointAltitude(LatLon latLon) {
        return this.doGetControlPointAltitude(latLon, this.getShape());
    }

    /*
     * WARNING - void declaration
     */
    protected double doGetControlPointAltitude(LatLon latLon, Renderable renderable) {
        double d;
        block9: {
            block8: {
                void position;
                d = 0.0;
                if (!(renderable instanceof Airspace) || ((Airspace)renderable).isDrawSurfaceShape()) break block8;
                Airspace airspace = (Airspace)renderable;
                d = airspace.getAltitudes()[1];
                if (!airspace.getAltitudeDatum()[1].equals("gov.nasa.worldwind.avkey.AboveGroundLevel")) break block9;
                LatLon latLon2 = airspace.getGroundReference();
                if (latLon2 == null) {
                    LatLon position2 = latLon;
                }
                d += this.getWwd().getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
                break block9;
            }
            if (renderable instanceof Path) {
                for (Position position : ((Path)renderable).getPositions()) {
                    if (!new LatLon(position).equals(latLon)) continue;
                    if (((Path)renderable).getAltitudeMode() == 0) {
                        d = position.getAltitude();
                        continue;
                    }
                    if (((Path)renderable).getAltitudeMode() != 2) continue;
                    d = position.getAltitude() + this.getWwd().getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
                }
            } else if (renderable instanceof Polygon) {
                for (Position position : ((Polygon)renderable).outerBoundary()) {
                    if (!new LatLon(position).equals(latLon)) continue;
                    if (((Polygon)renderable).getAltitudeMode() == 0) {
                        d = position.getAltitude();
                        continue;
                    }
                    if (((Polygon)renderable).getAltitudeMode() != 2) continue;
                    d = position.getAltitude() + this.getWwd().getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
                }
            }
        }
        return d;
    }

    protected int getShapeAltitudeMode() {
        int n = 0;
        if (this.getShape() instanceof Airspace && ((Airspace)this.getShape()).isDrawSurfaceShape()) {
            n = 1;
        } else if (this.getShape() instanceof Airspace) {
            if (((Airspace)this.getShape()).getAltitudeDatum()[1].equals("gov.nasa.worldwind.avkey.AboveGroundLevel")) {
                n = 2;
            }
        } else if (this.getShape() instanceof SurfaceShape) {
            n = 1;
        }
        return n;
    }

    protected ControlPointMarker makeControlPoint(Position position, MarkerAttributes markerAttributes, int n, String string) {
        return new ControlPointMarker(position, markerAttributes, n, string);
    }

    protected ControlPointMarker makeControlPoint(Position position, MarkerAttributes markerAttributes, int n, int n2, String string) {
        return new ControlPointMarker(position, markerAttributes, n, n2, string);
    }

    protected Vec4 computeControlPointDelta(LatLon latLon, LatLon latLon2) {
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon2);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon);
        return vec4.subtract3(vec42);
    }

    protected Angle normalizedHeading(Angle angle, Angle angle2) {
        double d = angle.getRadians() + angle2.getRadians();
        if (Math.abs(d) > Math.PI * 2) {
            d %= Math.PI * 2;
        }
        return Angle.fromRadians(d >= 0.0 ? d : d + Math.PI * 2);
    }

    protected Position computeEdgeLocation(LatLon latLon, LatLon latLon2, double d) {
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalNormalAtLocation(latLon.getLatitude(), latLon.getLongitude());
        Vec4 vec43 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon2);
        Vec4 vec44 = vec43.subtract3(vec4).normalize3();
        Vec4 vec45 = vec42.cross3(vec44).normalize3().multiply3(d);
        Position position = this.getWwd().getModel().getGlobe().computePositionFromEllipsoidalPoint(vec45.add3(vec4));
        double d2 = this.getControlPointAltitude(position);
        return new Position(position, d2);
    }

    protected Position computeRectangularEdgeLocation(LatLon latLon, LatLon latLon2, double d) {
        LatLon latLon3 = LatLon.interpolateGreatCircle(0.5, latLon, latLon2);
        Angle angle = LatLon.greatCircleAzimuth(latLon3, latLon2).add(Angle.POS90);
        Angle angle2 = Angle.fromRadians(d / this.getWwd().getModel().getGlobe().getRadius());
        LatLon latLon4 = LatLon.greatCircleEndPosition(latLon3, angle, angle2);
        double d2 = this.getControlPointAltitude(latLon4);
        return new Position(latLon4, d2);
    }

    protected Vec4 nearestPointOnSegment(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec44.normalize3();
        double d = vec43.subtract3(vec4).dot3(vec45);
        if (d < 0.0) {
            return vec4;
        }
        if (d > vec44.getLength3()) {
            return vec42;
        }
        return Vec4.fromLine3(vec4, d, vec45);
    }

    protected int addNearestLocation(Position position, double d, List<LatLon> list) {
        Globe globe = this.getWwd().getModel().getGlobe();
        Vec4 vec4 = globe.computeEllipsoidalPointFromPosition(position.getLatitude(), position.getLongitude(), d);
        Vec4 vec42 = null;
        int n = 0;
        double d2 = Double.MAX_VALUE;
        for (int i = 1; i <= list.size(); ++i) {
            Vec4 vec43;
            if (!(this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon) && !(this.getShape() instanceof SurfacePolygon) && i == list.size()) continue;
            LatLon latLon = list.get(i - 1);
            LatLon latLon2 = list.get(i == list.size() ? 0 : i);
            Vec4 vec44 = globe.computeEllipsoidalPointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d);
            Vec4 vec45 = this.nearestPointOnSegment(vec44, vec43 = globe.computeEllipsoidalPointFromPosition(latLon2.getLatitude(), latLon2.getLongitude(), d), vec4);
            double d3 = vec45.distanceTo3(vec4);
            if (!(d3 < d2)) continue;
            vec42 = vec45;
            n = i;
            d2 = d3;
        }
        if (vec42 != null) {
            Position position2 = globe.computePositionFromEllipsoidalPoint(vec42);
            if (n == list.size()) {
                list.add(position2);
            } else {
                list.add(n, position2);
            }
            this.getControlPointLayer().setMarkers(null);
            return n;
        }
        return -1;
    }

    protected void appendLocation(ControlPointMarker controlPointMarker, List<LatLon> list) {
        Globe globe = this.getWwd().getModel().getGlobe();
        if (controlPointMarker.getId() == 0) {
            Vec4 vec4 = globe.computeEllipsoidalPointFromLocation(list.get(0));
            Vec4 vec42 = globe.computeEllipsoidalPointFromLocation(list.get(1));
            Vec4 vec43 = vec4.add3(vec4.subtract3(vec42).multiply3(0.1));
            list.add(0, globe.computePositionFromEllipsoidalPoint(vec43));
        } else if (controlPointMarker.getId() == list.size() - 1) {
            Vec4 vec4 = globe.computeEllipsoidalPointFromLocation(list.get(list.size() - 2));
            Vec4 vec44 = globe.computeEllipsoidalPointFromLocation(list.get(list.size() - 1));
            Vec4 vec45 = vec44.add3(vec44.subtract3(vec4).multiply3(0.1));
            list.add(globe.computePositionFromEllipsoidalPoint(vec45));
        }
    }

    protected void moveLocation(ControlPointMarker controlPointMarker, Position position, List<LatLon> list) {
        Vec4 vec4 = this.computeControlPointDelta(this.getPreviousPosition(), position);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(new Position(controlPointMarker.getPosition(), 0.0));
        Position position2 = this.getWwd().getModel().getGlobe().computePositionFromEllipsoidalPoint(vec42.add3(vec4));
        list.set(controlPointMarker.getId(), position2);
    }

    protected void rotateLocations(Position position, List<LatLon> list) {
        LatLon latLon = LatLon.getCenter(this.getWwd().getModel().getGlobe(), list);
        Angle angle = LatLon.greatCircleAzimuth(latLon, this.getPreviousPosition());
        Angle angle2 = LatLon.greatCircleAzimuth(latLon, position).subtract(angle);
        this.currentHeading = this.normalizedHeading(this.getCurrentHeading(), angle2);
        for (int i = 0; i < list.size(); ++i) {
            LatLon latLon2 = list.get(i);
            Angle angle3 = LatLon.greatCircleAzimuth(latLon, latLon2);
            Angle angle4 = LatLon.greatCircleDistance(latLon, latLon2);
            LatLon latLon3 = LatLon.greatCircleEndPosition(latLon, angle3.add(angle2), angle4);
            list.set(i, latLon3);
        }
    }

    protected void reshapePolygonAirspace(Position position, ControlPointMarker controlPointMarker) {
        Iterable<LatLon> iterable = null;
        if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon) {
            iterable = ((gov.nasa.worldwind.render.airspaces.Polygon)this.getShape()).getLocations();
        } else if (this.getShape() instanceof Curtain) {
            iterable = ((Curtain)this.getShape()).getLocations();
        }
        if (iterable == null) {
            return;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            arrayList.add(latLon);
        }
        if (controlPointMarker != null && controlPointMarker.getPurpose().equals(ROTATION)) {
            this.rotateLocations(position, arrayList);
        } else if (controlPointMarker != null) {
            if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x200) != 0 && this.isExtensionEnabled()) {
                int n;
                int n2 = n = this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon ? 3 : 2;
                if (arrayList.size() > n) {
                    arrayList.remove(controlPointMarker.getId());
                    this.getControlPointLayer().setMarkers(null);
                }
            } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled() && this.getShape() instanceof Curtain) {
                this.appendLocation(controlPointMarker, arrayList);
                this.getControlPointLayer().setMarkers(null);
            } else {
                this.moveLocation(controlPointMarker, position, arrayList);
            }
        } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
            double d = ((Airspace)this.getShape()).getAltitudes()[1];
            this.addNearestLocation(position, d, arrayList);
        }
        if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon) {
            ((gov.nasa.worldwind.render.airspaces.Polygon)this.getShape()).setLocations(arrayList);
        } else if (this.getShape() instanceof Curtain) {
            ((Curtain)this.getShape()).setLocations(arrayList);
        }
    }

    protected void updatePolygonAirspaceControlPoints() {
        Iterator<Marker> iterator;
        LatLon latLon22;
        Iterable<LatLon> iterable = null;
        if (this.getShape() instanceof gov.nasa.worldwind.render.airspaces.Polygon) {
            iterable = ((gov.nasa.worldwind.render.airspaces.Polygon)this.getShape()).getLocations();
        } else if (this.getShape() instanceof Curtain) {
            iterable = ((Curtain)this.getShape()).getLocations();
        }
        if (iterable == null) {
            return;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon22 : iterable) {
            arrayList.add(latLon22);
        }
        if (arrayList.size() < 2) {
            return;
        }
        Globe globe = this.getWwd().getModel().getGlobe();
        latLon22 = LatLon.getCenter(globe, arrayList);
        double d = this.getControlPointAltitude(latLon22);
        Angle angle = LatLon.getAverageDistance(globe, latLon22, arrayList);
        angle = angle.multiply(1.2);
        Angle angle2 = this.getCurrentHeading();
        LatLon latLon3 = LatLon.greatCircleEndPosition(latLon22, angle2, angle);
        double d2 = this.getControlPointAltitude(latLon3);
        Iterable<Marker> iterable2 = this.getControlPointLayer().getMarkers();
        if (iterable2 == null) {
            iterator = new ArrayList();
            int n = 0;
            for (LatLon latLon : arrayList) {
                double d3 = this.getControlPointAltitude(latLon);
                Position position = new Position(latLon, d3);
                ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position, this.getLocationControlPointAttributes(), n++, LOCATION));
            }
            Position position = new Position(latLon3, d2);
            ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), n, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable2.iterator();
            for (LatLon latLon : arrayList) {
                double d4 = this.getControlPointAltitude(latLon);
                ((Marker)iterator.next()).setPosition(new Position(latLon, d4));
            }
            ((Marker)iterator.next()).setPosition(new Position(latLon3, d2));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        for (LatLon latLon : arrayList) {
            iterator.next();
        }
        ((ControlPointMarker)iterator.next()).rotation = angle2;
        this.updateOrientationLine(new Position(latLon22, d), new Position(latLon3, d2));
    }

    protected void reshapeCappedCylinder(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        CappedCylinder cappedCylinder = (CappedCylinder)this.getShape();
        double[] dArray = cappedCylinder.getRadii();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(cappedCylinder.getCenter());
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Vec4 vec44 = this.computeControlPointDelta(this.getPreviousPosition(), position);
        if (controlPointMarker.getPurpose().equals(OUTER_RADIUS)) {
            dArray[1] = dArray[1] + vec44.dot3(vec43);
        } else if (controlPointMarker.getPurpose().equals(INNER_RADIUS)) {
            dArray[0] = dArray[0] + vec44.dot3(vec43);
        }
        if (dArray[0] >= 0.0 && dArray[1] > 0.0 && dArray[0] < dArray[1]) {
            cappedCylinder.setRadii(dArray[0], dArray[1]);
        }
        if (this.getShape() instanceof PartialCappedCylinder) {
            Angle angle = LatLon.greatCircleAzimuth(cappedCylinder.getCenter(), this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(cappedCylinder.getCenter(), position).subtract(angle);
            Angle[] angleArray = ((PartialCappedCylinder)cappedCylinder).getAzimuths();
            if (controlPointMarker.getPurpose().equals(LEFT_AZIMUTH)) {
                angleArray[0] = this.normalizedHeading(angleArray[0], angle2);
            } else if (controlPointMarker.getPurpose().equals(RIGHT_AZIMUTH)) {
                angleArray[1] = this.normalizedHeading(angleArray[1], angle2);
            } else if (controlPointMarker.getPurpose().equals(ROTATION)) {
                this.currentHeading = this.normalizedHeading(this.getCurrentHeading(), angle2);
                angleArray[0] = this.normalizedHeading(angleArray[0], angle2);
                angleArray[1] = this.normalizedHeading(angleArray[1], angle2);
            }
            ((PartialCappedCylinder)cappedCylinder).setAzimuths(angleArray[0], angleArray[1]);
        }
    }

    protected void updateCappedCylinderControlPoints() {
        Iterator<Marker> iterator;
        CappedCylinder cappedCylinder = (CappedCylinder)this.getShape();
        double[] dArray = cappedCylinder.getRadii();
        boolean bl = dArray[0] > 0.0;
        LatLon latLon = LatLon.greatCircleEndPosition(cappedCylinder.getCenter(), Angle.fromDegrees(90.0), Angle.fromRadians(dArray[1] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(cappedCylinder.getCenter(), Angle.fromDegrees(90.0), Angle.fromRadians(dArray[0] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        double d = this.getControlPointAltitude(latLon);
        double d2 = this.getControlPointAltitude(latLon2);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(1);
            Position position = new Position(latLon, d);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, OUTER_RADIUS));
            if (bl) {
                position = new Position(latLon2, d2);
                iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 1, INNER_RADIUS));
            }
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, d));
            if (bl) {
                ((Marker)iterator.next()).setPosition(new Position(latLon2, d2));
            }
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = dArray[1];
        if (bl) {
            ((ControlPointMarker)iterator.next()).size = dArray[0];
        }
    }

    protected void updatePartialCappedCylinderControlPoints() {
        Iterator<Marker> iterator;
        PartialCappedCylinder partialCappedCylinder = (PartialCappedCylinder)this.getShape();
        double[] dArray = partialCappedCylinder.getRadii();
        boolean bl = dArray[0] > 0.0;
        double d = 0.5 * (dArray[0] + dArray[1]);
        Angle[] angleArray = partialCappedCylinder.getAzimuths();
        LatLon latLon = LatLon.greatCircleEndPosition(partialCappedCylinder.getCenter(), angleArray[1], Angle.fromRadians(dArray[1] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(partialCappedCylinder.getCenter(), angleArray[1], Angle.fromRadians(dArray[0] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon3 = LatLon.greatCircleEndPosition(partialCappedCylinder.getCenter(), angleArray[0], Angle.fromRadians(d / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon4 = LatLon.greatCircleEndPosition(partialCappedCylinder.getCenter(), angleArray[1], Angle.fromRadians(d / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        double d2 = this.getControlPointAltitude(latLon);
        double d3 = this.getControlPointAltitude(latLon2);
        double d4 = this.getControlPointAltitude(latLon4);
        double d5 = this.getControlPointAltitude(latLon3);
        LatLon latLon5 = LatLon.greatCircleEndPosition(partialCappedCylinder.getCenter(), this.getCurrentHeading(), Angle.fromRadians(1.2 * dArray[1] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        double d6 = this.getControlPointAltitude(latLon5);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(1);
            Position position = new Position(latLon, d2);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, OUTER_RADIUS));
            if (bl) {
                position = new Position(latLon2, d3);
                iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 1, INNER_RADIUS));
            }
            position = new Position(latLon3, d5);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 2, LEFT_AZIMUTH));
            position = new Position(latLon4, d4);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 3, RIGHT_AZIMUTH));
            position = new Position(latLon5, d6);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 4, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, d2));
            if (bl) {
                ((Marker)iterator.next()).setPosition(new Position(latLon2, d4));
            }
            ((Marker)iterator.next()).setPosition(new Position(latLon3, d5));
            ((Marker)iterator.next()).setPosition(new Position(latLon4, d4));
            ((Marker)iterator.next()).setPosition(new Position(latLon5, d6));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = dArray[1];
        if (bl) {
            ((ControlPointMarker)iterator.next()).size = dArray[0];
        }
        ((ControlPointMarker)iterator.next()).rotation = angleArray[0];
        ((ControlPointMarker)iterator.next()).rotation = angleArray[1];
        ((ControlPointMarker)iterator.next()).rotation = this.getCurrentHeading();
        double d7 = this.getControlPointAltitude(partialCappedCylinder.getCenter());
        this.updateOrientationLine(new Position(partialCappedCylinder.getCenter(), d7), new Position(latLon5, d6));
    }

    protected void reshapeCappedEllipticalCylinder(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        CappedEllipticalCylinder cappedEllipticalCylinder = (CappedEllipticalCylinder)this.getShape();
        double[] dArray = cappedEllipticalCylinder.getRadii();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(cappedEllipticalCylinder.getCenter());
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Vec4 vec44 = this.computeControlPointDelta(this.getPreviousPosition(), position);
        if (controlPointMarker.getPurpose().equals(INNER_MINOR_RADIUS)) {
            dArray[0] = dArray[0] + vec44.dot3(vec43);
        } else if (controlPointMarker.getPurpose().equals(INNER_MAJOR_RADIUS)) {
            dArray[1] = dArray[1] + vec44.dot3(vec43);
        } else if (controlPointMarker.getPurpose().equals(OUTER_MINOR_RADIUS)) {
            dArray[2] = dArray[2] + vec44.dot3(vec43);
        } else if (controlPointMarker.getPurpose().equals(OUTER_MAJOR_RADIUS)) {
            dArray[3] = dArray[3] + vec44.dot3(vec43);
        } else if (controlPointMarker.getPurpose().equals(ROTATION)) {
            Angle angle = LatLon.greatCircleAzimuth(cappedEllipticalCylinder.getCenter(), this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(cappedEllipticalCylinder.getCenter(), position).subtract(angle);
            cappedEllipticalCylinder.setHeading(this.normalizedHeading(cappedEllipticalCylinder.getHeading(), angle2));
            this.currentHeading = this.normalizedHeading(this.getCurrentHeading(), angle2);
        }
        if (ShapeEditor.isRadiiValid(dArray[0], dArray[2]) && ShapeEditor.isRadiiValid(dArray[1], dArray[3])) {
            cappedEllipticalCylinder.setRadii(dArray[0], dArray[1], dArray[2], dArray[3]);
        }
    }

    protected static boolean isRadiiValid(double d, double d2) {
        return d >= 0.0 && d < d2;
    }

    protected void updateCappedEllipticalCylinderControlPoints() {
        Iterator<Marker> iterator;
        CappedEllipticalCylinder cappedEllipticalCylinder = (CappedEllipticalCylinder)this.getShape();
        double[] dArray = cappedEllipticalCylinder.getRadii();
        boolean bl = dArray[0] > 0.0 && dArray[1] > 0.0;
        Angle angle = cappedEllipticalCylinder.getHeading();
        LatLon latLon = LatLon.greatCircleEndPosition(cappedEllipticalCylinder.getCenter(), Angle.fromDegrees(90.0).add(angle), Angle.fromRadians(dArray[0] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(cappedEllipticalCylinder.getCenter(), Angle.fromDegrees(0.0).add(angle), Angle.fromRadians(dArray[1] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon3 = LatLon.greatCircleEndPosition(cappedEllipticalCylinder.getCenter(), Angle.fromDegrees(90.0).add(angle), Angle.fromRadians(dArray[2] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon4 = LatLon.greatCircleEndPosition(cappedEllipticalCylinder.getCenter(), Angle.fromDegrees(0.0).add(angle), Angle.fromRadians(dArray[3] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon5 = LatLon.greatCircleEndPosition(cappedEllipticalCylinder.getCenter(), this.getCurrentHeading(), Angle.fromRadians(1.4 * dArray[3] / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        double d = this.getControlPointAltitude(latLon5);
        double d2 = this.getControlPointAltitude(latLon);
        double d3 = this.getControlPointAltitude(latLon2);
        double d4 = this.getControlPointAltitude(latLon3);
        double d5 = this.getControlPointAltitude(latLon4);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(2);
            Position position = new Position(latLon3, d4);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 2, OUTER_MINOR_RADIUS));
            position = new Position(latLon4, d5);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 3, OUTER_MAJOR_RADIUS));
            if (bl) {
                position = new Position(latLon, d2);
                iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, INNER_MINOR_RADIUS));
                position = new Position(latLon2, d3);
                iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 1, INNER_MAJOR_RADIUS));
            }
            position = new Position(latLon5, d);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 4, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon3, d4));
            ((Marker)iterator.next()).setPosition(new Position(latLon4, d5));
            if (bl) {
                ((Marker)iterator.next()).setPosition(new Position(latLon, d2));
                ((Marker)iterator.next()).setPosition(new Position(latLon2, d3));
            }
            ((Marker)iterator.next()).setPosition(new Position(latLon5, d));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = dArray[2];
        ((ControlPointMarker)iterator.next()).size = dArray[3];
        if (bl) {
            ((ControlPointMarker)iterator.next()).size = dArray[0];
            ((ControlPointMarker)iterator.next()).size = dArray[1];
        }
        ((ControlPointMarker)iterator.next()).rotation = this.getCurrentHeading();
        double d6 = this.getControlPointAltitude(cappedEllipticalCylinder.getCenter());
        this.updateOrientationLine(new Position(cappedEllipticalCylinder.getCenter(), d6), new Position(latLon5, d));
    }

    protected void reshapeSphere(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        SphereAirspace sphereAirspace = (SphereAirspace)this.getShape();
        double d = sphereAirspace.getRadius();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(sphereAirspace.getLocation());
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Vec4 vec44 = this.computeControlPointDelta(this.getPreviousPosition(), position);
        if (controlPointMarker.getPurpose().equals(OUTER_RADIUS)) {
            d += vec44.dot3(vec43);
        }
        if (d > 0.0) {
            sphereAirspace.setRadius(d);
        }
    }

    protected void updateSphereControlPoints() {
        Iterator<Marker> iterator;
        SphereAirspace sphereAirspace = (SphereAirspace)this.getShape();
        double d = sphereAirspace.getRadius();
        LatLon latLon = LatLon.greatCircleEndPosition(sphereAirspace.getLocation(), Angle.fromDegrees(90.0), Angle.fromRadians(d / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        double d2 = this.getControlPointAltitude(latLon);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(1);
            Position position = new Position(latLon, d2);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, OUTER_RADIUS));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, d2));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = d;
    }

    protected void reshapeOrbit(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        Orbit orbit = (Orbit)this.getShape();
        LatLon[] latLonArray = orbit.getLocations();
        double d = orbit.getWidth();
        LatLon latLon = LatLon.interpolateGreatCircle(0.5, latLonArray[0], latLonArray[1]);
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(new Position(controlPointMarker.getPosition(), 0.0));
        if (controlPointMarker.getPurpose().equals(RIGHT_WIDTH)) {
            Vec4 vec43;
            Vec4 vec44 = this.computeControlPointDelta(this.getPreviousPosition(), position);
            double d2 = d + vec44.dot3(vec43 = vec42.subtract3(vec4).normalize3());
            if (d2 > 0.0) {
                orbit.setWidth(d + vec44.dot3(vec43));
            }
        } else if (controlPointMarker.getPurpose().equals(ROTATION)) {
            Angle angle = LatLon.greatCircleAzimuth(latLon, this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(latLon, position).subtract(angle);
            for (int i = 0; i < 2; ++i) {
                Angle angle3 = LatLon.greatCircleAzimuth(latLon, latLonArray[i]);
                Angle angle4 = LatLon.greatCircleDistance(latLon, latLonArray[i]);
                latLonArray[i] = LatLon.greatCircleEndPosition(latLon, angle3.add(angle2), angle4);
            }
            orbit.setLocations(latLonArray[0], latLonArray[1]);
        } else {
            Vec4 vec45 = this.computeControlPointDelta(this.getPreviousPosition(), position);
            Position position2 = this.getWwd().getModel().getGlobe().computePositionFromEllipsoidalPoint(vec42.add3(vec45));
            latLonArray[controlPointMarker.getId()] = position2;
            orbit.setLocations(latLonArray[0], latLonArray[1]);
        }
    }

    protected void updateOrbitControlPoints() {
        Iterator<Marker> iterator;
        Orbit orbit = (Orbit)this.getShape();
        LatLon[] latLonArray = orbit.getLocations();
        double d = orbit.getWidth();
        double d2 = this.getControlPointAltitude(latLonArray[0]);
        double d3 = this.getControlPointAltitude(latLonArray[1]);
        Angle angle = LatLon.greatCircleAzimuth(latLonArray[0], latLonArray[1]);
        LatLon latLon = LatLon.interpolateGreatCircle(0.5, latLonArray[0], latLonArray[1]);
        double d4 = this.getControlPointAltitude(latLon);
        Position position = this.computeRectangularEdgeLocation(latLonArray[0], latLonArray[1], 0.5 * d);
        Globe globe = this.getWwd().getModel().getGlobe();
        Vec4 vec4 = globe.computeEllipsoidalPointFromLocation(latLon);
        Vec4 vec42 = globe.computeEllipsoidalPointFromLocation(latLonArray[1]);
        Vec4 vec43 = vec42.subtract3(vec4);
        vec43 = vec43.multiply3(1.0 + d / vec43.getLength3());
        Position position2 = globe.computePositionFromEllipsoidalPoint(vec43.add3(vec4));
        double d5 = this.getControlPointAltitude(position2);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(1);
            Position position3 = new Position(latLonArray[0], d2);
            iterator.add(this.makeControlPoint(position3, this.getLocationControlPointAttributes(), 0, LOCATION));
            position3 = new Position(latLonArray[1], d3);
            iterator.add(this.makeControlPoint(position3, this.getLocationControlPointAttributes(), 1, LOCATION));
            position3 = new Position(position, position.getAltitude());
            iterator.add(this.makeControlPoint(position3, this.getSizeControlPointAttributes(), 2, RIGHT_WIDTH));
            position3 = new Position(position2, d5);
            iterator.add(this.makeControlPoint(position3, this.getAngleControlPointAttributes(), 3, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLonArray[0], d2));
            ((Marker)iterator.next()).setPosition(new Position(latLonArray[1], d3));
            ((Marker)iterator.next()).setPosition(new Position(position, position.getAltitude()));
            ((Marker)iterator.next()).setPosition(new Position(position2, d5));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        iterator.next();
        iterator.next();
        ((ControlPointMarker)iterator.next()).size = d;
        ((ControlPointMarker)iterator.next()).rotation = this.normalizedHeading(angle, Angle.ZERO);
        this.updateOrientationLine(new Position(latLon, d4), new Position(position2, d5));
    }

    protected void reshapeRoute(Position position, ControlPointMarker controlPointMarker) {
        Route route = (Route)this.getShape();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon object : route.getLocations()) {
            arrayList.add(object);
        }
        if (controlPointMarker != null && controlPointMarker.getPurpose().equals(ROTATION)) {
            this.rotateLocations(position, arrayList);
            route.setLocations(arrayList);
        } else if (controlPointMarker != null && (controlPointMarker.getPurpose().equals(LEFT_WIDTH) || controlPointMarker.getPurpose().equals(RIGHT_WIDTH))) {
            LatLon latLon = LatLon.interpolateGreatCircle(0.5, (LatLon)arrayList.get(0), (LatLon)arrayList.get(1));
            Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(latLon);
            Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(new Position(controlPointMarker.getPosition(), 0.0));
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Vec4 vec44 = this.computeControlPointDelta(this.getPreviousPosition(), position);
            double d = route.getWidth() + vec44.dot3(vec43);
            if (d >= 0.0) {
                route.setWidth(d);
            }
        } else if (controlPointMarker != null) {
            if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x200) != 0 && this.isExtensionEnabled()) {
                if (arrayList.size() > 2) {
                    arrayList.remove(controlPointMarker.getId());
                    this.getControlPointLayer().setMarkers(null);
                }
            } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
                this.appendLocation(controlPointMarker, arrayList);
                this.getControlPointLayer().setMarkers(null);
            } else {
                this.moveLocation(controlPointMarker, position, arrayList);
            }
            route.setLocations(arrayList);
        } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
            double d = ((Airspace)this.getShape()).getAltitudes()[1];
            this.addNearestLocation(position, d, arrayList);
            route.setLocations(arrayList);
        }
    }

    protected void updateRouteControlPoints() {
        Iterator<Marker> iterator;
        Route route = (Route)this.getShape();
        if (route.getLocations() == null) {
            return;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : route.getLocations()) {
            arrayList.add(latLon);
        }
        if (arrayList.size() < 2) {
            return;
        }
        Globe globe = this.getWwd().getModel().getGlobe();
        double d = route.getWidth();
        Position position = this.computeRectangularEdgeLocation((LatLon)arrayList.get(0), (LatLon)arrayList.get(1), -0.5 * d);
        Position position2 = this.computeRectangularEdgeLocation((LatLon)arrayList.get(0), (LatLon)arrayList.get(1), 0.5 * d);
        LatLon latLon = LatLon.getCenter(globe, arrayList);
        double d2 = this.getControlPointAltitude(latLon);
        Angle angle = LatLon.greatCircleDistance(latLon, (LatLon)arrayList.get(1));
        angle = angle.add(Angle.fromRadians(route.getWidth() / globe.getEquatorialRadius()));
        Angle angle2 = this.getCurrentHeading();
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, angle2, angle);
        double d3 = this.getControlPointAltitude(latLon2);
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList();
            int n = 0;
            for (LatLon latLon3 : arrayList) {
                double d4 = this.getControlPointAltitude(latLon3);
                Position position3 = new Position(latLon3, d4);
                ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position3, this.getLocationControlPointAttributes(), n++, LOCATION));
            }
            Position position4 = new Position(position, position.getAltitude());
            ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position4, this.getSizeControlPointAttributes(), n++, RIGHT_WIDTH));
            Position position5 = new Position(position2, position2.getAltitude());
            ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position5, this.getSizeControlPointAttributes(), n++, LEFT_WIDTH));
            Position position6 = new Position(latLon2, d3);
            ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position6, this.getAngleControlPointAttributes(), n, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            for (LatLon latLon4 : arrayList) {
                double d5 = this.getControlPointAltitude(latLon4);
                ((Marker)iterator.next()).setPosition(new Position(latLon4, d5));
            }
            ((Marker)iterator.next()).setPosition(new Position(position, position.getAltitude()));
            ((Marker)iterator.next()).setPosition(new Position(position2, position2.getAltitude()));
            ((Marker)iterator.next()).setPosition(new Position(latLon2, d3));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        for (LatLon latLon5 : arrayList) {
            iterator.next();
        }
        ((ControlPointMarker)iterator.next()).size = route.getWidth();
        ((ControlPointMarker)iterator.next()).size = route.getWidth();
        ((ControlPointMarker)iterator.next()).rotation = angle2;
        this.updateOrientationLine(new Position(latLon, d2), new Position(latLon2, d3));
    }

    protected void reshapeTrack(Position position, ControlPointMarker controlPointMarker) {
        TrackAirspace trackAirspace = (TrackAirspace)this.getShape();
        List<Box> list = trackAirspace.getLegs();
        if (controlPointMarker != null && controlPointMarker.getPurpose().equals(ROTATION)) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (Box object2 : list) {
                arrayList.add(object2.getLocations()[0]);
                arrayList.add(object2.getLocations()[1]);
            }
            LatLon latLon = LatLon.getCenter(this.getWwd().getModel().getGlobe(), arrayList);
            Angle latLon2 = LatLon.greatCircleAzimuth(latLon, this.getPreviousPosition());
            Angle vec46 = LatLon.greatCircleAzimuth(latLon, position).subtract(latLon2);
            this.currentHeading = this.normalizedHeading(this.getCurrentHeading(), vec46);
            for (Box box : list) {
                LatLon[] box3 = box.getLocations();
                Angle angle = LatLon.greatCircleAzimuth(latLon, box3[0]);
                Angle angle2 = LatLon.greatCircleDistance(latLon, box3[0]);
                box3[0] = LatLon.greatCircleEndPosition(latLon, angle.add(vec46), angle2);
                angle = LatLon.greatCircleAzimuth(latLon, box3[1]);
                angle2 = LatLon.greatCircleDistance(latLon, box3[1]);
                box3[1] = LatLon.greatCircleEndPosition(latLon, angle.add(vec46), angle2);
                box.setLocations(box3[0], box3[1]);
            }
            trackAirspace.setLegs(new ArrayList<Box>(trackAirspace.getLegs()));
        } else if (controlPointMarker != null && (controlPointMarker.getPurpose().equals(LEFT_WIDTH) || controlPointMarker.getPurpose().equals(RIGHT_WIDTH))) {
            Box box = list.get(controlPointMarker.getLeg());
            LatLon[] latLonArray = box.getLocations();
            LatLon vec45 = LatLon.interpolateGreatCircle(0.5, latLonArray[0], latLonArray[1]);
            Vec4 vec47 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(vec45);
            Vec4 vec48 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(new Position(controlPointMarker.getPosition(), 0.0));
            Vec4 position3 = vec48.subtract3(vec47).normalize3();
            double[] dArray = box.getWidths();
            double[] dArray2 = new double[]{dArray[0], dArray[1]};
            Vec4 vec4 = this.computeControlPointDelta(this.getPreviousPosition(), position);
            if (controlPointMarker.getPurpose().equals(LEFT_WIDTH)) {
                dArray2[0] = dArray2[0] + vec4.dot3(position3);
            } else {
                dArray2[1] = dArray2[1] + vec4.dot3(position3);
            }
            if (dArray2[0] >= 0.0 && dArray2[1] >= 0.0) {
                box.setWidths(dArray2[0], dArray2[1]);
            }
            trackAirspace.setLegs(new ArrayList<Box>(trackAirspace.getLegs()));
        } else if (controlPointMarker != null) {
            list = new ArrayList<Box>(list);
            if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x200) != 0 && this.isExtensionEnabled()) {
                if (list.size() < 2) {
                    return;
                }
                if (controlPointMarker.getLeg() == 0 && controlPointMarker.getId() == 0) {
                    list.remove(0);
                } else if (controlPointMarker.getLeg() == list.size() - 1 && controlPointMarker.getId() == 1) {
                    list.remove(list.size() - 1);
                } else if (controlPointMarker.getLeg() == 0) {
                    list.get(0).setLocations(list.get(0).getLocations()[0], list.get(1).getLocations()[1]);
                    list.remove(1);
                } else {
                    Box box = controlPointMarker.getLeg() == 0 ? list.get(0) : list.get(controlPointMarker.getLeg() - 1);
                    Box box2 = list.get(controlPointMarker.getLeg() + 1);
                    box2.setLocations(box.getLocations()[1], box2.getLocations()[1]);
                    list.remove(controlPointMarker.getLeg());
                }
                trackAirspace.setLegs(list);
                this.determineTrackAdjacency();
                this.getControlPointLayer().setMarkers(null);
            } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
                Globe globe = this.getWwd().getModel().getGlobe();
                if (controlPointMarker.getLeg() == 0 && controlPointMarker.getId() == 0) {
                    Vec4 vec4 = globe.computeEllipsoidalPointFromLocation(list.get(0).getLocations()[0]);
                    vec4 = globe.computeEllipsoidalPointFromLocation(list.get(0).getLocations()[1]);
                    Vec4 box = vec4.add3(vec4.subtract3(vec4).multiply3(0.1));
                    Position box5 = globe.computePositionFromEllipsoidalPoint(box);
                    Box box4 = new Box(list.get(0));
                    box4.setLocations(box5, list.get(0).getLocations()[0]);
                    list.add(0, box4);
                } else if (controlPointMarker.getLeg() == list.size() - 1 && controlPointMarker.getId() == 1) {
                    Box box6 = list.get(list.size() - 1);
                    Vec4 position4 = globe.computeEllipsoidalPointFromLocation(box6.getLocations()[1]);
                    Vec4 n2 = globe.computeEllipsoidalPointFromLocation(box6.getLocations()[0]);
                    Vec4 vec4 = position4.add3(position4.subtract3(n2).multiply3(0.1));
                    Position position2 = globe.computePositionFromEllipsoidalPoint(vec4);
                    Box box = new Box(box6);
                    box.setLocations(box6.getLocations()[1], position2);
                    list.add(box);
                } else {
                    return;
                }
                trackAirspace.setLegs(list);
                this.determineTrackAdjacency();
                this.getControlPointLayer().setMarkers(null);
            } else {
                Vec4 vec4 = this.computeControlPointDelta(this.getPreviousPosition(), position);
                Vec4 vec49 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(new Position(controlPointMarker.getPosition(), 0.0));
                Position object3 = this.getWwd().getModel().getGlobe().computePositionFromEllipsoidalPoint(vec49.add3(vec4));
                Box box = trackAirspace.getLegs().get(controlPointMarker.getLeg());
                if (controlPointMarker.getId() == 0) {
                    box.setLocations(object3, box.getLocations()[1]);
                } else {
                    box.setLocations(box.getLocations()[0], object3);
                }
                trackAirspace.setLegs(new ArrayList<Box>(trackAirspace.getLegs()));
            }
        } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
            list = new ArrayList<Box>(list);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (Box box : list) {
                arrayList.add(box.getLocations()[0]);
            }
            arrayList.add(list.get(list.size() - 1).getLocations()[1]);
            int n = this.addNearestLocation(position, trackAirspace.getAltitudes()[1], arrayList);
            LatLon latLon = (LatLon)arrayList.get(n);
            int n2 = n - 1;
            Box box = list.get(n2);
            Box box2 = new Box(box);
            if (n2 > 0) {
                box2.setLocations(box.getLocations()[0], latLon);
                box.setLocations(latLon, box.getLocations()[1]);
                list.add(n2, box2);
            } else {
                box2.setLocations(latLon, box.getLocations()[1]);
                box.setLocations(box.getLocations()[0], latLon);
                list.add(1, box2);
            }
            trackAirspace.setLegs(new ArrayList<Box>(list));
            this.determineTrackAdjacency();
            this.getControlPointLayer().setMarkers(null);
        }
    }

    protected void updateTrackControlPoints() {
        Object object;
        Object object2;
        Object object4;
        int n;
        TrackAirspace trackAirspace = (TrackAirspace)this.getShape();
        List<Box> list = trackAirspace.getLegs();
        if (list == null) {
            return;
        }
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        Iterator<Marker> iterator = iterable != null ? iterable.iterator() : null;
        for (n = 0; n < list.size(); ++n) {
            double d;
            object4 = list.get(n);
            LatLon[] object32 = ((Box)object4).getLocations();
            if (iterable == null) {
                if (!this.trackAdjacencyList.contains(object4)) {
                    d = this.getControlPointAltitude(object32[0]);
                    object2 = this.makeControlPoint(new Position(object32[0], d), this.getLocationControlPointAttributes(), 0, n, LOCATION);
                    arrayList.add((Marker)object2);
                }
                d = this.getControlPointAltitude(object32[1]);
                object2 = this.makeControlPoint(new Position(object32[1], d), this.getLocationControlPointAttributes(), 1, n, LOCATION);
                arrayList.add((Marker)object2);
                continue;
            }
            if (!this.trackAdjacencyList.contains(object4)) {
                d = this.getControlPointAltitude(object32[0]);
                iterator.next().setPosition(new Position(object32[0], d));
            }
            d = this.getControlPointAltitude(object32[1]);
            iterator.next().setPosition(new Position(object32[1], d));
        }
        for (n = 0; n < list.size(); ++n) {
            object4 = list.get(n);
            LatLon[] latLonArray = ((Box)object4).getLocations();
            double[] dArray = ((Box)object4).getWidths();
            Position position = this.computeRectangularEdgeLocation(latLonArray[0], latLonArray[1], -dArray[0]);
            object2 = this.computeRectangularEdgeLocation(latLonArray[0], latLonArray[1], dArray[1]);
            if (iterable == null) {
                object = new Position(position, position.getAltitude());
                arrayList.add(this.makeControlPoint((Position)object, this.getSizeControlPointAttributes(), 2, n, LEFT_WIDTH));
                object = new Position((LatLon)object2, ((Position)object2).getAltitude());
                arrayList.add(this.makeControlPoint((Position)object, this.getSizeControlPointAttributes(), 3, n, RIGHT_WIDTH));
                continue;
            }
            iterator.next().setPosition(new Position(position, position.getAltitude()));
            iterator.next().setPosition(new Position((LatLon)object2, ((Position)object2).getAltitude()));
        }
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        for (Box box : list) {
            arrayList2.add(box.getLocations()[0]);
            arrayList2.add(box.getLocations()[1]);
        }
        object4 = this.getWwd().getModel().getGlobe();
        LatLon latLon = LatLon.getCenter((Globe)object4, arrayList2);
        double d = this.getControlPointAltitude(latLon);
        object2 = LatLon.getAverageDistance((Globe)object4, latLon, arrayList2);
        object = list.get(0).getWidths();
        object2 = ((Angle)object2).addRadians((object[0] + object[1]) / object4.getEquatorialRadius());
        Angle angle = this.getCurrentHeading();
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, angle, (Angle)object2);
        double d2 = this.getControlPointAltitude(latLon2);
        if (iterable == null) {
            Position position = new Position(latLon2, d2);
            arrayList.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 4, ROTATION));
        } else {
            iterator.next().setPosition(new Position(latLon2, d2));
        }
        if (iterable == null) {
            this.getControlPointLayer().setMarkers(arrayList);
        }
        this.updateOrientationLine(new Position(latLon, d), new Position(latLon2, d2));
        iterable = this.getControlPointLayer().getMarkers();
        for (Marker marker : iterable) {
            ControlPointMarker controlPointMarker = (ControlPointMarker)marker;
            if (controlPointMarker.getId() == 2) {
                controlPointMarker.size = list.get(controlPointMarker.getLeg()).getWidths()[0];
                continue;
            }
            if (controlPointMarker.getId() == 3) {
                controlPointMarker.size = list.get(controlPointMarker.getLeg()).getWidths()[1];
                continue;
            }
            if (controlPointMarker.getId() != 4) continue;
            controlPointMarker.rotation = angle;
        }
    }

    protected void reshapeSurfacePolygon(Position position, ControlPointMarker controlPointMarker) {
        Iterable<? extends LatLon> iterable = this.getShape() instanceof SurfacePolygon ? ((SurfacePolygon)this.getShape()).getLocations() : ((SurfacePolyline)this.getShape()).getLocations();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            arrayList.add(latLon);
        }
        if (controlPointMarker != null && controlPointMarker.getPurpose().equals(ROTATION)) {
            this.rotateLocations(position, arrayList);
        } else if (controlPointMarker != null) {
            if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x200) != 0 && this.isExtensionEnabled()) {
                int n;
                int n2 = n = this.getShape() instanceof SurfacePolygon ? 3 : 2;
                if (arrayList.size() > n) {
                    arrayList.remove(controlPointMarker.getId());
                    this.getControlPointLayer().setMarkers(null);
                }
            } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled() && this.getShape() instanceof SurfacePolyline) {
                this.appendLocation(controlPointMarker, arrayList);
                this.getControlPointLayer().setMarkers(null);
            } else {
                this.moveLocation(controlPointMarker, position, arrayList);
            }
        } else if ((this.getCurrentEvent().getMouseEvent().getModifiersEx() & 0x40) != 0 && this.isExtensionEnabled()) {
            this.addNearestLocation(position, 0.0, arrayList);
        }
        if (this.getShape() instanceof SurfacePolygon) {
            ((SurfacePolygon)this.getShape()).setLocations(arrayList);
        } else {
            ((SurfacePolyline)this.getShape()).setLocations(arrayList);
        }
    }

    protected void updateSurfacePolygonControlPoints() {
        Iterator<Marker> iterator;
        Iterable<? extends LatLon> iterable = null;
        if (this.getShape() instanceof SurfacePolygon) {
            iterable = ((SurfacePolygon)this.getShape()).getLocations();
        } else if (this.getShape() instanceof SurfacePolyline) {
            iterable = ((SurfacePolyline)this.getShape()).getLocations();
        }
        if (iterable == null) {
            return;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon2 : iterable) {
            arrayList.add(latLon2);
        }
        if (arrayList.size() < 2) {
            return;
        }
        Globe globe = this.getWwd().getModel().getGlobe();
        LatLon latLon = LatLon.getCenter(globe, arrayList);
        Angle angle = LatLon.getAverageDistance(globe, latLon, arrayList);
        angle = angle.multiply(1.2);
        Angle angle2 = this.getCurrentHeading();
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, angle2, angle);
        Iterable<Marker> iterable2 = this.getControlPointLayer().getMarkers();
        if (iterable2 == null) {
            iterator = new ArrayList();
            int n = 0;
            for (LatLon latLon3 : arrayList) {
                Position position = new Position(latLon3, 0.0);
                ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position, this.getLocationControlPointAttributes(), n++, LOCATION));
            }
            Position position = new Position(latLon2, 0.0);
            ((ArrayList)((Object)iterator)).add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), n, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable2.iterator();
            for (LatLon latLon4 : arrayList) {
                ((Marker)iterator.next()).setPosition(new Position(latLon4, 0.0));
            }
            ((Marker)iterator.next()).setPosition(new Position(latLon2, 0.0));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        for (LatLon latLon5 : arrayList) {
            iterator.next();
        }
        ((ControlPointMarker)iterator.next()).rotation = angle2;
        this.updateOrientationLine(new Position(latLon, 0.0), new Position(latLon2, 0.0));
    }

    protected void reshapeSurfaceCircle(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        SurfaceCircle surfaceCircle = (SurfaceCircle)this.getShape();
        Vec4 vec4 = this.computeControlPointDelta(this.getPreviousPosition(), position);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(surfaceCircle.getCenter());
        Vec4 vec43 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec44 = vec43.subtract3(vec42).normalize3();
        double d = surfaceCircle.getRadius() + vec4.dot3(vec44);
        if (d > 0.0) {
            surfaceCircle.setRadius(d);
        }
    }

    protected void updateSurfaceCircleControlPoints() {
        Object object;
        SurfaceCircle surfaceCircle = (SurfaceCircle)this.getShape();
        LatLon latLon = LatLon.greatCircleEndPosition(surfaceCircle.getCenter(), Angle.fromDegrees(90.0), Angle.fromRadians(surfaceCircle.getRadius() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            object = new ArrayList<ControlPointMarker>(1);
            Position position = new Position(latLon, 0.0);
            object.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, OUTER_RADIUS));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)object);
        } else {
            iterable.iterator().next().setPosition(new Position(latLon, 0.0));
        }
        object = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)object.next()).size = surfaceCircle.getRadius();
    }

    protected void reshapeSurfaceSquare(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        SurfaceSquare surfaceSquare = (SurfaceSquare)this.getShape();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(position);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(this.getPreviousPosition());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(surfaceSquare.getCenter());
        Vec4 vec45 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec46 = vec45.subtract3(vec44);
        if (controlPointMarker.getPurpose().equals(RIGHT_WIDTH)) {
            double d = surfaceSquare.getSize() + vec43.dot3(vec46.normalize3());
            if (d > 0.0) {
                surfaceSquare.setSize(d);
            }
        } else {
            Angle angle = LatLon.greatCircleAzimuth(surfaceSquare.getCenter(), this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(surfaceSquare.getCenter(), position).subtract(angle);
            surfaceSquare.setHeading(this.normalizedHeading(surfaceSquare.getHeading(), angle2));
        }
    }

    protected void updateSurfaceSquareControlPoints() {
        Iterator<Marker> iterator;
        SurfaceSquare surfaceSquare = (SurfaceSquare)this.getShape();
        LatLon latLon = LatLon.greatCircleEndPosition(surfaceSquare.getCenter(), Angle.fromDegrees(90.0 + surfaceSquare.getHeading().degrees), Angle.fromRadians(0.5 * surfaceSquare.getSize() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(surfaceSquare.getCenter(), Angle.fromDegrees(surfaceSquare.getHeading().degrees), Angle.fromRadians(0.7 * surfaceSquare.getSize() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(1);
            Position position = new Position(latLon, 0.0);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, RIGHT_WIDTH));
            position = new Position(latLon2, 0.0);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 1, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, 0.0));
            ((Marker)iterator.next()).setPosition(new Position(latLon2, 0.0));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = surfaceSquare.getSize();
        ((ControlPointMarker)iterator.next()).rotation = surfaceSquare.getHeading();
        this.updateOrientationLine(new Position(surfaceSquare.getCenter(), 0.0), new Position(latLon2, 0.0));
    }

    protected void reshapeSurfaceQuad(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        SurfaceQuad surfaceQuad = (SurfaceQuad)this.getShape();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(position);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(this.getPreviousPosition());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(surfaceQuad.getCenter());
        Vec4 vec45 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec46 = vec45.subtract3(vec44).normalize3();
        if (controlPointMarker.getPurpose().equals(WIDTH) || controlPointMarker.getPurpose().equals(HEIGHT)) {
            double d = surfaceQuad.getWidth() + (controlPointMarker.getId() == 0 ? vec43.dot3(vec46) : 0.0);
            double d2 = surfaceQuad.getHeight() + (controlPointMarker.getId() == 1 ? vec43.dot3(vec46) : 0.0);
            if (d > 0.0 && d2 > 0.0) {
                surfaceQuad.setSize(d, d2);
            }
        } else {
            Angle angle = LatLon.greatCircleAzimuth(surfaceQuad.getCenter(), this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(surfaceQuad.getCenter(), position).subtract(angle);
            surfaceQuad.setHeading(this.normalizedHeading(surfaceQuad.getHeading(), angle2));
        }
    }

    protected void updateSurfaceQuadControlPoints() {
        Iterator<Marker> iterator;
        SurfaceQuad surfaceQuad = (SurfaceQuad)this.getShape();
        LatLon latLon = LatLon.greatCircleEndPosition(surfaceQuad.getCenter(), Angle.fromDegrees(90.0 + surfaceQuad.getHeading().degrees), Angle.fromRadians(0.5 * surfaceQuad.getWidth() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(surfaceQuad.getCenter(), Angle.fromDegrees(surfaceQuad.getHeading().degrees), Angle.fromRadians(0.5 * surfaceQuad.getHeight() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon3 = LatLon.greatCircleEndPosition(surfaceQuad.getCenter(), Angle.fromDegrees(surfaceQuad.getHeading().degrees), Angle.fromRadians(0.7 * surfaceQuad.getHeight() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(2);
            Position position = new Position(latLon, 0.0);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, WIDTH));
            position = new Position(latLon2, 0.0);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 1, HEIGHT));
            position = new Position(latLon3, 0.0);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 2, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, 0.0));
            ((Marker)iterator.next()).setPosition(new Position(latLon2, 0.0));
            ((Marker)iterator.next()).setPosition(new Position(latLon3, 0.0));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = surfaceQuad.getWidth();
        ((ControlPointMarker)iterator.next()).size = surfaceQuad.getHeight();
        ((ControlPointMarker)iterator.next()).rotation = surfaceQuad.getHeading();
        this.updateOrientationLine(new Position(surfaceQuad.getCenter(), 0.0), new Position(latLon3, 0.0));
    }

    protected void reshapeSurfaceEllipse(Position position, ControlPointMarker controlPointMarker) {
        if (controlPointMarker == null) {
            return;
        }
        SurfaceEllipse surfaceEllipse = (SurfaceEllipse)this.getShape();
        Vec4 vec4 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(position);
        Vec4 vec42 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(this.getPreviousPosition());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(surfaceEllipse.getCenter());
        Vec4 vec45 = this.getWwd().getModel().getGlobe().computeEllipsoidalPointFromLocation(controlPointMarker.getPosition());
        Vec4 vec46 = vec45.subtract3(vec44).normalize3();
        if (controlPointMarker.getPurpose().equals(WIDTH) || controlPointMarker.getPurpose().equals(HEIGHT)) {
            double d = surfaceEllipse.getMajorRadius() + (controlPointMarker.getId() == 0 ? vec43.dot3(vec46) : 0.0);
            double d2 = surfaceEllipse.getMinorRadius() + (controlPointMarker.getId() == 1 ? vec43.dot3(vec46) : 0.0);
            if (d > 0.0 && d2 > 0.0) {
                surfaceEllipse.setRadii(d, d2);
            }
        } else {
            Angle angle = LatLon.greatCircleAzimuth(surfaceEllipse.getCenter(), this.getPreviousPosition());
            Angle angle2 = LatLon.greatCircleAzimuth(surfaceEllipse.getCenter(), position).subtract(angle);
            surfaceEllipse.setHeading(this.normalizedHeading(surfaceEllipse.getHeading(), angle2));
        }
        this.updateAnnotation(controlPointMarker);
    }

    protected void updateSurfaceEllipseControlPoints() {
        Iterator<Marker> iterator;
        SurfaceEllipse surfaceEllipse = (SurfaceEllipse)this.getShape();
        LatLon latLon = LatLon.greatCircleEndPosition(surfaceEllipse.getCenter(), Angle.fromDegrees(90.0 + surfaceEllipse.getHeading().degrees), Angle.fromRadians(surfaceEllipse.getMajorRadius() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon2 = LatLon.greatCircleEndPosition(surfaceEllipse.getCenter(), Angle.fromDegrees(surfaceEllipse.getHeading().degrees), Angle.fromRadians(surfaceEllipse.getMinorRadius() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        LatLon latLon3 = LatLon.greatCircleEndPosition(surfaceEllipse.getCenter(), Angle.fromDegrees(surfaceEllipse.getHeading().degrees), Angle.fromRadians(1.15 * surfaceEllipse.getMinorRadius() / this.getWwd().getModel().getGlobe().getEquatorialRadius()));
        Iterable<Marker> iterable = this.getControlPointLayer().getMarkers();
        if (iterable == null) {
            iterator = new ArrayList(2);
            Position position = new Position(latLon, 0.0);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 0, WIDTH));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
            position = new Position(latLon2, 0.0);
            iterator.add(this.makeControlPoint(position, this.getSizeControlPointAttributes(), 1, HEIGHT));
            position = new Position(latLon3, 0.0);
            iterator.add(this.makeControlPoint(position, this.getAngleControlPointAttributes(), 2, ROTATION));
            this.getControlPointLayer().setMarkers((Iterable<Marker>)((Object)iterator));
        } else {
            iterator = iterable.iterator();
            iterator.next().setPosition(new Position(latLon, 0.0));
            ((Marker)iterator.next()).setPosition(new Position(latLon2, 0.0));
            ((Marker)iterator.next()).setPosition(new Position(latLon3, 0.0));
        }
        iterator = this.getControlPointLayer().getMarkers().iterator();
        ((ControlPointMarker)iterator.next()).size = surfaceEllipse.getMajorRadius();
        ((ControlPointMarker)iterator.next()).size = surfaceEllipse.getMinorRadius();
        ((ControlPointMarker)iterator.next()).rotation = surfaceEllipse.getHeading();
        this.updateOrientationLine(new Position(surfaceEllipse.getCenter(), 0.0), new Position(latLon3, 0.0));
    }

    protected static class ControlPointMarker
    extends BasicMarker {
        protected int id;
        protected int leg;
        protected String purpose;
        protected Double size;
        protected Angle rotation;

        public ControlPointMarker(Position position, MarkerAttributes markerAttributes, int n, String string) {
            super(position, markerAttributes);
            this.id = n;
            this.purpose = string;
        }

        public ControlPointMarker(Position position, MarkerAttributes markerAttributes, int n, int n2, String string) {
            this(position, markerAttributes, n, string);
            this.leg = n2;
        }

        public int getId() {
            return this.id;
        }

        public int getLeg() {
            return this.leg;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public void setSize(double d) {
            this.size = d;
        }

        public Double getSize() {
            return this.size;
        }

        public void setRotation(Angle angle) {
            this.rotation = angle;
        }

        public Angle getRotation() {
            return this.rotation;
        }
    }
}

