/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class WWBufferUtil {
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_CHAR = 2;

    public static ByteBuffer newByteBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(n) : ByteBuffer.allocate(n);
    }

    public static ShortBuffer newShortBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(2 * n).asShortBuffer() : ShortBuffer.allocate(n);
    }

    public static IntBuffer newIntBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(4 * n).asIntBuffer() : IntBuffer.allocate(n);
    }

    public static FloatBuffer newFloatBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(4 * n).asFloatBuffer() : FloatBuffer.allocate(n);
    }

    public static DoubleBuffer newDoubleBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(8 * n).asDoubleBuffer() : DoubleBuffer.allocate(n);
    }

    public static CharBuffer newCharBuffer(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return bl ? WWBufferUtil.newDirectByteBuffer(2 * n).asCharBuffer() : CharBuffer.allocate(n);
    }

    public static BufferWrapper newByteBufferWrapper(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ByteBuffer byteBuffer = WWBufferUtil.newByteBuffer(n, bl);
        return new BufferWrapper.ByteBufferWrapper(byteBuffer);
    }

    public static BufferWrapper newShortBufferWrapper(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ShortBuffer shortBuffer = WWBufferUtil.newShortBuffer(n, bl);
        return new BufferWrapper.ShortBufferWrapper(shortBuffer);
    }

    public static BufferWrapper newIntBufferWrapper(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer = WWBufferUtil.newIntBuffer(n, bl);
        return new BufferWrapper.IntBufferWrapper(intBuffer);
    }

    public static BufferWrapper newFloatBufferWrapper(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FloatBuffer floatBuffer = WWBufferUtil.newFloatBuffer(n, bl);
        return new BufferWrapper.FloatBufferWrapper(floatBuffer);
    }

    public static BufferWrapper newDoubleBufferWrapper(int n, boolean bl) {
        if (n < 0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DoubleBuffer doubleBuffer = WWBufferUtil.newDoubleBuffer(n, bl);
        return new BufferWrapper.DoubleBufferWrapper(doubleBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer copyOf(ByteBuffer byteBuffer, int n) {
        if (n < 0 || n < byteBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ByteBuffer byteBuffer2 = WWBufferUtil.newByteBuffer(n, byteBuffer.isDirect());
        int n2 = byteBuffer.position();
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.rewind();
        }
        finally {
            byteBuffer.position(n2);
        }
        return byteBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuffer copyOf(CharBuffer charBuffer, int n) {
        if (n < 0 || n < charBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CharBuffer charBuffer2 = WWBufferUtil.newCharBuffer(n, charBuffer.isDirect());
        int n2 = charBuffer.position();
        try {
            charBuffer2.put(charBuffer);
            charBuffer2.rewind();
        }
        finally {
            charBuffer.position(n2);
        }
        return charBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer copyOf(ShortBuffer shortBuffer, int n) {
        if (n < 0 || n < shortBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ShortBuffer shortBuffer2 = WWBufferUtil.newShortBuffer(n, shortBuffer.isDirect());
        int n2 = shortBuffer.position();
        try {
            shortBuffer2.put(shortBuffer);
            shortBuffer2.rewind();
        }
        finally {
            shortBuffer.position(n2);
        }
        return shortBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer copyOf(IntBuffer intBuffer, int n) {
        if (n < 0 || n < intBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer2 = WWBufferUtil.newIntBuffer(n, intBuffer.isDirect());
        int n2 = intBuffer.position();
        try {
            intBuffer2.put(intBuffer);
            intBuffer2.rewind();
        }
        finally {
            intBuffer.position(n2);
        }
        return intBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer copyOf(FloatBuffer floatBuffer, int n) {
        if (n < 0 || n < floatBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FloatBuffer floatBuffer2 = WWBufferUtil.newFloatBuffer(n, floatBuffer.isDirect());
        int n2 = floatBuffer.position();
        try {
            floatBuffer2.put(floatBuffer);
            floatBuffer2.rewind();
        }
        finally {
            floatBuffer.position(n2);
        }
        return floatBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoubleBuffer copyOf(DoubleBuffer doubleBuffer, int n) {
        if (n < 0 || n < doubleBuffer.remaining()) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DoubleBuffer doubleBuffer2 = WWBufferUtil.newDoubleBuffer(n, doubleBuffer.isDirect());
        int n2 = doubleBuffer.position();
        try {
            doubleBuffer2.put(doubleBuffer);
            doubleBuffer2.rewind();
        }
        finally {
            doubleBuffer.position(n2);
        }
        return doubleBuffer2;
    }

    public static int sizeOfPrimitiveType(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if ("gov.nasa.worldwind.avkey.Int8".equals(object)) {
            return 1;
        }
        if ("gov.nasa.worldwind.avkey.Int16".equals(object)) {
            return 2;
        }
        if ("gov.nasa.worldwind.avkey.Int32".equals(object)) {
            return 4;
        }
        if ("gov.nasa.worldwind.avkey.Float32".equals(object)) {
            return 4;
        }
        if ("gov.nasa.worldwind.avkey.Float64".equals(object)) {
            return 8;
        }
        return -1;
    }

    public static double[] computeExtremeValues(BufferWrapper bufferWrapper, double d) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        for (int i = 0; i < bufferWrapper.length(); ++i) {
            double d4 = bufferWrapper.getDouble(i);
            if (Double.compare(d4, d) == 0) continue;
            if (d2 > d4) {
                d2 = d4;
            }
            if (!(d3 < d4)) continue;
            d3 = d4;
        }
        if (Double.compare(d2, Double.MAX_VALUE) == 0 || Double.compare(d3, -1.7976931348623157E308) == 0) {
            return null;
        }
        return new double[]{d2, d3};
    }

    public static double[] computeExtremeValues(BufferWrapper bufferWrapper) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWBufferUtil.computeExtremeValues(bufferWrapper, Double.NaN);
    }

    protected static ByteBuffer newDirectByteBuffer(int n) {
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    public static FloatBuffer copyArrayToBuffer(Vec4[] vec4Array, FloatBuffer floatBuffer) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Vec4 vec4 : vec4Array) {
            floatBuffer.put((float)vec4.x).put((float)vec4.y).put((float)vec4.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }
}

