/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.dashboard;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.util.StatisticsPanel;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class DashboardDialog
extends JDialog {
    private WorldWindow wwd;
    private boolean runContinuously = false;

    public DashboardDialog(Frame frame, WorldWindow worldWindow) throws HeadlessException {
        super(frame, "WWJ Dashboard");
        this.wwd = worldWindow;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createControls(), "Center");
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        worldWindow.addRenderingListener(new RenderingListener(){

            @Override
            public void stageChanged(RenderingEvent renderingEvent) {
                if (DashboardDialog.this.runContinuously && renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap") && renderingEvent.getSource() instanceof WorldWindow) {
                    ((WorldWindow)renderingEvent.getSource()).redraw();
                }
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.wwd = null;
    }

    public void raiseDialog() {
        this.makeCurrent();
        WWUtil.alignComponent(this.getParent(), this, "gov.nasa.worldwind.avkey.Right");
        this.setVisible(true);
    }

    public void lowerDialog() {
        this.setVisible(false);
    }

    private void makeCurrent() {
    }

    private JTabbedPane createControls() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout(10, 20));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.makeControlPanel(), "Center");
        jPanel.add((Component)this.makeOkayCancelPanel(), "South");
        jTabbedPane.add("Controls", jPanel);
        jTabbedPane.add("Performance", new StatisticsPanel(this.wwd, new Dimension(250, 500)));
        return jTabbedPane;
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.makeTerrainControlPanel());
        return jPanel;
    }

    private JPanel makeTerrainControlPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.setBorder(new CompoundBorder(new TitledBorder("Terrain"), new EmptyBorder(10, 10, 10, 10)));
        final JRadioButton jRadioButton = new JRadioButton("Show Triangles w/o Skirts");
        jPanel.add(jRadioButton);
        final JRadioButton jRadioButton2 = new JRadioButton("Make Triangles w/ Skirts");
        jPanel.add(jRadioButton2);
        JCheckBox jCheckBox = new JCheckBox("Show Tile Boundaries");
        jPanel.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox("Show Tile Extents");
        jPanel.add(jCheckBox2);
        final JCheckBox jCheckBox3 = new JCheckBox("Run Continuously");
        jPanel.add(jCheckBox3);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jRadioButton.isSelected();
                boolean bl2 = jRadioButton2.isSelected();
                if (bl && actionEvent.getSource() == jRadioButton) {
                    DashboardDialog.this.wwd.getModel().setShowWireframeInterior(true);
                    DashboardDialog.this.wwd.getModel().getGlobe().getTessellator().setMakeTileSkirts(false);
                    jRadioButton2.setSelected(false);
                } else if (bl2 && actionEvent.getSource() == jRadioButton2) {
                    DashboardDialog.this.wwd.getModel().setShowWireframeInterior(true);
                    DashboardDialog.this.wwd.getModel().getGlobe().getTessellator().setMakeTileSkirts(true);
                    jRadioButton.setSelected(false);
                } else {
                    DashboardDialog.this.wwd.getModel().setShowWireframeInterior(false);
                    DashboardDialog.this.wwd.getModel().getGlobe().getTessellator().setMakeTileSkirts(true);
                }
                DashboardDialog.this.wwd.redraw();
            }
        };
        jRadioButton.addActionListener(actionListener);
        jRadioButton2.addActionListener(actionListener);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashboardDialog.this.wwd.getModel().setShowWireframeExterior(!DashboardDialog.this.wwd.getModel().isShowWireframeExterior());
                DashboardDialog.this.wwd.redraw();
            }
        });
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashboardDialog.this.wwd.getModel().setShowTessellationBoundingVolumes(!DashboardDialog.this.wwd.getModel().isShowTessellationBoundingVolumes());
                DashboardDialog.this.wwd.redraw();
            }
        });
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashboardDialog.this.runContinuously = jCheckBox3.isSelected();
                DashboardDialog.this.wwd.redraw();
            }
        });
        return jPanel;
    }

    private JPanel makeOkayCancelPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        jPanel.add(new JLabel(""));
        jPanel.add(new JButton(new OkayAction()));
        return jPanel;
    }

    private class OkayAction
    extends AbstractAction {
        public OkayAction() {
            super("Okay");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DashboardDialog.this.lowerDialog();
        }
    }
}

