/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.gdal;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.GDAL;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.tiff.GeotiffReader;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ElevationsUtil;
import gov.nasa.worldwind.util.FileTree;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NativeLibraryLoader;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.gdal.GDALDataFinder;
import gov.nasa.worldwind.util.gdal.GDALLibraryFinder;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;
import org.gdal.ogr.ogr;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class GDALUtils {
    public static long ALPHA_MASK = 0xFFFFFFFFL;
    protected static byte ALPHA_TRANSPARENT = 0;
    protected static byte ALPHA_OPAQUE = (byte)-1;
    protected static final String JAVA_LIBRARY_PATH = "java.library.path";
    protected static final String GDAL_DRIVER_PATH = "GDAL_DRIVER_PATH";
    protected static final String OGR_DRIVER_PATH = "OGR_DRIVER_PATH";
    protected static final String GDAL_DATA_PATH = "GDAL_DATA";
    protected static final AtomicBoolean gdalIsAvailable = new AtomicBoolean(false);
    protected static final String gdalalljni = Configuration.isMacOS() ? "gdalalljni" : (GDALUtils.is32bitArchitecture() ? "gdalalljni32" : "gdalalljni64");
    protected static final CopyOnWriteArraySet<String> loadedLibraries = new CopyOnWriteArraySet();
    protected static final CopyOnWriteArraySet<String> failedLibraries = new CopyOnWriteArraySet();
    private static Class newClassLoader;
    private static Object originalClassLoader;
    private static Field fieldSysPaths;
    private static boolean fieldSysPaths_accessible;

    protected static boolean is32bitArchitecture() {
        String string = System.getProperty("sun.arch.data.model");
        if (!WWUtil.isEmpty(string)) {
            return "32".equals(string);
        }
        return "x86".equals(System.getProperty("os.arch"));
    }

    protected static boolean gdalPreLoadNativeLibrary(boolean bl) {
        try {
            NativeLibraryLoader.loadLibrary(gdalalljni);
            loadedLibraries.add(gdalalljni);
            Logging.logger().info(Logging.getMessage("generic.LibraryLoadedOK", gdalalljni));
            return true;
        }
        catch (Throwable throwable) {
            if (bl) {
                Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
            }
            return false;
        }
    }

    protected static boolean checkGdalJNIsAvailable() {
        try {
            Class<?> clazz = Class.forName("org.gdal.gdal.gdalJNI");
            Method method = clazz.getDeclaredMethod("isAvailable", new Class[0]);
            method.setAccessible(true);
            if (((Boolean)method.invoke(null, new Object[0])).booleanValue()) {
                clazz = Class.forName("org.gdal.gdalconst.gdalconstJNI");
                method = clazz.getDeclaredMethod("isAvailable", new Class[0]);
                method.setAccessible(true);
                return (Boolean)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static void initialize() {
        try {
            Object object;
            String string;
            boolean bl = null != System.getProperty("javawebstart.version", null);
            boolean bl2 = GDALUtils.gdalPreLoadNativeLibrary(false);
            if (!bl2 && !bl && (string = GDALUtils.buildPathString(object = GDALUtils.findGdalFolders(), true)) != null) {
                GDALUtils.alterJavaLibraryPath(string);
            }
            if (GDALUtils.checkGdalJNIsAvailable()) {
                if (!bl && null != (object = GDALUtils.findGdalDataFolder())) {
                    string = Logging.getMessage("gdal.SharedDataFolderFound", (String)object);
                    Logging.logger().finest(string);
                    gdal.SetConfigOption(GDAL_DATA_PATH, (String)object);
                }
                gdal.AllRegister();
                ogr.RegisterAll();
                object = Logging.getMessage("generic.LibraryLoadedOK", "GDAL v" + gdal.VersionInfo("RELEASE_NAME"));
                Logging.logger().info((String)object);
                GDALUtils.listAllRegisteredDrivers();
                gdalIsAvailable.set(true);
            } else {
                object = Logging.getMessage("generic.LibraryNotFound", "GDAL");
                string = Logging.getMessage("generic.LibraryNotLoaded", "GDAL", object);
                Logging.logger().warning(string);
            }
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.FINEST, throwable.getMessage(), throwable);
        }
    }

    protected static String getCurrentDirectory() {
        String string = System.getProperty("user.dir");
        if (null == string || string.length() == 0) {
            String string2 = Logging.getMessage("generic.UsersHomeDirectoryNotKnown");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        return string;
    }

    protected static String[] findGdalFolders() {
        try {
            String string = GDALUtils.getCurrentDirectory();
            FileTree fileTree = new FileTree(new File(string));
            fileTree.setMode(3);
            GDALLibraryFinder gDALLibraryFinder = new GDALLibraryFinder();
            fileTree.asList(gDALLibraryFinder);
            return gDALLibraryFinder.getFolders();
        }
        catch (Throwable throwable) {
            Logging.logger().severe(throwable.getMessage());
            return null;
        }
    }

    protected static String findGdalDataFolder() {
        String string;
        try {
            string = GDALUtils.getCurrentDirectory();
            FileTree fileTree = new FileTree(new File(string));
            fileTree.setMode(3);
            GDALDataFinder gDALDataFinder = new GDALDataFinder();
            fileTree.asList(gDALDataFinder);
            String[] stringArray = gDALDataFinder.getFolders();
            if (null != stringArray && stringArray.length > 0) {
                if (stringArray.length > 1) {
                    String string2 = Logging.getMessage("gdal.MultipleDataFoldersFound", GDALUtils.buildPathString(stringArray, false));
                    Logging.logger().warning(string2);
                }
                return stringArray[0];
            }
        }
        catch (Throwable throwable) {
            Logging.logger().severe(throwable.getMessage());
        }
        string = Logging.getMessage("gdal.SharedDataFolderNotFound");
        Logging.logger().severe(string);
        return null;
    }

    protected static String buildPathString(String[] stringArray, boolean bl) {
        String string = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lib-external/gdal").append(string);
        if (null != stringArray && stringArray.length > 0) {
            for (String string2 : stringArray) {
                stringBuffer.append(string2).append(string);
            }
        }
        if (bl) {
            stringBuffer.append(".").append(string);
            stringBuffer.append(System.getProperty("user.dir")).append(string);
            stringBuffer.append(System.getProperty(JAVA_LIBRARY_PATH));
        }
        return stringBuffer.toString();
    }

    protected static void listAllRegisteredDrivers() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < gdal.GetDriverCount(); ++i) {
            Driver driver = gdal.GetDriver(i);
            String string = Logging.getMessage("gdal.DriverDetails", driver.getShortName(), driver.getLongName(), driver.GetDescription());
            stringBuffer.append(string).append("\n");
        }
        Logging.logger().finest(stringBuffer.toString());
    }

    public static String getErrorMessage() {
        try {
            int n;
            if (gdalIsAvailable.get() && (n = gdal.GetLastErrorNo()) != gdalconst.CE_None) {
                return Logging.getMessage("gdal.InternalError", n, gdal.GetLastErrorMsg());
            }
        }
        catch (Throwable throwable) {
            return throwable.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset open(Object object, boolean bl) throws FileNotFoundException, IllegalArgumentException, SecurityException, WWRuntimeException {
        if (!gdalIsAvailable.get()) {
            if (bl) {
                return null;
            }
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        File file = WWIO.getFileForLocalAddress(object);
        if (null == file) {
            if (bl) {
                return null;
            }
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object.getClass().getName());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            if (bl) {
                return null;
            }
            String string = Logging.getMessage("generic.FileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        if (!file.canRead()) {
            if (bl) {
                return null;
            }
            String string = Logging.getMessage("generic.FileNoReadPermission", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new SecurityException(string);
        }
        Dataset dataset = null;
        try {
            gdal.PushErrorHandler("CPLQuietErrorHandler");
            dataset = gdal.Open(file.getAbsolutePath(), gdalconst.GA_ReadOnly);
        }
        finally {
            gdal.PopErrorHandler();
        }
        if (dataset == null) {
            if (bl) {
                return null;
            }
            String string = Logging.getMessage("generic.CannotOpenFile", GDALUtils.getErrorMessage());
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        return dataset;
    }

    public static Dataset open(Object object) throws FileNotFoundException, IllegalArgumentException, SecurityException, WWRuntimeException {
        return GDALUtils.open(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canOpen(Object object) {
        File file;
        if (!gdalIsAvailable.get()) {
            return false;
        }
        File file2 = file = null != object ? WWIO.getFileForLocalAddress(object) : null;
        if (null == file) {
            return false;
        }
        Dataset dataset = null;
        boolean bl = false;
        try {
            gdal.PushErrorHandler("CPLQuietErrorHandler");
            if (file.exists() && file.canRead()) {
                dataset = gdal.Open(file.getAbsolutePath(), gdalconst.GA_ReadOnly);
                bl = dataset != null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (null != dataset) {
                dataset.delete();
            }
            gdal.PopErrorHandler();
        }
        return bl;
    }

    protected static DataRaster composeImageDataRaster(Dataset dataset, AVList aVList) throws IllegalArgumentException, SecurityException, WWRuntimeException {
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4;
        Object object3;
        int n5;
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = null;
        int n6 = dataset.getRasterXSize();
        int n7 = dataset.getRasterYSize();
        int n8 = dataset.getRasterCount();
        if (n8 < 1) {
            String string = Logging.getMessage("generic.UnexpectedBandCount", n8);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double[] doubleArray = new Double[16];
        ByteBuffer[] byteBufferArray = new ByteBuffer[n8];
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = n6 * n7;
        int n10 = 0;
        int n11 = 0;
        double d = -1.7976931348623157E308;
        for (n5 = 0; n5 < n8; ++n5) {
            Band band = dataset.GetRasterBand(n5 + 1);
            if (null == band) {
                object3 = Logging.getMessage("nullValue.RasterBandIsNull`");
                Logging.logger().severe((String)object3);
                throw new WWRuntimeException((String)object3);
            }
            n10 = band.getDataType();
            n11 = n9 * (gdal.GetDataTypeSize(n10) / 8);
            object3 = ByteBuffer.allocateDirect(n11);
            ((ByteBuffer)object3).order(ByteOrder.nativeOrder());
            n4 = band.GetRasterColorInterpretation();
            if (aVList.hasKey("gov.nasa.worldwind.avkey.RasterBand.MaxPixelValue")) {
                d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.RasterBand.MaxPixelValue");
            } else if ((n10 == gdalconstConstants.GDT_UInt16 || n10 == gdalconstConstants.GDT_UInt32) && n4 != gdalconst.GCI_AlphaBand && n4 != gdalconst.GCI_Undefined) {
                band.GetMaximum(doubleArray);
                if (doubleArray[0] == null) {
                    double[] dArray = new double[2];
                    band.ComputeRasterMinMax(dArray);
                    d = dArray[1] > d ? dArray[1] : d;
                } else {
                    d = doubleArray[0] > d ? doubleArray[0] : d;
                }
            }
            n3 = band.ReadRaster_Direct(0, 0, band.getXSize(), band.getYSize(), n6, n7, n10, (ByteBuffer)object3);
            if (n3 != gdalconstConstants.CE_None) {
                throw new WWRuntimeException(GDALUtils.getErrorMessage());
            }
            n2 = n5;
            if (n4 == gdalconst.GCI_RedBand) {
                n2 = 0;
            } else if (n4 == gdalconst.GCI_GreenBand) {
                n2 = 1;
            } else if (n4 == gdalconst.GCI_BlueBand) {
                n2 = 2;
            }
            byteBufferArray[n2] = object3;
            nArray[n2] = n2;
            nArray2[n2] = 0;
        }
        int n12 = n5 = gdal.GetDataTypeSize(n10);
        n12 = aVList.hasKey("gov.nasa.worldwind.avkey.RasterBand.ActualBitsPerPixel") ? (Integer)aVList.getValue("gov.nasa.worldwind.avkey.RasterBand.ActualBitsPerPixel") : (d > 0.0 ? (int)Math.ceil(Math.log(d) / Math.log(2.0)) : n5);
        object3 = nArray;
        try {
            object3 = GDALUtils.extractBandOrder(dataset, aVList);
            if (null == object3 || 0 == ((Object)object3).length) {
                object3 = nArray;
            } else {
                nArray2 = new int[((Object)object3).length];
                nArray = new int[((Object)object3).length];
                for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                    nArray[n4] = n4;
                    nArray2[n4] = 0;
                }
            }
        }
        catch (Exception exception) {
            object3 = nArray;
            Logging.logger().severe(exception.getMessage());
        }
        DataBuffer dataBuffer = null;
        n3 = 0;
        n2 = ((Object)object3).length;
        boolean bl = n2 == 2 || n2 == 4;
        IntBuffer intBuffer = null;
        if (bl && aVList.hasKey("gov.nasa.worldwind.avkey.GDAL.MaskDataset")) {
            intBuffer = GDALUtils.extractImageMask(aVList);
        }
        if (n10 == gdalconstConstants.GDT_Byte) {
            object2 = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                object = object3[n];
                object2[n] = new byte[n9];
                byteBufferArray[object].get(object2[n]);
            }
            if (bl && null != intBuffer) {
                GDALUtils.applyImageMask(object2[n2 - 1], intBuffer);
            }
            dataBuffer = new DataBufferByte((byte[][])object2, n9);
            n3 = 0;
        } else if (n10 == gdalconstConstants.GDT_Int16) {
            object2 = new short[n2][];
            for (n = 0; n < n2; ++n) {
                object = object3[n];
                object2[n] = (byte[])new short[n9];
                byteBufferArray[object].asShortBuffer().get(object2[n]);
            }
            if (bl && null != intBuffer) {
                GDALUtils.applyImageMask((short[])object2[n2 - 1], intBuffer);
            }
            dataBuffer = new DataBufferShort((short[][])object2, n9);
            n3 = 2;
        } else if (n10 == gdalconstConstants.GDT_Int32 || n10 == gdalconstConstants.GDT_UInt32) {
            object2 = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object = object3[n];
                object2[n] = (byte[])new int[n9];
                byteBufferArray[object].asIntBuffer().get(object2[n]);
            }
            if (bl && null != intBuffer) {
                GDALUtils.applyImageMask((int[])object2[n2 - 1], intBuffer);
            }
            dataBuffer = new DataBufferInt((int[][])object2, n9);
            n3 = 3;
        } else if (n10 == gdalconstConstants.GDT_UInt16) {
            object2 = new short[n2][];
            for (n = 0; n < n2; ++n) {
                object = object3[n];
                object2[n] = (byte[])new short[n9];
                byteBufferArray[object].asShortBuffer().get(object2[n]);
            }
            if (bl && null != intBuffer) {
                GDALUtils.applyImageMask((short[])object2[n2 - 1], intBuffer);
            }
            dataBuffer = new DataBufferUShort((short[][])object2, n9);
            n3 = 1;
        } else {
            object2 = Logging.getMessage("generic.UnrecognizedDataType", n10);
            Logging.logger().severe((String)object2);
        }
        object2 = new BandedSampleModel(n3, n6, n7, n6, nArray, nArray2);
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object2, dataBuffer, null);
        Band band = dataset.GetRasterBand(1);
        if (band.GetRasterColorInterpretation() == gdalconstConstants.GCI_PaletteIndex) {
            IndexColorModel indexColorModel = band.GetRasterColorTable().getIndexColorModel(gdal.GetDataTypeSize(n10));
            bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        } else if (band.GetRasterColorInterpretation() == gdalconstConstants.GCI_GrayIndex && n2 == 2) {
            int n13 = 2;
            int n14 = 1003;
            ColorSpace colorSpace = ColorSpace.getInstance(n14);
            int[] nArray3 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray3[i] = n12;
            }
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray3, bl, false, n13, n3);
            BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, false, null);
            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 6);
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            WritableRaster writableRaster3 = bufferedImage.getRaster();
            int[] nArray4 = null;
            int[] nArray5 = null;
            int n15 = writableRaster2.getWidth();
            for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
                nArray4 = writableRaster2.getSamples(0, i, n15, 1, 0, nArray4);
                nArray5 = writableRaster2.getSamples(0, i, n15, 1, 1, nArray5);
                writableRaster3.setSamples(0, i, n15, 1, 0, nArray4);
                writableRaster3.setSamples(0, i, n15, 1, 1, nArray4);
                writableRaster3.setSamples(0, i, n15, 1, 2, nArray4);
                writableRaster3.setSamples(0, i, n15, 1, 3, nArray5);
            }
        } else {
            int n16 = bl ? 3 : 1;
            int n17 = n2 > 2 ? 1000 : 1003;
            ColorSpace colorSpace = ColorSpace.getInstance(n17);
            int[] nArray6 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray6[i] = n12;
            }
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray6, bl, false, n16, n3);
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        if (null != bufferedImage && AVListImpl.getBooleanValue(aVList, "gov.nasa.worldwind.avkey.DetectBlackGaps", false).booleanValue()) {
            bufferedImage = GDALUtils.detectVoidsAndMakeThemTransparent(bufferedImage);
        }
        return BufferedImageRaster.wrap(bufferedImage, aVList);
    }

    protected static BufferedImage detectVoidsAndMakeThemTransparent(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n <= 3 || n2 <= 3) {
            return bufferedImage;
        }
        try {
            bufferedImage2 = GDALUtils.verticalFlip(bufferedImage);
            GDALUtils.scanFill(bufferedImage2);
            bufferedImage2 = GDALUtils.verticalFlip(bufferedImage2);
            GDALUtils.scanFill(bufferedImage2);
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, throwable.getMessage(), throwable);
            bufferedImage2 = bufferedImage;
        }
        return bufferedImage2;
    }

    protected static void scanFill(BufferedImage bufferedImage) {
        int n;
        int n2;
        if (null == bufferedImage || bufferedImage.getWidth() <= 3 || bufferedImage.getHeight() <= 3) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        arrayList.add(-16777216);
        arrayList.add(-1);
        arrayList.add(0xFFFFFF);
        int n3 = 0;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int[] nArray = new int[n4 + 2];
        int[] nArray2 = new int[n4 + 2];
        bufferedImage.getRGB(0, 0, n4, 1, nArray2, 1, n4);
        int n6 = 0xFFFFFF & nArray2[1];
        if (n6 == 0x808080) {
            arrayList.add(0xFF000000 | n6);
            arrayList.add(0xFFFFFF & n6);
        }
        if ((n2 = 0xFFFFFF & nArray2[n4]) == 0x808080) {
            arrayList.add(0xFF000000 | n2);
            arrayList.add(0xFFFFFF & n2);
        }
        int n7 = arrayList.size();
        int[] nArray3 = new int[n7];
        for (n = 0; n < n7; ++n) {
            nArray3[n] = (Integer)arrayList.get(n);
        }
        int n8 = n3;
        nArray2[n4 + 1] = n8;
        nArray2[0] = n8;
        Arrays.fill(nArray, n3);
        for (int i = 0; i < n5; ++i) {
            int[] nArray4 = (int[])nArray.clone();
            nArray = (int[])nArray2.clone();
            if (i + 1 < n5) {
                bufferedImage.getRGB(0, i + 1, n4, 1, nArray2, 1, n4);
                int n9 = n3;
                nArray2[n4 + 1] = n9;
                nArray2[0] = n9;
            } else {
                Arrays.fill(nArray2, n3);
            }
            block2: for (int j = 1; j <= n4; ++j) {
                n = nArray[j];
                for (int k = 0; k < n7; ++k) {
                    if (n != nArray3[k] || nArray4[j - 1] != n3 && nArray4[j] != n3 && nArray4[j + 1] != n3 && nArray[j - 1] != n3 && nArray[j + 1] != n3 && nArray2[j - 1] != n3 && nArray2[j] != n3 && nArray2[j + 1] != n3) continue;
                    nArray[j] = n3;
                    continue block2;
                }
            }
            bufferedImage.setRGB(0, i, n4, 1, nArray, 1, n4);
        }
    }

    protected static BufferedImage verticalFlip(BufferedImage bufferedImage) {
        if (null == bufferedImage) {
            return null;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, n2, n, 0, null);
        graphics2D.setComposite(composite);
        graphics2D.dispose();
        return bufferedImage2;
    }

    protected static void applyImageMask(byte[] byArray, IntBuffer intBuffer) {
        if (null == byArray || null == intBuffer || byArray.length != intBuffer.capacity()) {
            return;
        }
        int n = byArray.length;
        intBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            long l = ALPHA_MASK & (long)intBuffer.get();
            if (l != ALPHA_MASK) continue;
            byArray[i] = ALPHA_TRANSPARENT;
        }
        intBuffer.rewind();
    }

    protected static void applyImageMask(short[] sArray, IntBuffer intBuffer) {
        if (null == sArray || null == intBuffer || sArray.length != intBuffer.capacity()) {
            return;
        }
        int n = sArray.length;
        intBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            long l = ALPHA_MASK & (long)intBuffer.get();
            if (l != ALPHA_MASK) continue;
            sArray[i] = ALPHA_TRANSPARENT;
        }
        intBuffer.rewind();
    }

    protected static void applyImageMask(int[] nArray, IntBuffer intBuffer) {
        if (null == nArray || null == intBuffer || nArray.length != intBuffer.capacity()) {
            return;
        }
        int n = nArray.length;
        intBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            long l = ALPHA_MASK & (long)intBuffer.get();
            if (l != ALPHA_MASK) continue;
            nArray[i] = ALPHA_TRANSPARENT;
        }
        intBuffer.rewind();
    }

    protected static IntBuffer extractImageMask(AVList aVList) {
        if (null == aVList || !aVList.hasKey("gov.nasa.worldwind.avkey.GDAL.MaskDataset")) {
            return null;
        }
        try {
            Object object = aVList.getValue("gov.nasa.worldwind.avkey.GDAL.MaskDataset");
            if (object instanceof Dataset) {
                Dataset dataset = (Dataset)object;
                Band band = dataset.GetRasterBand(1);
                if (null == band) {
                    String string = Logging.getMessage("nullValue.RasterBandIsNull");
                    Logging.logger().severe(string);
                    return null;
                }
                int n = dataset.getRasterXSize();
                int n2 = dataset.getRasterYSize();
                int n3 = band.getDataType();
                int n4 = n * n2 * (gdal.GetDataTypeSize(n3) / 8);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4);
                byteBuffer.order(ByteOrder.nativeOrder());
                int n5 = band.ReadRaster_Direct(0, 0, band.getXSize(), band.getYSize(), n, n2, n3, byteBuffer);
                if (n5 != gdalconstConstants.CE_None) {
                    throw new WWRuntimeException(GDALUtils.getErrorMessage());
                }
                return byteBuffer.asIntBuffer();
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    public static double[] calcGetGeoTransform(Sector sector, int n, int n2) throws IllegalArgumentException {
        if (null == sector) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (0 == n) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (0 == n2) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{sector.getMinLongitude().degrees, Math.abs(sector.getDeltaLonDegrees() / (double)n), 0.0, sector.getMaxLatitude().degrees, 0.0, -Math.abs(sector.getDeltaLatDegrees() / (double)n2)};
        return dArray;
    }

    public static SpatialReference createGeographicSRS() throws WWRuntimeException {
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        SpatialReference spatialReference = new SpatialReference();
        spatialReference.ImportFromProj4("+proj=latlong +datum=WGS84 +no_defs");
        return spatialReference;
    }

    protected static LatLon getLatLonForRasterPoint(double[] dArray, int n, int n2, CoordinateTransformation coordinateTransformation) {
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        Point2D point2D = GDAL.getGeoPointForRasterPoint(dArray, n, n2);
        if (null == point2D) {
            return null;
        }
        double[] dArray2 = coordinateTransformation.TransformPoint(point2D.getX(), point2D.getY());
        return LatLon.fromDegrees(dArray2[1], dArray2[0]);
    }

    public static AVList extractRasterParameters(Dataset dataset) throws IllegalArgumentException, WWRuntimeException {
        return GDALUtils.extractRasterParameters(dataset, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVList extractRasterParameters(Dataset dataset, AVList aVList, boolean bl) throws IllegalArgumentException, WWRuntimeException {
        Object object;
        Object object2;
        Object object3;
        if (null == aVList) {
            aVList = new AVListImpl();
        }
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().finest(string);
            throw new WWRuntimeException(string);
        }
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        int n = dataset.getRasterXSize();
        if (0 >= n) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        int n2 = dataset.getRasterYSize();
        if (0 >= n2) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        int n3 = dataset.getRasterCount();
        if (0 >= n3) {
            String string = Logging.getMessage("generic.UnexpectedBandCount", n3);
            Logging.logger().finest(string);
            throw new WWRuntimeException(string);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.NumBands", n3);
        Band band = dataset.GetRasterBand(1);
        if (null != band) {
            int n4;
            if (band.GetOverviewCount() > 0) {
                aVList.setValue("gov.nasa.worldwind.avkey.Raster.HasOverviews", Boolean.TRUE);
            }
            if ((n4 = band.getDataType()) == gdalconst.GDT_Int16 || n4 == gdalconst.GDT_CInt16) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
            } else if (n4 == gdalconst.GDT_Int32 || n4 == gdalconst.GDT_CInt32) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int32");
            } else if (n4 == gdalconst.GDT_Float32 || n4 == gdalconst.GDT_CFloat32) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Float32");
            } else if (n4 == gdalconst.GDT_Byte) {
                int n5 = band.GetColorInterpretation();
                if (n5 == gdalconst.GCI_GrayIndex && n3 < 3) {
                    aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Grayscale");
                } else {
                    aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Color");
                }
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
            } else if (n4 == gdalconst.GDT_UInt16) {
                aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", n3 >= 3 ? "gov.nasa.worldwind.avkey.Color" : "gov.nasa.worldwind.avkey.Grayscale");
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
            } else if (n4 == gdalconst.GDT_UInt32) {
                aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", n3 >= 3 ? "gov.nasa.worldwind.avkey.Color" : "gov.nasa.worldwind.avkey.Grayscale");
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int32");
            } else {
                String string = Logging.getMessage("generic.UnrecognizedDataType", n4);
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            if ("GTiff".equalsIgnoreCase(dataset.GetDriver().getShortName()) && aVList.hasKey("gov.nasa.worldwind.avkey.File") && "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat")) && !aVList.hasKey("gov.nasa.worldwind.avkey.ElevationUnit")) {
                GeotiffReader geotiffReader = null;
                try {
                    object3 = (File)aVList.getValue("gov.nasa.worldwind.avkey.File");
                    object2 = new AVListImpl();
                    geotiffReader = new GeotiffReader((File)object3);
                    geotiffReader.copyMetadataTo((AVList)object2);
                    WWUtil.copyValues((AVList)object2, aVList, new String[]{"gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.ElevationMinKey", "gov.nasa.worldwind.avkey.ElevationMaxKey", "gov.nasa.worldwind.avkey.MissingDataFlag"}, false);
                }
                catch (Throwable throwable) {
                    Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
                }
                finally {
                    if (null != geotiffReader) {
                        geotiffReader.dispose();
                    }
                }
            }
            GDALUtils.extractMinMaxSampleValues(dataset, band, aVList);
            if (!(!"gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat")) || aVList.hasKey("gov.nasa.worldwind.avkey.ElevationMinKey") && aVList.hasKey("gov.nasa.worldwind.avkey.ElevationMaxKey") && aVList.hasKey("gov.nasa.worldwind.avkey.MissingDataFlag") || bl)) {
                double[] dArray = new double[2];
                band.ComputeRasterMinMax(dArray);
                if (ElevationsUtil.isKnownMissingSignal(dArray[0])) {
                    aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", dArray[0]);
                    if (GDALUtils.setNoDataValue(band, dArray[0])) {
                        band.ComputeRasterMinMax(dArray);
                        aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", dArray[0]);
                        aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", dArray[1]);
                    }
                } else {
                    aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", dArray[0]);
                    aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", dArray[1]);
                }
            }
        }
        String string = null;
        if (aVList.hasKey("gov.nasa.worldwind.avkey.SpatialReference.WKT")) {
            string = aVList.getStringValue("gov.nasa.worldwind.avkey.SpatialReference.WKT");
        }
        if (WWUtil.isEmpty(string)) {
            string = dataset.GetProjectionRef();
        }
        if (WWUtil.isEmpty(string)) {
            string = dataset.GetProjection();
        }
        SpatialReference spatialReference = null;
        if (!WWUtil.isEmpty(string)) {
            aVList.setValue("gov.nasa.worldwind.avkey.SpatialReference.WKT", string);
            spatialReference = new SpatialReference(string);
        }
        object3 = new double[6];
        dataset.GetGeoTransform((double[])object3);
        if (object3[5] > 0.0) {
            object3[5] = -object3[5];
        }
        object2 = GDAL.computeCornersFromGeotransform(object3, n, n2);
        double d = GDAL.getMinX(object2);
        double d2 = GDAL.getMinY(object2);
        double d3 = GDAL.getMaxX(object2);
        double d4 = GDAL.getMaxY(object2);
        double d5 = object3[2];
        double d6 = object3[4];
        double d7 = object3[1];
        double d8 = object3[5];
        aVList.setValue("gov.nasa.worldwind.avkey.PixelWidth", d7);
        aVList.setValue("gov.nasa.worldwind.avkey.PixelHeight", d8);
        if (d == 0.0 && d7 == 1.0 && d5 == 0.0 && d4 == 0.0 && d6 == 0.0 && d8 == 1.0) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Screen");
        } else if (Angle.isValidLongitude(d) && Angle.isValidLatitude(d4) && Angle.isValidLongitude(d3) && Angle.isValidLatitude(d2)) {
            if (null == spatialReference) {
                spatialReference = GDALUtils.createGeographicSRS();
            } else if (spatialReference.IsGeographic() == 0) {
                object = Logging.getMessage("generic.UnexpectedCoordinateSystem", spatialReference.ExportToWkt());
                Logging.logger().warning((String)object);
                spatialReference = GDALUtils.createGeographicSRS();
            }
        }
        if (null != spatialReference) {
            Object object4;
            object = null;
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.SpatialReference.WKT")) {
                aVList.setValue("gov.nasa.worldwind.avkey.SpatialReference.WKT", spatialReference.ExportToWkt());
            }
            if (spatialReference.IsLocal() == 1) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown");
                String string2 = Logging.getMessage("generic.UnknownCoordinateSystem", string);
                Logging.logger().severe(string2);
                return aVList;
            }
            GDAL.Area area = new GDAL.Area(spatialReference, dataset);
            if (null != area) {
                aVList.setValue("gov.nasa.worldwind.avkey.GDAL.Area", area);
                object = area.getSector();
                if (null != object) {
                    aVList.setValue("gov.nasa.worldwind.avKey.Sector", object);
                    object4 = new LatLon(((Sector)object).getMaxLatitude(), ((Sector)object).getMinLongitude());
                    aVList.setValue("gov.nasa.worldwind.avkey.Origin", object4);
                }
            }
            if (spatialReference.IsGeographic() == 1) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
            } else if (spatialReference.IsProjected() == 1) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Projected");
                object4 = spatialReference.GetAttrValue("PROJCS|PROJECTION");
                String string3 = spatialReference.GetAttrValue("PROJCS|UNIT");
                if (null != string3) {
                    if ("meter".equals(string3 = string3.toLowerCase()) || "meters".equals(string3) || "metre".equals(string3) || "metres".equals(string3)) {
                        aVList.setValue("gov.nasa.worldwind.avkey.Projection.Units", "gov.nasa.worldwind.avkey.Unit.Meter");
                    } else if ("foot".equals(string3) || "feet".equals(string3)) {
                        aVList.setValue("gov.nasa.worldwind.avkey.Projection.Units", "gov.nasa.worldwind.avkey.Unit.Foot");
                    } else {
                        Logging.logger().warning(Logging.getMessage("generic.UnknownProjectionUnits", string3));
                    }
                }
                if (null != object4 && 0 < ((String)object4).length()) {
                    aVList.setValue("gov.nasa.worldwind.avkey.Projection.Name", object4);
                }
            } else if (spatialReference.IsLocal() == 1) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Screen");
            } else {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown");
                object4 = Logging.getMessage("generic.UnknownCoordinateSystem", string);
                Logging.logger().severe((String)object4);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown");
        }
        return aVList;
    }

    protected static Double convertStringToDouble(String string) {
        return string == null ? null : WWUtil.convertStringToDouble(string);
    }

    protected static void extractMinMaxSampleValues(Dataset dataset, Band band, AVList aVList) {
        if (null != dataset && null != aVList && "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            Double d;
            band = null != band ? band : dataset.GetRasterBand(1);
            Double[] doubleArray = new Double[16];
            Double d2 = GDALUtils.convertStringToDouble(dataset.GetMetadataItem("TIFFTAG_MINSAMPLEVALUE"));
            Double d3 = GDALUtils.convertStringToDouble(dataset.GetMetadataItem("TIFFTAG_MAXSAMPLEVALUE"));
            if (d2 == null || d3 == null) {
                band.GetMinimum(doubleArray);
                d2 = null != doubleArray[0] ? doubleArray[0] : d2;
                band.GetMaximum(doubleArray);
                d3 = null != doubleArray[0] ? doubleArray[0] : d3;
            }
            band.GetNoDataValue(doubleArray);
            Double d4 = d = null != doubleArray[0] ? doubleArray[0] : GDALUtils.convertStringToDouble(dataset.GetMetadataItem("TIFFTAG_GDAL_NODATA"));
            if (ElevationsUtil.isKnownMissingSignal(d2)) {
                if (d == null) {
                    d = d2;
                }
                d2 = null;
            }
            if (null != d2) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d2);
            }
            if (null != d3) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d3);
            }
            if (null != d) {
                aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", d);
            }
        }
    }

    protected static boolean setNoDataValue(Band band, Double d) {
        if (null != band && null != d) {
            try {
                gdal.PushErrorHandler("CPLQuietErrorHandler");
                boolean bl = gdalconst.CE_None == band.SetNoDataValue(d);
                return bl;
            }
            finally {
                gdal.PopErrorHandler();
            }
        }
        return false;
    }

    public static DataRaster composeDataRaster(Dataset dataset, AVList aVList) throws IllegalArgumentException, WWRuntimeException {
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        String string = (aVList = GDALUtils.extractRasterParameters(dataset, aVList, false)).getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
        if ("gov.nasa.worldwind.avkey.Elevation".equals(string)) {
            return GDALUtils.composeNonImageDataRaster(dataset, aVList);
        }
        if ("gov.nasa.worldwind.avkey.Image".equals(string)) {
            return GDALUtils.composeImageDataRaster(dataset, aVList);
        }
        String string2 = Logging.getMessage("generic.UnexpectedRasterType", string);
        Logging.logger().severe(string2);
        throw new WWRuntimeException(string2);
    }

    public static int[] extractBandOrder(Dataset dataset, AVList aVList) throws IllegalArgumentException, WWRuntimeException {
        if (!gdalIsAvailable.get()) {
            String string = Logging.getMessage("gdal.GDALNotAvailable");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int[] nArray = null;
        if (aVList.hasKey("gov.nasa.worldwind.avkey.BandsOrder")) {
            Object object;
            int n = dataset.getRasterCount();
            Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.BandsOrder");
            if (null != object2 && object2 instanceof Integer[]) {
                object = (Integer[])object2;
                nArray = new int[((Integer[])object).length];
                for (int i = 0; i < ((Integer[])object).length; ++i) {
                    nArray[i] = object[i];
                }
            } else if (null != object2 && object2 instanceof int[]) {
                nArray = (int[])object2;
            }
            if (null == nArray) {
                object = Logging.getMessage("nullValue.BandOrderIsNull");
                Logging.logger().severe((String)object);
                throw new IllegalArgumentException((String)object);
            }
            if (0 == nArray.length) {
                object = Logging.getMessage("generic.BandOrderIsEmpty");
                Logging.logger().severe((String)object);
                throw new IllegalArgumentException((String)object);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0 && nArray[i] < n) continue;
                String string = Logging.getMessage("generic.InvalidBandOrder", nArray[i], n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
        }
        return nArray;
    }

    protected static DataRaster composeNonImageDataRaster(Dataset dataset, AVList aVList) throws IllegalArgumentException, WWRuntimeException {
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
        if (!"gov.nasa.worldwind.avkey.Elevation".equals(string)) {
            String string2 = Logging.getMessage("generic.UnexpectedRasterType", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null == object || !(object instanceof Sector)) {
            String string3 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        Sector sector = (Sector)object;
        int n = dataset.getRasterCount();
        if (n != 1) {
            String string4 = Logging.getMessage("generic.UnexpectedBandCount", n);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (aVList.hasKey("gov.nasa.worldwind.avkey.ByteOrder")) {
            byteOrder = "gov.nasa.worldwind.avkey.LittleEndian".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder")) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        } else {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", byteOrder == ByteOrder.BIG_ENDIAN ? "gov.nasa.worldwind.avkey.BigEndian" : "gov.nasa.worldwind.avkey.LittleEndian");
        }
        int n2 = dataset.getRasterXSize();
        int n3 = dataset.getRasterYSize();
        Band band = dataset.GetRasterBand(1);
        if (null == band) {
            String string5 = Logging.getMessage("nullValue.RasterBandIsNull");
            Logging.logger().severe(string5);
            throw new WWRuntimeException(string5);
        }
        int n4 = band.getDataType();
        int n5 = gdal.GetDataTypeSize(n4);
        int n6 = n2 * n3 * (n5 / 8);
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocateDirect(n6);
        }
        catch (Throwable throwable) {
            String string6 = Logging.getMessage("generic.MemoryAllocationError", n6);
            Logging.logger().log(Level.SEVERE, string6, throwable);
            throw new WWRuntimeException(string6);
        }
        byteBuffer.order(byteOrder);
        int n7 = band.ReadRaster_Direct(0, 0, band.getXSize(), band.getYSize(), n2, n3, band.getDataType(), byteBuffer);
        if (n7 != gdalconstConstants.CE_None) {
            throw new WWRuntimeException(GDALUtils.getErrorMessage());
        }
        ByteBufferRaster byteBufferRaster = new ByteBufferRaster(n2, n3, sector, byteBuffer, aVList);
        ElevationsUtil.rectify(byteBufferRaster);
        return byteBufferRaster;
    }

    protected static void alterJavaLibraryPath(String string) throws IllegalAccessException, NoSuchFieldException {
        System.setProperty(JAVA_LIBRARY_PATH, string);
        newClassLoader = ClassLoader.class;
        fieldSysPaths = newClassLoader.getDeclaredField("sys_paths");
        if (null != fieldSysPaths) {
            fieldSysPaths_accessible = fieldSysPaths.isAccessible();
            if (!fieldSysPaths_accessible) {
                fieldSysPaths.setAccessible(true);
            }
            originalClassLoader = fieldSysPaths.get(newClassLoader);
            fieldSysPaths.set(newClassLoader, null);
        }
    }

    protected static void restoreJavaLibraryPath() {
        try {
            if (null != originalClassLoader && null != fieldSysPaths) {
                fieldSysPaths.set(newClassLoader, originalClassLoader);
                fieldSysPaths.setAccessible(fieldSysPaths_accessible);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    static {
        GDALUtils.initialize();
        newClassLoader = null;
        originalClassLoader = null;
        fieldSysPaths = null;
        fieldSysPaths_accessible = false;
    }
}

