/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.measure;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.util.measure.MeasureToolController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MeasureTool
extends AVListImpl
implements Disposable {
    public static final String SHAPE_LINE = "MeasureTool.ShapeLine";
    public static final String SHAPE_PATH = "MeasureTool.ShapePath";
    public static final String SHAPE_POLYGON = "MeasureTool.ShapePolygon";
    public static final String SHAPE_CIRCLE = "MeasureTool.ShapeCircle";
    public static final String SHAPE_ELLIPSE = "MeasureTool.ShapeEllipse";
    public static final String SHAPE_QUAD = "MeasureTool.ShapeQuad";
    public static final String SHAPE_SQUARE = "MeasureTool.ShapeSquare";
    public static final String EVENT_POSITION_ADD = "MeasureTool.AddPosition";
    public static final String EVENT_POSITION_REMOVE = "MeasureTool.RemovePosition";
    public static final String EVENT_POSITION_REPLACE = "MeasureTool.ReplacePosition";
    public static final String EVENT_METRIC_CHANGED = "MeasureTool.MetricChanged";
    public static final String EVENT_ARMED = "MeasureTool.Armed";
    public static final String EVENT_RUBBERBAND_START = "MeasureTool.RubberBandStart";
    public static final String EVENT_RUBBERBAND_STOP = "MeasureTool.RubberBandStop";
    public static final String ANGLE_LABEL = "MeasureTool.AngleLabel";
    public static final String AREA_LABEL = "MeasureTool.AreaLabel";
    public static final String LENGTH_LABEL = "MeasureTool.LengthLabel";
    public static final String PERIMETER_LABEL = "MeasureTool.PerimeterLabel";
    public static final String RADIUS_LABEL = "MeasureTool.RadiusLabel";
    public static final String HEIGHT_LABEL = "MeasureTool.HeightLabel";
    public static final String WIDTH_LABEL = "MeasureTool.WidthLabel";
    public static final String HEADING_LABEL = "MeasureTool.HeadingLabel";
    public static final String CENTER_LATITUDE_LABEL = "MeasureTool.CenterLatitudeLabel";
    public static final String CENTER_LONGITUDE_LABEL = "MeasureTool.CenterLongitudeLabel";
    public static final String LATITUDE_LABEL = "MeasureTool.LatitudeLabel";
    public static final String LONGITUDE_LABEL = "MeasureTool.LongitudeLabel";
    public static final String ACCUMULATED_LABEL = "MeasureTool.AccumulatedLabel";
    public static final String MAJOR_AXIS_LABEL = "MeasureTool.MajorAxisLabel";
    public static final String MINOR_AXIS_LABEL = "MeasureTool.MinorAxisLabel";
    public static final String CONTROL_TYPE_LOCATION_INDEX = "MeasureTool.ControlTypeLocationIndex";
    public static final String CONTROL_TYPE_REGULAR_SHAPE = "MeasureTool.ControlTypeRegularShape";
    public static final String CONTROL_TYPE_LEADER_ORIGIN = "MeasureTool.ControlTypeLeaderOrigin";
    private static final String CENTER = "Center";
    private static final String NORTH = "North";
    private static final String EAST = "East";
    private static final String SOUTH = "South";
    private static final String WEST = "West";
    private static final String NORTHEAST = "NE";
    private static final String SOUTHEAST = "SE";
    private static final String SOUTHWEST = "SW";
    private static final String NORTHWEST = "NW";
    private static final String NORTH_LEADER = "NorthLeader";
    protected static final double SHAPE_MIN_WIDTH_METERS = 0.1;
    protected static final double SHAPE_MIN_HEIGHT_METERS = 0.1;
    protected static final int MAX_SHAPE_MOVE_ITERATIONS = 10;
    protected static final double SHAPE_CONTROL_EPSILON_METERS = 0.01;
    protected final WorldWindow wwd;
    protected MeasureToolController controller;
    protected ArrayList<Position> positions = new ArrayList();
    protected ArrayList<Renderable> controlPoints = new ArrayList();
    protected RenderableLayer applicationLayer;
    protected CustomRenderableLayer layer;
    protected CustomRenderableLayer controlPointsLayer;
    protected CustomRenderableLayer shapeLayer;
    protected Polyline line;
    protected SurfaceShape surfaceShape;
    protected ScreenAnnotation annotation;
    protected Color lineColor = Color.YELLOW;
    protected Color fillColor = new Color(0.6f, 0.6f, 0.4f, 0.5f);
    protected double lineWidth = 2.0;
    protected String pathType = "gov.nasa.worldwind.avkey.GreatCircle";
    protected AnnotationAttributes controlPointsAttributes;
    protected AnnotationAttributes controlPointWithLeaderAttributes;
    protected ShapeAttributes leaderAttributes;
    protected AnnotationAttributes annotationAttributes;
    protected String measureShapeType = "MeasureTool.ShapeLine";
    protected boolean followTerrain = false;
    protected boolean showControlPoints = true;
    protected boolean showAnnotation = true;
    protected UnitsFormat unitsFormat = new UnitsFormat();
    protected Rectangle2D.Double shapeRectangle = null;
    protected Position shapeCenterPosition = null;
    protected Angle shapeOrientation = null;
    protected int shapeIntervals = 64;

    public MeasureTool(WorldWindow worldWindow) {
        this(worldWindow, null);
    }

    public MeasureTool(WorldWindow worldWindow, RenderableLayer renderableLayer) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.applicationLayer = renderableLayer;
        this.layer = this.createCustomRenderableLayer();
        this.shapeLayer = this.createCustomRenderableLayer();
        this.controlPointsLayer = this.createCustomRenderableLayer();
        this.shapeLayer.setPickEnabled(false);
        this.layer.setName("Measure Tool");
        this.layer.addRenderable(this.shapeLayer);
        this.layer.addRenderable(this.controlPointsLayer);
        this.controlPointsLayer.setEnabled(this.showControlPoints);
        if (this.applicationLayer != null) {
            this.applicationLayer.addRenderable(this.layer);
        } else {
            this.wwd.getModel().getLayers().add(this.layer);
        }
        this.controlPointsAttributes = new AnnotationAttributes();
        this.controlPointsAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.controlPointsAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        this.controlPointsAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        this.controlPointsAttributes.setSize(new Dimension(8, 8));
        this.controlPointsAttributes.setDrawOffset(new Point(0, -4));
        this.controlPointsAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.controlPointsAttributes.setBorderWidth(0.0);
        this.controlPointsAttributes.setCornerRadius(0);
        this.controlPointsAttributes.setBackgroundColor(Color.BLUE);
        this.controlPointsAttributes.setTextColor(Color.GREEN);
        this.controlPointsAttributes.setHighlightScale(1.2);
        this.controlPointsAttributes.setDistanceMaxScale(1.0);
        this.controlPointsAttributes.setDistanceMinScale(1.0);
        this.controlPointsAttributes.setDistanceMinOpacity(1.0);
        this.controlPointWithLeaderAttributes = new AnnotationAttributes();
        this.controlPointWithLeaderAttributes.setDefaults(this.controlPointsAttributes);
        this.controlPointWithLeaderAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeEllipse");
        this.controlPointWithLeaderAttributes.setSize(new Dimension(10, 10));
        this.controlPointWithLeaderAttributes.setDrawOffset(new Point(0, -5));
        this.controlPointWithLeaderAttributes.setBackgroundColor(Color.LIGHT_GRAY);
        this.leaderAttributes = new BasicShapeAttributes();
        this.leaderAttributes.setOutlineMaterial(Material.WHITE);
        this.leaderAttributes.setOutlineOpacity(0.7);
        this.leaderAttributes.setOutlineWidth(3.0);
        this.setInitialLabels();
        this.annotationAttributes = new AnnotationAttributes();
        this.annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
        this.annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.annotationAttributes.setDrawOffset(new Point(0, 10));
        this.annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        this.annotationAttributes.setFont(Font.decode("Arial-Bold-14"));
        this.annotationAttributes.setTextColor(Color.WHITE);
        this.annotationAttributes.setBackgroundColor(Color.BLACK);
        this.annotationAttributes.setSize(new Dimension(220, 0));
        this.annotation = new ScreenAnnotation("", new Point(0, 0), this.annotationAttributes);
        this.annotation.getAttributes().setVisible(false);
        this.annotation.getAttributes().setDrawOffset(null);
        this.shapeLayer.addRenderable(this.annotation);
    }

    protected void setInitialLabels() {
        this.setLabel(ACCUMULATED_LABEL, Logging.getMessage(ACCUMULATED_LABEL));
        this.setLabel(ANGLE_LABEL, Logging.getMessage(ANGLE_LABEL));
        this.setLabel(AREA_LABEL, Logging.getMessage(AREA_LABEL));
        this.setLabel(CENTER_LATITUDE_LABEL, Logging.getMessage(CENTER_LATITUDE_LABEL));
        this.setLabel(CENTER_LONGITUDE_LABEL, Logging.getMessage(CENTER_LONGITUDE_LABEL));
        this.setLabel(HEADING_LABEL, Logging.getMessage(HEADING_LABEL));
        this.setLabel(HEIGHT_LABEL, Logging.getMessage(HEIGHT_LABEL));
        this.setLabel(LATITUDE_LABEL, Logging.getMessage(LATITUDE_LABEL));
        this.setLabel(LONGITUDE_LABEL, Logging.getMessage(LONGITUDE_LABEL));
        this.setLabel(LENGTH_LABEL, Logging.getMessage(LENGTH_LABEL));
        this.setLabel(MAJOR_AXIS_LABEL, Logging.getMessage(MAJOR_AXIS_LABEL));
        this.setLabel(MINOR_AXIS_LABEL, Logging.getMessage(MINOR_AXIS_LABEL));
        this.setLabel(PERIMETER_LABEL, Logging.getMessage(PERIMETER_LABEL));
        this.setLabel(RADIUS_LABEL, Logging.getMessage(RADIUS_LABEL));
        this.setLabel(WIDTH_LABEL, Logging.getMessage(WIDTH_LABEL));
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public UnitsFormat getUnitsFormat() {
        return this.unitsFormat;
    }

    public void setUnitsFormat(UnitsFormat unitsFormat) {
        if (unitsFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.unitsFormat = unitsFormat;
    }

    protected CustomRenderableLayer createCustomRenderableLayer() {
        return new CustomRenderableLayer();
    }

    public void setController(MeasureToolController measureToolController) {
        if (this.controller != null) {
            this.wwd.getInputHandler().removeMouseListener(this.controller);
            this.wwd.getInputHandler().removeMouseMotionListener(this.controller);
            this.wwd.removePositionListener(this.controller);
            this.wwd.removeSelectListener(this.controller);
            this.wwd.removeRenderingListener(this.controller);
            this.controller = null;
        }
        if (measureToolController != null) {
            this.controller = measureToolController;
            this.controller.setMeasureTool(this);
            this.wwd.getInputHandler().addMouseListener(this.controller);
            this.wwd.getInputHandler().addMouseMotionListener(this.controller);
            this.wwd.addPositionListener(this.controller);
            this.wwd.addSelectListener(this.controller);
            this.wwd.addRenderingListener(this.controller);
        }
    }

    public void setLabel(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.setValue(string, string2);
        }
    }

    public String getLabel(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.LabelName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.getStringValue(string);
        return string3 != null ? string3 : this.unitsFormat.getStringValue(string);
    }

    public MeasureToolController getController() {
        return this.controller;
    }

    public void setArmed(boolean bl) {
        if (this.controller != null) {
            this.controller.setArmed(bl);
        }
    }

    public boolean isArmed() {
        return this.controller != null && this.controller.isArmed();
    }

    public RenderableLayer getLayer() {
        return this.layer;
    }

    public RenderableLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public Polyline getLine() {
        return this.line;
    }

    public SurfaceShape getSurfaceShape() {
        return this.surfaceShape;
    }

    public ArrayList<? extends Position> getPositions() {
        return this.positions;
    }

    public void setPositions(ArrayList<? extends Position> arrayList) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (arrayList.size() < 2) {
            return;
        }
        this.clear();
        boolean bl = arrayList.get(0).equals(arrayList.get(arrayList.size() - 1));
        if (arrayList.size() > 2 && bl) {
            this.setMeasureShapeType(SHAPE_POLYGON);
        } else {
            this.setMeasureShapeType(this.getPathType(arrayList));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Position position = arrayList.get(i);
            this.positions.add(position);
            if (i >= arrayList.size() - 1 && bl) continue;
            this.addControlPoint(position, CONTROL_TYPE_LOCATION_INDEX, this.positions.size() - 1);
        }
        if (this.measureShapeType.equals(SHAPE_LINE)) {
            this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    public ArrayList<Renderable> getControlPoints() {
        return this.controlPoints;
    }

    public AnnotationAttributes getControlPointsAttributes() {
        return this.controlPointsAttributes;
    }

    public AnnotationAttributes getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lineColor = color;
        if (this.line != null) {
            this.line.setColor(color);
        }
        if (this.surfaceShape != null) {
            ShapeAttributes shapeAttributes = this.surfaceShape.getAttributes();
            if (shapeAttributes == null) {
                shapeAttributes = new BasicShapeAttributes();
            }
            shapeAttributes.setOutlineMaterial(new Material(color));
            shapeAttributes.setOutlineOpacity((double)color.getAlpha() / 255.0);
            this.surfaceShape.setAttributes(shapeAttributes);
        }
        this.wwd.redraw();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fillColor = color;
        if (this.surfaceShape != null) {
            ShapeAttributes shapeAttributes = this.surfaceShape.getAttributes();
            if (shapeAttributes == null) {
                shapeAttributes = new BasicShapeAttributes();
            }
            shapeAttributes.setInteriorMaterial(new Material(color));
            shapeAttributes.setInteriorOpacity((double)color.getAlpha() / 255.0);
            this.surfaceShape.setAttributes(shapeAttributes);
        }
        this.wwd.redraw();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        if (this.line != null) {
            this.line.setLineWidth(d);
        }
        if (this.surfaceShape != null) {
            ShapeAttributes shapeAttributes = this.surfaceShape.getAttributes();
            if (shapeAttributes == null) {
                shapeAttributes = new BasicShapeAttributes();
            }
            shapeAttributes.setOutlineWidth(d);
            this.surfaceShape.setAttributes(shapeAttributes);
        }
        this.wwd.redraw();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String string) {
        this.pathType = string;
        if (this.line != null) {
            this.line.setPathType(MeasureTool.polylinePathTypeFromKey(string));
        }
        if (this.surfaceShape != null) {
            this.surfaceShape.setPathType(string);
        }
        if (this.isRegularShape()) {
            this.updateShapeControlPoints();
        }
        this.wwd.redraw();
    }

    protected static int polylinePathTypeFromKey(String string) {
        if (string != null && string == "gov.nasa.worldwind.avkey.GreatCircle") {
            return 0;
        }
        if (string != null && (string == "gov.nasa.worldwind.avkey.RhumbLine" || string == "gov.nasa.worldwind.avkey.Loxodrome")) {
            return 2;
        }
        return 1;
    }

    protected static String keyFromPolylinePathType(int n) {
        if (n == 0) {
            return "gov.nasa.worldwind.avkey.GreatCircle";
        }
        if (n == 2) {
            return "gov.nasa.worldwind.avkey.RhumbLine";
        }
        return "gov.nasa.worldwind.avkey.Linear";
    }

    public boolean isShowControlPoints() {
        return this.showControlPoints;
    }

    public void setShowControlPoints(boolean bl) {
        this.showControlPoints = bl;
        this.controlPointsLayer.setEnabled(bl);
        this.wwd.redraw();
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean bl) {
        this.showAnnotation = bl;
    }

    public void clear() {
        while (this.positions.size() > 0 || this.controlPoints.size() > 0) {
            this.removeControlPoint();
        }
        this.shapeCenterPosition = null;
        this.shapeOrientation = null;
        this.shapeRectangle = null;
    }

    public boolean isMeasureShape(Object object) {
        return object == this.shapeLayer;
    }

    public String getMeasureShapeType() {
        return this.measureShapeType;
    }

    public void setMeasureShapeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!this.measureShapeType.equals(string)) {
            this.setArmed(false);
            this.clear();
            this.measureShapeType = string;
        }
    }

    public void setMeasureShapeType(String string, Position position, double d) {
        this.setMeasureShapeType(string, position, d * 2.0, d * 2.0, Angle.ZERO);
    }

    public void setMeasureShapeType(String string, Position position, double d, double d2, Angle angle) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (angle == null) {
            String string4 = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.isRegularShape(string)) {
            this.setArmed(false);
            this.clear();
            if ((string.equals(SHAPE_CIRCLE) || string.equals(SHAPE_SQUARE)) && d != d2) {
                d = Math.max(d, d2);
                d2 = Math.max(d, d2);
            }
            this.measureShapeType = string;
            this.shapeCenterPosition = position;
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d, d2);
            this.shapeOrientation = angle;
            this.updateShapeControlPoints();
            this.updateMeasureShape();
            this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
            this.wwd.redraw();
        }
    }

    public void setMeasureShape(Polyline polyline) {
        if (polyline == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setArmed(false);
        this.clear();
        if (this.surfaceShape != null) {
            this.shapeLayer.removeRenderable(this.surfaceShape);
            this.surfaceShape = null;
        }
        if (this.line != null) {
            this.shapeLayer.removeRenderable(this.line);
        }
        this.line = polyline;
        this.shapeLayer.addRenderable(polyline);
        this.setFollowTerrain(polyline.isFollowTerrain());
        this.setPathType(MeasureTool.keyFromPolylinePathType(polyline.getPathType()));
        int n = 0;
        for (Position position : polyline.getPositions()) {
            this.positions.add(position);
            this.addControlPoint(position, CONTROL_TYPE_LOCATION_INDEX, n++);
        }
        this.measureShapeType = this.getPathType(this.positions);
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    protected String getPathType(List<? extends Position> list) {
        return list.size() > 2 ? SHAPE_PATH : SHAPE_LINE;
    }

    public void setMeasureShape(SurfaceShape surfaceShape) {
        if (surfaceShape == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setArmed(false);
        this.clear();
        if (this.surfaceShape != null) {
            this.shapeLayer.removeRenderable(this.surfaceShape);
        }
        if (this.line != null) {
            this.shapeLayer.removeRenderable(this.line);
            this.line = null;
        }
        this.surfaceShape = surfaceShape;
        this.shapeLayer.addRenderable(surfaceShape);
        this.setPathType(surfaceShape.getPathType());
        if (surfaceShape instanceof SurfaceQuad) {
            this.measureShapeType = surfaceShape instanceof SurfaceSquare ? SHAPE_SQUARE : SHAPE_QUAD;
            SurfaceQuad surfaceQuad = (SurfaceQuad)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceQuad.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceQuad.getWidth(), surfaceQuad.getHeight());
            this.shapeOrientation = surfaceQuad.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else if (surfaceShape instanceof SurfaceEllipse) {
            this.measureShapeType = surfaceShape instanceof SurfaceCircle ? SHAPE_CIRCLE : SHAPE_ELLIPSE;
            SurfaceEllipse surfaceEllipse = (SurfaceEllipse)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceEllipse.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceEllipse.getMajorRadius() * 2.0, surfaceEllipse.getMinorRadius() * 2.0);
            this.shapeOrientation = surfaceEllipse.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else {
            this.measureShapeType = SHAPE_POLYGON;
            this.updatePositionsFromShape();
            for (int i = 0; i < this.positions.size() - 1; ++i) {
                this.addControlPoint(this.positions.get(i), CONTROL_TYPE_LOCATION_INDEX, i);
            }
        }
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    public boolean isRegularShape() {
        return this.isRegularShape(this.measureShapeType);
    }

    protected boolean isRegularShape(String string) {
        return string.equals(SHAPE_CIRCLE) || string.equals(SHAPE_ELLIPSE) || string.equals(SHAPE_QUAD) || string.equals(SHAPE_SQUARE);
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        this.followTerrain = bl;
        if (this.line != null) {
            this.line.setFollowTerrain(bl);
        }
    }

    public boolean isCenterControl(ControlPoint controlPoint) {
        String string = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
        return string != null && string.equals(CENTER);
    }

    public boolean isSideControl(ControlPoint controlPoint) {
        String string = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
        return string != null && (string.equals(NORTH) || string.equals(EAST) || string.equals(SOUTH) || string.equals(WEST));
    }

    public boolean isCornerControl(ControlPoint controlPoint) {
        String string = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
        return string != null && (string.equals(NORTHEAST) || string.equals(SOUTHEAST) || string.equals(SOUTHWEST) || string.equals(NORTHWEST));
    }

    public double getLength() {
        Globe globe = this.wwd.getModel().getGlobe();
        if (this.line != null) {
            return this.line.getLength(globe);
        }
        if (this.surfaceShape != null) {
            return this.surfaceShape.getPerimeter(globe);
        }
        return -1.0;
    }

    public double getArea() {
        Globe globe = this.wwd.getModel().getGlobe();
        if (this.surfaceShape != null) {
            return this.surfaceShape.getArea(globe, this.followTerrain);
        }
        return -1.0;
    }

    public double getWidth() {
        if (this.shapeRectangle != null) {
            return this.shapeRectangle.width;
        }
        return -1.0;
    }

    public double getHeight() {
        if (this.shapeRectangle != null) {
            return this.shapeRectangle.height;
        }
        return -1.0;
    }

    public Angle getOrientation() {
        return this.shapeOrientation;
    }

    public Position getCenterPosition() {
        return this.shapeCenterPosition;
    }

    public Position addControlPoint() {
        Position position = this.wwd.getCurrentPosition();
        if (position == null) {
            return null;
        }
        if (this.isRegularShape()) {
            if (this.shapeCenterPosition == null) {
                this.shapeCenterPosition = position;
                this.shapeOrientation = this.getShapeInitialHeading();
                this.updateShapeControlPoints();
            } else if (this.shapeRectangle == null) {
                String string = this.getShapeInitialControl(position);
                this.updateShapeProperties(string, position, null);
                this.updateShapeControlPoints();
            }
        } else if (!this.measureShapeType.equals(SHAPE_POLYGON) || this.positions.size() <= 1) {
            this.positions.add(position);
            this.addControlPoint(this.positions.get(this.positions.size() - 1), CONTROL_TYPE_LOCATION_INDEX, this.positions.size() - 1);
            if (this.measureShapeType.equals(SHAPE_POLYGON) && this.positions.size() == 2) {
                this.positions.add(this.positions.get(0));
            }
            if (this.measureShapeType.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        } else {
            this.positions.add(this.positions.size() - 1, position);
            this.addControlPoint(this.positions.get(this.positions.size() - 2), CONTROL_TYPE_LOCATION_INDEX, this.positions.size() - 2);
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_ADD, null, position);
        this.wwd.redraw();
        return position;
    }

    public void removeControlPoint() {
        Position position = null;
        if (this.isRegularShape()) {
            if (this.shapeRectangle != null) {
                this.shapeRectangle = null;
                this.shapeOrientation = null;
                this.positions.clear();
                while (this.controlPoints.size() > 1) {
                    this.controlPoints.remove(1);
                }
            } else if (this.shapeCenterPosition != null) {
                this.shapeCenterPosition = null;
                this.controlPoints.clear();
            }
        } else {
            if (this.positions.size() == 0) {
                return;
            }
            if (!this.measureShapeType.equals(SHAPE_POLYGON) || this.positions.size() == 1) {
                position = this.positions.get(this.positions.size() - 1);
                this.positions.remove(this.positions.size() - 1);
            } else {
                position = this.positions.get(this.positions.size() - 2);
                this.positions.remove(this.positions.size() - 2);
                if (this.positions.size() == 2) {
                    this.positions.remove(1);
                }
            }
            if (this.controlPoints.size() > 0) {
                this.controlPoints.remove(this.controlPoints.size() - 1);
            }
        }
        this.controlPointsLayer.setRenderables(this.controlPoints);
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_REMOVE, position, null);
        this.wwd.redraw();
    }

    public void moveControlPoint(ControlPoint controlPoint) {
        this.moveControlPoint(controlPoint, null);
    }

    public void moveControlPoint(ControlPoint controlPoint, String string) {
        if (controlPoint == null) {
            String string2 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (controlPoint.getValue(CONTROL_TYPE_REGULAR_SHAPE) != null) {
            this.updateShapeProperties((String)controlPoint.getValue(CONTROL_TYPE_REGULAR_SHAPE), controlPoint.getPosition(), string);
            this.updateShapeControlPoints();
        }
        if (controlPoint.getValue(CONTROL_TYPE_LOCATION_INDEX) != null) {
            int n = (Integer)controlPoint.getValue(CONTROL_TYPE_LOCATION_INDEX);
            Position position = this.computeSurfacePosition(controlPoint.getPosition());
            position = new Position(controlPoint.getPosition(), position.getAltitude());
            this.positions.set(n, position);
            if (this.measureShapeType.equals(SHAPE_POLYGON) && this.positions.size() > 2 && n == 0) {
                this.positions.set(this.positions.size() - 1, position);
            }
            if (this.measureShapeType.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        }
        this.updateMeasureShape();
    }

    public void moveMeasureShape(Angle angle, Angle angle2) {
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isRegularShape()) {
            if (this.controlPoints.size() > 0) {
                ControlPoint controlPoint = this.getControlPoint(CENTER);
                controlPoint.setPosition(new Position(LatLon.greatCircleEndPosition((LatLon)controlPoint.getPosition(), angle, angle2), 0.0));
                this.moveControlPoint(controlPoint);
            }
        } else {
            for (int i = 0; i < this.positions.size(); ++i) {
                Position position = this.computeSurfacePosition(LatLon.greatCircleEndPosition((LatLon)this.positions.get(i), angle, angle2));
                this.positions.set(i, position);
                if (this.measureShapeType.equals(SHAPE_POLYGON) && i >= this.positions.size() - 1) continue;
                ((ControlPoint)this.controlPoints.get(i)).setPosition(new Position(position, 0.0));
            }
            if (this.measureShapeType.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
            this.updateMeasureShape();
        }
    }

    protected Position computeSurfacePosition(LatLon latLon) {
        Vec4 vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(latLon.getLatitude(), latLon.getLongitude());
        if (vec4 != null) {
            return this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        }
        return new Position(latLon, this.wwd.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
    }

    public String getShapeInitialControl(Position position) {
        if (this.measureShapeType.equals(SHAPE_ELLIPSE) || this.measureShapeType.equals(SHAPE_CIRCLE)) {
            return EAST;
        }
        if (this.measureShapeType.equals(SHAPE_QUAD) || this.measureShapeType.equals(SHAPE_SQUARE)) {
            return NORTHEAST;
        }
        return null;
    }

    protected Angle getShapeInitialHeading() {
        return this.wwd.getView().getHeading();
    }

    protected void updateShapeProperties(String string, Position position, String string2) {
        if (string.equals(CENTER)) {
            this.updateShapeCenter(string, position);
        } else if (string.equals(NORTH_LEADER)) {
            this.updateShapeOrientation(string, position);
        } else {
            this.updateShapeSize(string, position);
        }
    }

    protected void updateShapeCenter(String string, Position position) {
        this.shapeCenterPosition = position;
    }

    protected void updateShapeOrientation(String string, Position position) {
        Angle angle = this.computeControlPointAzimuth(string, this.shapeRectangle.width, this.shapeRectangle.height);
        Angle angle2 = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position);
        angle2 = angle2.subtract(angle);
        this.shapeOrientation = MeasureTool.computeNormalizedHeading(angle2);
    }

    protected void updateShapeSize(String string, Position position) {
        if (this.measureShapeType.equals(SHAPE_ELLIPSE) || this.measureShapeType.equals(SHAPE_CIRCLE)) {
            double d;
            double d2;
            Angle angle = this.computeControlPointAzimuth(string, 1.0, 1.0).add(this.shapeOrientation);
            Angle angle2 = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position);
            Angle angle3 = LatLon.greatCircleDistance(this.shapeCenterPosition, position);
            Angle angle4 = angle.angularDistanceTo(angle2);
            double d3 = this.wwd.getModel().getGlobe().getRadiusAt(this.shapeCenterPosition);
            double d4 = Math.abs(angle4.cos()) * Math.abs(angle3.radians) * d3;
            if (string.equals(EAST) || string.equals(WEST)) {
                d2 = 2.0 * d4;
                double d5 = d = this.shapeRectangle != null ? this.shapeRectangle.getHeight() : d2;
                if (this.measureShapeType.equals(SHAPE_CIRCLE)) {
                    d = d2;
                } else if (this.controller != null && this.controller.isActive()) {
                    d = 0.6 * d2;
                }
            } else {
                d = 2.0 * d4;
                double d6 = d2 = this.shapeRectangle != null ? this.shapeRectangle.getWidth() : d;
                if (this.measureShapeType.equals(SHAPE_CIRCLE)) {
                    d2 = d;
                } else if (this.controller != null && this.controller.isActive()) {
                    d2 = 0.6 * d;
                }
            }
            if (d2 <= 0.1) {
                d2 = 0.1;
            }
            if (d <= 0.1) {
                d = 0.1;
            }
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d2, d);
            this.swapEdgeControls(string, position);
        } else if (this.measureShapeType.equals(SHAPE_QUAD) || this.measureShapeType.equals(SHAPE_SQUARE)) {
            ControlPoint controlPoint = this.getOppositeControl(string);
            Angle angle = LatLon.greatCircleAzimuth(controlPoint.getPosition(), position);
            Angle angle5 = LatLon.greatCircleDistance(controlPoint.getPosition(), position);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)controlPoint.getPosition(), angle, angle5.divide(2.0));
            Angle angle6 = LatLon.greatCircleAzimuth(latLon, position);
            angle6 = this.computeControlPointAzimuthInShapeCoordinates(string, angle6);
            Angle angle7 = LatLon.greatCircleDistance(latLon, position);
            double d = this.wwd.getModel().getGlobe().getRadiusAt(latLon);
            double d7 = angle7.radians * d;
            double d8 = 2.0 * d7 * Math.abs(angle6.sin());
            double d9 = 2.0 * d7 * Math.abs(angle6.cos());
            if (d8 <= 0.1) {
                d8 = 0.1;
            }
            if (d9 <= 0.1) {
                d9 = 0.1;
            }
            if (this.measureShapeType.equals(SHAPE_SQUARE)) {
                double d10;
                d8 = d10 = Math.min(d8, d9);
                d9 = d10;
                this.swapCornerControls(string, position);
                LatLon latLon2 = this.moveShapeByControlPoint(controlPoint, this.wwd.getModel().getGlobe(), this.shapeOrientation, latLon, d8, d9);
                if (latLon2 != null) {
                    latLon = latLon2;
                }
            }
            this.shapeCenterPosition = new Position(latLon, 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d8, d9);
            if (this.measureShapeType.equals(SHAPE_QUAD)) {
                this.swapCornerControls(string, position);
            }
        }
    }

    public ControlPoint getControlPoint(String string) {
        for (Renderable renderable : this.controlPoints) {
            String string2 = ((ControlPoint)renderable).getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
            if (string2 == null || !string2.equals(string)) continue;
            return (ControlPoint)renderable;
        }
        return null;
    }

    protected String computeCornerControl(Position position) {
        if (this.shapeCenterPosition == null || this.shapeOrientation == null) {
            return null;
        }
        Angle angle = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position).subtract(this.shapeOrientation);
        angle = MeasureTool.computeNormalizedHeading(angle);
        if (angle.degrees < 90.0) {
            return NORTHEAST;
        }
        if (angle.degrees < 180.0) {
            return SOUTHEAST;
        }
        if (angle.degrees < 270.0) {
            return SOUTHWEST;
        }
        return NORTHWEST;
    }

    protected ControlPoint getOppositeControl(String string) {
        if (this.controlPoints.size() == 0) {
            return null;
        }
        if (this.controlPoints.size() == 1) {
            return this.getControlPoint(CENTER);
        }
        if (string.equals(NORTH)) {
            return this.getControlPoint(SOUTH);
        }
        if (string.equals(EAST)) {
            return this.getControlPoint(WEST);
        }
        if (string.equals(SOUTH)) {
            return this.getControlPoint(NORTH);
        }
        if (string.equals(WEST)) {
            return this.getControlPoint(EAST);
        }
        if (string.equals(NORTHEAST)) {
            return this.getControlPoint(SOUTHWEST);
        }
        if (string.equals(SOUTHEAST)) {
            return this.getControlPoint(NORTHWEST);
        }
        if (string.equals(SOUTHWEST)) {
            return this.getControlPoint(NORTHEAST);
        }
        if (string.equals(NORTHWEST)) {
            return this.getControlPoint(SOUTHEAST);
        }
        return null;
    }

    protected LatLon moveShapeByControlPoint(ControlPoint controlPoint, Globe globe, Angle angle, LatLon latLon, double d, double d2) {
        double d3 = globe.getRadiusAt(latLon);
        String string = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
        if (string == null) {
            return latLon;
        }
        LatLon latLon2 = latLon;
        for (int i = 0; i < 10; ++i) {
            LatLon latLon3 = this.computeControlPointLocation(string, globe, angle, latLon2, d, d2);
            Angle angle2 = LatLon.greatCircleAzimuth(latLon3, controlPoint.getPosition());
            Angle angle3 = LatLon.greatCircleDistance(latLon3, controlPoint.getPosition());
            double d4 = angle3.radians * d3;
            if (d4 < 0.01) break;
            latLon2 = LatLon.greatCircleEndPosition(latLon2, angle2, angle3);
        }
        return latLon2;
    }

    protected void swapEdgeControls(String string, Position position) {
        String string2;
        ControlPoint controlPoint;
        if (this.controlPoints.size() < 2) {
            return;
        }
        if (this.shapeCenterPosition == null || this.shapeOrientation == null) {
            return;
        }
        Angle angle = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position).subtract(this.shapeOrientation);
        angle = MeasureTool.computeNormalizedHeading(angle);
        if (string.equals(NORTH) && angle.degrees < 270.0 && angle.degrees > 90.0 || string.equals(SOUTH) && (angle.degrees > 270.0 || angle.degrees < 90.0)) {
            for (Renderable renderable : this.controlPoints) {
                controlPoint = (ControlPoint)renderable;
                string2 = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
                if (string2 == null) continue;
                if (string2.equals(NORTH)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, SOUTH);
                    continue;
                }
                if (!string2.equals(SOUTH)) continue;
                controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, NORTH);
            }
        }
        if (string.equals(EAST) && angle.degrees < 360.0 && angle.degrees > 180.0 || string.equals(WEST) && angle.degrees < 180.0 && angle.degrees > 0.0) {
            for (Renderable renderable : this.controlPoints) {
                controlPoint = (ControlPoint)renderable;
                string2 = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
                if (string2 == null) continue;
                if (string2.equals(EAST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, WEST);
                    continue;
                }
                if (!string2.equals(WEST)) continue;
                controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, EAST);
            }
        }
    }

    protected void swapCornerControls(String string, Position position) {
        String string2;
        ControlPoint controlPoint;
        if (this.controlPoints.size() < 2) {
            return;
        }
        String string3 = this.computeCornerControl(position);
        if (string.equals(string3)) {
            return;
        }
        if (string.length() != 2 || string3.length() != 2) {
            return;
        }
        if (string.charAt(0) != string3.charAt(0)) {
            for (Renderable renderable : this.controlPoints) {
                controlPoint = (ControlPoint)renderable;
                string2 = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
                if (string2 == null) continue;
                if (string2.equals(NORTHEAST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, SOUTHEAST);
                    continue;
                }
                if (string2.equals(SOUTHEAST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, NORTHEAST);
                    continue;
                }
                if (string2.equals(SOUTHWEST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, NORTHWEST);
                    continue;
                }
                if (!string2.equals(NORTHWEST)) continue;
                controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, SOUTHWEST);
            }
        }
        if (string.charAt(1) != string3.charAt(1)) {
            for (Renderable renderable : this.controlPoints) {
                controlPoint = (ControlPoint)renderable;
                string2 = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
                if (string2 == null) continue;
                if (string2.equals(NORTHEAST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, NORTHWEST);
                    continue;
                }
                if (string2.equals(SOUTHEAST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, SOUTHWEST);
                    continue;
                }
                if (string2.equals(SOUTHWEST)) {
                    controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, SOUTHEAST);
                    continue;
                }
                if (!string2.equals(NORTHWEST)) continue;
                controlPoint.setValue(CONTROL_TYPE_REGULAR_SHAPE, NORTHEAST);
            }
        }
    }

    protected LatLon computeControlPointLocation(String string, Globe globe, Angle angle, LatLon latLon, double d, double d2) {
        Angle angle2 = this.computeControlPointAzimuth(string, d, d2);
        Angle angle3 = this.computeControlPointPathLength(string, d, d2, globe.getRadiusAt(latLon));
        if (string.equals(CENTER)) {
            return latLon;
        }
        if (angle2 != null && angle3 != null) {
            angle2 = angle2.add(angle);
            return LatLon.greatCircleEndPosition(latLon, angle2, angle3);
        }
        return null;
    }

    protected LatLon computeQuadEdgeMidpointLocation(String string, Globe globe, Angle angle, LatLon latLon, double d, double d2) {
        LatLon latLon2 = this.computeControlPointLocation(NORTHEAST, globe, angle, latLon, d, d2);
        LatLon latLon3 = this.computeControlPointLocation(SOUTHEAST, globe, angle, latLon, d, d2);
        LatLon latLon4 = this.computeControlPointLocation(SOUTHWEST, globe, angle, latLon, d, d2);
        LatLon latLon5 = this.computeControlPointLocation(NORTHWEST, globe, angle, latLon, d, d2);
        if (string.equals(NORTH)) {
            return LatLon.interpolate(this.pathType, 0.5, latLon5, latLon2);
        }
        if (string.equals(EAST)) {
            return LatLon.interpolate(this.pathType, 0.5, latLon2, latLon3);
        }
        if (string.equals(SOUTH)) {
            return LatLon.interpolate(this.pathType, 0.5, latLon4, latLon3);
        }
        if (string.equals(WEST)) {
            return LatLon.interpolate(this.pathType, 0.5, latLon4, latLon5);
        }
        return null;
    }

    protected Angle computeControlPointAzimuth(String string, double d, double d2) {
        Angle angle = null;
        if (string.equals(NORTH)) {
            angle = Angle.ZERO;
        } else if (string.equals(EAST)) {
            angle = Angle.POS90;
        } else if (string.equals(SOUTH)) {
            angle = Angle.POS180;
        } else if (string.equals(WEST)) {
            angle = Angle.fromDegrees(270.0);
        } else if (string.equals(NORTHEAST)) {
            angle = Angle.fromRadians(Math.atan2(d, d2));
        } else if (string.equals(SOUTHEAST)) {
            angle = Angle.fromRadians(Math.atan2(d, -d2));
        } else if (string.equals(SOUTHWEST)) {
            angle = Angle.fromRadians(Math.atan2(-d, -d2));
        } else if (string.equals(NORTHWEST)) {
            angle = Angle.fromRadians(Math.atan2(-d, d2));
        } else if (string.equals(NORTH_LEADER)) {
            angle = Angle.ZERO;
        }
        return angle != null ? MeasureTool.computeNormalizedHeading(angle) : null;
    }

    protected Angle computeControlPointAzimuthInShapeCoordinates(String string, Angle angle) {
        if (string.equals(NORTHEAST)) {
            return angle.subtract(this.shapeOrientation);
        }
        if (string.equals(SOUTHEAST)) {
            return this.shapeOrientation.addDegrees(180.0).subtract(angle);
        }
        if (string.equals(SOUTHWEST)) {
            return angle.subtract(this.shapeOrientation.addDegrees(180.0));
        }
        if (string.equals(NORTHWEST)) {
            return this.shapeOrientation.subtract(angle);
        }
        return null;
    }

    protected Angle computeControlPointPathLength(String string, double d, double d2, double d3) {
        Angle angle = null;
        if (string.equals(NORTH) || string.equals(SOUTH)) {
            angle = Angle.fromRadians(d2 / 2.0 / d3);
        } else if (string.equals(EAST) || string.equals(WEST)) {
            angle = Angle.fromRadians(d / 2.0 / d3);
        } else if (string.equals(NORTHEAST) || string.equals(SOUTHEAST) || string.equals(SOUTHWEST) || string.equals(NORTHWEST)) {
            double d4 = Math.sqrt(d * d / 4.0 + d2 * d2 / 4.0);
            angle = Angle.fromRadians(d4 / d3);
        } else if (string.equals(NORTH_LEADER)) {
            angle = Angle.fromRadians(0.75 * d2 / d3);
        }
        return angle;
    }

    protected static Angle computeNormalizedHeading(Angle angle) {
        double d = angle.degrees % 360.0;
        double d2 = d > 360.0 ? d - 360.0 : (d < 0.0 ? 360.0 + d : d);
        return Angle.fromDegrees(d2);
    }

    protected void updateShapeControlPoints() {
        if (this.shapeCenterPosition != null) {
            if (this.controlPoints.size() < 1) {
                this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, CENTER);
            }
            ((ControlPoint)this.controlPoints.get(0)).setPosition(new Position(this.shapeCenterPosition, 0.0));
        }
        if (this.shapeRectangle != null) {
            if (this.controlPoints.size() < 5) {
                if (this.measureShapeType.equals(SHAPE_ELLIPSE) || this.measureShapeType.equals(SHAPE_CIRCLE)) {
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, NORTH);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, EAST);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, SOUTH);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, WEST);
                } else if (this.measureShapeType.equals(SHAPE_QUAD) || this.measureShapeType.equals(SHAPE_SQUARE)) {
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, NORTHEAST);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, SOUTHEAST);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, SOUTHWEST);
                    this.addControlPoint(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, NORTHWEST);
                }
                this.addControlPointWithLeader(Position.ZERO, CONTROL_TYPE_REGULAR_SHAPE, NORTH_LEADER, CONTROL_TYPE_LEADER_ORIGIN, NORTH);
            }
            Globe globe = this.getWwd().getModel().getGlobe();
            for (Renderable renderable : this.controlPoints) {
                LatLon latLon;
                ControlPoint controlPoint = (ControlPoint)renderable;
                String string = controlPoint.getStringValue(CONTROL_TYPE_REGULAR_SHAPE);
                if (string == null || (latLon = this.computeControlPointLocation(string, globe, this.shapeOrientation, this.shapeCenterPosition, this.shapeRectangle.getWidth(), this.shapeRectangle.getHeight())) == null) continue;
                controlPoint.setPosition(new Position(latLon, 0.0));
                if (!(controlPoint instanceof ControlPointWithLeader)) continue;
                this.updateControlPointWithLeader((ControlPointWithLeader)controlPoint, latLon);
            }
        }
    }

    protected void updateControlPointWithLeader(ControlPointWithLeader controlPointWithLeader, LatLon latLon) {
        Globe globe = this.getWwd().getModel().getGlobe();
        String string = controlPointWithLeader.getStringValue(CONTROL_TYPE_LEADER_ORIGIN);
        if (string == null) {
            return;
        }
        LatLon latLon2 = this.measureShapeType.equals(SHAPE_QUAD) || this.measureShapeType.equals(SHAPE_SQUARE) ? this.computeQuadEdgeMidpointLocation(string, globe, this.shapeOrientation, this.shapeCenterPosition, this.shapeRectangle.getWidth(), this.shapeRectangle.getHeight()) : this.computeControlPointLocation(string, globe, this.shapeOrientation, this.shapeCenterPosition, this.shapeRectangle.getWidth(), this.shapeRectangle.getHeight());
        if (latLon2 == null) {
            return;
        }
        controlPointWithLeader.setLeaderLocations(latLon2, latLon);
    }

    protected void updateMeasureShape() {
        if (this.measureShapeType.equals(SHAPE_LINE) || this.measureShapeType.equals(SHAPE_PATH)) {
            if (this.positions.size() > 1 && this.line == null) {
                this.line = new Polyline();
                this.line.setFollowTerrain(this.isFollowTerrain());
                this.line.setLineWidth(this.getLineWidth());
                this.line.setColor(this.getLineColor());
                this.line.setPathType(MeasureTool.polylinePathTypeFromKey(this.getPathType()));
                this.shapeLayer.addRenderable(this.line);
            }
            if (this.positions.size() < 2 && this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
            if (this.positions.size() > 1 && this.line != null) {
                this.line.setPositions(this.positions);
            }
            if (this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
            }
        } else if (this.measureShapeType.equals(SHAPE_POLYGON)) {
            if (this.positions.size() >= 4 && this.surfaceShape == null) {
                this.surfaceShape = new SurfacePolygon(this.positions);
                BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                basicShapeAttributes.setInteriorMaterial(new Material(this.getFillColor()));
                basicShapeAttributes.setInteriorOpacity((double)this.getFillColor().getAlpha() / 255.0);
                basicShapeAttributes.setOutlineMaterial(new Material(this.getLineColor()));
                basicShapeAttributes.setOutlineOpacity((double)this.getLineColor().getAlpha() / 255.0);
                basicShapeAttributes.setOutlineWidth(this.getLineWidth());
                this.surfaceShape.setAttributes(basicShapeAttributes);
                this.shapeLayer.addRenderable(this.surfaceShape);
            }
            if (this.positions.size() <= 3 && this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
            }
            if (this.surfaceShape != null) {
                ((SurfacePolygon)this.surfaceShape).setLocations(this.positions);
            }
            if (this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
        } else if (this.isRegularShape()) {
            if (this.shapeCenterPosition != null && this.shapeRectangle != null && this.surfaceShape == null) {
                if (this.measureShapeType.equals(SHAPE_QUAD)) {
                    this.surfaceShape = new SurfaceQuad(this.shapeCenterPosition, this.shapeRectangle.width, this.shapeRectangle.height, this.shapeOrientation);
                } else if (this.measureShapeType.equals(SHAPE_SQUARE)) {
                    this.surfaceShape = new SurfaceSquare(this.shapeCenterPosition, this.shapeRectangle.width);
                } else if (this.measureShapeType.equals(SHAPE_ELLIPSE)) {
                    this.surfaceShape = new SurfaceEllipse(this.shapeCenterPosition, this.shapeRectangle.width / 2.0, this.shapeRectangle.height / 2.0, this.shapeOrientation, this.shapeIntervals);
                } else if (this.measureShapeType.equals(SHAPE_CIRCLE)) {
                    this.surfaceShape = new SurfaceCircle((LatLon)this.shapeCenterPosition, this.shapeRectangle.width / 2.0, this.shapeIntervals);
                }
                BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                basicShapeAttributes.setInteriorMaterial(new Material(this.getFillColor()));
                basicShapeAttributes.setInteriorOpacity((double)this.getFillColor().getAlpha() / 255.0);
                basicShapeAttributes.setOutlineMaterial(new Material(this.getLineColor()));
                basicShapeAttributes.setOutlineOpacity((double)this.getLineColor().getAlpha() / 255.0);
                basicShapeAttributes.setOutlineWidth(this.getLineWidth());
                this.surfaceShape.setAttributes(basicShapeAttributes);
                this.shapeLayer.addRenderable(this.surfaceShape);
            }
            if (this.shapeRectangle == null && this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
                this.positions.clear();
            }
            if (this.surfaceShape != null) {
                if (this.measureShapeType.equals(SHAPE_QUAD) || this.measureShapeType.equals(SHAPE_SQUARE)) {
                    ((SurfaceQuad)this.surfaceShape).setCenter(this.shapeCenterPosition);
                    ((SurfaceQuad)this.surfaceShape).setSize(this.shapeRectangle.width, this.shapeRectangle.height);
                    ((SurfaceQuad)this.surfaceShape).setHeading(this.shapeOrientation);
                }
                if (this.measureShapeType.equals(SHAPE_ELLIPSE) || this.measureShapeType.equals(SHAPE_CIRCLE)) {
                    ((SurfaceEllipse)this.surfaceShape).setCenter(this.shapeCenterPosition);
                    ((SurfaceEllipse)this.surfaceShape).setRadii(this.shapeRectangle.width / 2.0, this.shapeRectangle.height / 2.0);
                    ((SurfaceEllipse)this.surfaceShape).setHeading(this.shapeOrientation);
                }
                this.updatePositionsFromShape();
            }
            if (this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
        }
    }

    protected void updatePositionsFromShape() {
        Globe globe = this.wwd.getModel().getGlobe();
        this.positions.clear();
        Iterable<? extends LatLon> iterable = this.surfaceShape.getLocations(globe);
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                this.positions.add(new Position(latLon, 0.0));
            }
        }
    }

    @Override
    public void dispose() {
        this.setController(null);
        if (this.applicationLayer != null) {
            this.applicationLayer.removeRenderable(this.layer);
        } else {
            this.wwd.getModel().getLayers().remove(this.layer);
        }
        this.layer.removeAllRenderables();
        this.shapeLayer.removeAllRenderables();
        this.controlPoints.clear();
    }

    protected void addControlPoint(Position position, String string, Object object) {
        ControlPoint controlPoint = new ControlPoint(new Position(position, 0.0), this.controlPointsAttributes, this);
        controlPoint.setValue(string, object);
        this.doAddControlPoint(controlPoint);
    }

    protected void addControlPointWithLeader(Position position, String string, Object object, String string2, Object object2) {
        ControlPointWithLeader controlPointWithLeader = new ControlPointWithLeader(new Position(position, 0.0), this.controlPointWithLeaderAttributes, this.leaderAttributes, this);
        controlPointWithLeader.setValue(string, object);
        controlPointWithLeader.setValue(string2, object2);
        this.doAddControlPoint(controlPointWithLeader);
    }

    protected void doAddControlPoint(ControlPoint controlPoint) {
        this.controlPoints.add(controlPoint);
        this.controlPointsLayer.setRenderables(this.controlPoints);
    }

    public void updateAnnotation(Position position) {
        if (position == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        String string = this.getDisplayString(position);
        if (string == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        this.annotation.setText(string);
        this.annotation.setPosition(position);
        this.annotation.getAttributes().setVisible(true);
    }

    protected String getDisplayString(Position position) {
        String string = null;
        if (position != null) {
            if (this.measureShapeType.equals(SHAPE_CIRCLE) && this.shapeRectangle != null) {
                string = this.formatCircleMeasurements(position);
            } else if (this.measureShapeType.equals(SHAPE_SQUARE) && this.shapeRectangle != null) {
                string = this.formatSquareMeasurements(position);
            } else if (this.measureShapeType.equals(SHAPE_QUAD) && this.shapeRectangle != null) {
                string = this.formatQuadMeasurements(position);
            } else if (this.measureShapeType.equals(SHAPE_ELLIPSE) && this.shapeRectangle != null) {
                string = this.formatEllipseMeasurements(position);
            } else if (this.measureShapeType.equals(SHAPE_LINE) || this.measureShapeType.equals(SHAPE_PATH)) {
                string = this.formatLineMeasurements(position);
            } else if (this.measureShapeType.equals(SHAPE_POLYGON)) {
                string = this.formatPolygonMeasurements(position);
            }
        }
        return string;
    }

    protected String formatCircleMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.areaNL(this.getLabel(AREA_LABEL), this.getArea()));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(PERIMETER_LABEL), this.getLength()));
        if (this.shapeRectangle != null) {
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(RADIUS_LABEL), this.shapeRectangle.width / 2.0));
        }
        if (this.getCenterPosition() != null && this.areLocationsRedundant(this.getCenterPosition(), position)) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LATITUDE_LABEL), this.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LONGITUDE_LABEL), this.getCenterPosition().getLongitude()));
        }
        if (!this.areLocationsRedundant(position, this.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        }
        return stringBuilder.toString();
    }

    protected String formatEllipseMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.areaNL(this.getLabel(AREA_LABEL), this.getArea()));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(PERIMETER_LABEL), this.getLength()));
        if (this.shapeRectangle != null) {
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(MAJOR_AXIS_LABEL), this.shapeRectangle.width));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(MINOR_AXIS_LABEL), this.shapeRectangle.height));
        }
        if (this.getOrientation() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(HEADING_LABEL), this.getOrientation()));
        }
        if (this.getCenterPosition() != null && this.areLocationsRedundant(this.getCenterPosition(), position)) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LATITUDE_LABEL), this.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LONGITUDE_LABEL), this.getCenterPosition().getLongitude()));
        }
        if (!this.areLocationsRedundant(position, this.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        }
        return stringBuilder.toString();
    }

    protected String formatSquareMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.areaNL(this.getLabel(AREA_LABEL), this.getArea()));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(PERIMETER_LABEL), this.getLength()));
        if (this.shapeRectangle != null) {
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(WIDTH_LABEL), this.shapeRectangle.width));
        }
        if (this.getOrientation() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(HEADING_LABEL), this.getOrientation()));
        }
        if (this.getCenterPosition() != null && this.areLocationsRedundant(this.getCenterPosition(), position)) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LATITUDE_LABEL), this.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LONGITUDE_LABEL), this.getCenterPosition().getLongitude()));
        }
        if (!this.areLocationsRedundant(position, this.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        }
        return stringBuilder.toString();
    }

    protected String formatQuadMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.areaNL(this.getLabel(AREA_LABEL), this.getArea()));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(PERIMETER_LABEL), this.getLength()));
        if (this.shapeRectangle != null) {
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(WIDTH_LABEL), this.shapeRectangle.width));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(HEIGHT_LABEL), this.shapeRectangle.height));
        }
        if (this.getOrientation() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(HEADING_LABEL), this.getOrientation()));
        }
        if (this.getCenterPosition() != null && this.areLocationsRedundant(this.getCenterPosition(), position)) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LATITUDE_LABEL), this.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LONGITUDE_LABEL), this.getCenterPosition().getLongitude()));
        }
        if (!this.areLocationsRedundant(position, this.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        }
        return stringBuilder.toString();
    }

    protected String formatPolygonMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.areaNL(this.getLabel(AREA_LABEL), this.getArea()));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(PERIMETER_LABEL), this.getLength()));
        if (this.getCenterPosition() != null && this.areLocationsRedundant(this.getCenterPosition(), position)) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LATITUDE_LABEL), this.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(CENTER_LONGITUDE_LABEL), this.getCenterPosition().getLongitude()));
        }
        if (!this.areLocationsRedundant(position, this.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        }
        return stringBuilder.toString();
    }

    protected String formatLineMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(LENGTH_LABEL), this.getLength()));
        Double d = this.computeAccumulatedLength(position);
        if (d != null && d >= 1.0 && !this.lengthsEssentiallyEqual(this.getLength(), d)) {
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel(ACCUMULATED_LABEL), d));
        }
        if (this.getOrientation() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(HEADING_LABEL), this.getOrientation()));
        }
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LATITUDE_LABEL), position.getLatitude()));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel(LONGITUDE_LABEL), position.getLongitude()));
        return stringBuilder.toString();
    }

    protected Double computeAccumulatedLength(LatLon latLon) {
        double d;
        if (this.positions.size() <= 2) {
            return null;
        }
        double d2 = this.wwd.getModel().getGlobe().getRadius();
        double d3 = 0.0;
        int n = 0;
        LatLon latLon2 = this.positions.get(n);
        for (int i = 1; i < this.positions.size(); ++i) {
            LatLon latLon3 = this.positions.get(i);
            double d4 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon3).radians * d2;
            double d5 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon).radians * d2;
            double d6 = LatLon.greatCircleDistance((LatLon)latLon3, (LatLon)latLon).radians * d2;
            if (d5 <= d4 && d6 <= d4) {
                d3 += d5 / (d5 + d6) * d4;
                break;
            }
            d3 += d4;
            latLon2 = latLon3;
        }
        return d3 < (d = this.computePathLength()) ? Double.valueOf(this.getLength() * (d3 / d)) : null;
    }

    protected double computePathLength() {
        double d = 0.0;
        LatLon latLon = null;
        for (LatLon latLon2 : this.positions) {
            if (latLon != null) {
                d += LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon2).radians;
            }
            latLon = latLon2;
        }
        return d * this.wwd.getModel().getGlobe().getRadius();
    }

    protected Angle computeAngleBetween(LatLon latLon, LatLon latLon2, LatLon latLon3) {
        Vec4 vec4 = new Vec4(latLon2.getLatitude().radians - latLon.getLatitude().radians, latLon2.getLongitude().radians - latLon.getLongitude().radians, 0.0);
        Vec4 vec42 = new Vec4(latLon3.getLatitude().radians - latLon2.getLatitude().radians, latLon3.getLongitude().radians - latLon2.getLongitude().radians, 0.0);
        return vec4.angleBetween3(vec42);
    }

    protected boolean lengthsEssentiallyEqual(Double d, Double d2) {
        return Math.abs(d - d2) / d < 0.001;
    }

    protected boolean areLocationsRedundant(LatLon latLon, LatLon latLon2) {
        String string;
        if (latLon == null || latLon2 == null) {
            return false;
        }
        String string2 = this.unitsFormat.angleNL("", latLon.getLatitude());
        if (!string2.equals(string = this.unitsFormat.angleNL("", latLon2.getLatitude()))) {
            return false;
        }
        String string3 = this.unitsFormat.angleNL("", latLon.getLongitude());
        String string4 = this.unitsFormat.angleNL("", latLon2.getLongitude());
        return string3.equals(string4);
    }

    protected static class CustomRenderableLayer
    extends RenderableLayer
    implements PreRenderable,
    Renderable {
        protected CustomRenderableLayer() {
        }

        @Override
        public void render(DrawContext drawContext) {
            if (drawContext.isPickingMode() && !this.isPickEnabled()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            super.render(drawContext);
        }
    }

    public static class ControlPoint
    extends GlobeAnnotation {
        MeasureTool parent;

        public ControlPoint(Position position, AnnotationAttributes annotationAttributes, MeasureTool measureTool) {
            super("", position, annotationAttributes);
            this.parent = measureTool;
        }

        public MeasureTool getParent() {
            return this.parent;
        }
    }

    protected static class ControlPointWithLeader
    extends ControlPoint
    implements PreRenderable {
        protected SurfacePolyline leaderLine;

        public ControlPointWithLeader(Position position, AnnotationAttributes annotationAttributes, ShapeAttributes shapeAttributes, MeasureTool measureTool) {
            super(position, annotationAttributes, measureTool);
            this.leaderLine = new SurfacePolyline(shapeAttributes);
        }

        @Override
        public void preRender(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.leaderLine != null) {
                this.leaderLine.preRender(drawContext);
            }
        }

        @Override
        public void render(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.leaderLine != null) {
                this.leaderLine.render(drawContext);
            }
            super.render(drawContext);
        }

        public void setLeaderLocations(LatLon latLon, LatLon latLon2) {
            if (latLon == null) {
                String string = Logging.getMessage("nullValue.BeginIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (latLon2 == null) {
                String string = Logging.getMessage("nullValue.EndIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.leaderLine.setLocations(Arrays.asList(latLon, latLon2));
        }
    }
}

