/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.tree.DragControl;
import gov.nasa.worldwind.util.tree.TreeHotSpot;
import gov.nasa.worldwind.util.tree.TreeUtil;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ScrollBar
implements Renderable {
    public static final String UNIT_UP = "gov.nasa.util.ScrollBar.UnitUp";
    public static final String UNIT_DOWN = "gov.nasa.util.ScrollBar.UnitDown";
    public static final String BLOCK_UP = "gov.nasa.util.ScrollBar.BlockUp";
    public static final String BLOCK_DOWN = "gov.nasa.util.ScrollBar.BlockDown";
    protected static final int DEFAULT_MIN_VALUE = 0;
    protected static final int DEFAULT_MAX_VALUE = 100;
    protected static final int DEFAULT_UNIT_INCREMENT = 5;
    protected static final int DEFAULT_MIN_SCROLL_KNOB_SIZE = 10;
    protected static final int DEFAULT_AUTO_SCROLL_DELAY = 20;
    protected static final Insets DEFAULT_ARROW_INSETS = new Insets(2, 2, 2, 2);
    protected static final double DEFAULT_OPACITY = 1.0;
    protected static final Color DEFAULT_LINE_COLOR = Color.BLACK;
    protected static final Color DEFAULT_SCROLL_KNOB_COLOR1 = new Color(29, 78, 169);
    protected static final Color DEFAULT_SCROLL_KNOB_COLOR2 = new Color(93, 158, 223);
    protected int minValue = 0;
    protected int maxValue = 100;
    protected int value;
    protected int extent;
    protected int unitIncrement = 5;
    protected int scrollArrowSize;
    protected int minScrollKnobSize = 10;
    protected PickSupport pickSupport = new PickSupport();
    protected Rectangle bounds = new Rectangle();
    protected Rectangle scrollBounds = new Rectangle();
    protected Insets arrowInsets = DEFAULT_ARROW_INSETS;
    protected String orientation;
    protected double opacity = 1.0;
    protected Color lineColor = DEFAULT_LINE_COLOR;
    protected Color knobColor1 = DEFAULT_SCROLL_KNOB_COLOR1;
    protected Color knobColor2 = DEFAULT_SCROLL_KNOB_COLOR2;
    protected int autoScrollDelay = 20;
    protected boolean autoScrolling;
    protected String autoScrollIncrement;
    protected HotSpot scrollUpControl;
    protected HotSpot scrollDownControl;
    protected HotSpot scrollUpBlockControl;
    protected HotSpot scrollDownBlockControl;
    protected ScrollKnob scrollKnobControl;
    protected long frameNumber = -1L;
    protected Rectangle scrollUpControlBounds;
    protected Rectangle scrollDownControlBounds;
    protected Rectangle scrollKnobBounds;
    protected Rectangle scrollUpBarBounds;
    protected Rectangle scrollDownBarBounds;
    protected long nextAutoScroll;

    public ScrollBar(HotSpot hotSpot) {
        this.setOrientation("gov.nasa.worldwind.avkey.Vertical");
        this.initializeUIControls(hotSpot);
    }

    public ScrollBar(HotSpot hotSpot, String string) {
        this.setOrientation(string);
        this.initializeUIControls(hotSpot);
    }

    protected void initializeUIControls(HotSpot hotSpot) {
        this.scrollKnobControl = new ScrollKnob(hotSpot, this);
        this.scrollUpControl = new ScrollControl(hotSpot, this, UNIT_UP);
        this.scrollDownControl = new ScrollControl(hotSpot, this, UNIT_DOWN);
        this.scrollUpBlockControl = new ScrollControl(hotSpot, this, BLOCK_UP);
        this.scrollDownBlockControl = new ScrollControl(hotSpot, this, BLOCK_DOWN);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
        this.scrollArrowSize = "gov.nasa.worldwind.avkey.Vertical".equals(this.getOrientation()) ? rectangle.width : rectangle.height;
        this.scrollBounds = new Rectangle(rectangle.x, rectangle.y + this.scrollArrowSize, rectangle.width, rectangle.height - 2 * this.scrollArrowSize);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "minValue < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minValue = n;
        if (this.getValue() < this.minValue) {
            this.setValue(this.minValue);
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxValue < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxValue = n;
        if (this.getValue() > this.maxValue) {
            this.setValue(this.maxValue);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = WWMath.clamp(n, this.getMinValue(), this.getMaxValue() - this.getExtent());
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int n) {
        if (n <= 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "unitIncrement <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.unitIncrement = n;
    }

    public int getBlockIncrement() {
        return this.extent;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.orientation = string;
    }

    public int getExtent() {
        return this.extent;
    }

    public void setExtent(int n) {
        this.extent = Math.min(n, this.getMaxValue() - this.getMinValue());
        if (this.getValue() + this.getExtent() > this.getMaxValue()) {
            this.setValue(this.getMaxValue() - this.getExtent());
        }
    }

    public double getValueAsPercentage() {
        return (double)this.getValue() / (double)(this.getMaxValue() - this.getMinValue());
    }

    public int getMinScrollKnobSize() {
        return this.minScrollKnobSize;
    }

    public void setMinScrollKnobSize(int n) {
        this.minScrollKnobSize = n;
    }

    protected int getKnobSize(int n) {
        return (int)Math.max((double)n * ((double)this.getExtent() / (double)(this.getMaxValue() - this.minValue)), (double)this.getMinScrollKnobSize());
    }

    protected int getScrollArrowSize() {
        return this.scrollArrowSize;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lineColor = color;
    }

    public void setKnobColor(Color color, Color color2) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.knobColor1 = color;
        this.knobColor2 = color2;
    }

    public Color[] getKnobColor() {
        return new Color[]{this.knobColor1, this.knobColor2};
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public int getAutoScrollDelay() {
        return this.autoScrollDelay;
    }

    public void setAutoScrollDelay(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.autoScrollDelay = n;
    }

    public void scroll(int n) {
        this.setValue(this.getValue() + n);
    }

    public void scroll(String string) {
        if (UNIT_UP.equals(string)) {
            this.scroll(-this.getUnitIncrement());
        } else if (UNIT_DOWN.equals(string)) {
            this.scroll(this.getUnitIncrement());
        } else if (BLOCK_UP.equals(string)) {
            this.scroll(-this.getBlockIncrement());
        } else if (BLOCK_DOWN.equals(string)) {
            this.scroll(this.getBlockIncrement());
        }
    }

    public void startAutoScroll(String string) {
        this.autoScrolling = true;
        this.autoScrollIncrement = string;
    }

    public void stopAutoScroll() {
        this.autoScrolling = false;
    }

    public boolean isAutoScrolling() {
        return this.autoScrolling;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.frameNumber) {
            long l;
            if (this.isAutoScrolling() && (l = System.currentTimeMillis()) > this.nextAutoScroll) {
                int n = this.getAutoScrollDelay();
                this.scroll(this.autoScrollIncrement);
                drawContext.setRedrawRequested(n);
                this.nextAutoScroll = l + (long)n;
            }
            this.computeBounds();
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
        if (!this.canDrawInBounds()) {
            return;
        }
        if (drawContext.isPickingMode()) {
            this.doPick(drawContext);
        } else {
            this.draw(drawContext);
        }
    }

    protected boolean canDrawInBounds() {
        int n = this.getScrollArrowSize();
        String string = this.getOrientation();
        if ("gov.nasa.worldwind.avkey.Vertical".equals(string)) {
            return this.bounds.height >= n * 2 + this.getMinScrollKnobSize() && this.bounds.width >= n;
        }
        return this.bounds.width >= n * 2 + this.getMinScrollKnobSize() && this.bounds.height >= n;
    }

    protected void computeBounds() {
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        int n3 = this.bounds.x + this.bounds.width;
        int n4 = this.bounds.y + this.bounds.height;
        int n5 = this.getScrollArrowSize();
        if ("gov.nasa.worldwind.avkey.Vertical".equals(this.getOrientation())) {
            this.scrollDownControlBounds = new Rectangle(n, n2, n5, n5);
            this.scrollUpControlBounds = new Rectangle(n, n4 - n5, n5, n5);
            int n6 = this.bounds.height - 2 * n5;
            int n7 = (int)((double)n6 * this.getValueAsPercentage());
            int n8 = n4 - n5 - n7 - this.getKnobSize(n6);
            if (n8 < n2 + n5) {
                n8 = n2 + n5;
            }
            this.scrollKnobBounds = new Rectangle(n, n8 - 1, n5, this.getKnobSize(n6) + 1);
            this.scrollDownBarBounds = new Rectangle(n, n2 + n5, n5, n8 - n2 - n5);
            int n9 = (int)this.scrollKnobBounds.getMaxY();
            this.scrollUpBarBounds = new Rectangle(n, n9, n5, this.scrollUpControlBounds.y - n9);
        } else {
            this.scrollUpControlBounds = new Rectangle(n, n2, n5, n5);
            this.scrollDownControlBounds = new Rectangle(n3 - n5, n2, n5, n5);
            int n10 = this.bounds.width - 2 * n5;
            int n11 = (int)((double)n10 * this.getValueAsPercentage());
            int n12 = n + n5 + n11;
            int n13 = this.getKnobSize(n10);
            this.scrollKnobBounds = new Rectangle(n12, n2, n13 + 1, n5);
            if (this.scrollKnobBounds.getMaxX() > (double)(n3 - n5)) {
                this.scrollKnobBounds.x = n3 - n5 - n13;
            }
            this.scrollUpBarBounds = new Rectangle(n + n5, n2, this.scrollKnobBounds.x - n5 - n, n5);
            int n14 = (int)this.scrollKnobBounds.getMaxX();
            this.scrollDownBarBounds = new Rectangle(n14, n2, this.scrollDownControlBounds.x - n14, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 16397);
            gL2.glLineWidth(1.0f);
            OGLUtil.applyColor(gL2, this.getLineColor(), this.getOpacity(), false);
            gL2.glPolygonMode(1028, 6913);
            try {
                gL2.glBegin(7);
                this.drawQuad(drawContext, this.bounds);
                this.drawQuad(drawContext, this.scrollDownControlBounds);
                this.drawQuad(drawContext, this.scrollUpControlBounds);
            }
            finally {
                gL2.glEnd();
            }
            gL2.glPolygonMode(1032, 6914);
            String string = "gov.nasa.worldwind.avkey.Vertical".equals(this.getOrientation()) ? "gov.nasa.worldwind.avkey.Horizontal" : "gov.nasa.worldwind.avkey.Vertical";
            TreeUtil.drawRectWithGradient(gL2, this.scrollKnobBounds, this.knobColor2, this.knobColor1, this.getOpacity(), string);
            OGLUtil.applyColor(gL2, this.getLineColor(), this.getOpacity(), false);
            gL2.glBegin(2);
            this.drawQuad(drawContext, this.scrollKnobBounds);
            gL2.glEnd();
            gL2.glPolygonMode(1032, 6914);
            if ("gov.nasa.worldwind.avkey.Vertical".equals(this.getOrientation())) {
                this.drawTriangle(drawContext, 90.0f, this.scrollUpControlBounds, this.arrowInsets);
                this.drawTriangle(drawContext, -90.0f, this.scrollDownControlBounds, this.arrowInsets);
            } else {
                this.drawTriangle(drawContext, 180.0f, this.scrollUpControlBounds, this.arrowInsets);
                this.drawTriangle(drawContext, 0.0f, this.scrollDownControlBounds, this.arrowInsets);
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected void doPick(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            this.pickSupport.clearPickList();
            this.pickSupport.beginPicking(drawContext);
            gL2.glBegin(7);
            this.drawPickableQuad(drawContext, this.scrollDownControl, this.scrollDownControlBounds);
            this.drawPickableQuad(drawContext, this.scrollUpControl, this.scrollUpControlBounds);
            this.drawPickableQuad(drawContext, this.scrollDownBlockControl, this.scrollDownBarBounds);
            this.drawPickableQuad(drawContext, this.scrollUpBlockControl, this.scrollUpBarBounds);
            this.drawPickableQuad(drawContext, this.scrollKnobControl, this.scrollKnobBounds);
        }
        finally {
            gL2.glEnd();
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), drawContext.getCurrentLayer());
        }
    }

    protected void drawPickableQuad(DrawContext drawContext, Object object, Rectangle rectangle) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        this.pickSupport.addPickableObject(n, object);
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        this.drawQuad(drawContext, rectangle);
    }

    protected void drawQuad(DrawContext drawContext, Rectangle rectangle) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = (int)rectangle.getMinX();
        int n2 = (int)rectangle.getMinY();
        int n3 = (int)rectangle.getMaxX();
        int n4 = (int)rectangle.getMaxY();
        gL2.glVertex2i(n, n2);
        gL2.glVertex2i(n3, n2);
        gL2.glVertex2i(n3, n4);
        gL2.glVertex2i(n, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTriangle(DrawContext drawContext, float f, Rectangle rectangle, Insets insets) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            gL2.glPushMatrix();
            Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.bottom, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
            float f2 = (float)rectangle2.height / 2.0f;
            float f3 = (float)rectangle2.width / 2.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (f == 90.0f) {
                f4 = f3;
                f5 = ((float)rectangle2.height - f3) / 2.0f;
            } else if (f == -90.0f) {
                f4 = f3;
                f5 = ((float)rectangle2.height - f3) / 2.0f + f3;
            } else if (f == 0.0f) {
                f4 = ((float)rectangle2.width - f3) / 2.0f;
                f5 = f2;
            } else if (f == 180.0f) {
                f4 = ((float)rectangle2.width - f3) / 2.0f + f3;
                f5 = f2;
            }
            gL2.glTranslated((float)rectangle2.x + f4, (float)rectangle2.y + f5, 1.0);
            gL2.glRotatef(f, 0.0f, 0.0f, 1.0f);
            gL2.glBegin(4);
            gL2.glVertex2f(0.0f, f2);
            gL2.glVertex2f(f3, 0.0f);
            gL2.glVertex2f(0.0f, -f2);
            gL2.glEnd();
        }
        finally {
            gL2.glPopMatrix();
        }
    }

    public class ScrollKnob
    extends DragControl {
        protected ScrollBar scrollBar;
        protected int dragRefValue;

        public ScrollKnob(HotSpot hotSpot, ScrollBar scrollBar2) {
            super(hotSpot);
            this.scrollBar = scrollBar2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        protected void beginDrag(Point point) {
            super.beginDrag(point);
            this.dragRefValue = this.scrollBar.getValue();
        }

        @Override
        protected void drag(Point point) {
            int n;
            int n2;
            if ("gov.nasa.worldwind.avkey.Vertical".equals(this.scrollBar.getOrientation())) {
                n2 = point.y - this.dragRefPoint.y;
                n = this.scrollBar.scrollBounds.height - this.scrollBar.getMinScrollKnobSize();
            } else {
                n2 = point.x - this.dragRefPoint.x;
                n = this.scrollBar.scrollBounds.width;
            }
            int n3 = this.scrollBar.getMaxValue() - this.scrollBar.getMinValue();
            int n4 = (int)((double)n2 / (double)n * (double)n3);
            this.scrollBar.setValue(this.dragRefValue + n4);
        }
    }

    public class ScrollControl
    extends TreeHotSpot {
        protected ScrollBar scrollBar;
        protected String adjustment;

        public ScrollControl(HotSpot hotSpot, ScrollBar scrollBar2, String string) {
            super(hotSpot);
            this.scrollBar = scrollBar2;
            this.adjustment = string;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.isConsumed()) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                this.scrollBar.startAutoScroll(this.adjustment);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.isConsumed()) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                this.scrollBar.stopAutoScroll();
            }
        }

        @Override
        public void selected(SelectEvent selectEvent) {
            if (selectEvent == null || selectEvent.isConsumed()) {
                return;
            }
            if (selectEvent.isDrag()) {
                selectEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void setActive(boolean bl) {
            if (!bl) {
                this.scrollBar.stopAutoScroll();
            }
            super.setActive(bl);
        }
    }
}

