/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.awt.Rectangle;

public class TreeUtil {
    public static void drawPickableRect(DrawContext drawContext, PickSupport pickSupport, Object object, Rectangle rectangle) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawingContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        pickSupport.addPickableObject(n, object);
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        TreeUtil.drawRect(gL2, rectangle);
    }

    public static void drawRect(GL2 gL2, Rectangle rectangle) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gL2.glRecti(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static void drawRectWithGradient(GL2 gL2, Rectangle rectangle, Color color, Color color2, double d, String string) {
        if (gL2 == null) {
            String string2 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rectangle == null) {
            String string3 = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        gL2.glBegin(7);
        if ("gov.nasa.worldwind.avkey.Horizontal".equals(string)) {
            OGLUtil.applyColor(gL2, color, d, false);
            gL2.glVertex2d(rectangle.getMinX(), rectangle.getMaxY());
            gL2.glVertex2d(rectangle.getMinX(), rectangle.getMinY());
            OGLUtil.applyColor(gL2, color2, d, false);
            gL2.glVertex2d(rectangle.getMaxX(), rectangle.getMinY());
            gL2.glVertex2d(rectangle.getMaxX(), rectangle.getMaxY());
        } else {
            OGLUtil.applyColor(gL2, color, d, false);
            gL2.glVertex2d(rectangle.getMaxX(), rectangle.getMaxY());
            gL2.glVertex2d(rectangle.getMinX(), rectangle.getMaxY());
            OGLUtil.applyColor(gL2, color2, d, false);
            gL2.glVertex2d(rectangle.getMinX(), rectangle.getMinY());
            gL2.glVertex2d(rectangle.getMaxX(), rectangle.getMinY());
        }
        gL2.glEnd();
    }
}

