/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.webview;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Dimension;
import java.util.logging.Level;

public class WebViewTexture
extends BasicWWTexture {
    protected Dimension frameSize;
    protected boolean flipVertically;

    public WebViewTexture(Dimension dimension, boolean bl, boolean bl2) {
        super(new Object(), bl);
        this.frameSize = dimension;
        this.flipVertically = bl2;
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        boolean bl = super.bind(drawContext);
        if (bl) {
            this.updateIfNeeded(drawContext);
        }
        return bl;
    }

    @Override
    protected Texture initializeTexture(DrawContext drawContext, Object object) {
        Texture texture;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.textureInitializationFailed) {
            return null;
        }
        GL gL = drawContext.getGL();
        try {
            TextureData textureData = new TextureData(gL.getGLProfile(), 6408, this.frameSize.width, this.frameSize.height, 0, 6408, 5121, false, false, this.flipVertically, Buffers.newDirectByteBuffer(4 * this.frameSize.width * this.frameSize.height), null);
            texture = TextureIO.newTexture(textureData);
            drawContext.getTextureCache().put(object, texture);
            texture.bind(gL);
            gL.glTexParameteri(3553, 10241, 9728);
            gL.glTexParameteri(3553, 10240, 9728);
            gL.glTexParameteri(3553, 10242, 33069);
            gL.glTexParameteri(3553, 10243, 33069);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
            Logging.logger().log(Level.SEVERE, string, exception);
            this.textureInitializationFailed = true;
            return null;
        }
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        this.texCoords = texture.getImageTexCoords();
        return texture;
    }

    protected void updateIfNeeded(DrawContext drawContext) {
    }
}

