/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.view.BasicViewPropertyLimits;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewLimits;

public class BasicOrbitViewLimits
extends BasicViewPropertyLimits
implements OrbitViewLimits {
    protected Sector centerLocationLimits;
    protected double minCenterElevation;
    protected double maxCenterElevation;
    protected double minZoom;
    protected double maxZoom;

    public BasicOrbitViewLimits() {
        this.reset();
    }

    @Override
    public Sector getCenterLocationLimits() {
        return this.centerLocationLimits;
    }

    @Override
    public void setCenterLocationLimits(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerLocationLimits = sector;
    }

    @Override
    public double[] getCenterElevationLimits() {
        return new double[]{this.minCenterElevation, this.maxCenterElevation};
    }

    @Override
    public void setCenterElevationLimits(double d, double d2) {
        this.minCenterElevation = d;
        this.maxCenterElevation = d2;
    }

    @Override
    public double[] getZoomLimits() {
        return new double[]{this.minZoom, this.maxZoom};
    }

    @Override
    public void setZoomLimits(double d, double d2) {
        this.minZoom = d;
        this.maxZoom = d2;
    }

    @Override
    public void reset() {
        super.reset();
        this.centerLocationLimits = Sector.FULL_SPHERE;
        this.minCenterElevation = -1.7976931348623157E308;
        this.maxCenterElevation = Double.MAX_VALUE;
        this.minZoom = 0.0;
        this.maxZoom = Double.MAX_VALUE;
    }

    @Override
    public Position limitCenterPosition(View view, Position position) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = this.centerLocationLimits;
        Angle angle = Angle.clamp(position.latitude, sector.getMinLatitude(), sector.getMaxLatitude());
        Angle angle2 = Angle.clamp(position.longitude, sector.getMinLongitude(), sector.getMaxLongitude());
        double d = WWMath.clamp(position.elevation, this.minCenterElevation, this.maxCenterElevation);
        return new Position(angle, angle2, d);
    }

    @Override
    public double limitZoom(View view, double d) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = this.minZoom;
        double d3 = this.maxZoom;
        if (this.is2DGlobe(view.getGlobe())) {
            double d4 = Math.PI * view.getGlobe().getEquatorialRadius() / view.getFieldOfView().tanHalfAngle();
            if (d2 > d4) {
                d2 = d4;
            }
            if (d3 > d4) {
                d3 = d4;
            }
        }
        return WWMath.clamp(d, d2, d3);
    }

    public static void applyLimits(OrbitView orbitView, OrbitViewLimits orbitViewLimits) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        orbitView.setCenterPosition(BasicOrbitViewLimits.limitCenterPosition(orbitView.getCenterPosition(), orbitViewLimits));
        orbitView.setHeading(BasicOrbitViewLimits.limitHeading(orbitView.getHeading(), orbitViewLimits));
        orbitView.setPitch(BasicOrbitViewLimits.limitPitch(orbitView.getPitch(), orbitViewLimits));
        orbitView.setZoom(BasicOrbitViewLimits.limitZoom(orbitView.getZoom(), orbitViewLimits));
    }

    public static Position limitCenterPosition(Position position, OrbitViewLimits orbitViewLimits) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Position(BasicOrbitViewLimits.limitCenterLocation(position.getLatitude(), position.getLongitude(), orbitViewLimits), BasicOrbitViewLimits.limitCenterElevation(position.getElevation(), orbitViewLimits));
    }

    public static LatLon limitCenterLocation(Angle angle, Angle angle2, OrbitViewLimits orbitViewLimits) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = orbitViewLimits.getCenterLocationLimits();
        Angle angle3 = angle;
        Angle angle4 = angle2;
        if (angle.compareTo(sector.getMinLatitude()) < 0) {
            angle3 = sector.getMinLatitude();
        } else if (angle.compareTo(sector.getMaxLatitude()) > 0) {
            angle3 = sector.getMaxLatitude();
        }
        if (angle2.compareTo(sector.getMinLongitude()) < 0) {
            angle4 = sector.getMinLongitude();
        } else if (angle2.compareTo(sector.getMaxLongitude()) > 0) {
            angle4 = sector.getMaxLongitude();
        }
        return new LatLon(angle3, angle4);
    }

    public static double limitCenterElevation(double d, OrbitViewLimits orbitViewLimits) {
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = orbitViewLimits.getCenterElevationLimits();
        double d2 = d;
        if (d < dArray[0]) {
            d2 = dArray[0];
        } else if (d > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    public static double limitZoom(double d, OrbitViewLimits orbitViewLimits) {
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = orbitViewLimits.getZoomLimits();
        double d2 = d;
        if (d < dArray[0]) {
            d2 = dArray[0];
        } else if (d > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    @Override
    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.getRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsSector(stateObject, "centerLocationLimits", this.centerLocationLimits);
        restorableSupport.addStateValueAsDouble(stateObject, "minCenterElevation", this.minCenterElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "maxCenterElevation", this.maxCenterElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "minZoom", this.minZoom);
        restorableSupport.addStateValueAsDouble(stateObject, "maxZoom", this.maxZoom);
    }

    @Override
    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.restoreState(restorableSupport, stateObject);
        Sector sector = restorableSupport.getStateValueAsSector(stateObject, "centerLocationLimits");
        if (sector != null) {
            this.setCenterLocationLimits(sector);
        }
        double[] dArray = this.getCenterElevationLimits();
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "minCenterElevation");
        if (d2 != null) {
            dArray[0] = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxCenterElevation")) != null) {
            dArray[1] = d;
        }
        if (d2 != null || d != null) {
            this.setCenterElevationLimits(dArray[0], dArray[1]);
        }
        dArray = this.getZoomLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minZoom");
        if (d2 != null) {
            dArray[0] = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxZoom")) != null) {
            dArray[1] = d;
        }
        if (d2 != null || d != null) {
            this.setZoomLimits(dArray[0], dArray[1]);
        }
    }
}

