/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;

public class OrbitViewEyePointAnimator
implements Animator {
    protected static final double STOP_DISTANCE = 0.1;
    protected Globe globe;
    protected BasicOrbitView view;
    protected Vec4 eyePoint;
    protected double smoothing;
    protected boolean hasNext;

    public OrbitViewEyePointAnimator(Globe globe, BasicOrbitView basicOrbitView, Vec4 vec4, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (basicOrbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.globe = globe;
        this.view = basicOrbitView;
        this.eyePoint = vec4;
        this.smoothing = d;
        this.hasNext = true;
    }

    public void setEyePoint(Vec4 vec4) {
        this.eyePoint = vec4;
    }

    @Override
    public void start() {
        this.hasNext = true;
    }

    @Override
    public void stop() {
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void set(double d) {
    }

    @Override
    public void next() {
        Matrix matrix = this.view.getModelviewMatrix();
        Vec4 vec4 = matrix.extractEyePoint();
        if (vec4.distanceTo3(this.eyePoint) > 0.1) {
            vec4 = Vec4.mix3(1.0 - this.smoothing, vec4, this.eyePoint);
            OrbitViewEyePointAnimator.setEyePoint(this.globe, this.view, vec4);
        } else {
            OrbitViewEyePointAnimator.setEyePoint(this.globe, this.view, this.eyePoint);
            this.stop();
        }
    }

    public static void setEyePoint(Globe globe, BasicOrbitView basicOrbitView, Vec4 vec4) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (basicOrbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec42 = basicOrbitView.getModelviewMatrix().extractEyePoint().subtract3(vec4);
        Matrix matrix = basicOrbitView.getModelviewMatrix().multiply(Matrix.fromTranslation(vec42));
        Vec4 vec43 = matrix.extractEyePoint();
        Vec4 vec44 = matrix.extractForwardVector();
        Vec4 vec45 = vec43.add3(vec44.multiply3(basicOrbitView.getZoom()));
        AVList aVList = matrix.extractViewingParameters(vec45, basicOrbitView.getRoll(), globe);
        basicOrbitView.setCenterPosition((Position)aVList.getValue("gov.nasa.worldwind.avkey.Origin"));
        basicOrbitView.setHeading((Angle)aVList.getValue("gov.nasa.worldwind.avkey.Heading"));
        basicOrbitView.setPitch((Angle)aVList.getValue("gov.nasa.worldwind.avkey.Tilt"));
        basicOrbitView.setRoll((Angle)aVList.getValue("gov.nasa.worldwind.avkey.Roll"));
        basicOrbitView.setZoom((Double)aVList.getValue("gov.nasa.worldwind.avkey.Range"));
        basicOrbitView.setViewOutOfFocus(true);
    }
}

