/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationController;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.CompoundAnimator;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.RotateToAngleAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.animation.SmoothInterpolator;
import gov.nasa.worldwind.awt.AbstractViewInputHandler;
import gov.nasa.worldwind.awt.BasicViewInputHandler;
import gov.nasa.worldwind.awt.ViewInputActionHandler;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.ViewUtil;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlyToOrbitViewAnimator;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewCenterAnimator;
import gov.nasa.worldwind.view.orbit.OrbitViewEyePointAnimator;
import gov.nasa.worldwind.view.orbit.OrbitViewInputSupport;
import gov.nasa.worldwind.view.orbit.OrbitViewMoveToZoomAnimator;
import gov.nasa.worldwind.view.orbit.OrbitViewPropertyAccessor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.logging.Level;

public class OrbitViewInputHandler
extends BasicViewInputHandler {
    protected AnimationController gotoAnimControl = new AnimationController();
    protected AnimationController uiAnimControl = new AnimationController();
    protected static final String VIEW_ANIM_HEADING = "ViewAnimHeading";
    protected static final String VIEW_ANIM_PITCH = "ViewAnimPitch";
    protected static final String VIEW_ANIM_ROLL = "ViewAnimRoll";
    protected static final String VIEW_ANIM_HEADING_PITCH = "ViewAnimHeadingPitch";
    protected static final String VIEW_ANIM_POSITION = "ViewAnimPosition";
    protected static final String VIEW_ANIM_CENTER = "ViewAnimCenter";
    protected static final String VIEW_ANIM_ZOOM = "ViewAnimZoom";
    protected static final String VIEW_ANIM_PAN = "ViewAnimPan";
    protected static final String VIEW_ANIM_APP = "ViewAnimApp";
    protected static final String VIEW_ANIM_EYE = "ViewAnimEye";
    protected static final String VIEW_ANIM_STOP = "ViewAnimStop";
    public static final String ORBITVIEW_RESET_ROLL = "gov.nasa.worldwind.ViewResetRoll";

    public OrbitViewInputHandler() {
        this.initializeInputHandlers();
    }

    protected void initializeInputHandlers() {
        ViewInputAttributes.ActionAttributes.MouseAction[] mouseActionArray = new ViewInputAttributes.ActionAttributes.MouseAction[]{new ViewInputAttributes.ActionAttributes.MouseAction(1024)};
        this.getAttributes().setMouseActionAttributes(ORBITVIEW_RESET_ROLL, 0, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_PRESS, mouseActionArray, 2.0, 2.2, false, 0.0);
        ViewInputAttributes.ActionAttributes actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes(ORBITVIEW_RESET_ROLL);
        actionAttributes.setMouseActionListener(new ResetRollActionListener());
    }

    protected boolean isNonContinous2DGlobe() {
        Globe globe = this.getWorldWindow().getModel().getGlobe();
        return globe instanceof Globe2D && !((Globe2D)((Object)globe)).isContinuous();
    }

    protected void setTargetEyePosition(Position position, AnimationController animationController, String string) {
    }

    @Override
    protected void onMoveTo(Position position, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.isNonContinous2DGlobe()) {
            this.onMoveTo2D(position, deviceAttributes, actionAttributes);
            return;
        }
        if (view instanceof OrbitView) {
            double d = this.getScaleValueZoom(actionAttributes);
            if (!actionAttributes.isEnableSmoothing()) {
                d = 0.0;
            }
            OrbitViewCenterAnimator orbitViewCenterAnimator = new OrbitViewCenterAnimator((BasicOrbitView)this.getView(), view.getEyePosition(), position, d, OrbitViewPropertyAccessor.createCenterPositionAccessor((OrbitView)view), true);
            this.gotoAnimControl.put(VIEW_ANIM_CENTER, orbitViewCenterAnimator);
            this.setTargetEyePosition(new Position(position, view.getEyePosition().getAltitude()), this.gotoAnimControl, VIEW_ANIM_CENTER);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected void onMoveTo2D(Position position, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null || !(view instanceof BasicOrbitView)) {
            return;
        }
        Globe globe = this.getWorldWindow().getModel().getGlobe();
        BasicOrbitView basicOrbitView = (BasicOrbitView)view;
        Matrix matrix = OrbitViewInputSupport.computeTransformMatrix(globe, position, basicOrbitView.getHeading(), basicOrbitView.getPitch(), basicOrbitView.getRoll(), basicOrbitView.getZoom());
        Vec4 vec4 = matrix.extractEyePoint();
        double d = actionAttributes.isEnableSmoothing() ? this.getScaleValueZoom(actionAttributes) : 0.0;
        this.gotoAnimControl.put(VIEW_ANIM_EYE, new OrbitViewEyePointAnimator(globe, basicOrbitView, vec4, d));
        this.setTargetEyePosition(position, this.gotoAnimControl, VIEW_ANIM_EYE);
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    protected void onHorizontalTranslateAbs(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_HEADING, VIEW_ANIM_PITCH, VIEW_ANIM_ZOOM, VIEW_ANIM_EYE);
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            double d = angle.degrees;
            double d2 = angle2.degrees;
            Position position = ((OrbitView)view).getCenterPosition();
            d = WWMath.clamp(position.latitude.degrees + d, -90.0, 90.0);
            d2 = Angle.normalizedDegreesLongitude(position.longitude.degrees + d2);
            position = Position.fromDegrees(d, d2, position.elevation);
            this.setCenterPosition((BasicOrbitView)view, this.uiAnimControl, position, actionAttributes);
        }
    }

    @Override
    protected void onHorizontalTranslateRel(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (this.isNonContinous2DGlobe()) {
            this.onHorizontalTranslate2D(d, d2, d3, d4, deviceAttributes, actionAttributes);
            return;
        }
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_HEADING, VIEW_ANIM_PITCH, VIEW_ANIM_ZOOM, VIEW_ANIM_EYE);
        if (actionAttributes.getMouseActions() != null) {
            double d5 = Math.sqrt(d * d + d2 * d2);
            if (d5 > 0.0) {
                d /= d5;
                d2 /= d5;
            }
            Point point = OrbitViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.getWorldWindow());
            Point point2 = OrbitViewInputHandler.constrainToSourceBounds(this.getLastMousePoint(), this.getWorldWindow());
            if (this.getSelectedPosition() == null) {
                this.setSelectedPosition(this.computeSelectedPosition());
            } else if (this.computeSelectedPosition() == null) {
                this.setSelectedPosition(null);
            } else if (this.computeSelectedPointAt(point) == null || this.computeSelectedPointAt(point2) == null) {
                this.setSelectedPosition(null);
            }
            Vec4 vec4 = this.computeSelectedPointAt(point);
            Vec4 vec42 = this.computeSelectedPointAt(point2);
            if (vec4 != null && vec42 != null) {
                LatLon latLon = this.getChangeInLocation(point2, point, vec42, vec4);
                this.onHorizontalTranslateAbs(latLon.getLatitude(), latLon.getLongitude(), actionAttributes);
                return;
            }
            Point point3 = ViewUtil.subtract(point, point2);
            d = point3.y;
            d2 = -point3.x;
        }
        Angle angle = Angle.fromDegrees(d * this.getScaleValueHorizTransRel(deviceAttributes, actionAttributes));
        Angle angle2 = Angle.fromDegrees(d2 * this.getScaleValueHorizTransRel(deviceAttributes, actionAttributes));
        this.onHorizontalTranslateRel(angle, angle2, actionAttributes);
    }

    protected void onHorizontalTranslateRel(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            double d = view.getHeading().sin();
            double d2 = view.getHeading().cos();
            double d3 = d2 * angle.degrees - d * angle2.degrees;
            double d4 = d * angle.degrees + d2 * angle2.degrees;
            Position position = ((OrbitView)view).getCenterPosition();
            d3 = WWMath.clamp(position.latitude.degrees + d3, -90.0, 90.0);
            d4 = Angle.normalizedDegreesLongitude(position.longitude.degrees + d4);
            position = Position.fromDegrees(d3, d4, position.elevation);
            this.setCenterPosition((BasicOrbitView)view, this.uiAnimControl, position, actionAttributes);
        }
    }

    protected void onHorizontalTranslate2D(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null || !(view instanceof BasicOrbitView)) {
            return;
        }
        this.stopAllAnimators();
        if (actionAttributes.getMouseActions() != null) {
            BasicOrbitView basicOrbitView = (BasicOrbitView)this.getView();
            Point point = OrbitViewInputHandler.constrainToSourceBounds(this.getMouseDownPoint(), this.getWorldWindow());
            Point point2 = OrbitViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.getWorldWindow());
            Line line = ViewUtil.computeRayFromScreenPoint(basicOrbitView, point.x, point.y, this.mouseDownModelview, this.mouseDownProjection, this.mouseDownViewport);
            Line line2 = ViewUtil.computeRayFromScreenPoint(basicOrbitView, point2.x, point2.y, this.mouseDownModelview, this.mouseDownProjection, this.mouseDownViewport);
            Globe globe = this.getWorldWindow().getModel().getGlobe();
            Position position = this.getSelectedPosition();
            Vec4 vec4 = position != null ? globe.computePointFromPosition(position) : new Vec4(0.0, 0.0, 0.0);
            Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
            Plane plane = new Plane(vec42.x, vec42.y, vec42.z, -vec42.dot3(vec4));
            Vec4 vec43 = plane.intersect(line);
            Vec4 vec44 = plane.intersect(line2);
            Vec4 vec45 = vec44.subtract3(vec43);
            Matrix matrix = this.mouseDownModelview.multiply(Matrix.fromTranslation(vec45));
            Vec4 vec46 = matrix.extractEyePoint();
            this.setEyePoint(vec46, actionAttributes);
        } else {
            Globe globe = this.getWorldWindow().getModel().getGlobe();
            double d5 = this.getScaleValueHorizTransRel(deviceAttributes, actionAttributes);
            double d6 = d5 * Math.PI / 180.0;
            double d7 = d6 * globe.getRadius();
            Vec4 vec4 = new Vec4(-d2, -d, 0.0);
            vec4 = vec4.multiply3(d7);
            BasicOrbitView basicOrbitView = (BasicOrbitView)this.getView();
            Matrix matrix = ViewUtil.computeTransformMatrix(globe, basicOrbitView.getCenterPosition(), basicOrbitView.getHeading(), Angle.ZERO, basicOrbitView.getRoll());
            vec4 = vec4.transformBy3(matrix.getInverse());
            Matrix matrix2 = this.getView().getModelviewMatrix().multiply(Matrix.fromTranslation(vec4));
            Vec4 vec47 = matrix2.extractEyePoint();
            this.setEyePoint(vec47, actionAttributes);
        }
    }

    @Override
    protected void onResetHeading(ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.addHeadingAnimator(view.getHeading(), Angle.ZERO);
    }

    protected void onResetRoll(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (Angle.ZERO.equals(view.getRoll())) {
            return;
        }
        this.addRollAnimator(view.getRoll(), Angle.ZERO);
    }

    @Override
    protected void onResetHeadingPitchRoll(ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.addHeadingPitchRollAnimator(view.getHeading(), Angle.ZERO, view.getPitch(), Angle.ZERO, view.getRoll(), Angle.ZERO);
    }

    @Override
    protected void onRotateView(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_CENTER, VIEW_ANIM_ZOOM, VIEW_ANIM_EYE);
        if (actionAttributes.getMouseActions() != null) {
            if (this.getWorldWindow() instanceof Component && this.getMousePoint().y < ((Component)((Object)this.getWorldWindow())).getHeight() / 2) {
                d = -d;
            }
        } else {
            double d5 = Math.sqrt(d * d + d2 * d2);
            if (d5 > 0.0) {
                d /= d5;
                d2 /= d5;
            }
        }
        Angle angle = Angle.fromDegrees(d * this.getScaleValueRotate(actionAttributes));
        Angle angle2 = Angle.fromDegrees(d2 * this.getScaleValueRotate(actionAttributes));
        this.onRotateView(angle, angle2, actionAttributes);
    }

    protected void onRotateView(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            if (!angle.equals(Angle.ZERO)) {
                this.changeHeading((BasicOrbitView)view, this.uiAnimControl, angle, actionAttributes);
            }
            if (!angle2.equals(Angle.ZERO)) {
                this.changePitch((BasicOrbitView)view, this.uiAnimControl, angle2, actionAttributes);
            }
        }
    }

    @Override
    protected void onVerticalTranslate(double d, double d2, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_CENTER, VIEW_ANIM_HEADING, VIEW_ANIM_PITCH, VIEW_ANIM_EYE);
        double d3 = d * this.getScaleValueRotate(actionAttributes);
        this.onVerticalTranslate(d3, actionAttributes);
    }

    protected void onVerticalTranslate(double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            this.changeZoom((BasicOrbitView)view, this.uiAnimControl, d, actionAttributes);
        }
    }

    @Override
    public void apply() {
        super.apply();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.gotoAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        } else {
            this.gotoAnimControl.clear();
        }
        if (this.uiAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        } else {
            this.uiAnimControl.clear();
        }
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.handlePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.view.orbit.OrbitView.CenterStopped") {
            this.handleOrbitViewCenterStopped();
        }
    }

    protected void stopAllAnimators() {
        this.uiAnimControl.stopAnimations();
        this.gotoAnimControl.stopAnimations();
        this.uiAnimControl.clear();
        this.gotoAnimControl.clear();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            ((BasicOrbitView)view).setViewOutOfFocus(true);
        }
    }

    protected void stopGoToAnimators() {
        this.gotoAnimControl.stopAnimations();
        this.gotoAnimControl.clear();
    }

    protected void stopUserInputAnimators(Object ... objectArray) {
        for (Object object : objectArray) {
            if (this.uiAnimControl.get(object) == null) continue;
            ((Animator)this.uiAnimControl.get(object)).stop();
            this.uiAnimControl.remove(object);
        }
    }

    @Override
    protected void handleViewStopped() {
        this.stopAllAnimators();
        this.setTargetEyePosition(this.getView().getEyePosition(), null, VIEW_ANIM_STOP);
    }

    protected void handleOrbitViewCenterStopped() {
        this.stopUserInputAnimators(VIEW_ANIM_CENTER, VIEW_ANIM_EYE);
        this.setTargetEyePosition(this.getView().getEyePosition(), this.uiAnimControl, VIEW_ANIM_STOP);
    }

    protected void setEyePoint(Vec4 vec4, ViewInputAttributes.ActionAttributes actionAttributes) {
        double d;
        Globe globe = this.getWorldWindow().getModel().getGlobe();
        BasicOrbitView basicOrbitView = (BasicOrbitView)this.getView();
        double d2 = d = this.isEnableSmoothing() && actionAttributes.isEnableSmoothing() ? actionAttributes.getSmoothingValue() : 0.0;
        if (d == 0.0) {
            OrbitViewEyePointAnimator.setEyePoint(globe, basicOrbitView, vec4);
            this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        } else {
            this.uiAnimControl.put(VIEW_ANIM_EYE, new OrbitViewEyePointAnimator(globe, basicOrbitView, vec4, d));
            this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        }
    }

    protected void setCenterPosition(BasicOrbitView basicOrbitView, AnimationController animationController, Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
        Position position2;
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_CENTER) != null) {
                animationController.remove(VIEW_ANIM_CENTER);
            }
            position2 = basicOrbitView.getOrbitViewLimits().limitCenterPosition(basicOrbitView, position);
            basicOrbitView.setCenterPosition(position2);
            basicOrbitView.setViewOutOfFocus(true);
        } else {
            OrbitViewCenterAnimator orbitViewCenterAnimator = (OrbitViewCenterAnimator)animationController.get(VIEW_ANIM_CENTER);
            Position position3 = basicOrbitView.getCenterPosition();
            if (orbitViewCenterAnimator == null || !orbitViewCenterAnimator.hasNext()) {
                position2 = this.computeNewPosition(basicOrbitView, position);
                orbitViewCenterAnimator = new OrbitViewCenterAnimator((BasicOrbitView)this.getView(), position3, position2, d, OrbitViewPropertyAccessor.createCenterPositionAccessor(basicOrbitView), true);
                animationController.put(VIEW_ANIM_CENTER, orbitViewCenterAnimator);
            } else {
                position2 = new Position(orbitViewCenterAnimator.getEnd().getLatitude().add(position.getLatitude()).subtract(position3.getLatitude()), orbitViewCenterAnimator.getEnd().getLongitude().add(position.getLongitude()).subtract(position3.getLongitude()), orbitViewCenterAnimator.getEnd().getElevation() + position.getElevation() - position3.getElevation());
                position2 = this.computeNewPosition(basicOrbitView, position2);
                orbitViewCenterAnimator.setEnd(position2);
            }
            orbitViewCenterAnimator.start();
        }
        this.setTargetEyePosition(new Position(position2, basicOrbitView.getEyePosition().elevation), animationController, VIEW_ANIM_CENTER);
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changeHeading(BasicOrbitView basicOrbitView, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_HEADING) != null) {
                animationController.remove(VIEW_ANIM_HEADING);
            }
            Angle angle2 = this.computeNewHeading(basicOrbitView, basicOrbitView.getHeading().add(angle));
            basicOrbitView.setHeading(angle2);
        } else {
            RotateToAngleAnimator rotateToAngleAnimator = (RotateToAngleAnimator)animationController.get(VIEW_ANIM_HEADING);
            if (rotateToAngleAnimator == null || !rotateToAngleAnimator.hasNext()) {
                Angle angle3 = this.computeNewHeading(basicOrbitView, basicOrbitView.getHeading().add(angle));
                rotateToAngleAnimator = new RotateToAngleAnimator(basicOrbitView.getHeading(), angle3, d, ViewPropertyAccessor.createHeadingAccessor(basicOrbitView));
                animationController.put(VIEW_ANIM_HEADING, rotateToAngleAnimator);
            } else {
                Angle angle4 = this.computeNewHeading(basicOrbitView, rotateToAngleAnimator.getEnd().add(angle));
                rotateToAngleAnimator.setEnd(angle4);
            }
            rotateToAngleAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changePitch(BasicOrbitView basicOrbitView, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_PITCH) != null) {
                animationController.remove(VIEW_ANIM_PITCH);
            }
            Angle angle2 = this.computeNewPitch(basicOrbitView, basicOrbitView.getPitch().add(angle));
            basicOrbitView.setPitch(angle2);
        } else {
            RotateToAngleAnimator rotateToAngleAnimator = (RotateToAngleAnimator)animationController.get(VIEW_ANIM_PITCH);
            if (rotateToAngleAnimator == null || !rotateToAngleAnimator.hasNext()) {
                Angle angle3 = this.computeNewPitch(basicOrbitView, basicOrbitView.getPitch().add(angle));
                rotateToAngleAnimator = new RotateToAngleAnimator(basicOrbitView.getPitch(), angle3, d, (PropertyAccessor.AngleAccessor)new CollisionAwarePitchAccessor(basicOrbitView));
                rotateToAngleAnimator.setStopOnInvalidState(true);
                animationController.put(VIEW_ANIM_PITCH, rotateToAngleAnimator);
            } else {
                Angle angle4 = this.computeNewPitch(basicOrbitView, rotateToAngleAnimator.getEnd().add(angle));
                rotateToAngleAnimator.setEnd(angle4);
            }
            rotateToAngleAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changeZoom(BasicOrbitView basicOrbitView, AnimationController animationController, double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d2 = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d2 = 0.0;
        }
        if (d2 == 0.0) {
            if (animationController.get(VIEW_ANIM_ZOOM) != null) {
                animationController.remove(VIEW_ANIM_ZOOM);
            }
            basicOrbitView.setZoom(this.computeNewZoom(basicOrbitView, basicOrbitView.getZoom(), d));
        } else {
            double d3;
            OrbitViewMoveToZoomAnimator orbitViewMoveToZoomAnimator = (OrbitViewMoveToZoomAnimator)animationController.get(VIEW_ANIM_ZOOM);
            if (orbitViewMoveToZoomAnimator == null || !orbitViewMoveToZoomAnimator.hasNext()) {
                d3 = this.computeNewZoom(basicOrbitView, basicOrbitView.getZoom(), d);
                orbitViewMoveToZoomAnimator = new OrbitViewMoveToZoomAnimator(basicOrbitView, d3, d2, OrbitViewPropertyAccessor.createZoomAccessor(basicOrbitView), false);
                animationController.put(VIEW_ANIM_ZOOM, orbitViewMoveToZoomAnimator);
            } else {
                d3 = this.computeNewZoom(basicOrbitView, orbitViewMoveToZoomAnimator.getEnd(), d);
                orbitViewMoveToZoomAnimator.setEnd(d3);
            }
            this.setTargetEyePosition(new Position(basicOrbitView.getEyePosition(), d3), animationController, VIEW_ANIM_ZOOM);
            orbitViewMoveToZoomAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected Position computeNewPosition(OrbitView orbitView, Position position) {
        Angle angle = Angle.fromDegrees(WWMath.clamp(position.latitude.degrees, -90.0, 90.0));
        Angle angle2 = Angle.normalizedLongitude(position.longitude);
        Position position2 = new Position(angle, angle2, position.elevation);
        return orbitView.getOrbitViewLimits().limitCenterPosition(orbitView, position2);
    }

    protected Angle computeNewHeading(OrbitView orbitView, Angle angle) {
        Angle angle2 = BasicOrbitView.normalizedHeading(angle);
        return orbitView.getOrbitViewLimits().limitHeading(orbitView, angle2);
    }

    protected Angle computeNewPitch(OrbitView orbitView, Angle angle) {
        Angle angle2 = BasicOrbitView.normalizedPitch(angle);
        return orbitView.getOrbitViewLimits().limitPitch(orbitView, angle2);
    }

    protected double computeNewZoom(OrbitView orbitView, double d, double d2) {
        double d3 = d != 0.0 ? Math.log(d) : 0.0;
        double d4 = Math.exp(d3 + d2);
        return orbitView.getOrbitViewLimits().limitZoom(orbitView, d4);
    }

    protected double getScaleValueHorizTransRel(ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = this.getScaleValue(dArray[0], dArray[1], ((OrbitView)view).getZoom(), 3.0 * d, true);
            return d2;
        }
        return super.getScaleValueElevation(deviceAttributes, actionAttributes);
    }

    protected double getScaleValueRotate(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = this.getScaleValue(dArray[0], dArray[1], ((OrbitView)view).getZoom(), 3.0 * d, false);
            return d2;
        }
        return 1.0;
    }

    protected double getScaleValueZoom(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = ((OrbitView)view).getZoom() / (3.0 * d);
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            return dArray[0] * (1.0 - d2) + dArray[1] * d2;
        }
        return 1.0;
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        int n = bl ? 1 : 0;
        OrbitView orbitView = (OrbitView)this.getView();
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = FlyToOrbitViewAnimator.createFlyToOrbitViewAnimator(orbitView, position, position2, angle, angle2, angle3, angle4, d, d2, l, n);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, flyToOrbitViewAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        this.setTargetEyePosition(new Position(position2, d2), this.gotoAnimControl, VIEW_ANIM_PAN);
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, boolean bl) {
        int n = bl ? 1 : 0;
        long l = AnimationSupport.getScaledTimeMillisecs(position, position2, 2000L, 10000L);
        OrbitView orbitView = (OrbitView)this.getView();
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = FlyToOrbitViewAnimator.createFlyToOrbitViewAnimator(orbitView, position, position2, angle, angle2, angle3, angle4, d, d2, l, n);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, flyToOrbitViewAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        this.setTargetEyePosition(new Position(position2, d2), this.gotoAnimControl, VIEW_ANIM_PAN);
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, long l, boolean bl) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, l, bl);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, boolean bl) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, bl);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, false);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addEyePositionAnimator(long l, Position position, Position position2) {
        PositionAnimator positionAnimator = ViewUtil.createEyePositionAnimator(this.getView(), l, position, position2);
        this.gotoAnimControl.put(VIEW_ANIM_POSITION, positionAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        this.setTargetEyePosition(position2, this.gotoAnimControl, VIEW_ANIM_POSITION);
    }

    public void addHeadingAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING_PITCH);
        AngleAnimator angleAnimator = ViewUtil.createHeadingAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_HEADING, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPitchAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING_PITCH);
        AngleAnimator angleAnimator = ViewUtil.createPitchAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_PITCH, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addRollAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_ROLL);
        AngleAnimator angleAnimator = ViewUtil.createRollAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_ROLL, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addHeadingPitchRollAnimator(Angle angle, Angle angle2, Angle angle3, Angle angle4, Angle angle5, Angle angle6) {
        this.gotoAnimControl.remove(VIEW_ANIM_PITCH);
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING);
        CompoundAnimator compoundAnimator = ViewUtil.createHeadingPitchRollAnimator(this.getView(), angle, angle2, angle3, angle4, angle5, angle6);
        this.gotoAnimControl.put(VIEW_ANIM_HEADING_PITCH, compoundAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addZoomAnimator(double d, double d2) {
        DoubleAnimator doubleAnimator = new DoubleAnimator(new ScheduledInterpolator(4000L), d, d2, OrbitViewPropertyAccessor.createZoomAccessor((OrbitView)this.getView()));
        this.gotoAnimControl.put(VIEW_ANIM_ZOOM, doubleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addFlyToZoomAnimator(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            OrbitView orbitView = (OrbitView)view;
            Angle angle3 = orbitView.getHeading();
            Angle angle4 = orbitView.getPitch();
            double d2 = orbitView.getZoom();
            long l = AnimationSupport.getScaledTimeMillisecs(d2, d, 1000L, 8000L);
            DoubleAnimator doubleAnimator = new DoubleAnimator(new ScheduledInterpolator(l), d2, d, OrbitViewPropertyAccessor.createZoomAccessor(orbitView));
            AngleAnimator angleAnimator = new AngleAnimator(new ScheduledInterpolator(l), angle3, angle, ViewPropertyAccessor.createHeadingAccessor(orbitView));
            AngleAnimator angleAnimator2 = new AngleAnimator(new ScheduledInterpolator(l), angle4, angle2, ViewPropertyAccessor.createPitchAccessor(orbitView));
            this.gotoAnimControl.put(VIEW_ANIM_ZOOM, doubleAnimator);
            this.gotoAnimControl.put(VIEW_ANIM_HEADING, angleAnimator);
            this.gotoAnimControl.put(VIEW_ANIM_PITCH, angleAnimator2);
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
        }
    }

    public void addCenterAnimator(Position position, Position position2, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            this.addCenterAnimator(position, position2, 4000L, bl);
        }
    }

    public void addCenterAnimator(Position position, Position position2, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            OrbitView orbitView = (OrbitView)view;
            ScheduledInterpolator scheduledInterpolator = bl ? new SmoothInterpolator(l) : new ScheduledInterpolator(l);
            PositionAnimator positionAnimator = new PositionAnimator(scheduledInterpolator, position, position2, OrbitViewPropertyAccessor.createCenterPositionAccessor(orbitView));
            this.gotoAnimControl.put(VIEW_ANIM_CENTER, positionAnimator);
            this.setTargetEyePosition(position2, this.gotoAnimControl, VIEW_ANIM_CENTER);
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
        }
    }

    @Override
    public void goTo(Position position, double d) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.stopAnimators();
        this.addPanToAnimator(position, orbitView.getHeading(), orbitView.getPitch(), d, true);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    @Override
    public void stopAnimators() {
        this.uiAnimControl.stopAnimations();
        this.gotoAnimControl.stopAnimations();
        this.setTargetEyePosition(this.getView().getEyePosition(), null, VIEW_ANIM_STOP);
    }

    @Override
    public boolean isAnimating() {
        return this.uiAnimControl.hasActiveAnimation() || this.gotoAnimControl.hasActiveAnimation();
    }

    @Override
    public void addAnimator(Animator animator) {
        long l = new Date().getTime();
        this.gotoAnimControl.put(VIEW_ANIM_APP + l, animator);
    }

    public class ResetRollActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            OrbitViewInputHandler.this.onResetRoll(actionAttributes);
            return true;
        }
    }

    protected static class CollisionAwarePitchAccessor
    implements PropertyAccessor.AngleAccessor {
        protected OrbitView orbitView;

        public CollisionAwarePitchAccessor(OrbitView orbitView) {
            if (orbitView == null) {
                String string = Logging.getMessage("nullValue.OrbitViewIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.orbitView = orbitView;
        }

        @Override
        public Angle getAngle() {
            return this.orbitView.getPitch();
        }

        @Override
        public boolean setAngle(Angle angle) {
            if (angle == null) {
                return false;
            }
            if (this.orbitView.isDetectCollisions()) {
                this.orbitView.hadCollisions();
            }
            try {
                this.orbitView.setPitch(angle);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileChangingView");
                Logging.logger().log(Level.SEVERE, string, exception);
                return false;
            }
            return !this.orbitView.isDetectCollisions() || !this.orbitView.hadCollisions();
        }
    }
}

