/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMSTiledImageLayer
extends BasicTiledImageLayer {
    private static final String[] formatOrderPreference = new String[]{"image/dds", "image/png", "image/jpeg"};

    public WMSTiledImageLayer(AVList aVList) {
        super(aVList);
    }

    public WMSTiledImageLayer(Document document, AVList aVList) {
        this(document.getDocumentElement(), aVList);
    }

    public WMSTiledImageLayer(Element element, AVList aVList) {
        this(WMSTiledImageLayer.wmsGetParamsFromDocument(element, aVList));
    }

    public WMSTiledImageLayer(WMSCapabilities wMSCapabilities, AVList aVList) {
        this(WMSTiledImageLayer.wmsGetParamsFromCapsDoc(wMSCapabilities, aVList));
    }

    public WMSTiledImageLayer(String string) {
        this(WMSTiledImageLayer.wmsRestorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static AVList wmsGetParamsFromDocument(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        DataConfigurationUtils.getWMSLayerConfigParams(element, aVList);
        BasicTiledImageLayer.getParamsFromDocument(element, aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList));
        return aVList;
    }

    public static AVList wmsGetParamsFromCapsDoc(WMSCapabilities wMSCapabilities, AVList aVList) {
        if (wMSCapabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        try {
            DataConfigurationUtils.getWMSLayerConfigParams(wMSCapabilities, formatOrderPreference, aVList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = Logging.getMessage("WMS.MissingLayerParameters");
            Logging.logger().log(java.util.logging.Level.SEVERE, string, illegalArgumentException);
            throw new IllegalArgumentException(string, illegalArgumentException);
        }
        catch (WWRuntimeException wWRuntimeException) {
            String string = Logging.getMessage("WMS.MissingCapabilityValues");
            Logging.logger().log(java.util.logging.Level.SEVERE, string, wWRuntimeException);
            throw new IllegalArgumentException(string, wWRuntimeException);
        }
        WMSTiledImageLayer.setFallbacks(aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList));
        aVList.setValue("gov.nasa.worldwind.avkey.UseTransparentTextures", true);
        return aVList;
    }

    @Override
    public BufferedImage composeImageForSector(Sector sector, int n, int n2, double d, int n3, String string, boolean bl, BufferedImage bufferedImage, int n4) throws Exception {
        if (sector == null) {
            String string2 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Level level = n3 >= 0 && n3 < this.getLevels().getNumLevels() ? this.getLevels().getLevel(n3) : this.getLevels().getLastLevel();
        ComposeImageTile composeImageTile = new ComposeImageTile(sector, string, level, n, n2);
        try {
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(n, n2, 1);
            }
            this.downloadImage(composeImageTile, string, n4);
            Thread.sleep(1L);
            BufferedImage bufferedImage2 = ImageIO.read(composeImageTile.getFile());
            Thread.sleep(1L);
            ImageUtil.mergeImage(sector, composeImageTile.getSector(), d, bufferedImage2, bufferedImage);
            Thread.sleep(1L);
            this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", 0.0, 1.0);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (Exception exception) {
            if (bl) {
                throw exception;
            }
            String string3 = Logging.getMessage("generic.ExceptionWhileRequestingImage", composeImageTile.getPath());
            Logging.logger().log(java.util.logging.Level.WARNING, string3, exception);
        }
        return bufferedImage;
    }

    @Override
    protected Document createConfigurationDocument(AVList aVList) {
        Document document = super.createConfigurationDocument(aVList);
        if (document == null || document.getDocumentElement() == null) {
            return document;
        }
        DataConfigurationUtils.createWMSLayerConfigElements(aVList, document.getDocumentElement());
        return document;
    }

    @Override
    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object instanceof URLBuilder) {
            restorableSupport.addStateValueAsString(stateObject, "wms.Version", ((URLBuilder)object).wmsVersion);
            restorableSupport.addStateValueAsString(stateObject, "wms.Crs", ((URLBuilder)object).crs);
        } else {
            super.getRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    public static AVList wmsRestorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        WMSTiledImageLayer.wmsRestoreStateToParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void wmsRestoreStateToParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        WMSTiledImageLayer.restoreStateForParams(restorableSupport, stateObject, aVList);
        WMSTiledImageLayer.legacyWmsRestoreStateToParams(restorableSupport, stateObject, aVList);
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ImageFormat");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.Title")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Title", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DisplayName")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }
        RestorableSupport.adjustTitleAndDisplayName(aVList);
        string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.LayerNames");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.StyleNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.StyleNames", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "wms.Version")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.WMSVersion", string);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList));
    }

    protected static void legacyWmsRestoreStateToParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avkey.LevelZeroTileDelta.Latitude");
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avkey.LevelZeroTileDelta.Longitude");
        if (d != null && d2 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", LatLon.fromDegrees(d, d2));
        }
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avKey.Sector.MinLatitude");
        Double d4 = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avKey.Sector.MinLongitude");
        Double d5 = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avKey.Sector.MaxLatitude");
        Double d6 = restorableSupport.getStateValueAsDouble(stateObject, "gov.nasa.worldwind.avKey.Sector.MaxLongitude");
        if (d3 != null && d4 != null && d5 != null && d6 != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(d3, d5, d4, d6));
        }
    }

    public static class URLBuilder
    implements TileUrlBuilder {
        private static final String MAX_VERSION = "1.3.0";
        private final String layerNames;
        private final String styleNames;
        private final String imageFormat;
        private final String wmsVersion;
        private final String crs;
        private final String backgroundColor;
        public String URLTemplate;

        public URLBuilder(AVList aVList) {
            String string;
            String string2;
            this.layerNames = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
            this.styleNames = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
            this.imageFormat = aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
            this.backgroundColor = aVList.getStringValue("gov.nasa.worldwind.avkey.BackgroundColor");
            String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.WMSVersion");
            if (string3 == null || WWUtil.compareVersion(string3, MAX_VERSION) >= 0) {
                this.wmsVersion = MAX_VERSION;
                string2 = "&crs=";
                string = "CRS:84";
            } else {
                this.wmsVersion = string3;
                string2 = "&srs=";
                string = "EPSG:4326";
            }
            String string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem");
            this.crs = string2 + (string4 != null ? string4 : string);
        }

        @Override
        public URL getURL(Tile tile, String string) throws MalformedURLException {
            String string2;
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(WWXML.fixGetMapString(tile.getLevel().getService()));
                if (!stringBuffer.toString().toLowerCase().contains("service=wms")) {
                    stringBuffer.append("service=WMS");
                }
                stringBuffer.append("&request=GetMap");
                stringBuffer.append("&version=").append(this.wmsVersion);
                stringBuffer.append(this.crs);
                stringBuffer.append("&layers=").append(this.layerNames);
                stringBuffer.append("&styles=").append(this.styleNames != null ? this.styleNames : "");
                stringBuffer.append("&transparent=TRUE");
                if (this.backgroundColor != null) {
                    stringBuffer.append("&bgcolor=").append(this.backgroundColor);
                }
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            String string3 = string2 = string != null ? string : this.imageFormat;
            if (null != string2) {
                stringBuffer.append("&format=").append(string2);
            }
            stringBuffer.append("&width=").append(tile.getWidth());
            stringBuffer.append("&height=").append(tile.getHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            if (WWUtil.compareVersion(this.wmsVersion, "1.1.1") <= 0 || this.crs.contains("CRS:84")) {
                stringBuffer.append(sector.getMinLongitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMinLatitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMaxLongitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMaxLatitude().getDegrees());
            } else {
                stringBuffer.append(sector.getMinLatitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMinLongitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMaxLatitude().getDegrees());
                stringBuffer.append(",");
                stringBuffer.append(sector.getMaxLongitude().getDegrees());
            }
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }

    protected static class ComposeImageTile
    extends TextureTile {
        protected int width;
        protected int height;
        protected File file;

        public ComposeImageTile(Sector sector, String string, Level level, int n, int n2) throws IOException {
            super(sector, level, -1, -1);
            this.width = n;
            this.height = n2;
            this.file = File.createTempFile("WWJDeleteOnExit", WWIO.makeSuffixForMimeType(string));
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        public File getFile() {
            return this.file;
        }
    }
}

