/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl.awt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import jogamp.nativewindow.jawt.windows.Win32SunJDKReflection;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsAWTWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class, new WindowsAWTWGLGraphicsConfigurationFactory());
    }

    private WindowsAWTWGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
            if (DEBUG) {
                System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: creating default device: " + abstractGraphicsScreen);
            }
        }
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)abstractGraphicsScreen;
        graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilitiesChooser objects");
        }
        if (DEBUG) {
            System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: got " + abstractGraphicsScreen);
        }
        WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(0);
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, aWTGraphicsScreen.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(windowsGraphicsDevice, capabilitiesImmutable);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, defaultGraphicsScreen, n);
        if (windowsWGLGraphicsConfiguration == null) {
            throw new GLException("Unable to choose a GraphicsConfiguration: " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + defaultGraphicsScreen);
        }
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(((GLCapabilitiesImmutable)capabilitiesImmutable).getGLProfile());
        GraphicsConfiguration graphicsConfiguration = null;
        if (gLDrawableFactory instanceof WindowsWGLDrawableFactory) {
            block20: {
                try {
                    windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration(gLDrawableFactory, null);
                    if (1 <= windowsWGLGraphicsConfiguration.getPixelFormatID()) {
                        graphicsConfiguration = Win32SunJDKReflection.graphicsConfigurationGet(graphicsDevice, windowsWGLGraphicsConfiguration.getPixelFormatID());
                        if (DEBUG) {
                            System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found new AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
                        }
                    }
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block20;
                    gLException.printStackTrace();
                }
            }
            if (null == graphicsConfiguration) {
                int n2;
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
                int[] nArray = new int[graphicsConfigurationArray.length];
                ArrayHashSet<Integer> arrayHashSet = new ArrayHashSet<Integer>(false, 16, 0.75f);
                for (n2 = 0; n2 < graphicsConfigurationArray.length; ++n2) {
                    GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[n2];
                    nArray[n2] = Win32SunJDKReflection.graphicsConfigurationGetPixelFormatID(graphicsConfiguration2);
                    arrayHashSet.add(nArray[n2]);
                    if (!DEBUG) continue;
                    System.err.println("AWT pfd[" + n2 + "] " + nArray[n2]);
                }
                if (DEBUG) {
                    System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: PFD IDs: " + nArray.length + ", unique: " + arrayHashSet.size());
                }
                windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration(gLDrawableFactory, nArray);
                n2 = arrayHashSet.indexOf(windowsWGLGraphicsConfiguration.getPixelFormatID());
                if (0 <= n2) {
                    graphicsConfiguration = graphicsConfigurationArray[n2];
                    if (DEBUG) {
                        System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found matching AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
                    }
                }
            }
        } else {
            graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        }
        if (null == graphicsConfiguration) {
            throw new GLException("Unable to determine GraphicsConfiguration: " + windowsWGLGraphicsConfiguration);
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, windowsWGLGraphicsConfiguration.getChosenCapabilities(), windowsWGLGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, windowsWGLGraphicsConfiguration);
    }
}

