/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.JsonReadContext;
import org.codehaus.jackson.impl.JsonWriteContext;
import org.codehaus.jackson.util.ByteArrayBuilder;

public class TokenBuffer
extends JsonGenerator {
    static final int DEFAULT_FEATURES = JsonParser.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected Segment _first;
    protected Segment _last;
    protected int _appendOffset;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        this._generatorFeatures = DEFAULT_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext();
        this._first = this._last = new Segment();
        this._appendOffset = 0;
    }

    public JsonParser asParser() {
        return this.asParser(this._objectCodec);
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        return new Parser(this._first, objectCodec);
    }

    public JsonParser asParser(JsonParser jsonParser) {
        Parser parser = new Parser(this._first, jsonParser.getCodec());
        parser.setLocation(jsonParser.getTokenLocation());
        return parser;
    }

    public void serialize(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        Segment segment = this._first;
        int n = -1;
        while (true) {
            JsonToken jsonToken;
            if (++n >= 16) {
                n = 0;
                if ((segment = segment.next()) == null) break;
            }
            if ((jsonToken = segment.type(n)) == null) break;
            switch (jsonToken) {
                case START_OBJECT: {
                    jsonGenerator.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    jsonGenerator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    jsonGenerator.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    jsonGenerator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    jsonGenerator.writeFieldName((String)segment.get(n));
                    break;
                }
                case VALUE_STRING: {
                    jsonGenerator.writeString((String)segment.get(n));
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Number number = (Number)segment.get(n);
                    if (number instanceof BigInteger) {
                        jsonGenerator.writeNumber((BigInteger)number);
                        break;
                    }
                    if (number instanceof Long) {
                        jsonGenerator.writeNumber(number.longValue());
                        break;
                    }
                    jsonGenerator.writeNumber(number.intValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    Number number = (Number)segment.get(n);
                    if (number instanceof BigDecimal) {
                        jsonGenerator.writeNumber((BigDecimal)number);
                        break;
                    }
                    if (number instanceof Float) {
                        jsonGenerator.writeNumber(number.floatValue());
                        break;
                    }
                    jsonGenerator.writeNumber(number.doubleValue());
                    break;
                }
                case VALUE_TRUE: {
                    jsonGenerator.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    jsonGenerator.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    jsonGenerator.writeNull();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    jsonGenerator.writeObject(segment.get(n));
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n = 0;
        while (true) {
            JsonToken jsonToken;
            try {
                jsonToken = jsonParser.nextToken();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            if (jsonToken == null) break;
            if (n < 100) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(jsonToken.toString());
            }
            ++n;
        }
        if (n >= 100) {
            stringBuilder.append(" ... (truncated ").append(n - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, string);
        this._writeContext.writeFieldName(string);
    }

    @Override
    public void writeString(String string) throws IOException, JsonGenerationException {
        if (string == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, string);
        }
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(cArray, n, n2));
    }

    @Override
    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, n);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, l);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, d);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
        }
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_INT, bigInteger);
        }
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException {
        this.writeString(string);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._append(bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object object) throws IOException, JsonProcessingException {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    @Override
    public void writeTree(JsonNode jsonNode) throws IOException, JsonProcessingException {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, jsonNode);
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.writeObject(byArray2);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) throws IOException, JsonProcessingException {
        block0 : switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        this.writeNumber(jsonParser.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jsonParser.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jsonParser.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: should never end up through this code path");
            }
        }
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
        }
        switch (jsonToken) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    protected final void _append(JsonToken jsonToken) {
        Segment segment = this._last.append(this._appendOffset, jsonToken);
        if (segment == null) {
            ++this._appendOffset;
        } else {
            this._last = segment;
            this._appendOffset = 1;
        }
    }

    protected final void _append(JsonToken jsonToken, Object object) {
        Segment segment = this._last.append(this._appendOffset, jsonToken, object);
        if (segment == null) {
            ++this._appendOffset;
        } else {
            this._last = segment;
            this._appendOffset = 1;
        }
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    protected static final class Segment {
        public static final int TOKENS_PER_SEGMENT = 16;
        private static final JsonToken[] TOKEN_TYPES_BY_INDEX = new JsonToken[16];
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];

        public JsonToken type(int n) {
            long l = this._tokenTypes;
            if (n > 0) {
                l >>= n << 2;
            }
            int n2 = (int)l & 0xF;
            return TOKEN_TYPES_BY_INDEX[n2];
        }

        public Object get(int n) {
            return this._tokens[n];
        }

        public Segment next() {
            return this._next;
        }

        public Segment append(int n, JsonToken jsonToken) {
            if (n < 16) {
                this.set(n, jsonToken);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken);
            return this._next;
        }

        public Segment append(int n, JsonToken jsonToken, Object object) {
            if (n < 16) {
                this.set(n, jsonToken, object);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object);
            return this._next;
        }

        public void set(int n, JsonToken jsonToken) {
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
        }

        public void set(int n, JsonToken jsonToken, Object object) {
            this._tokens[n] = object;
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
        }

        static {
            JsonToken[] jsonTokenArray = JsonToken.values();
            System.arraycopy(jsonTokenArray, 1, TOKEN_TYPES_BY_INDEX, 1, Math.min(15, jsonTokenArray.length - 1));
        }
    }

    protected static final class Parser
    extends JsonParser {
        protected ObjectCodec _codec;
        protected Segment _segment;
        protected int _segmentPtr;
        protected JsonReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected JsonLocation _location = null;
        private static final int INT_SPACE = 32;

        public Parser(Segment segment, ObjectCodec objectCodec) {
            this._segment = segment;
            this._segmentPtr = -1;
            this._codec = objectCodec;
            this._parsingContext = JsonReadContext.createRootContext(-1, -1);
        }

        public void setLocation(JsonLocation jsonLocation) {
            this._location = jsonLocation;
        }

        @Override
        public ObjectCodec getCodec() {
            return this._codec;
        }

        @Override
        public void setCodec(ObjectCodec objectCodec) {
            this._codec = objectCodec;
        }

        @Override
        public void close() throws IOException {
            if (!this._closed) {
                this._closed = true;
            }
        }

        @Override
        public JsonToken nextToken() throws IOException, JsonParseException {
            if (this._closed || this._segment == null) {
                return null;
            }
            if (++this._segmentPtr >= 16) {
                this._segmentPtr = 0;
                this._segment = this._segment.next();
                if (this._segment == null) {
                    return null;
                }
            }
            this._currToken = this._segment.type(this._segmentPtr);
            if (this._currToken == JsonToken.FIELD_NAME) {
                this._parsingContext.setCurrentName((String)this._currentObject());
            } else if (this._currToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
            } else if (this._currToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
            } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
                this._parsingContext = this._parsingContext.getParent();
                if (this._parsingContext == null) {
                    this._parsingContext = JsonReadContext.createRootContext(-1, -1);
                }
            }
            return this._currToken;
        }

        @Override
        public JsonParser skipChildren() throws IOException, JsonParseException {
            if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
                return this;
            }
            int n = 1;
            JsonToken jsonToken;
            while ((jsonToken = this.nextToken()) != null) {
                switch (jsonToken) {
                    case START_OBJECT: 
                    case START_ARRAY: {
                        ++n;
                        break;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        if (--n != 0) break;
                        return this;
                    }
                }
            }
            return this;
        }

        @Override
        public boolean isClosed() {
            return this._closed;
        }

        @Override
        public JsonStreamContext getParsingContext() {
            return this._parsingContext;
        }

        @Override
        public JsonLocation getTokenLocation() {
            return this.getCurrentLocation();
        }

        @Override
        public JsonLocation getCurrentLocation() {
            return this._location == null ? JsonLocation.NA : this._location;
        }

        @Override
        public String getCurrentName() {
            return this._parsingContext.getCurrentName();
        }

        @Override
        public String getText() {
            if (this._currToken != null) {
                switch (this._currToken) {
                    case FIELD_NAME: 
                    case VALUE_STRING: {
                        return (String)this._currentObject();
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        Object object = this._currentObject();
                        return object == null ? null : object.toString();
                    }
                }
                return this._currToken.asString();
            }
            return null;
        }

        @Override
        public char[] getTextCharacters() {
            String string = this.getText();
            return string == null ? null : string.toCharArray();
        }

        @Override
        public int getTextLength() {
            String string = this.getText();
            return string == null ? 0 : string.length();
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
            Number number = this.getNumberValue();
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            switch (this.getNumberType()) {
                case BIG_DECIMAL: {
                    return ((BigDecimal)number).toBigInteger();
                }
            }
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        public BigDecimal getDecimalValue() throws IOException, JsonParseException {
            Number number = this.getNumberValue();
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            switch (this.getNumberType()) {
                case INT: 
                case LONG: {
                    return BigDecimal.valueOf(number.longValue());
                }
                case BIG_INTEGER: {
                    return new BigDecimal((BigInteger)number);
                }
            }
            return BigDecimal.valueOf(number.doubleValue());
        }

        @Override
        public double getDoubleValue() throws IOException, JsonParseException {
            return this.getNumberValue().doubleValue();
        }

        @Override
        public float getFloatValue() throws IOException, JsonParseException {
            return this.getNumberValue().floatValue();
        }

        @Override
        public int getIntValue() throws IOException, JsonParseException {
            return this.getNumberValue().intValue();
        }

        @Override
        public long getLongValue() throws IOException, JsonParseException {
            return this.getNumberValue().longValue();
        }

        @Override
        public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
            Number number = this.getNumberValue();
            if (number instanceof Integer) {
                return JsonParser.NumberType.INT;
            }
            if (number instanceof Long) {
                return JsonParser.NumberType.LONG;
            }
            if (number instanceof Double) {
                return JsonParser.NumberType.DOUBLE;
            }
            if (number instanceof BigDecimal) {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
            if (number instanceof Float) {
                return JsonParser.NumberType.FLOAT;
            }
            if (number instanceof BigInteger) {
                return JsonParser.NumberType.BIG_INTEGER;
            }
            return null;
        }

        @Override
        public final Number getNumberValue() throws IOException, JsonParseException {
            this._checkIsNumber();
            return (Number)this._currentObject();
        }

        @Override
        public Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        @Override
        public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
            Object object;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
                return (byte[])object;
            }
            if (this._currToken != JsonToken.VALUE_STRING) {
                throw this._constructError("Current token (" + this._currToken + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), can not access as binary");
            }
            object = this.getText();
            if (object == null) {
                return null;
            }
            ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
            if (byteArrayBuilder == null) {
                this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
            }
            this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
            return byteArrayBuilder.toByteArray();
        }

        protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException, JsonParseException {
            int n = 0;
            int n2 = string.length();
            block0: while (n < n2) {
                char c;
                do {
                    c = string.charAt(n++);
                    if (n >= n2) break block0;
                } while (c <= ' ');
                int n3 = base64Variant.decodeBase64Char(c);
                if (n3 < 0) {
                    this._reportInvalidBase64(base64Variant, c, 0, null);
                }
                int n4 = n3;
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                    this._reportInvalidBase64(base64Variant, c, 1, null);
                }
                n4 = n4 << 6 | n3;
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                    if (n3 != -2) {
                        this._reportInvalidBase64(base64Variant, c, 2, null);
                    }
                    if (n >= n2) {
                        this._reportBase64EOF();
                    }
                    if (!base64Variant.usesPaddingChar(c = string.charAt(n++))) {
                        this._reportInvalidBase64(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
                n4 = n4 << 6 | n3;
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                    if (n3 != -2) {
                        this._reportInvalidBase64(base64Variant, c, 3, null);
                    }
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
                n4 = n4 << 6 | n3;
                byteArrayBuilder.appendThreeBytes(n4);
            }
        }

        protected final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        protected void _checkIsNumber() throws JsonParseException {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
            }
        }

        protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n, String string) throws JsonParseException {
            String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            throw this._constructError(string2);
        }

        protected void _reportBase64EOF() throws JsonParseException {
            throw this._constructError("Unexpected end-of-String in base64 content");
        }
    }
}

