/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.awt.Point;

public abstract class GLRenderable
implements Renderable,
PreRenderable,
Highlightable,
Movable,
Movable2 {
    protected Layer pickLayer;
    protected Position position;
    protected double azimuth = 0.0;
    protected double roll = 0.0;
    protected double elevation = 0.0;
    protected double renderDistance = 50000.0;
    protected boolean keepConstantSize = true;
    protected double size = 1.0;
    protected boolean clamp = false;
    protected boolean useLighting = true;
    protected boolean visible = true;
    protected Vec4 lightSource = new Vec4(1.0, 0.5, 1.0);
    protected double eyeDistance;
    protected double eyeDistanceOffset = 0.0;
    boolean drawnOnce = false;
    protected PickSupport pickSupport = new PickSupport();
    private boolean highlighted;

    public GLRenderable(Position position) {
        this.position = position;
    }

    public void clamp() {
        this.clamp = true;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.visible) {
            return;
        }
        drawContext.addOrderedRenderable(new OrderedGLRenderable());
    }

    protected void updateEyeDistance(DrawContext drawContext) {
        this.eyeDistance = drawContext.getGlobe().computePointFromPosition(this.position).distanceTo3(drawContext.getView().getEyePoint()) + this.eyeDistanceOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void myRender(DrawContext drawContext) {
        this.updateEyeDistance(drawContext);
        if (this.eyeDistance > this.renderDistance) {
            return;
        }
        try {
            if (drawContext.isPickingMode() && drawContext.getCurrentLayer() != null) {
                this.pickLayer = drawContext.getCurrentLayer();
            }
            this.beginDraw(drawContext);
            if (drawContext.isPickingMode()) {
                GL2 gL2 = drawContext.getGL().getGL2();
                Color color = drawContext.getUniquePickColor();
                this.pickSupport.addPickableObject(color.getRGB(), this, this.position);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            }
            this.draw(drawContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.endDraw(drawContext);
        }
    }

    protected void draw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Vec4 vec4 = this.clamp ? drawContext.computeTerrainPoint(this.position.latitude, this.position.longitude, 0.0) : drawContext.getGlobe().computePointFromPosition(this.position, this.position.elevation * drawContext.getVerticalExaggeration());
        double d = this.computeSize(drawContext, vec4);
        if (drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            drawContext.getView().pushReferenceCenter(drawContext, vec4);
            gL2.glRotated(this.position.getLongitude().degrees, 0.0, 1.0, 0.0);
            gL2.glRotated(-this.position.getLatitude().degrees, 1.0, 0.0, 0.0);
            gL2.glRotated(-this.azimuth, 0.0, 0.0, 1.0);
            gL2.glRotated(this.elevation, 1.0, 0.0, 0.0);
            gL2.glRotated(this.roll, 0.0, 1.0, 0.0);
            gL2.glScaled(d, d, d);
            this.drawGL(drawContext);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    protected abstract void drawGL(DrawContext var1);

    protected void beginDraw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(323915);
        if (this.useLighting && !drawContext.isPickingMode()) {
            gL2.glEnable(2884);
            gL2.glEnable(7425);
            gL2.glEnable(2896);
            gL2.glLightModeli(2897, 1);
            gL2.glLightModeli(2898, 0);
            gL2.glEnable(16384);
            Vec4 vec4 = this.lightSource.normalize3();
            float[] fArray = new float[]{(float)vec4.x, (float)vec4.y, (float)vec4.z, 0.0f};
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glLightfv(16384, 4611, fArray, 0);
            gL2.glPopMatrix();
        }
        gL2.glEnable(2977);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
    }

    protected void endDraw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glPopAttrib();
    }

    protected double computeSize(DrawContext drawContext, Vec4 vec4) {
        if (this.keepConstantSize) {
            return this.size;
        }
        if (vec4 == null) {
            System.err.println("Null location when computing size");
            return 1.0;
        }
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = 60.0 * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < 2.0) {
            d2 = 2.0;
        }
        return d2;
    }

    protected final Vec4 computeTerrainPoint(DrawContext drawContext, Angle angle, Angle angle2) {
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2);
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, drawContext.getGlobe().getElevation(angle, angle2) * drawContext.getVerticalExaggeration());
        }
        return vec4;
    }

    public boolean isConstantSize() {
        return this.keepConstantSize;
    }

    public void setKeepConstantSize(boolean bl) {
        this.keepConstantSize = bl;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double d) {
        this.azimuth = d;
    }

    public double getRoll() {
        return this.roll;
    }

    public void setRoll(double d) {
        this.roll = d;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setRenderDistance(double d) {
        this.renderDistance = d;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext.getCurrentLayer() != null) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public Position getReferencePosition() {
        return this.position;
    }

    @Override
    public void move(Position position) {
        Angle angle = LatLon.greatCircleAzimuth(this.getReferencePosition(), position);
        Angle angle2 = LatLon.greatCircleDistance(this.getReferencePosition(), position);
        this.position = new Position(LatLon.greatCircleEndPosition((LatLon)this.position, angle, angle2), this.position.elevation);
    }

    protected void doMoveTo(Globe globe, Position position, Position position2) {
        this.position = new Position(position2, this.position.getElevation());
    }

    @Override
    public void moveTo(Position position) {
        this.position = position;
    }

    @Override
    public void moveTo(Globe globe, Position position) {
        this.position = new Position(position, this.position.getElevation());
    }

    public class OrderedGLRenderable
    implements OrderedRenderable {
        @Override
        public double getDistanceFromEye() {
            return GLRenderable.this.eyeDistance;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            GLRenderable.this.pickSupport.clearPickList();
            try {
                GLRenderable.this.pickSupport.beginPicking(drawContext);
                GLRenderable.this.myRender(drawContext);
            }
            finally {
                GLRenderable.this.pickSupport.endPicking(drawContext);
                GLRenderable.this.pickSupport.resolvePick(drawContext, point, GLRenderable.this.pickLayer);
            }
        }

        @Override
        public void render(DrawContext drawContext) {
            GLRenderable.this.myRender(drawContext);
        }
    }
}

