/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.fire;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.util.ArrayList;
import osm.map.worldwind.gl.fire.Spark;

public class Fire {
    float radius;
    float height;
    float lifespan;
    int genRate;
    Color color = Color.RED;
    Texture texture;
    private ArrayList<Spark> particles;

    public Fire(float f, float f2, float f3, int n) {
        this.radius = f;
        this.height = f2;
        this.lifespan = f3;
        this.genRate = n;
        this.particles = new ArrayList();
        try {
            this.texture = TextureIO.newTexture(this.getClass().getResource("/osm/map/worldwind/gl/fire/smoke3.png"), false, ".png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.spawnParticles(1.0f);
    }

    public void draw(GL2 gL2) {
        gL2.glEnable(3042);
        OGLUtil.applyBlending(gL2, false);
        gL2.glDisable(2896);
        gL2.glPushAttrib(8192);
        gL2.glTexParameteri(3553, 10242, 10496);
        gL2.glTexParameteri(3553, 10243, 10496);
        gL2.glEnable(3553);
        for (Spark spark : this.particles) {
            gL2.glPushMatrix();
            gL2.glColor4fv(spark.getColor(), 0);
            gL2.glTranslatef(spark.getPos()[0], spark.getPos()[1], spark.getPos()[2]);
            gL2.glRotatef(spark.roty, 0.0f, 1.0f, 0.0f);
            this.texture.bind(gL2);
            gL2.glBegin(4);
            gL2.glTexCoord2f(0.0f, 0.0f);
            gL2.glVertex3f(-spark.size / 2.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(0.0f, 1.0f);
            gL2.glVertex3f(0.0f, spark.size, 0.0f);
            gL2.glTexCoord2f(1.0f, 0.0f);
            gL2.glVertex3f(spark.size / 2.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(0.0f, 0.0f);
            gL2.glVertex3f(0.0f, 0.0f, -spark.size / 2.0f);
            gL2.glTexCoord2f(0.0f, 1.0f);
            gL2.glVertex3f(0.0f, spark.size, 0.0f);
            gL2.glTexCoord2f(1.0f, 0.0f);
            gL2.glVertex3f(0.0f, 0.0f, spark.size / 2.0f);
            gL2.glEnd();
            gL2.glPopMatrix();
        }
        gL2.glDisable(3553);
        gL2.glPopAttrib();
        gL2.glEnable(2896);
    }

    public void update(float f) {
        float[] fArray = new float[]{(float)Math.random() * 10.0f - 5.0f, 0.0f, (float)Math.random() * 10.0f - 5.0f};
        ArrayList<Spark> arrayList = new ArrayList<Spark>();
        for (Spark spark : this.particles) {
            if (spark.isAlive()) {
                spark.move(f, fArray);
                float f2 = spark.getAge() / spark.getLifeTime();
                if (f2 <= 0.9f || spark.getPos()[1] < this.height * 20.0f) {
                    spark.setColor(1, f2);
                    spark.setColor(3, 1.0f - f2);
                    continue;
                }
                spark.setColor(new float[]{0.1f, 0.1f, 0.1f, 0.1f});
                continue;
            }
            arrayList.add(spark);
        }
        this.particles.removeAll(arrayList);
        arrayList.clear();
        this.spawnParticles(f);
    }

    private void spawnParticles(float f) {
        float f2 = f * (float)this.genRate;
        float f3 = (float)((int)f2) - f2;
        f2 = (int)f2;
        if (Math.random() < (double)f3) {
            f2 += 1.0f;
        }
        int n = 0;
        while ((float)n < f2) {
            float f4 = (float)Math.sqrt(Math.random()) * this.radius;
            float f5 = (float)(Math.random() * Math.PI * 2.0);
            Spark spark = new Spark(new float[]{(float)Math.cos(f5) * f4, 0.0f, (float)Math.sin(f5) * f4}, new float[]{(float)Math.random() * 2.0f - 1.0f, (float)Math.random() * this.height * 6.0f, (float)Math.random() * 2.0f - 1.0f}, (float)Math.random() * this.height * this.lifespan + 1.0f);
            spark.setColor(new float[]{(float)this.color.getRed() / 256.0f, (float)this.color.getGreen() / 256.0f, (float)this.color.getBlue() / 256.0f, 0.3f});
            this.particles.add(spark);
            ++n;
        }
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setLifeSpan(float f) {
        this.lifespan = f;
    }

    public void setGenRate(int n) {
        this.genRate = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

