/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.fire;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import java.awt.Color;
import osm.map.worldwind.gl.GLRenderable;
import osm.map.worldwind.gl.fire.Fire;

public class FireRenderable
extends GLRenderable {
    Fire fire;
    float radius;
    float height;
    float lifespan;
    int genRate;
    boolean initialized = false;
    long previousTimeStamp = System.currentTimeMillis();

    public FireRenderable(Position position, float f, float f2, float f3, int n, double d) {
        super(position);
        this.radius = f;
        this.height = f2;
        this.lifespan = f3;
        this.genRate = n;
        this.size = d;
        this.useLighting = false;
    }

    public void reload() {
        this.initialized = false;
    }

    @Override
    protected void drawGL(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!this.initialized) {
            if (this.fire != null) {
                this.fire.setGenRate(0);
            }
            this.fire = new Fire(this.radius, this.height, this.lifespan, this.genRate);
            this.initialized = true;
        }
        this.fire.draw(gL2);
        long l = System.currentTimeMillis();
        if (l - this.previousTimeStamp > 30L) {
            this.fire.update(0.2f);
            this.previousTimeStamp = l;
        }
    }

    public void setRadius(double d) {
        this.fire.setRadius((float)d);
    }

    public void setHeight(double d) {
        this.fire.setHeight((float)d);
    }

    public void setLifeSpan(double d) {
        this.fire.setLifeSpan((float)d);
    }

    public void setGenRate(int n) {
        this.fire.setGenRate(n);
    }

    public void setColor(Color color) {
        this.fire.setColor(color);
    }
}

