/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.fire;

public class Particle
implements Comparable<Particle> {
    private float[] pos;
    private float[] veloc;
    private float age;
    private float lifeTime;
    private float[] color;
    private static float[] viewer;

    public static void setViewerPosition(float[] fArray) {
        viewer = fArray;
    }

    public Particle(float[] fArray, float[] fArray2, float f) {
        this.pos = fArray;
        this.veloc = fArray2;
        this.age = 0.0f;
        this.lifeTime = f;
        this.color = new float[]{0.0f, 0.0f, 0.0f};
    }

    public void setVeloc(float[] fArray) {
        this.veloc = fArray;
    }

    public void setColor(float[] fArray) {
        if (fArray.length == 3) {
            this.color = new float[]{fArray[0], fArray[1], fArray[2]};
        } else if (fArray.length == 4) {
            this.color = new float[]{fArray[0], fArray[1], fArray[2], fArray[3]};
        }
    }

    public void reset(float[] fArray, float[] fArray2, float f) {
        this.pos = fArray;
        this.veloc = fArray2;
        this.lifeTime = f;
        this.age = 0.0f;
    }

    public void setColor(int n, float f) {
        this.color[n] = f;
    }

    public void setPos(int n, float f) {
        this.pos[n] = f;
    }

    public float getAge() {
        return this.age;
    }

    public float getLifeTime() {
        return this.lifeTime;
    }

    public float[] getColor() {
        if (this.color.length == 4) {
            return new float[]{this.color[0], this.color[1], this.color[2], this.color[3]};
        }
        return new float[]{this.color[0], this.color[1], this.color[2]};
    }

    public void move(float f, float[] fArray) {
        this.veloc[0] = this.veloc[0] + fArray[0] * f;
        this.veloc[1] = this.veloc[1] + fArray[1] * f;
        this.veloc[2] = this.veloc[2] + fArray[2] * f;
        this.pos[0] = this.pos[0] + this.veloc[0] * f;
        this.pos[1] = this.pos[1] + this.veloc[1] * f;
        this.pos[2] = this.pos[2] + this.veloc[2] * f;
        this.age += f;
    }

    public boolean isAlive() {
        return this.age <= this.lifeTime;
    }

    public float[] getPos() {
        return new float[]{this.pos[0], this.pos[1], this.pos[2]};
    }

    public float[] getVeloc() {
        return new float[]{this.veloc[0], this.veloc[1], this.veloc[2]};
    }

    @Override
    public int compareTo(Particle particle) {
        float f;
        float[] fArray = particle.getPos();
        float f2 = (viewer[0] - fArray[0]) * (viewer[0] - fArray[0]) + (viewer[1] - fArray[1]) * (viewer[1] - fArray[1]) + (viewer[2] - fArray[2]) * (viewer[2] - fArray[2]);
        if (f2 > (f = (viewer[0] - this.pos[0]) * (viewer[0] - this.pos[0]) + (viewer[1] - this.pos[1]) * (viewer[1] - this.pos[1]) + (viewer[2] - this.pos[2]) * (viewer[2] - this.pos[2]))) {
            return 1;
        }
        if (f2 < f) {
            return -1;
        }
        return 0;
    }
}

