/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.obj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MtlLoader {
    String basePath;
    public List<Material> materials = new ArrayList<Material>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MtlLoader(String string, String string2) {
        this.basePath = string;
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = this.getInputStream(string, string2);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.loadobject(bufferedReader);
        }
        catch (IOException iOException) {
            System.out.println("Could not open file: " + string + "/" + string2);
            this.materials = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(MtlLoader.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    final InputStream getInputStream(String string, String string2) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string + "/" + string2);
        if (inputStream == null) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(new File(string), string2);
            }
            if (file.exists() && file.canRead()) {
                inputStream = new FileInputStream(file);
            }
        }
        return inputStream;
    }

    boolean exists(String string, String string2) throws IOException {
        URL uRL = this.getClass().getResource(string + "/" + string2);
        if (uRL == null) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(new File(string), string2);
            }
            uRL = file.toURI().toURL();
        }
        return uRL != null;
    }

    public Material getMtl(String string) {
        for (int i = 0; i < this.materials.size(); ++i) {
            Material material = this.materials.get(i);
            if (!material.name.matches(string)) continue;
            return material;
        }
        return null;
    }

    private float[] getValues(String string) {
        String[] stringArray = string.split("\\s+");
        return new float[]{Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
    }

    private float getValue(String string) {
        return Float.parseFloat(string.split("\\s+")[1]);
    }

    private void loadobject(BufferedReader bufferedReader) {
        int n = 0;
        try {
            String string;
            boolean bl = true;
            Material material = new Material();
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                ++n;
                if ((string = string.trim()).length() <= 0) continue;
                if (string.startsWith("newmtl")) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.materials.add(material);
                        material = new Material();
                    }
                    object = string.split("\\s+");
                    material.name = object[1];
                    material.mtlnum = n2++;
                }
                if (string.startsWith("Ka")) {
                    material.Ka = this.getValues(string);
                }
                if (string.startsWith("Kd")) {
                    material.Kd = this.getValues(string);
                }
                if (string.startsWith("Ks")) {
                    material.Ks = this.getValues(string);
                }
                if (string.startsWith("d")) {
                    material.d = this.getValue(string);
                }
                if (string.startsWith("Ns")) {
                    material.Ns = this.getValue(string);
                }
                if (string.startsWith("illum")) {
                    material.illum = this.getValue(string);
                }
                if (!string.startsWith("map_Kd")) continue;
                object = string.trim().substring(string.indexOf(" ")).trim();
                if (this.exists(this.basePath, (String)object)) {
                    material.map_Kd = object;
                    continue;
                }
                System.err.println("Error: unable to read texture " + (String)object);
            }
            this.materials.add(material);
        }
        catch (IOException iOException) {
            System.out.println("Failed to read file: " + bufferedReader.toString());
            iOException.printStackTrace();
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
            System.out.println("Malformed MTL (on line " + n + "): " + bufferedReader.toString() + "\r \r" + runtimeException.getMessage());
        }
    }

    public class Material {
        public String name;
        public int mtlnum;
        public float Ns;
        public float Ni;
        public float Tr;
        public float illum;
        public float[] Tf = new float[3];
        public float d = 1.0f;
        public float[] Ka = new float[3];
        public float[] Kd = new float[3];
        public float[] Ks = new float[3];
        public float[] Ke = new float[3];
        public String map_Kd = null;
    }
}

