/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.obj;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import osm.map.worldwind.gl.obj.BoundingBox;
import osm.map.worldwind.gl.obj.MtlLoader;

public class ObjLoader {
    List<float[]> vertexSets = new ArrayList<float[]>();
    List<float[]> vertexSetsNorms = new ArrayList<float[]>();
    List<float[]> vertexSetsTexs = new ArrayList<float[]>();
    List<Face> faces = new ArrayList<Face>();
    int objectlist;
    float toppoint;
    float bottompoint;
    float leftpoint;
    float rightpoint;
    float farpoint;
    float nearpoint;
    Map<String, Texture> textureCache = new HashMap<String, Texture>();
    BoundingBox bbox;
    private static final Logger logger = Logger.getLogger(ObjLoader.class.getName());
    String basePath;
    boolean flipTextureVertically;

    public ObjLoader(String string, GL2 gL2, boolean bl, boolean bl2) {
        this.flipTextureVertically = bl2;
        String string2 = "";
        string = string.replaceAll("\\\\", "/");
        int n = string.lastIndexOf("/");
        if (n < 0) {
            n = 0;
        }
        String string3 = string.substring(n + 1);
        string2 = string.substring(0, n);
        this.init(string2, string3, gL2, bl);
    }

    public ObjLoader(String string, String string2, GL2 gL2, boolean bl, boolean bl2) {
        this.flipTextureVertically = bl2;
        this.init(string, string2, gL2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string, String string2, GL2 gL2, boolean bl) {
        try {
            this.basePath = string == null ? "" : string;
            try (BufferedReader bufferedReader = null;){
                InputStream inputStream = this.getInputStream(string, string2);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                this.loadObject(bufferedReader);
                if (bl) {
                    this.centerit();
                }
                this.opengldrawtolist(gL2);
                this.cleanup();
            }
            this.bbox = new BoundingBox(this.getXWidth(), this.getYHeight(), this.getZDepth(), this.bottompoint, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException("error loading model: " + string + "/" + string2, exception);
        }
    }

    InputStream getInputStream(String string, String string2) throws IOException {
        File file;
        String string3 = string + "/" + string2;
        InputStream inputStream = this.getClass().getResourceAsStream(string3);
        if (inputStream == null && (file = new File(string3)).exists()) {
            inputStream = new FileInputStream(file);
        }
        if (string3.endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream, 8192);
        }
        return inputStream;
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    private void cleanup() {
        this.vertexSets.clear();
        this.vertexSetsNorms.clear();
        this.vertexSetsTexs.clear();
        this.faces.clear();
    }

    private void loadObject(BufferedReader bufferedReader) {
        String string = null;
        MtlLoader mtlLoader = null;
        try {
            String string2;
            boolean bl = true;
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (string2.length() <= 0) continue;
                if ((string2 = string2.trim()).startsWith("v ")) {
                    object = new float[4];
                    string2 = string2.substring(2, string2.length());
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        object[n] = Float.parseFloat(stringTokenizer.nextToken());
                        ++n;
                    }
                    if (bl) {
                        this.rightpoint = object[0];
                        this.leftpoint = (float)object[0];
                        this.toppoint = (float)object[1];
                        this.bottompoint = (float)object[1];
                        this.nearpoint = (float)object[2];
                        this.farpoint = (float)object[2];
                        bl = false;
                    }
                    this.rightpoint = Math.max(object[0], this.rightpoint);
                    this.leftpoint = Math.min((float)object[0], this.leftpoint);
                    this.toppoint = Math.max((float)object[1], this.toppoint);
                    this.bottompoint = Math.min((float)object[1], this.bottompoint);
                    this.nearpoint = Math.max((float)object[2], this.nearpoint);
                    this.farpoint = Math.min((float)object[2], this.farpoint);
                    this.vertexSets.add((float[])object);
                    continue;
                }
                if (string2.startsWith("vt")) {
                    object = new float[4];
                    string2 = string2.substring(3, string2.length());
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        object[n] = Float.parseFloat(stringTokenizer.nextToken());
                        ++n;
                    }
                    this.vertexSetsTexs.add((float[])object);
                    continue;
                }
                if (string2.startsWith("vn")) {
                    object = new float[4];
                    string2 = string2.substring(3, string2.length());
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        object[n] = Float.parseFloat(stringTokenizer.nextToken());
                        ++n;
                    }
                    this.vertexSetsNorms.add((float[])object);
                    continue;
                }
                if (string2.startsWith("f ")) {
                    string2 = string2.substring(2, string2.length());
                    object = new StringTokenizer(string2, " ");
                    int n = ((StringTokenizer)object).countTokens();
                    int[] nArray = new int[n];
                    int[] nArray2 = new int[n];
                    int[] nArray3 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        char[] cArray = ((StringTokenizer)object).nextToken().toCharArray();
                        StringBuilder stringBuilder = new StringBuilder();
                        char c = 'x';
                        for (int j = 0; j < cArray.length; ++j) {
                            if (cArray[j] == '/' && c == '/') {
                                stringBuilder.append('0');
                            }
                            c = cArray[j];
                            stringBuilder.append(c);
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString(), "/");
                        int n2 = stringTokenizer.countTokens();
                        nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        nArray2[i] = n2 > 1 ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                        nArray3[i] = n2 > 2 ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                    }
                    this.faces.add(new Face(mtlLoader.getMtl(string), nArray, nArray3, nArray2));
                    continue;
                }
                if (string2.startsWith("mtllib")) {
                    mtlLoader = new MtlLoader(this.basePath, string2.substring(string2.indexOf(" ")).trim());
                    continue;
                }
                if (!string2.startsWith("usemtl")) continue;
                string = string2.split("\\s+")[1];
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed to read file: " + bufferedReader.toString());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Malformed OBJ file: " + bufferedReader.toString() + "\r \r" + numberFormatException.getMessage());
        }
        Collections.sort(this.faces);
    }

    private void centerit() {
        float f = (this.rightpoint - this.leftpoint) / 2.0f;
        float f2 = (this.toppoint - this.bottompoint) / 2.0f;
        float f3 = (this.nearpoint - this.farpoint) / 2.0f;
        for (int i = 0; i < this.vertexSets.size(); ++i) {
            float[] fArray = new float[4];
            fArray[0] = this.vertexSets.get(i)[0] - this.leftpoint - f;
            fArray[1] = this.vertexSets.get(i)[1] - this.bottompoint;
            fArray[2] = this.vertexSets.get(i)[2] - this.farpoint - f3;
            this.vertexSets.set(i, fArray);
        }
    }

    public double getMaxDimen() {
        double d = Math.max(this.getXWidth(), this.getYHeight());
        return Math.max(d, (double)this.getZDepth());
    }

    public float getXWidth() {
        return this.rightpoint - this.leftpoint;
    }

    public float getYHeight() {
        return this.toppoint - this.bottompoint;
    }

    public float getZDepth() {
        return this.nearpoint - this.farpoint;
    }

    public int getPolygonCount() {
        return this.faces.size();
    }

    private void opengldrawtolist(GL2 gL2) {
        String string = "";
        Texture texture = null;
        this.objectlist = gL2.glGenLists(1);
        gL2.glNewList(this.objectlist, 4864);
        MtlLoader.Material material = null;
        for (Face face : this.faces) {
            if (material == null || !material.name.equals(face.mtl.name)) {
                material = face.mtl;
                if (material.map_Kd == null) {
                    if (texture != null) {
                        texture.disable(gL2);
                        texture = null;
                        string = "";
                    }
                } else if (!string.equals(material.map_Kd.toString())) {
                    if (texture != null) {
                        texture.disable(gL2);
                    }
                    texture = face.texture;
                    texture.enable(gL2);
                    texture.bind(gL2);
                    gL2.glTexParameteri(3553, 10243, 10497);
                    gL2.glTexParameteri(3553, 10242, 10497);
                    gL2.glTexParameteri(3553, 10240, 9729);
                    gL2.glTexParameteri(3553, 10241, 9729);
                    string = material.map_Kd.toString();
                }
                gL2.glEnable(2903);
                gL2.glBlendFunc(770, 771);
                gL2.glEnable(3042);
                float[] fArray = this.lighten(new float[]{Math.min(1.0f, material.Kd[0] + material.Ka[0]), Math.min(1.0f, material.Kd[1] + material.Ka[1]), Math.min(1.0f, material.Kd[2] + material.Ka[2])}, 0.15f);
                gL2.glColor4f(fArray[0], fArray[1], fArray[2], material.d);
            }
            gL2.glBegin(face.polyType);
            for (int i = 0; i < face.v.length; ++i) {
                float[] fArray;
                if (face.vn[i] != 0) {
                    fArray = this.vertexSetsNorms.get(face.vn[i] - 1);
                    gL2.glNormal3f(fArray[0], fArray[1], fArray[2]);
                }
                if (face.vt[i] != 0) {
                    fArray = this.vertexSetsTexs.get(face.vt[i] - 1);
                    if (this.flipTextureVertically) {
                        gL2.glTexCoord2f(fArray[0], 1.0f - fArray[1]);
                    } else {
                        gL2.glTexCoord2f(fArray[0], fArray[1]);
                    }
                }
                fArray = this.vertexSets.get(face.v[i] - 1);
                gL2.glVertex3f(fArray[0], fArray[1], fArray[2]);
            }
            gL2.glEnd();
        }
        gL2.glDisable(2903);
        if (texture != null) {
            texture.disable(gL2);
        }
        gL2.glEndList();
    }

    private float[] lighten(float[] fArray, float f) {
        float f2 = Math.min(1.0f, fArray[0] + f);
        float f3 = Math.min(1.0f, fArray[1] + f);
        float f4 = Math.min(1.0f, fArray[2] + f);
        return new float[]{f2, f3, f4};
    }

    public void opengldraw(GL2 gL2) {
        gL2.glCallList(this.objectlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Texture getTexture(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (this.textureCache.get(string) == null) {
            try (InputStream inputStream = null;){
                inputStream = this.getInputStream(this.basePath, string);
                String string2 = null;
                String[] stringArray = string.split("\\.");
                if (stringArray != null && stringArray.length > 1) {
                    string2 = stringArray[stringArray.length - 1];
                }
                Texture texture = TextureIO.newTexture(inputStream, false, string2);
                this.textureCache.put(string, texture);
            }
        }
        return this.textureCache.get(string);
    }

    public class Face
    implements Comparable<Face> {
        MtlLoader.Material mtl;
        int[] v;
        int[] vn;
        int[] vt;
        int polyType;
        Texture texture;

        public Face(MtlLoader.Material material, int[] nArray, int[] nArray2, int[] nArray3) {
            this.mtl = material;
            this.v = nArray;
            this.vn = nArray2;
            this.vt = nArray3;
            switch (nArray.length) {
                case 3: {
                    this.polyType = 4;
                    break;
                }
                case 4: {
                    this.polyType = 7;
                    break;
                }
                default: {
                    this.polyType = 9;
                }
            }
            if (material.map_Kd != null) {
                try {
                    this.texture = ObjLoader.this.getTexture(material.map_Kd);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Exception reading texture: " + material.map_Kd, exception);
                }
            }
        }

        @Override
        public int compareTo(Face face) {
            if (this.mtl.d > face.mtl.d) {
                return -1;
            }
            if (this.mtl.d < face.mtl.d) {
                return 1;
            }
            if (this.texture == null && face.texture != null) {
                return -1;
            }
            if (this.texture != null && face.texture == null) {
                return 1;
            }
            if (this.texture != null && face.texture != null) {
                return this.mtl.map_Kd.compareTo(face.mtl.map_Kd);
            }
            return this.mtl.name.compareTo(face.mtl.name);
        }
    }
}

