/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TextVariableHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextVariableHelper.class);
    private static final char MASKING_CHAR = '\\';
    private static final char DOLLAR = '$';
    private static final char OPENING_BRACKET = '{';
    private static final char CLOSING_BRACKET = '}';

    private TextVariableHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckForSigned
    private static int _nextCharConsiderMasking(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnegative char c, @Nonnull StringBuilder stringBuilder) {
        boolean bl = false;
        for (int i = n; i < n + n2; ++i) {
            char c2 = cArray[i];
            if (c2 == '\\') {
                boolean bl2 = bl = !bl;
                if (bl) continue;
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == c) {
                if (!bl) return i;
                stringBuilder.append(c2);
            } else {
                stringBuilder.append(c2);
            }
            bl = false;
        }
        return -1;
    }

    @CheckForSigned
    private static int _findStartOfVarName(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull StringBuilder stringBuilder) {
        int n3 = TextVariableHelper._nextCharConsiderMasking(cArray, n, n2, '$', stringBuilder);
        while (n3 >= n && n3 <= n + n2 - 1) {
            boolean bl;
            boolean bl2 = bl = n3 == n + n2 - 1;
            if (!bl && cArray[n3 + 1] == '{') {
                return n3 + 2;
            }
            stringBuilder.append('$');
            if (bl) {
                return -1;
            }
            n3 = TextVariableHelper._nextCharConsiderMasking(cArray, n3 + 1, n2, '$', stringBuilder);
        }
        return n3;
    }

    @Nonnull
    static ICommonsList<String> splitByVariables(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Text");
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(n);
        int n3 = TextVariableHelper._findStartOfVarName(cArray, n2, n - n2, stringBuilder);
        while (n3 >= 0) {
            commonsArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            int n4 = TextVariableHelper._nextCharConsiderMasking(cArray, n3, n - n3, '}', stringBuilder);
            if (n4 < 0) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("End of variable was not found in '" + string + "' starting from ofs " + n3);
                }
                String string2 = string.substring(n3 - 2);
                if (commonsArrayList.size() % 2 == 1) {
                    commonsArrayList.setLast((String)commonsArrayList.getLast() + string2);
                } else {
                    commonsArrayList.add(string2);
                }
                stringBuilder.setLength(0);
                break;
            }
            commonsArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            n2 = n4 + 1;
            n3 = TextVariableHelper._findStartOfVarName(cArray, n2, n - n2, stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            commonsArrayList.add(stringBuilder.toString());
        }
        return commonsArrayList;
    }

    public static boolean containsVariables(@Nullable String string) {
        return StringHelper.hasText(string) && TextVariableHelper.splitByVariables(string).size() > 1;
    }

    public static void forEachTextAndVariable(@Nullable String string, @Nonnull Consumer<String> consumer, @Nonnull Consumer<String> consumer2) {
        ValueEnforcer.notNull(consumer, "TextFragmentHandler");
        ValueEnforcer.notNull(consumer2, "VariableNameHandler");
        if (StringHelper.hasNoText(string)) {
            consumer.accept(string);
        } else {
            ICommonsList<String> iCommonsList = TextVariableHelper.splitByVariables(string);
            if (iCommonsList.size() <= 1) {
                consumer.accept(string);
            } else {
                boolean bl = true;
                for (String string2 : iCommonsList) {
                    if (StringHelper.hasText(string2)) {
                        if (bl) {
                            consumer.accept(string2);
                        } else {
                            consumer2.accept(string2);
                        }
                    }
                    bl = !bl;
                }
            }
        }
    }

    @Nullable
    public static String getWithReplacedVariables(@Nullable String string2, @Nonnull UnaryOperator<String> unaryOperator) {
        ValueEnforcer.notNull(unaryOperator, "VariableProvider");
        if (StringHelper.hasNoText(string2)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() * 2);
        TextVariableHelper.forEachTextAndVariable(string2, stringBuilder::append, string -> {
            String string2 = (String)unaryOperator.apply((String)string);
            stringBuilder.append(string2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved configuration variable '" + string + "' to '" + string2 + "'");
            }
        });
        return stringBuilder.toString();
    }
}

