/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.javascript.object;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import netscape.javascript.JSObject;

public class LatLong
extends JavascriptObject {
    public static final double EarthRadiusMeters = 6378137.0;

    public LatLong(double latitude, double longitude) {
        super("google.maps.LatLng", latitude, longitude);
    }

    public LatLong(JSObject jsObject) {
        super("google.maps.LatLng", jsObject);
    }

    public double getLatitude() {
        return this.invokeJavascriptReturnValue("lat", Number.class).doubleValue();
    }

    public double getLongitude() {
        return this.invokeJavascriptReturnValue("lng", Number.class).doubleValue();
    }

    public double distanceFrom(LatLong end) {
        double dLat = (end.getLatitude() - this.getLatitude()) * Math.PI / 180.0;
        double dLon = (end.getLongitude() - this.getLongitude()) * Math.PI / 180.0;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(this.getLatitude() * Math.PI / 180.0) * Math.cos(end.getLatitude() * Math.PI / 180.0) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = 6378137.0 * c;
        return d;
    }

    public double latToRadians() {
        return Math.toRadians(this.getLatitude());
    }

    public double longToRadians() {
        return Math.toRadians(this.getLongitude());
    }

    public LatLong getDestinationPoint(double bearing, double distance) {
        double brng = Math.toRadians(bearing);
        double lat1 = this.latToRadians();
        double lon1 = this.longToRadians();
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distance / 6378137.0) + Math.cos(lat1) * Math.sin(distance / 6378137.0) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(distance / 6378137.0) * Math.cos(lat1), Math.cos(distance / 6378137.0) - Math.sin(lat1) * Math.sin(lat2));
        return new LatLong(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public double getBearing(LatLong end) {
        if (this.equals(end)) {
            return 0.0;
        }
        double lat1 = this.latToRadians();
        double lon1 = this.longToRadians();
        double lat2 = end.latToRadians();
        double lon2 = end.longToRadians();
        double angle = -Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return Math.toDegrees(angle);
    }

    public String toString() {
        return "lat: " + String.format("%.8G", this.getLatitude()) + " lng: " + String.format("%.8G", this.getLongitude());
    }
}

