/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.geocoding;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.service.geocoding.GeocoderAddressComponentType;
import com.dlsc.gmapsfx.service.geocoding.GeocoderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class GeocoderAddressComponent
extends JavascriptObject {
    public GeocoderAddressComponent() {
        super("google.maps.GeocoderAddressComponent");
    }

    public GeocoderAddressComponent(JSObject jsObject) {
        super("google.maps.GeocoderAddressComponent", jsObject);
    }

    public String getShortName() {
        return this.getJSObject().getMember("short_name").toString();
    }

    public String getLongName() {
        return this.getJSObject().getMember("long_name").toString();
    }

    public List<GeocoderAddressComponentType> getTypes() {
        JSObject jsType = (JSObject)this.getJSObject().getMember("types");
        return GeocoderUtils.convertJSObjectToListOfEnum(jsType, GeocoderAddressComponentType.class);
    }

    public List<String> getPostcodeLocalities() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            if (!(this.jsObject.getMember("postcode_localities") instanceof String)) {
                List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.jsObject.getMember("postcode_localities"));
                for (JSObject jsLocality : jsLocalities) {
                    String text = jsLocality.toString();
                    if (text == null || text.isEmpty() || text.equals("undefined")) continue;
                    result.add(text);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", e);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\t Short Name: ").append(this.getShortName()).append("\n");
        builder.append("\t Long Name: ").append(this.getLongName()).append("\n");
        builder.append("\t Component Types: ").append(this.getTypes()).append("\n");
        builder.append("\t Postcode Localities: ").append(this.getPostcodeLocalities()).append("\n");
        return builder.toString();
    }
}

