/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import se.trixon.almond.util.AlmondGui;
import se.trixon.almond.util.AlmondOptions;
import se.trixon.almond.util.Xlog;
import se.trixon.almond.util.icons.material.swing.MaterialIcon;
import se.trixon.almond.util.swing.SwingHelper;

public class AlmondUI
extends AlmondGui {
    protected final AlmondOptions mAlmondOptions = AlmondOptions.getInstance();
    private final ArrayList<AlmondOptions.AlmondOptionsWatcher> mAlmondOptionsWatchers = new ArrayList();
    private JFrame mFrame = null;

    public static AlmondUI getInstance() {
        return Holder.INSTANCE;
    }

    private AlmondUI() {
        if (IS_MAC) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.mAlmondOptions.getPreferences().addPreferenceChangeListener(evt -> {
            String key = evt.getKey();
            AlmondOptions.AlmondOptionsEvent almondOptionsEvent = key.equalsIgnoreCase("displayMenuIcons") ? AlmondOptions.AlmondOptionsEvent.MENU_ICONS : (key.equalsIgnoreCase("forceLookAndFeel") || key.equalsIgnoreCase("lookAndFeel") ? AlmondOptions.AlmondOptionsEvent.LOOK_AND_FEEL : (key.equalsIgnoreCase("lookAndFeelIcons") ? AlmondOptions.AlmondOptionsEvent.ICON_THEME : (key.equalsIgnoreCase("menu_mode") ? AlmondOptions.AlmondOptionsEvent.MENU_MODE : null)));
            this.initClientOption(almondOptionsEvent);
            this.notifyOptionWatchers(almondOptionsEvent);
        });
    }

    public void addOptionsWatcher(AlmondOptions.AlmondOptionsWatcher almondOptionsWatcher) {
        this.mAlmondOptionsWatchers.add(almondOptionsWatcher);
    }

    public void addWindowWatcher(final Preferences preferences, final JFrame frame) {
        this.mFrame = frame;
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingHelper.frameStateSave(preferences, frame);
                try {
                    preferences.sync();
                }
                catch (BackingStoreException ex) {
                    Logger.getLogger(AlmondUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        try {
            SwingHelper.frameStateRestore(preferences, frame, 900, 700);
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(AlmondUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JFrame getFrame() {
        return this.mFrame;
    }

    public void initLookAndFeel() {
        if (this.mAlmondOptions.isForceLookAndFeel()) {
            try {
                UIManager.setLookAndFeel(SwingHelper.getLookAndFeelClassName(this.mAlmondOptions.getLookAndFeel()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                Xlog.timedErr(ex.getMessage());
            }
        }
    }

    public void initOptions() {
        for (AlmondOptions.AlmondOptionsEvent almondOptionsEvent : AlmondOptions.AlmondOptionsEvent.values()) {
            this.initClientOption(almondOptionsEvent);
            this.notifyOptionWatchers(almondOptionsEvent);
        }
    }

    public void installFlatLaf() {
        UIManager.installLookAndFeel("FlatLaf Dark", "com.formdev.flatlaf.FlatDarkLaf");
        UIManager.installLookAndFeel("FlatLaf Light", "com.formdev.flatlaf.FlatLightLaf");
    }

    public void setFrame(JFrame frame) {
        this.mFrame = frame;
    }

    private void initClientOption(AlmondOptions.AlmondOptionsEvent almondOptionsEvent) {
        switch (almondOptionsEvent) {
            case LOOK_AND_FEEL: {
                if (!this.mAlmondOptions.isForceLookAndFeel()) break;
                try {
                    UIManager.setLookAndFeel(SwingHelper.getLookAndFeelClassName(this.mAlmondOptions.getLookAndFeel()));
                    if (!this.mAlmondOptions.getLookAndFeel().equalsIgnoreCase("Darcula")) break;
                    int iconSize = 32;
                    UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
                    uiDefaults.put("OptionPane.informationIcon", MaterialIcon._Action.INFO_OUTLINE.getImageIcon(iconSize));
                    uiDefaults.put("OptionPane.errorIcon", MaterialIcon._Alert.ERROR_OUTLINE.getImageIcon(iconSize));
                    uiDefaults.put("OptionPane.questionIcon", MaterialIcon._Action.HELP_OUTLINE.getImageIcon(iconSize));
                    uiDefaults.put("OptionPane.warningIcon", MaterialIcon._Alert.WARNING.getImageIcon(iconSize));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                    Xlog.timedErr(ex.getMessage());
                }
                break;
            }
        }
    }

    private void notifyOptionWatchers(AlmondOptions.AlmondOptionsEvent almondOptionsEvent) {
        SwingUtilities.invokeLater(() -> this.mAlmondOptionsWatchers.stream().forEach(optionsWatcher -> {
            try {
                optionsWatcher.onAlmondOptions(almondOptionsEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    private static class Holder {
        private static final AlmondUI INSTANCE = new AlmondUI();

        private Holder() {
        }
    }
}

