/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SortOrder;
import se.trixon.almond.util.DateHelper;

public class CollectionHelper {
    public static Double decDouble(Map<String, Double> map, String key) {
        CollectionHelper.incDouble(map, key, -1.0);
        return map.get(key);
    }

    public static Double decDouble(Map<String, Double> map, String key, double d) {
        CollectionHelper.incDouble(map, key, -d);
        return map.get(key);
    }

    public static Integer decInteger(Map<String, Integer> map, String key) {
        CollectionHelper.incInteger(map, key, -1);
        return map.get(key);
    }

    public static Integer decInteger(Map<String, Integer> map, String key, int i) {
        CollectionHelper.incInteger(map, key, -i);
        return map.get(key);
    }

    public static Double incDouble(Map<String, Double> map, String key) {
        CollectionHelper.incDouble(map, key, 1.0);
        return map.get(key);
    }

    public static Double incDouble(Map<String, Double> map, String key, double d) {
        map.put(key, map.getOrDefault(key, 0.0) + d);
        return map.get(key);
    }

    public static Integer incInteger(Map<String, Integer> map, String key, int i) {
        map.put(key, map.getOrDefault(key, 0) + i);
        return map.get(key);
    }

    public static Integer incInteger(Map<String, Integer> map, String key) {
        CollectionHelper.incInteger(map, key, 1);
        return map.get(key);
    }

    public static void moveItem(List list, int sourceIndex, int targetIndex) {
        if (sourceIndex <= targetIndex) {
            Collections.rotate(list.subList(sourceIndex, targetIndex + 1), -1);
        } else {
            Collections.rotate(list.subList(targetIndex, sourceIndex + 1), 1);
        }
    }

    public static void replaceIfAfter(Map<String, Timestamp> map, String key, Timestamp newTimestamp) {
        Timestamp oldTimestamp = map.getOrDefault(key, new Timestamp(Long.MIN_VALUE));
        map.put(key, DateHelper.getMax(oldTimestamp, newTimestamp));
    }

    public static void replaceIfBefore(Map<String, Timestamp> map, String key, Timestamp newTimestamp) {
        Timestamp oldTimestamp = map.getOrDefault(key, new Timestamp(Long.MAX_VALUE));
        map.put(key, DateHelper.getMin(oldTimestamp, newTimestamp));
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return CollectionHelper.sortByValue(map, SortOrder.ASCENDING);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, SortOrder sortOrder) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        if (sortOrder == SortOrder.DESCENDING) {
            Collections.reverse(list);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }
}

