/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import se.trixon.almond.util.GlobalStateChangeEvent;
import se.trixon.almond.util.GlobalStateChangeListener;

public class GlobalState {
    private final Map<String, Object> mKeyObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<GlobalStateChangeListener, String[]> mListenerKeyMap = Collections.synchronizedMap(new HashMap());
    private final Set<GlobalStateChangeListener> mListeners = Collections.synchronizedSet(new HashSet());

    public synchronized void addListener(GlobalStateChangeListener listener, String ... keys) {
        this.mListeners.add(listener);
        this.mListenerKeyMap.put(listener, keys);
    }

    public <T> T get(String key, Class<T> type) {
        return type.cast(this.mKeyObjectMap.get(key));
    }

    public <T> T get(String key) {
        return (T)this.mKeyObjectMap.get(key);
    }

    public <T> T getOrDefault(String key, Object o) {
        return (T)this.mKeyObjectMap.getOrDefault(key, o);
    }

    public synchronized void put(String key, Object object) {
        this.put(key, object, false);
    }

    public void removeAllListeners() {
        this.mListeners.clear();
    }

    public void removeListener(GlobalStateChangeListener listener) {
        this.mListenerKeyMap.remove(listener);
        this.mListeners.remove(listener);
    }

    public void send(String key, Object object) {
        this.put(key, object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String key, final Object object, boolean _volatile) {
        if (!_volatile) {
            this.mKeyObjectMap.put(key, object);
        }
        GlobalStateChangeEvent event = new GlobalStateChangeEvent(key, object, this, _volatile){

            @Override
            public <T> T getValue() {
                return (T)object;
            }
        };
        GlobalState globalState = this;
        synchronized (globalState) {
            for (GlobalStateChangeListener listener : new HashSet<GlobalStateChangeListener>(this.mListeners)) {
                Object[] listenerKeys = this.mListenerKeyMap.get(listener);
                if (listenerKeys.length != 0 && !ArrayUtils.contains((Object[])listenerKeys, (Object)key)) continue;
                listener.globalStateChange(event);
            }
        }
    }
}

