/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.trixon.almond.util.SystemHelper;

public class PomInfo {
    private static final String NOT_SET = "NOT SET";
    private String mArtifactId = "NOT SET";
    private String mGroupId = "NOT SET";
    private String mVersion = "NOT SET";

    public PomInfo(Class c, String groupId, String artifactId) {
        InputStream inputStream = c.getResourceAsStream("/META-INF/maven/%s/%s/pom.properties".formatted(groupId, artifactId));
        Properties p = new Properties();
        if (inputStream != null) {
            try {
                p.load(inputStream);
                this.mArtifactId = p.getProperty("artifactId");
                this.mGroupId = p.getProperty("groupId");
                this.mVersion = p.getProperty("version");
            }
            catch (IOException | NullPointerException ex) {
                Logger.getLogger(SystemHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getArtifactId() {
        return this.mArtifactId;
    }

    public String getGroupId() {
        return this.mGroupId;
    }

    public String getVersion() {
        return this.mVersion;
    }
}

